/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityUnleashEvent;

public interface Leashable {
    public static final String r_ = "leash";
    public static final double h = 12.0;
    public static final double i = 6.0;
    public static final double j = 16.0;
    public static final Vec3D k = new Vec3D(0.8, 0.2, 0.8);
    public static final float l = 0.7f;
    public static final double m = 10.0;
    public static final double n = 0.11;
    public static final List<Vec3D> o = ImmutableList.of((Object)new Vec3D(0.0, 0.5, 0.5));
    public static final List<Vec3D> p = ImmutableList.of((Object)new Vec3D(0.0, 0.5, 0.0));
    public static final List<Vec3D> q = ImmutableList.of((Object)new Vec3D(-0.5, 0.5, 0.5), (Object)new Vec3D(-0.5, 0.5, -0.5), (Object)new Vec3D(0.5, 0.5, -0.5), (Object)new Vec3D(0.5, 0.5, 0.5));

    @Nullable
    public a U_();

    public void a(@Nullable a var1);

    default public boolean T_() {
        return this.U_() != null && this.U_().b != null;
    }

    default public boolean o() {
        return this.U_() != null;
    }

    default public boolean b_(Entity entity) {
        return this != entity && !(this.b(entity) > this.A()) && this.v();
    }

    default public double b(Entity entity) {
        return entity.de().f().f(((Entity)((Object)this)).de().f());
    }

    default public boolean v() {
        return true;
    }

    default public void e_(int delayedLeashHolderId) {
        this.a(new a(delayedLeashHolderId));
        Leashable.a((Entity)((Object)this), false, false);
    }

    default public void b(ValueInput input) {
        a leashData = input.a(r_, a.a).orElse(null);
        if (this.U_() != null && leashData == null) {
            this.x();
        }
        this.a(leashData);
    }

    default public void a(ValueOutput output, @Nullable a leashData) {
        if (leashData != null && leashData.b != null && leashData.b.pluginRemoved) {
            return;
        }
        output.b(r_, a.a, leashData);
    }

    private static <E extends Entity> void b(E entity, a leashData) {
        World world;
        if (leashData.c != null && (world = entity.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Optional<UUID> optional = leashData.c.left();
            Optional<BlockPosition> optional1 = leashData.c.right();
            if (optional.isPresent()) {
                Entity entity1 = serverLevel.d(optional.get());
                if (entity1 != null) {
                    Leashable.a(entity, entity1, true);
                    return;
                }
            } else if (optional1.isPresent()) {
                Leashable.a(entity, EntityLeash.b(serverLevel, optional1.get()), true);
                return;
            }
            if (entity.at > 100) {
                entity.forceDrops = true;
                entity.a(serverLevel, Items.wU);
                entity.forceDrops = false;
                ((Leashable)((Object)entity)).a(null);
            }
        }
    }

    default public void w() {
        Leashable.a((Entity)((Object)this), true, true);
    }

    default public void x() {
        Leashable.a((Entity)((Object)this), true, false);
    }

    default public void y() {
    }

    private static <E extends Entity> void a(E entity, boolean broadcastPacket, boolean dropItem) {
        a leashData = ((Leashable)((Object)entity)).U_();
        if (leashData != null && leashData.b != null) {
            ((Leashable)((Object)entity)).a(null);
            ((Leashable)((Object)entity)).y();
            World world = entity.an();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (dropItem) {
                    entity.forceDrops = true;
                    entity.a(serverLevel, Items.wU);
                    entity.forceDrops = false;
                }
                if (broadcastPacket) {
                    serverLevel.n().b(entity, new PacketPlayOutAttachEntity(entity, null));
                }
                leashData.b.b((Leashable)((Object)entity));
            }
        }
    }

    public static <E extends Entity> void a_(WorldServer level, E entity) {
        a leashData = ((Leashable)((Object)entity)).U_();
        if (leashData != null && leashData.c != null) {
            Leashable.b(entity, leashData);
        }
        if (leashData != null && leashData.b != null) {
            Entity leashHolder;
            if (!entity.au() || !leashData.b.au()) {
                EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), !entity.bX() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, level.S().c(GameRules.j) && !entity.pluginRemoved);
                event.callEvent();
                if (event.isDropLeash()) {
                    ((Leashable)((Object)entity)).w();
                } else {
                    ((Leashable)((Object)entity)).x();
                }
            }
            if ((leashHolder = ((Leashable)((Object)entity)).ak_()) != null && leashHolder.an() == entity.an()) {
                double d2 = ((Leashable)((Object)entity)).b(leashHolder);
                ((Leashable)((Object)entity)).d(leashHolder);
                if (d2 > ((Leashable)((Object)entity)).leashSnapDistanceOrConfig()) {
                    ((Leashable)((Object)entity)).C();
                } else if (d2 > ((Leashable)((Object)entity)).B() - (double)leashHolder.dA() - (double)entity.dA() && ((Leashable)((Object)entity)).a(leashHolder, leashData)) {
                    ((Leashable)((Object)entity)).z();
                } else {
                    ((Leashable)((Object)entity)).e(leashHolder);
                }
                entity.v((float)((double)entity.dX() - leashData.d));
                leashData.d *= (double)Leashable.c(entity);
            }
        }
    }

    default public void z() {
        Entity entity = (Entity)((Object)this);
        entity.cL();
    }

    default public double leashSnapDistanceOrConfig() {
        Leashable leashable = this;
        if (!(leashable instanceof Entity)) {
            return this.A();
        }
        Entity entity = (Entity)((Object)leashable);
        return entity.an().paperConfig().misc.maxLeashDistance.or(this.A());
    }

    default public double A() {
        return 12.0;
    }

    default public double B() {
        return 6.0;
    }

    public static <E extends Entity> float c(E entity) {
        if (entity.aS()) {
            return entity.an().a_(entity.bb()).b().g() * 0.91f;
        }
        return entity.bx() ? 0.8f : 0.91f;
    }

    default public void d(Entity entity) {
        entity.a(this);
    }

    default public void C() {
        boolean dropLeash = true;
        Leashable leashable = this;
        if (leashable instanceof Entity) {
            Entity entity = (Entity)((Object)leashable);
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE, true);
            if (!event.callEvent()) {
                return;
            }
            Entity leashHolder = this.ak_();
            World level = leashHolder.an();
            dropLeash = event.isDropLeash();
            level.a(null, leashHolder.dK(), leashHolder.dM(), leashHolder.dQ(), SoundEffects.pH, SoundCategory.g, 1.0f, 1.0f);
        }
        if (dropLeash) {
            this.w();
        } else {
            this.x();
        }
    }

    default public void e(Entity entity) {
    }

    default public boolean a(Entity entity, a leashData) {
        boolean flag = entity.dT() && this.D();
        List<b> list = Leashable.a((Entity)((Object)this), entity, flag ? q : o, flag ? q : p);
        if (list.isEmpty()) {
            return false;
        }
        b wrench = b.a(list).a(flag ? 0.25 : 1.0);
        leashData.d += 10.0 * wrench.b();
        Vec3D vec3 = Leashable.g(entity).d(((Entity)((Object)this)).ag());
        ((Entity)((Object)this)).l(wrench.a().h(k).e(vec3.c(0.11)));
        return true;
    }

    private static Vec3D g(Entity holder) {
        EntityInsentient mob;
        return holder instanceof EntityInsentient && (mob = (EntityInsentient)holder).gx() ? Vec3D.c : holder.ag();
    }

    private static <E extends Entity> List<b> a(E entity, Entity leashHolder, List<Vec3D> entityAttachmentPoint, List<Vec3D> leasherAttachmentPoint) {
        double d2 = ((Leashable)((Object)entity)).B();
        Vec3D holderMovement = Leashable.g(entity);
        float f2 = entity.dX() * ((float)Math.PI / 180);
        Vec3D vec3 = new Vec3D(entity.dA(), entity.dB(), entity.dA());
        float f1 = leashHolder.dX() * ((float)Math.PI / 180);
        Vec3D vec31 = new Vec3D(leashHolder.dA(), leashHolder.dB(), leashHolder.dA());
        ArrayList<b> list = new ArrayList<b>();
        for (int i2 = 0; i2 < entityAttachmentPoint.size(); ++i2) {
            Vec3D vec32 = entityAttachmentPoint.get(i2).h(vec3).b(-f2);
            Vec3D vec33 = entity.dD().e(vec32);
            Vec3D vec34 = leasherAttachmentPoint.get(i2).h(vec31).b(-f1);
            Vec3D vec35 = leashHolder.dD().e(vec34);
            Leashable.a(vec35, vec33, d2, holderMovement, vec32).ifPresent(list::add);
        }
        return list;
    }

    private static Optional<b> a(Vec3D entityAttachmentPoint, Vec3D leasherAttachmentPoint, double elasticDistance, Vec3D knownMovement, Vec3D relativeAttachmentPoint) {
        boolean flag;
        double d2 = leasherAttachmentPoint.f(entityAttachmentPoint);
        if (d2 < elasticDistance) {
            return Optional.empty();
        }
        Vec3D vec3 = entityAttachmentPoint.d(leasherAttachmentPoint).d().c(d2 - elasticDistance);
        double d1 = b.a(relativeAttachmentPoint, vec3);
        boolean bl = flag = knownMovement.b(vec3) >= 0.0;
        if (flag) {
            vec3 = vec3.c((double)0.3f);
        }
        return Optional.of(new b(vec3, d1));
    }

    default public boolean D() {
        return false;
    }

    default public Vec3D[] E() {
        return Leashable.a((Entity)((Object)this), 0.0, 0.5, 0.5, 0.5);
    }

    public static Vec3D[] a(Entity entity, double zOffset, double z2, double x2, double y2) {
        float bbWidth = entity.dA();
        double d2 = zOffset * (double)bbWidth;
        double d1 = z2 * (double)bbWidth;
        double d22 = x2 * (double)bbWidth;
        double d3 = y2 * (double)entity.dB();
        return new Vec3D[]{new Vec3D(-d22, d3, d1 + d2), new Vec3D(-d22, d3, -d1 + d2), new Vec3D(d22, d3, -d1 + d2), new Vec3D(d22, d3, d1 + d2)};
    }

    default public Vec3D a_(float partialTick) {
        return this.F();
    }

    default public Vec3D F() {
        Entity entity = (Entity)((Object)this);
        return new Vec3D(0.0, entity.df(), entity.dA() * 0.4f);
    }

    default public void a_(Entity leashHolder, boolean broadcastPacket) {
        if (this != leashHolder) {
            Leashable.a((Entity)((Object)this), leashHolder, broadcastPacket);
        }
    }

    private static <E extends Entity> void a(E entity, Entity leashHolder, boolean broadcastPacket) {
        World world;
        a leashData = ((Leashable)((Object)entity)).U_();
        if (leashData == null) {
            leashData = new a(leashHolder);
            ((Leashable)((Object)entity)).a(leashData);
        } else {
            Entity entity1 = leashData.b;
            leashData.a(leashHolder);
            if (entity1 != null && entity1 != leashHolder) {
                entity1.b((Leashable)((Object)entity));
            }
        }
        if (broadcastPacket && (world = entity.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.n().b(entity, new PacketPlayOutAttachEntity(entity, leashHolder));
        }
        if (entity.cl()) {
            entity.cb();
        }
    }

    @Nullable
    default public Entity ak_() {
        return Leashable.h((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity h(E entity) {
        Entity var3;
        a leashData = ((Leashable)((Object)entity)).U_();
        if (leashData == null) {
            return null;
        }
        if (leashData.e != 0 && entity.an().D_() && (var3 = entity.an().a(leashData.e)) instanceof Entity) {
            leashData.a(var3);
        }
        return leashData.b;
    }

    public static List<Leashable> c_(Entity entity) {
        return Leashable.a(entity, (Leashable leashable) -> leashable.ak_() == entity);
    }

    public static List<Leashable> a(Entity entity, Predicate<Leashable> predicate) {
        return Leashable.a(entity.an(), entity.de().f(), predicate);
    }

    public static List<Leashable> a(World level, Vec3D pos, Predicate<Leashable> predicate) {
        double d2 = 32.0;
        AxisAlignedBB aabb = AxisAlignedBB.a(pos, 32.0, 32.0, 32.0);
        return level.a(Entity.class, aabb, entity -> {
            Leashable leashable;
            return entity instanceof Leashable && predicate.test(leashable = (Leashable)((Object)entity));
        }).stream().map(Leashable.class::cast).toList();
    }

    public static final class a {
        public static final Codec<a> a = Codec.xor((Codec)UUIDUtil.a.fieldOf("UUID").codec(), BlockPosition.a).xmap(a::new, leashData -> {
            Entity patt0$temp = leashData.b;
            if (patt0$temp instanceof EntityLeash) {
                EntityLeash leashFenceKnotEntity = (EntityLeash)patt0$temp;
                return Either.right(leashFenceKnotEntity.i());
            }
            return leashData.b != null ? Either.left(leashData.b.cT()) : Objects.requireNonNull(leashData.c, "Invalid LeashData had no attachment");
        });
        int e;
        @Nullable
        public Entity b;
        @Nullable
        public Either<UUID, BlockPosition> c;
        public double d;

        private a(Either<UUID, BlockPosition> delayedLeashInfo) {
            this.c = delayedLeashInfo;
        }

        a(Entity leashHolder) {
            this.b = leashHolder;
        }

        a(int delayedLeashHolderId) {
            this.e = delayedLeashHolderId;
        }

        public void a(Entity leashHolder) {
            this.b = leashHolder;
            this.c = null;
            this.e = 0;
        }
    }

    public static final class b
    extends Record {
        private final Vec3D b;
        private final double c;
        static b a = new b(Vec3D.c, 0.0);

        public b(Vec3D force, double torque) {
            this.b = force;
            this.c = torque;
        }

        static double a(Vec3D attachmentPoint, Vec3D force) {
            return attachmentPoint.i * force.g - attachmentPoint.g * force.i;
        }

        static b a(List<b> wrenches) {
            if (wrenches.isEmpty()) {
                return a;
            }
            double d2 = 0.0;
            double d1 = 0.0;
            double d22 = 0.0;
            double d3 = 0.0;
            for (b wrench : wrenches) {
                Vec3D vec3 = wrench.b;
                d2 += vec3.g;
                d1 += vec3.h;
                d22 += vec3.i;
                d3 += wrench.c;
            }
            return new b(new Vec3D(d2, d1, d22), d3);
        }

        public b a(double scale) {
            return new b(this.b.c(scale), this.c * scale);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "force;torque", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "force;torque", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "force;torque", "b", "c"}, this, o2);
        }

        public Vec3D a() {
            return this.b;
        }

        public double b() {
            return this.c;
        }
    }
}

