/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;

public class AttributeMapBase {
    private final Map<Holder<AttributeBase>, AttributeModifiable> a = new Object2ObjectOpenHashMap();
    private final Set<AttributeModifiable> b = new ObjectOpenHashSet();
    private final Set<AttributeModifiable> c = new ObjectOpenHashSet();
    private final AttributeProvider d;
    private final EntityLiving entity;

    public AttributeMapBase(AttributeProvider supplier) {
        this(supplier, null);
    }

    public AttributeMapBase(AttributeProvider defaultAttributes, EntityLiving entity) {
        this.entity = entity;
        this.d = defaultAttributes;
    }

    private void a(AttributeModifiable instance) {
        this.c.add(instance);
        if (instance.a().a().b() && (this.entity == null || this.entity.shouldSendAttribute(instance.a().a()))) {
            this.b.add(instance);
        }
    }

    public Set<AttributeModifiable> a() {
        return this.b;
    }

    public Set<AttributeModifiable> b() {
        return this.c;
    }

    public Collection<AttributeModifiable> c() {
        return this.a.values().stream().filter(instance -> instance.a().a().b() && (this.entity == null || this.entity.shouldSendAttribute(instance.a().a()))).collect(Collectors.toList());
    }

    @Nullable
    public AttributeModifiable a(Holder<AttributeBase> attribute) {
        return this.a.computeIfAbsent(attribute, holder -> this.d.a(this::a, (Holder<AttributeBase>)holder));
    }

    public boolean b(Holder<AttributeBase> attribute) {
        return this.a.get(attribute) != null || this.d.c(attribute);
    }

    public boolean a(Holder<AttributeBase> attribute, MinecraftKey id) {
        AttributeModifiable attributeInstance = this.a.get(attribute);
        return attributeInstance != null ? attributeInstance.a(id) != null : this.d.b(attribute, id);
    }

    public double c(Holder<AttributeBase> attribute) {
        AttributeModifiable attributeInstance = this.a.get(attribute);
        return attributeInstance != null ? attributeInstance.g() : this.d.a(attribute);
    }

    public double d(Holder<AttributeBase> attribute) {
        AttributeModifiable attributeInstance = this.a.get(attribute);
        return attributeInstance != null ? attributeInstance.b() : this.d.b(attribute);
    }

    public double b(Holder<AttributeBase> attribute, MinecraftKey id) {
        AttributeModifiable attributeInstance = this.a.get(attribute);
        return attributeInstance != null ? attributeInstance.a(id).b() : this.d.a(attribute, id);
    }

    public void a(Multimap<Holder<AttributeBase>, AttributeModifier> modifiers) {
        modifiers.forEach((attribute, modifier) -> {
            AttributeModifiable instance = this.a((Holder<AttributeBase>)attribute);
            if (instance != null) {
                instance.c(modifier.a());
                instance.b((AttributeModifier)modifier);
            }
        });
    }

    public void b(Multimap<Holder<AttributeBase>, AttributeModifier> modifiers) {
        modifiers.asMap().forEach((holder, collection) -> {
            AttributeModifiable attributeInstance = this.a.get(holder);
            if (attributeInstance != null) {
                collection.forEach(attributeModifier -> attributeInstance.c(attributeModifier.a()));
            }
        });
    }

    public void a(AttributeMapBase map) {
        map.a.values().forEach(attribute -> {
            AttributeModifiable instance = this.a(attribute.a());
            if (instance != null) {
                instance.a((AttributeModifiable)attribute);
            }
        });
    }

    public void b(AttributeMapBase map) {
        map.a.values().forEach(attribute -> {
            AttributeModifiable instance = this.a(attribute.a());
            if (instance != null) {
                instance.a(attribute.b());
            }
        });
    }

    public void c(AttributeMapBase map) {
        map.a.values().forEach(attribute -> {
            AttributeModifiable instance = this.a(attribute.a());
            if (instance != null) {
                instance.a(attribute.d());
            }
        });
    }

    public boolean e(Holder<AttributeBase> attribute) {
        if (!this.d.c(attribute)) {
            return false;
        }
        AttributeModifiable attributeInstance = this.a.get(attribute);
        if (attributeInstance != null) {
            attributeInstance.a(this.d.b(attribute));
        }
        return true;
    }

    public List<AttributeModifiable.a> d() {
        ArrayList<AttributeModifiable.a> list = new ArrayList<AttributeModifiable.a>(this.a.values().size());
        for (AttributeModifiable attributeInstance : this.a.values()) {
            list.add(attributeInstance.h());
        }
        return list;
    }

    public void a(List<AttributeModifiable.a> attributes) {
        for (AttributeModifiable.a packed : attributes) {
            AttributeModifiable instance = this.a(packed.a());
            if (instance == null) continue;
            instance.a(packed);
        }
    }

    public void registerAttribute(Holder<AttributeBase> attributeBase) {
        AttributeModifiable attributeModifiable = new AttributeModifiable(attributeBase, AttributeModifiable::a);
        this.a.put(attributeBase, attributeModifiable);
    }
}

