/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeModifiable {
    private final Holder<AttributeBase> a;
    private final Map<AttributeModifier.Operation, Map<MinecraftKey, AttributeModifier>> b = Maps.newEnumMap(AttributeModifier.Operation.class);
    private final Map<MinecraftKey, AttributeModifier> c = new Object2ObjectArrayMap();
    private final Map<MinecraftKey, AttributeModifier> d = new Object2ObjectArrayMap();
    private double e;
    private boolean f = true;
    private double g;
    private final Consumer<AttributeModifiable> h;

    public AttributeModifiable(Holder<AttributeBase> attribute, Consumer<AttributeModifiable> onDirty) {
        this.a = attribute;
        this.h = onDirty;
        this.e = attribute.a().a();
    }

    public Holder<AttributeBase> a() {
        return this.a;
    }

    public double b() {
        return this.e;
    }

    public void a(double baseValue) {
        if (baseValue != this.e) {
            this.e = baseValue;
            this.e();
        }
    }

    @VisibleForTesting
    Map<MinecraftKey, AttributeModifier> a(AttributeModifier.Operation operation) {
        return this.b.computeIfAbsent(operation, operation1 -> new Object2ObjectOpenHashMap());
    }

    public Set<AttributeModifier> c() {
        return ImmutableSet.copyOf(this.c.values());
    }

    public Set<AttributeModifier> d() {
        return ImmutableSet.copyOf(this.d.values());
    }

    @Nullable
    public AttributeModifier a(MinecraftKey id) {
        return this.c.get(id);
    }

    public boolean b(MinecraftKey id) {
        return this.c.get(id) != null;
    }

    private void f(AttributeModifier modifier) {
        AttributeModifier attributeModifier = this.c.putIfAbsent(modifier.a(), modifier);
        if (attributeModifier != null) {
            throw new IllegalArgumentException("Modifier is already applied on this attribute!");
        }
        this.a(modifier.c()).put(modifier.a(), modifier);
        this.e();
    }

    public void a(AttributeModifier modifier) {
        AttributeModifier attributeModifier = this.c.put(modifier.a(), modifier);
        if (modifier != attributeModifier) {
            this.a(modifier.c()).put(modifier.a(), modifier);
            this.e();
        }
    }

    public void b(AttributeModifier modifier) {
        this.f(modifier);
    }

    public void c(AttributeModifier modifier) {
        this.c(modifier.a());
        this.f(modifier);
        this.d.put(modifier.a(), modifier);
    }

    public void d(AttributeModifier modifier) {
        this.f(modifier);
        this.d.put(modifier.a(), modifier);
    }

    public void a(Collection<AttributeModifier> modifiers) {
        for (AttributeModifier attributeModifier : modifiers) {
            this.d(attributeModifier);
        }
    }

    protected void e() {
        this.f = true;
        this.h.accept(this);
    }

    public void e(AttributeModifier modifier) {
        this.c(modifier.a());
    }

    public boolean c(MinecraftKey id) {
        AttributeModifier attributeModifier = this.c.remove(id);
        if (attributeModifier == null) {
            return false;
        }
        this.a(attributeModifier.c()).remove(id);
        this.d.remove(id);
        this.e();
        return true;
    }

    public void f() {
        for (AttributeModifier attributeModifier : this.c()) {
            this.e(attributeModifier);
        }
    }

    public double g() {
        if (this.f) {
            this.g = this.i();
            this.f = false;
        }
        return this.g;
    }

    private double i() {
        double baseValue = this.b();
        for (AttributeModifier attributeModifier : this.b(AttributeModifier.Operation.a)) {
            baseValue += attributeModifier.b();
        }
        double d2 = baseValue;
        for (AttributeModifier attributeModifier1 : this.b(AttributeModifier.Operation.b)) {
            d2 += baseValue * attributeModifier1.b();
        }
        for (AttributeModifier attributeModifier1 : this.b(AttributeModifier.Operation.c)) {
            d2 *= 1.0 + attributeModifier1.b();
        }
        return this.a.a().a(d2);
    }

    private Collection<AttributeModifier> b(AttributeModifier.Operation operation) {
        return this.b.getOrDefault(operation, Map.of()).values();
    }

    public void a(AttributeModifiable instance) {
        this.e = instance.e;
        this.c.clear();
        this.c.putAll(instance.c);
        this.d.clear();
        this.d.putAll(instance.d);
        this.b.clear();
        instance.b.forEach((operation, map) -> this.a((AttributeModifier.Operation)operation).putAll((Map<MinecraftKey, AttributeModifier>)map));
        this.e();
    }

    public a h() {
        return new a(this.a, this.e, List.copyOf(this.d.values()));
    }

    public void a(a instance) {
        this.e = instance.d;
        for (AttributeModifier attributeModifier : instance.e) {
            this.c.put(attributeModifier.a(), attributeModifier);
            this.a(attributeModifier.c()).put(attributeModifier.a(), attributeModifier);
            this.d.put(attributeModifier.a(), attributeModifier);
        }
        this.e();
    }

    public static final class a
    extends Record {
        private final Holder<AttributeBase> c;
        private final double d;
        private final List<AttributeModifier> e;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.t.r().fieldOf("id").forGetter(a::a), (App)Codec.DOUBLE.fieldOf("base").orElse((Object)0.0).forGetter(a::b), (App)AttributeModifier.b.listOf().optionalFieldOf("modifiers", List.of()).forGetter(a::c)).apply((Applicative)instance, a::new));
        public static final Codec<List<a>> b = a.listOf();

        public a(Holder<AttributeBase> attribute, double baseValue, List<AttributeModifier> modifiers) {
            this.c = attribute;
            this.d = baseValue;
            this.e = modifiers;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "attribute;baseValue;modifiers", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "attribute;baseValue;modifiers", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "attribute;baseValue;modifiers", "c", "d", "e"}, this, o2);
        }

        public Holder<AttributeBase> a() {
            return this.c;
        }

        public double b() {
            return this.d;
        }

        public List<AttributeModifier> c() {
            return this.e;
        }
    }
}

