/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.phys.Vec3D;

public class AnimalPanic<E extends EntityCreature>
extends Behavior<E> {
    private static final int c = 100;
    private static final int d = 120;
    private static final int e = 5;
    private static final int f = 4;
    private final float g;
    private final Function<EntityCreature, TagKey<DamageType>> h;
    private final Function<E, Vec3D> i;

    public AnimalPanic(float speedMultiplier) {
        this(speedMultiplier, pathfinderMob -> DamageTypeTags.F, pathfinderMob -> LandRandomPos.a(pathfinderMob, 5, 4));
    }

    public AnimalPanic(float speedMultiplier, int y2) {
        this(speedMultiplier, pathfinderMob -> DamageTypeTags.F, pathfinderMob -> AirAndWaterRandomPos.a(pathfinderMob, 5, 4, y2, pathfinderMob.h((float)0.0f).g, pathfinderMob.h((float)0.0f).i, 1.5707963705062866));
    }

    public AnimalPanic(float speedMultiplier, Function<EntityCreature, TagKey<DamageType>> panicCausingDamageTypes) {
        this(speedMultiplier, panicCausingDamageTypes, pathfinderMob -> LandRandomPos.a(pathfinderMob, 5, 4));
    }

    public AnimalPanic(float speedMultiplier, Function<EntityCreature, TagKey<DamageType>> panicCausingDamageTypes, Function<E, Vec3D> positionGetter) {
        super(Map.of(MemoryModuleType.aa, MemoryStatus.c, MemoryModuleType.y, MemoryStatus.c), 100, 120);
        this.g = speedMultiplier;
        this.h = panicCausingDamageTypes;
        this.i = positionGetter;
    }

    @Override
    protected boolean a(WorldServer level, E owner) {
        return ((EntityLiving)owner).eq().c(MemoryModuleType.y).map(damageSource -> damageSource.a(this.h.apply((EntityCreature)owner))).orElse(false) != false || ((EntityLiving)owner).eq().a(MemoryModuleType.aa);
    }

    @Override
    protected boolean a(WorldServer level, E entity, long gameTime) {
        return true;
    }

    @Override
    protected void b(WorldServer level, E entity, long gameTime) {
        ((EntityLiving)entity).eq().a(MemoryModuleType.aa, true);
        ((EntityLiving)entity).eq().b(MemoryModuleType.n);
        ((EntityInsentient)entity).S().n();
    }

    @Override
    protected void c(WorldServer level, E entity, long gameTime) {
        BehaviorController<?> brain = ((EntityLiving)entity).eq();
        brain.b(MemoryModuleType.aa);
    }

    @Override
    protected void d(WorldServer level, E owner, long gameTime) {
        Vec3D panicPos;
        if (((EntityInsentient)owner).S().l() && (panicPos = this.a(owner, level)) != null) {
            ((EntityLiving)owner).eq().a(MemoryModuleType.n, new MemoryTarget(panicPos, this.g, 0));
        }
    }

    @Nullable
    private Vec3D a(E pathfinder, WorldServer level) {
        Optional<Vec3D> optional;
        if (((Entity)pathfinder).ck() && (optional = this.a((IBlockAccess)level, (Entity)pathfinder).map(Vec3D::c)).isPresent()) {
            return optional.get();
        }
        return this.i.apply(pathfinder);
    }

    private Optional<BlockPosition> a(IBlockAccess level, Entity entity) {
        BlockPosition blockPos = entity.dF();
        if (!level.a_(blockPos).g(level, blockPos).c()) {
            return Optional.empty();
        }
        Predicate<BlockPosition> predicate = MathHelper.f(entity.dA()) == 2 ? blockPos1 -> BlockPosition.a(blockPos1).allMatch(blockPos2 -> level.b_((BlockPosition)blockPos2).a(TagsFluid.a)) : blockPos1 -> level.b_((BlockPosition)blockPos1).a(TagsFluid.a);
        return BlockPosition.a(blockPos, 5, 1, predicate);
    }
}

