/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.random.WeightedRandom2;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;

public class LongJumpToRandomPos<E extends EntityInsentient>
extends Behavior<E> {
    protected static final int c = 20;
    private static final int m = 40;
    protected static final int d = 8;
    private static final int n = 200;
    private static final List<Integer> o = Lists.newArrayList((Object[])new Integer[]{65, 70, 75, 80});
    private final UniformInt p;
    protected final int e;
    protected final int f;
    protected final float g;
    protected List<a> h = Lists.newArrayList();
    protected Optional<Vec3D> i = Optional.empty();
    @Nullable
    protected Vec3D j;
    protected int k;
    protected long l;
    private final Function<E, SoundEffect> q;
    private final BiPredicate<E, BlockPosition> r;

    public LongJumpToRandomPos(UniformInt timeBetweenLongJumps, int maxLongJumpHeight, int maxLongJumpWidth, float maxJumpVelocity, Function<E, SoundEffect> getJumpSound) {
        this(timeBetweenLongJumps, maxLongJumpHeight, maxLongJumpWidth, maxJumpVelocity, getJumpSound, LongJumpToRandomPos::a);
    }

    public static <E extends EntityInsentient> boolean a(E mob, BlockPosition pos) {
        BlockPosition blockPos;
        World level = mob.an();
        return level.a_(blockPos = pos.e()).s() && mob.a(PathfinderNormal.b(mob, pos)) == 0.0f;
    }

    public LongJumpToRandomPos(UniformInt timeBetweenLongJumps, int maxLongJumpHeight, int maxLongJumpWidth, float maxJumpVelocityMultiplier, Function<E, SoundEffect> getJumpSound, BiPredicate<E, BlockPosition> acceptableLandingSpot) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.o, (Object)((Object)MemoryStatus.c), MemoryModuleType.T, (Object)((Object)MemoryStatus.b), MemoryModuleType.U, (Object)((Object)MemoryStatus.b)), 200);
        this.p = timeBetweenLongJumps;
        this.e = maxLongJumpHeight;
        this.f = maxLongJumpWidth;
        this.g = maxJumpVelocityMultiplier;
        this.q = getJumpSound;
        this.r = acceptableLandingSpot;
    }

    @Override
    protected boolean a(WorldServer level, EntityInsentient owner) {
        boolean flag;
        boolean bl = flag = owner.aS() && !owner.bu() && !owner.bJ() && !level.a_(owner.dF()).a(Blocks.qg);
        if (!flag) {
            owner.eq().a(MemoryModuleType.T, Integer.valueOf(this.p.a(level.z) / 2));
        }
        return flag;
    }

    protected boolean b(WorldServer level, EntityInsentient entity, long gameTime) {
        boolean flag;
        boolean bl = flag = this.i.isPresent() && this.i.get().equals(entity.dD()) && this.k > 0 && !entity.bu() && (this.j != null || !this.h.isEmpty());
        if (!flag && entity.eq().c(MemoryModuleType.U).isEmpty()) {
            entity.eq().a(MemoryModuleType.T, Integer.valueOf(this.p.a(level.z) / 2));
            entity.eq().b(MemoryModuleType.o);
        }
        return flag;
    }

    protected void a(WorldServer level, E entity, long gameTime) {
        this.j = null;
        this.k = 20;
        this.i = Optional.of(((Entity)entity).dD());
        BlockPosition blockPos = ((Entity)entity).dF();
        int x2 = blockPos.u();
        int y2 = blockPos.v();
        int z2 = blockPos.w();
        this.h = BlockPosition.a(x2 - this.f, y2 - this.e, z2 - this.f, x2 + this.f, y2 + this.e, z2 + this.f).filter(blockPos1 -> !blockPos1.equals(blockPos)).map(blockPos1 -> new a(blockPos1.j(), MathHelper.c(blockPos.j((BaseBlockPosition)blockPos1)))).collect(Collectors.toCollection(Lists::newArrayList));
    }

    @Override
    protected void c(WorldServer level, E owner, long gameTime) {
        if (this.j != null) {
            if (gameTime - this.l >= 40L) {
                ((Entity)owner).v(((EntityLiving)owner).bB);
                ((EntityLiving)owner).r(true);
                double len = this.j.g();
                double d2 = len + (double)((EntityLiving)owner).fx();
                ((Entity)owner).k(this.j.c(d2 / len));
                ((EntityLiving)owner).eq().a(MemoryModuleType.U, true);
                level.a(null, (Entity)owner, this.q.apply(owner), SoundCategory.g, 1.0f, 1.0f);
            }
        } else {
            --this.k;
            this.d(level, owner, gameTime);
        }
    }

    @Override
    protected void d(WorldServer level, E entity, long prepareJumpStart) {
        while (!this.h.isEmpty()) {
            Vec3D vec3;
            Vec3D vec31;
            a possibleJump;
            BlockPosition blockPos;
            Optional<a> jumpCandidate = this.a(level);
            if (jumpCandidate.isEmpty() || !this.a(level, entity, blockPos = (possibleJump = jumpCandidate.get()).a()) || (vec31 = this.a((EntityInsentient)entity, vec3 = Vec3D.b(blockPos))) == null) continue;
            ((EntityLiving)entity).eq().a(MemoryModuleType.o, new BehaviorTarget(blockPos));
            NavigationAbstract navigation = ((EntityInsentient)entity).S();
            PathEntity path = navigation.a(blockPos, 0, 8);
            if (path != null && path.j()) continue;
            this.j = vec31;
            this.l = prepareJumpStart;
            return;
        }
    }

    protected Optional<a> a(WorldServer level) {
        Optional<a> randomItem = WeightedRandom2.a(level.z, this.h, a::b);
        randomItem.ifPresent(this.h::remove);
        return randomItem;
    }

    private boolean a(WorldServer level, E entity, BlockPosition pos) {
        BlockPosition blockPos = ((Entity)entity).dF();
        int x2 = blockPos.u();
        int z2 = blockPos.w();
        return (x2 != pos.u() || z2 != pos.w()) && this.r.test(entity, pos);
    }

    @Nullable
    protected Vec3D a(EntityInsentient mob, Vec3D target) {
        ArrayList list = Lists.newArrayList(o);
        Collections.shuffle(list);
        float f2 = (float)(mob.i(GenericAttributes.p) * (double)this.g);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int i2 = (Integer)iterator.next();
            Optional<Vec3D> optional = LongJumpUtil.a(mob, target, f2, i2, true);
            if (!optional.isPresent()) continue;
            return optional.get();
        }
        return null;
    }

    public record a(BlockPosition a, int b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "targetPos;weight", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "targetPos;weight", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "targetPos;weight", "a", "b"}, this, o2);
        }
    }
}

