/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.function.TriConsumer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class TransportItemsBetweenContainers
extends Behavior<EntityCreature> {
    public static final int c = 60;
    private static final int d = 6000;
    private static final int e = 16;
    private static final int f = 10;
    private static final int g = 50;
    private static final int h = 1;
    private static final int i = 140;
    private static final double j = 3.0;
    private static final double k = 0.5;
    private static final double l = 1.0;
    private static final double m = 2.0;
    private final float n;
    private final int o;
    private final int p;
    private final Predicate<IBlockData> q;
    private final Predicate<IBlockData> r;
    private final Predicate<d> s;
    private final Consumer<EntityCreature> t;
    private final Map<a, b> u;
    @Nullable
    private d v = null;
    private c w;
    @Nullable
    private a x;
    private int y;

    public TransportItemsBetweenContainers(float speedModifier, Predicate<IBlockData> sourceBlockType, Predicate<IBlockData> destinationBlockType, int horizontalSearchDistance, int verticalSearchDistance, Map<a, b> onTargetInteractionActions, Consumer<EntityCreature> onStartTravelling, Predicate<d> shouldQueueForTarget) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ac, (Object)((Object)MemoryStatus.c), MemoryModuleType.ad, (Object)((Object)MemoryStatus.c), MemoryModuleType.ae, (Object)((Object)MemoryStatus.b), MemoryModuleType.aa, (Object)((Object)MemoryStatus.b)));
        this.n = speedModifier;
        this.q = sourceBlockType;
        this.r = destinationBlockType;
        this.o = horizontalSearchDistance;
        this.p = verticalSearchDistance;
        this.t = onStartTravelling;
        this.s = shouldQueueForTarget;
        this.u = onTargetInteractionActions;
        this.w = net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$c.a;
    }

    protected void a(WorldServer level, EntityCreature entity, long gameTime) {
        NavigationAbstract navigationAbstract = entity.S();
        if (navigationAbstract instanceof Navigation) {
            Navigation groundPathNavigation = (Navigation)navigationAbstract;
            groundPathNavigation.d(true);
        }
    }

    @Override
    protected boolean a(WorldServer level, EntityCreature owner) {
        return !owner.T_();
    }

    protected boolean b(WorldServer level, EntityCreature entity, long gameTime) {
        return entity.eq().c(MemoryModuleType.ae).isEmpty() && !entity.gF() && !entity.T_();
    }

    @Override
    protected boolean a(long gameTime) {
        return false;
    }

    @Override
    protected void c(WorldServer level, EntityCreature owner, long gameTime) {
        boolean flag = this.b(level, owner);
        if (this.v == null) {
            this.d(level, owner, gameTime);
        } else if (!flag) {
            if (this.w.equals((Object)net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$c.b)) {
                this.c(this.v, level, owner);
            }
            if (this.w.equals((Object)net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$c.a)) {
                this.a(this.v, (World)level, owner);
            }
            if (this.w.equals((Object)net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$c.c)) {
                this.b(this.v, (World)level, owner);
            }
        }
    }

    private boolean b(WorldServer level, EntityCreature mob) {
        if (!this.a((World)level, mob)) {
            this.a(mob);
            Optional<d> transportTarget = this.c(level, mob);
            if (transportTarget.isPresent()) {
                this.v = transportTarget.get();
                this.g(mob);
                this.a(mob, (World)level, this.v.a);
                return true;
            }
            this.p(mob);
            return true;
        }
        return false;
    }

    private void c(d target, World level, EntityCreature mob) {
        if (!this.b(target, level)) {
            this.e(mob);
        }
    }

    protected void a(d target, World level, EntityCreature mob) {
        if (this.a(3.0, target, level, mob, this.c(mob)) && this.b(target, level)) {
            this.d(mob);
        } else if (this.a(TransportItemsBetweenContainers.n(mob), target, level, mob, this.c(mob))) {
            this.a(target, mob);
        } else {
            this.f(mob);
        }
    }

    private Vec3D c(EntityCreature mob) {
        return this.a(mob, mob.dD());
    }

    protected void b(d target, World level, EntityCreature mob) {
        if (!this.a(2.0, target, level, mob, this.c(mob))) {
            this.g(mob);
        } else {
            ++this.y;
            this.b(target, mob);
            if (this.y >= 60) {
                this.a(mob, target.b, this::c, (EntityCreature pathfinderMob, IInventory container) -> this.a(mob), this::d, (EntityCreature pathfinderMob, IInventory container) -> this.a(mob));
                this.g(mob);
            }
        }
    }

    private void d(EntityCreature mob) {
        this.q(mob);
        this.a(net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$c.b);
    }

    private void e(EntityCreature mob) {
        this.a(net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$c.a);
        this.f(mob);
    }

    private void f(EntityCreature mob) {
        if (this.v != null) {
            BehaviorUtil.a((EntityLiving)mob, this.v.a, this.n, 0);
        }
    }

    private void a(d target, EntityCreature mob) {
        this.a(mob, target.b, this.a(net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$a.a), this.a(net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$a.b), this.a(net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$a.c), this.a(net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$a.d));
        this.a(net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$c.c);
    }

    private void g(EntityCreature mob) {
        this.t.accept(mob);
        this.a(net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$c.a);
        this.x = null;
        this.y = 0;
    }

    private BiConsumer<EntityCreature, IInventory> a(a state) {
        return (pathfinderMob, container) -> this.b(state);
    }

    private void a(c state) {
        this.w = state;
    }

    private void b(a state) {
        this.x = state;
    }

    private void b(d target, EntityCreature mob) {
        mob.eq().a(MemoryModuleType.o, new BehaviorTarget(target.a));
        this.q(mob);
        if (this.x != null) {
            Optional.ofNullable(this.u.get((Object)this.x)).ifPresent(onTargetReachedInteraction -> onTargetReachedInteraction.accept(mob, target, this.y));
        }
    }

    private void a(EntityCreature mob, IInventory container, BiConsumer<EntityCreature, IInventory> pickupItem, BiConsumer<EntityCreature, IInventory> pickupNoItem, BiConsumer<EntityCreature, IInventory> placeItem, BiConsumer<EntityCreature, IInventory> placeNoItem) {
        if (TransportItemsBetweenContainers.o(mob)) {
            if (TransportItemsBetweenContainers.a(container)) {
                pickupItem.accept(mob, container);
            } else {
                pickupNoItem.accept(mob, container);
            }
        } else if (TransportItemsBetweenContainers.a(mob, container)) {
            placeItem.accept(mob, container);
        } else {
            placeNoItem.accept(mob, container);
        }
    }

    private Optional<d> c(WorldServer level, EntityCreature mob) {
        AxisAlignedBB targetSearchArea = this.h(mob);
        Set<GlobalPos> visitedPositions = TransportItemsBetweenContainers.k(mob);
        Set<GlobalPos> unreachablePositions = TransportItemsBetweenContainers.l(mob);
        List<ChunkCoordIntPair> list = ChunkCoordIntPair.a(new ChunkCoordIntPair(mob.dF()), Math.floorDiv(this.i(mob), 16) + 1).toList();
        d transportItemTarget = null;
        double d2 = 3.4028234663852886E38;
        for (ChunkCoordIntPair chunkPos : list) {
            Chunk chunkNow = level.n().a(chunkPos.h, chunkPos.i);
            if (chunkNow == null) continue;
            for (TileEntity blockEntity : chunkNow.J().values()) {
                d transportItemTarget1;
                TileEntityContainer chestBlockEntity;
                double d1;
                if (!(blockEntity instanceof TileEntityContainer) || !((d1 = (chestBlockEntity = (TileEntityContainer)blockEntity).aD_().b(mob.dD())) < d2) || (transportItemTarget1 = this.a(mob, level, chestBlockEntity, visitedPositions, unreachablePositions, targetSearchArea)) == null) continue;
                transportItemTarget = transportItemTarget1;
                d2 = d1;
            }
        }
        return transportItemTarget == null ? Optional.empty() : Optional.of(transportItemTarget);
    }

    @Nullable
    private d a(EntityCreature mob, World level, TileEntity blockEntity, Set<GlobalPos> visitedPositions, Set<GlobalPos> unreachablePositions, AxisAlignedBB searchArea) {
        BlockPosition blockPos = blockEntity.aD_();
        boolean flag = searchArea.e(blockPos.u(), blockPos.v(), blockPos.w());
        if (!flag) {
            return null;
        }
        d transportItemTarget = net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$d.a(blockEntity, level);
        if (transportItemTarget == null) {
            return null;
        }
        boolean flag1 = this.a(mob, transportItemTarget.d) && !this.a(visitedPositions, unreachablePositions, transportItemTarget, level) && !this.a(transportItemTarget) && CraftEventFactory.callTransporterValidateTarget(mob, level, transportItemTarget.a);
        return flag1 ? transportItemTarget : null;
    }

    @Override
    private boolean a(d target) {
        TileEntityContainer baseContainerBlockEntity;
        TileEntity tileEntity = target.c;
        return tileEntity instanceof TileEntityContainer && (baseContainerBlockEntity = (TileEntityContainer)tileEntity).m();
    }

    private boolean a(World level, EntityCreature mob) {
        boolean flag;
        boolean bl = flag = this.v != null && this.a(mob, this.v.d) && this.b(level, this.v);
        if (flag && (mob.an().purpurConfig.copperGolemCanOpenBarrel && this.v.d.a(Blocks.oR) || !this.a(level, this.v))) {
            if (!this.w.equals((Object)net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$c.a)) {
                return true;
            }
            if (this.a(level, this.v, mob)) {
                return true;
            }
            this.b(mob, level, this.v.a);
        }
        return false;
    }

    private boolean a(World level, d target, EntityCreature mob) {
        PathEntity path = mob.S().j() == null ? mob.S().a(target.a, 0) : mob.S().j();
        Vec3D positionToReachTargetFrom = this.a(path, mob);
        boolean isWithinTargetDistance = this.a(TransportItemsBetweenContainers.n(mob), target, level, mob, positionToReachTargetFrom);
        boolean flag = path == null && !isWithinTargetDistance;
        return flag || this.a(level, isWithinTargetDistance, positionToReachTargetFrom, target, mob);
    }

    private Vec3D a(@Nullable PathEntity path, EntityCreature mob) {
        boolean flag = path == null || path.d() == null;
        Vec3D vec3 = flag ? mob.dD() : path.d().a().c();
        return this.a(mob, vec3);
    }

    private Vec3D a(EntityCreature mob, Vec3D pos) {
        return pos.b(0.0, mob.de().c() / 2.0, 0.0);
    }

    private boolean a(World level, d target) {
        return BlockChest.a(level, target.a);
    }

    private boolean b(World level, d target) {
        return target.c.equals(level.c_(target.a));
    }

    private Stream<d> a(d target, World level) {
        if (target.d.a(BlockChest.d, BlockPropertyChestType.a) != BlockPropertyChestType.a) {
            d transportItemTarget = net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$d.a(BlockChest.b(target.a, target.d), level);
            return transportItemTarget != null ? Stream.of(target, transportItemTarget) : Stream.of(target);
        }
        return Stream.of(target);
    }

    private AxisAlignedBB h(EntityCreature mob) {
        int horizontalSearchDistance = this.i(mob);
        return new AxisAlignedBB(mob.dF()).c(horizontalSearchDistance, this.j(mob), horizontalSearchDistance);
    }

    private int i(EntityCreature mob) {
        return mob.cl() ? 1 : this.o;
    }

    private int j(EntityCreature mob) {
        return mob.cl() ? 1 : this.p;
    }

    private static Set<GlobalPos> k(EntityCreature mob) {
        return mob.eq().c(MemoryModuleType.ac).orElse(Set.of());
    }

    private static Set<GlobalPos> l(EntityCreature mob) {
        return mob.eq().c(MemoryModuleType.ad).orElse(Set.of());
    }

    private boolean a(Set<GlobalPos> visitedPositions, Set<GlobalPos> unreachablePositions, d target, World level) {
        return this.a(target, level).map(transportItemTarget -> new GlobalPos(level.al(), transportItemTarget.a)).anyMatch(globalPos -> visitedPositions.contains(globalPos) || unreachablePositions.contains(globalPos));
    }

    private static boolean m(EntityCreature mob) {
        return mob.S().j() != null && mob.S().j().c();
    }

    protected void a(EntityCreature mob, World level, BlockPosition pos) {
        HashSet<GlobalPos> set = new HashSet<GlobalPos>(TransportItemsBetweenContainers.k(mob));
        set.add(new GlobalPos(level.al(), pos));
        if (set.size() > 10) {
            this.p(mob);
        } else {
            mob.eq().a(MemoryModuleType.ac, set, 6000L);
        }
    }

    protected void b(EntityCreature mob, World level, BlockPosition pos) {
        HashSet<GlobalPos> set = new HashSet<GlobalPos>(TransportItemsBetweenContainers.k(mob));
        set.remove(new GlobalPos(level.al(), pos));
        HashSet<GlobalPos> set1 = new HashSet<GlobalPos>(TransportItemsBetweenContainers.l(mob));
        set1.add(new GlobalPos(level.al(), pos));
        if (set1.size() > 50) {
            this.p(mob);
        } else {
            mob.eq().a(MemoryModuleType.ac, set, 6000L);
            mob.eq().a(MemoryModuleType.ad, set1, 6000L);
        }
    }

    private boolean a(EntityCreature mob, IBlockData state) {
        return TransportItemsBetweenContainers.o(mob) ? this.q.test(state) : mob.an().purpurConfig.copperGolemCanOpenBarrel && state.a(Blocks.oR) || this.r.test(state);
    }

    private static double n(EntityCreature mob) {
        return TransportItemsBetweenContainers.m(mob) ? 1.0 : 0.5;
    }

    private boolean a(double distance, d target, World level, EntityCreature mob, Vec3D pos) {
        AxisAlignedBB boundingBox = mob.de();
        AxisAlignedBB aabb = AxisAlignedBB.a(pos, boundingBox.b(), boundingBox.c(), boundingBox.d());
        return target.d.g(level, target.a).a().c(distance, 0.5, distance).a(target.a).c(aabb);
    }

    private boolean a(World level, boolean withinDistance, Vec3D pos, d target, EntityCreature mob) {
        return withinDistance && this.a(target, level, mob, pos);
    }

    private boolean a(d target, World level, EntityCreature mob, Vec3D pos) {
        Vec3D center = target.a.b();
        return EnumDirection.a().map(direction -> center.b(0.5 * (double)direction.j(), 0.5 * (double)direction.k(), 0.5 * (double)direction.l())).map(vec3 -> level.a(new RayTrace(pos, (Vec3D)vec3, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, mob))).anyMatch(blockHitResult -> blockHitResult.d() == MovingObjectPosition.EnumMovingObjectType.b && blockHitResult.b().equals(target.a));
    }

    private boolean b(d target, World level) {
        return this.a(target, level).anyMatch(this.s);
    }

    private static boolean o(EntityCreature mob) {
        return mob.fq().f();
    }

    private static boolean a(IInventory container) {
        return !container.c();
    }

    private static boolean a(EntityCreature mob, IInventory container) {
        return container.c() || TransportItemsBetweenContainers.b(mob, container);
    }

    private static boolean b(EntityCreature mob, IInventory container) {
        ItemStack mainHandItem = mob.fq();
        for (ItemStack itemStack : container) {
            if (!ItemStack.b(itemStack, mainHandItem)) continue;
            return true;
        }
        return false;
    }

    private void c(EntityCreature mob, IInventory container) {
        mob.a(EnumItemSlot.a, TransportItemsBetweenContainers.b(container));
        mob.g(EnumItemSlot.a);
        container.e();
        this.b(mob);
    }

    private void d(EntityCreature mob, IInventory container) {
        ItemStack itemStack = TransportItemsBetweenContainers.e(mob, container);
        container.e();
        mob.a(EnumItemSlot.a, itemStack);
        if (itemStack.f()) {
            this.b(mob);
        } else {
            this.a(mob);
        }
    }

    private static ItemStack b(IInventory container) {
        int i2 = 0;
        for (ItemStack itemStack : container) {
            if (!itemStack.f()) {
                int min = Math.min(itemStack.M(), 16);
                return container.a(i2, min);
            }
            ++i2;
        }
        return ItemStack.l;
    }

    private static ItemStack e(EntityCreature mob, IInventory container) {
        int i2 = 0;
        ItemStack mainHandItem = mob.fq();
        for (ItemStack itemStack : container) {
            if (itemStack.f()) {
                container.a(i2, mainHandItem);
                return ItemStack.l;
            }
            if (ItemStack.c(itemStack, mainHandItem) && itemStack.M() < itemStack.k()) {
                int i1 = itemStack.k() - itemStack.M();
                int min = Math.min(i1, mainHandItem.M());
                itemStack.e(itemStack.M() + min);
                mainHandItem.e(mainHandItem.M() - i1);
                container.a(i2, itemStack);
                if (mainHandItem.f()) {
                    return ItemStack.l;
                }
            }
            ++i2;
        }
        return mainHandItem;
    }

    protected void a(EntityCreature mob) {
        this.y = 0;
        this.v = null;
        mob.S().n();
        mob.eq().b(MemoryModuleType.n);
    }

    protected void b(EntityCreature mob) {
        this.a(mob);
        mob.eq().b(MemoryModuleType.ac);
        mob.eq().b(MemoryModuleType.ad);
    }

    private void p(EntityCreature mob) {
        this.a(mob);
        mob.eq().a(MemoryModuleType.ae, Integer.valueOf(140));
        mob.eq().b(MemoryModuleType.ac);
        mob.eq().b(MemoryModuleType.ad);
    }

    @Override
    protected void d(WorldServer level, EntityCreature entity, long gameTime) {
        this.g(entity);
        NavigationAbstract navigationAbstract = entity.S();
        if (navigationAbstract instanceof Navigation) {
            Navigation groundPathNavigation = (Navigation)navigationAbstract;
            groundPathNavigation.d(false);
        }
    }

    private void q(EntityCreature entity) {
        entity.S().n();
        entity.I(0.0f);
        entity.H(0.0f);
        entity.B(0.0f);
        entity.m(0.0, entity.dI().h, 0.0);
    }

    public record d(BlockPosition a, IInventory b, TileEntity c, IBlockData d) {
        @Nullable
        public static d a(TileEntity blockEntity, World level) {
            BlockPosition blockPos = blockEntity.aD_();
            IBlockData blockState = blockEntity.o();
            IInventory blockEntityContainer = net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$d.a(blockEntity, blockState, level, blockPos);
            return blockEntityContainer != null ? new d(blockPos, blockEntityContainer, blockEntity, blockState) : null;
        }

        @Nullable
        public static d a(BlockPosition pos, World level) {
            TileEntity blockEntity = level.c_(pos);
            return blockEntity == null ? null : net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$d.a(blockEntity, level);
        }

        @Nullable
        private static IInventory a(TileEntity blockEntity, IBlockData state, World level, BlockPosition pos) {
            IInventory container;
            Block block = state.b();
            if (block instanceof BlockChest) {
                BlockChest chestBlock = (BlockChest)block;
                return BlockChest.a(chestBlock, state, level, pos, false);
            }
            return blockEntity instanceof IInventory ? (container = (IInventory)((Object)blockEntity)) : null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "pos;container;blockEntity;state", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "pos;container;blockEntity;state", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "pos;container;blockEntity;state", "a", "b", "c", "d"}, this, o2);
        }
    }

    public static final class c
    extends Enum<c> {
        public static final /* enum */ c a = new c();
        public static final /* enum */ c b = new c();
        public static final /* enum */ c c = new c();
        private static final /* synthetic */ c[] d;

        public static c[] values() {
            return (c[])d.clone();
        }

        public static c valueOf(String name) {
            return Enum.valueOf(c.class, name);
        }

        private static /* synthetic */ c[] a() {
            return new c[]{a, b, c};
        }

        static {
            d = net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$c.a();
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        public static final /* enum */ a d = new a();
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c, d};
        }

        static {
            e = net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers$a.a();
        }
    }

    @FunctionalInterface
    public static interface b
    extends TriConsumer<EntityCreature, d, Integer> {
    }
}

