/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.phys.Vec3D;

public class RandomPositionGenerator {
    private static final int a = 10;

    public static BlockPosition a(RandomSource random, int horizontalDistance, int verticalDistance) {
        int i2 = random.a(2 * horizontalDistance + 1) - horizontalDistance;
        int i1 = random.a(2 * verticalDistance + 1) - verticalDistance;
        int i22 = random.a(2 * horizontalDistance + 1) - horizontalDistance;
        return new BlockPosition(i2, i1, i22);
    }

    @Nullable
    public static BlockPosition a(RandomSource random, int maxHorizontalDifference, int yRange, int y2, double x2, double z2, double maxAngleDelta) {
        double d2 = MathHelper.d(z2, x2) - 1.5707963705062866;
        double d1 = d2 + (double)(2.0f * random.i() - 1.0f) * maxAngleDelta;
        double d22 = Math.sqrt(random.j()) * (double)MathHelper.g * (double)maxHorizontalDifference;
        double d3 = -d22 * Math.sin(d1);
        double d4 = d22 * Math.cos(d1);
        if (!(Math.abs(d3) > (double)maxHorizontalDifference) && !(Math.abs(d4) > (double)maxHorizontalDifference)) {
            int i2 = random.a(2 * yRange + 1) - yRange + y2;
            return BlockPosition.a(d3, (double)i2, d4);
        }
        return null;
    }

    @VisibleForTesting
    public static BlockPosition a(BlockPosition pos, int maxY, Predicate<BlockPosition> posPredicate) {
        if (!posPredicate.test(pos)) {
            return pos;
        }
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k().c(EnumDirection.b);
        while (mutableBlockPos.v() <= maxY && posPredicate.test(mutableBlockPos)) {
            mutableBlockPos.c(EnumDirection.b);
        }
        return mutableBlockPos.j();
    }

    @VisibleForTesting
    public static BlockPosition a(BlockPosition pos, int aboveSolidAmount, int maxY, Predicate<BlockPosition> posPredicate) {
        if (aboveSolidAmount < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + aboveSolidAmount + ", expected >= 0");
        }
        if (!posPredicate.test(pos)) {
            return pos;
        }
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k().c(EnumDirection.b);
        while (mutableBlockPos.v() <= maxY && posPredicate.test(mutableBlockPos)) {
            mutableBlockPos.c(EnumDirection.b);
        }
        int y2 = mutableBlockPos.v();
        while (mutableBlockPos.v() <= maxY && mutableBlockPos.v() - y2 < aboveSolidAmount) {
            mutableBlockPos.c(EnumDirection.b);
            if (!posPredicate.test(mutableBlockPos)) continue;
            mutableBlockPos.c(EnumDirection.a);
            break;
        }
        return mutableBlockPos.j();
    }

    @Nullable
    public static Vec3D a(EntityCreature mob, Supplier<BlockPosition> posSupplier) {
        return RandomPositionGenerator.a(posSupplier, mob::c);
    }

    @Nullable
    public static Vec3D a(Supplier<BlockPosition> posSupplier, ToDoubleFunction<BlockPosition> toDoubleFunction) {
        double d2 = Double.NEGATIVE_INFINITY;
        BlockPosition blockPos = null;
        for (int i2 = 0; i2 < 10; ++i2) {
            double d1;
            BlockPosition blockPos1 = posSupplier.get();
            if (blockPos1 == null || !((d1 = toDoubleFunction.applyAsDouble(blockPos1)) > d2)) continue;
            d2 = d1;
            blockPos = blockPos1;
        }
        return blockPos != null ? Vec3D.c(blockPos) : null;
    }

    public static BlockPosition a(EntityCreature mob, int range, RandomSource random, BlockPosition pos) {
        int x2 = pos.u();
        int z2 = pos.w();
        if (mob.gw() && range > 1) {
            BlockPosition homePosition = mob.gt();
            x2 = mob.dK() > (double)homePosition.u() ? (x2 -= random.a(range / 2)) : (x2 += random.a(range / 2));
            z2 = mob.dQ() > (double)homePosition.w() ? (z2 -= random.a(range / 2)) : (z2 += random.a(range / 2));
        }
        return BlockPosition.a((double)x2 + mob.dK(), (double)pos.v() + mob.dM(), (double)z2 + mob.dQ());
    }
}

