/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ambient;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ambient.EntityAmbient;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.purpurmc.purpur.controller.FlyingWithSpacebarMoveControllerWASD;

public class EntityBat
extends EntityAmbient {
    public static final float a = 0.5f;
    public static final float b = 10.0f;
    private static final DataWatcherObject<Byte> e = DataWatcher.a(EntityBat.class, DataWatcherRegistry.a);
    private static final int f = 1;
    private static final PathfinderTargetCondition cs = PathfinderTargetCondition.b().a(4.0);
    private static final byte ct = 0;
    public final AnimationState c = new AnimationState();
    public final AnimationState d = new AnimationState();
    @Nullable
    public BlockPosition cu;

    public EntityBat(EntityTypes<? extends EntityBat> type, World level) {
        super((EntityTypes<? extends EntityAmbient>)type, level);
        this.cn = new FlyingWithSpacebarMoveControllerWASD((EntityInsentient)this, 0.075f);
        if (!level.D_()) {
            this.x(true);
        }
    }

    @Override
    public boolean shouldSendAttribute(AttributeBase attribute) {
        return attribute != GenericAttributes.m.a();
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.batRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.batRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.batControllable;
    }

    @Override
    public double getMaxY() {
        return this.an().purpurConfig.batMaxY;
    }

    @Override
    public void onMount(EntityHuman rider) {
        super.onMount(rider);
        if (this.m()) {
            this.x(false);
            this.an().a(null, 1025, new BlockPosition(this).d(), 0);
        }
    }

    @Override
    public void m(Vec3D vec3) {
        super.m(vec3);
        if (this.getRider() != null && this.isControllable() && !((Entity)this).bc) {
            float speed = (float)this.i(GenericAttributes.m) * 2.0f;
            this.B(speed);
            Vec3D mot = this.dI();
            this.a(EnumMoveType.a, mot.d(speed, 0.25, speed));
            this.k(mot.c(0.9));
        }
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.batMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.batScale);
        this.h(GenericAttributes.n).a(this.an().purpurConfig.batFollowRange);
        this.h(GenericAttributes.q).a(this.an().purpurConfig.batKnockbackResistance);
        this.h(GenericAttributes.w).a(this.an().purpurConfig.batMovementSpeed);
        this.h(GenericAttributes.m).a(this.an().purpurConfig.batFlyingSpeed);
        this.h(GenericAttributes.a).a(this.an().purpurConfig.batArmor);
        this.h(GenericAttributes.b).a(this.an().purpurConfig.batArmorToughness);
        this.h(GenericAttributes.d).a(this.an().purpurConfig.batAttackKnockback);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.batTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.batAlwaysDropExp;
    }

    @Override
    public boolean bl() {
        return !this.m() && (float)this.at % 10.0f == 0.0f;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(e, (byte)0);
    }

    @Override
    public float ft() {
        return 0.1f;
    }

    @Override
    public float fu() {
        return super.fu() * 0.95f;
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return this.m() && this.as.a(4) != 0 ? null : SoundEffects.bG;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.bI;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.bH;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void E(Entity entity) {
    }

    @Override
    protected void q() {
    }

    public static AttributeProvider.Builder k() {
        return EntityInsentient.I().a(GenericAttributes.t, 6.0).a(GenericAttributes.m, 0.6);
    }

    public boolean m() {
        return (this.az.a(e) & 1) != 0;
    }

    public void x(boolean isResting) {
        byte b2 = this.az.a(e);
        if (isResting) {
            this.az.a(e, (byte)(b2 | 1));
        } else {
            this.az.a(e, (byte)(b2 & 0xFFFFFFFE));
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.m()) {
            this.k(Vec3D.c);
            this.n(this.dK(), (double)MathHelper.a(this.dM()) + 1.0 - (double)this.dB(), this.dQ());
        } else {
            this.k(this.dI().d(1.0, 0.6, 1.0));
        }
        this.s();
    }

    @Override
    protected void a(WorldServer level) {
        if (this.getRider() != null && this.isControllable()) {
            Vec3D mot = this.dI();
            this.m(mot.a(), mot.b() + (this.getVerticalMot() > 0.0f ? 0.07 : 0.0), mot.c());
            return;
        }
        super.a(level);
        BlockPosition blockPos = this.dF();
        BlockPosition blockPos1 = blockPos.d();
        if (this.m()) {
            boolean isSilent = this.bm();
            if (level.a_(blockPos1).d(level, blockPos)) {
                if (this.as.a(200) == 0) {
                    this.bD = this.as.a(360);
                }
                if (level.a(cs, this) != null && CraftEventFactory.handleBatToggleSleepEvent(this, true)) {
                    this.x(false);
                    if (!isSilent) {
                        level.a(null, 1025, blockPos, 0);
                    }
                }
            } else if (CraftEventFactory.handleBatToggleSleepEvent(this, true)) {
                this.x(false);
                if (!isSilent) {
                    level.a(null, 1025, blockPos, 0);
                }
            }
        } else {
            if (!(this.cu == null || level.w(this.cu) && this.cu.v() > level.M_())) {
                this.cu = null;
            }
            if (this.cu == null || this.as.a(30) == 0 || this.cu.a(this.dD(), 2.0)) {
                this.cu = BlockPosition.a(this.dK() + (double)this.as.a(7) - (double)this.as.a(7), this.dM() + (double)this.as.a(6) - 2.0, this.dQ() + (double)this.as.a(7) - (double)this.as.a(7));
            }
            double d2 = (double)this.cu.u() + 0.5 - this.dK();
            double d1 = (double)this.cu.v() + 0.1 - this.dM();
            double d22 = (double)this.cu.w() + 0.5 - this.dQ();
            Vec3D deltaMovement = this.dI();
            Vec3D vec3 = deltaMovement.b((Math.signum(d2) * 0.5 - deltaMovement.g) * (double)0.1f, (Math.signum(d1) * (double)0.7f - deltaMovement.h) * (double)0.1f, (Math.signum(d22) * 0.5 - deltaMovement.i) * (double)0.1f);
            this.k(vec3);
            float f2 = (float)(MathHelper.d(vec3.i, vec3.g) * 180.0 / 3.1415927410125732) - 90.0f;
            float f1 = MathHelper.h(f2 - this.dX());
            this.bO = 0.5f;
            this.v(this.dX() + f1);
            if (this.as.a(100) == 0 && level.a_(blockPos1).d(level, blockPos1) && CraftEventFactory.handleBatToggleSleepEvent(this, false)) {
                this.x(true);
            }
        }
    }

    @Override
    protected Entity.MovementEmission br() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public boolean o_() {
        return true;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if (this.m() && CraftEventFactory.handleBatToggleSleepEvent(this, true)) {
            this.x(false);
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.az.a(e, input.a("BatFlags", (byte)0));
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("BatFlags", this.az.a(e));
    }

    public static boolean b(EntityTypes<EntityBat> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource randomSource) {
        if (pos.v() >= level.a(HeightMap.Type.b, pos).v()) {
            return false;
        }
        int maxLocalRawBrightness = level.C(pos);
        int i2 = 4;
        if (EntityBat.isHalloweenSeason(level.getMinecraftWorld())) {
            i2 = 7;
        } else if (randomSource.h()) {
            return false;
        }
        return maxLocalRawBrightness <= randomSource.a(i2) && level.a_(pos.e()).a(TagsBlock.cv) && EntityBat.a(entityType, level, spawnReason, pos, randomSource);
    }

    public static boolean isHalloweenSeason(World level) {
        return level.purpurConfig.forceHalloweenSeason || EntityBat.n();
    }

    private static boolean n() {
        LocalDate localDate = LocalDate.now();
        int i2 = localDate.get(ChronoField.DAY_OF_MONTH);
        int i1 = localDate.get(ChronoField.MONTH_OF_YEAR);
        return i1 == 10 && i2 >= 20 || i1 == 11 && i2 <= 3;
    }

    private void s() {
        if (this.m()) {
            this.c.a();
            this.d.b(this.at);
        } else {
            this.d.a();
            this.c.b(this.at);
        }
    }
}

