/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public abstract class AbstractCow
extends EntityAnimal {
    private static final EntitySize ct = EntityTypes.F.n().a(0.5f).b(0.665f);
    private int redMushroomsFed = 0;
    private int brownMushroomsFed = 0;

    public AbstractCow(EntityTypes<? extends AbstractCow> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
    }

    @Override
    protected void H() {
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(0, new HasRider(this));
        this.cq.a(1, new PathfinderGoalPanic(this, 2.0));
        this.cq.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cq.a(3, new PathfinderGoalTempt(this, 1.25, itemStack -> this.an().purpurConfig.cowFeedMushrooms > 0 && (itemStack.a(Blocks.cq.h()) || itemStack.a(Blocks.cp.h())) || itemStack.a(TagsItem.aE), false));
        this.cq.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.cq.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cq.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cq.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aE);
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gN().a(GenericAttributes.t, 10.0).a(GenericAttributes.w, 0.2f);
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.gK;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.gM;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.gL;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.gO, 0.15f, 1.0f);
    }

    @Override
    public float ft() {
        return 0.4f;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        if (this.getRider() != null) {
            return EnumInteractionResult.e;
        }
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.sk) && !this.g_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent(player.an(), player, this.dF(), this.dF(), null, itemInHand, Items.sq, hand);
            if (event.isCancelled()) {
                player.cl.b();
                return this.tryRide(player, hand);
            }
            player.a(SoundEffects.gN, 1.0f, 1.0f);
            ItemStack itemStack = ItemLiquidUtil.a(itemInHand, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemStack);
            return EnumInteractionResult.a;
        }
        if (this.an().purpurConfig.cowFeedMushrooms > 0 && this.ax() != EntityTypes.aJ && this.isMushroom(itemInHand)) {
            return this.feedMushroom(player, itemInHand);
        }
        return super.b(player, hand);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.g_() ? ct : super.b(pose);
    }

    private boolean isMushroom(ItemStack stack) {
        return stack.h() == Blocks.cq.h() || stack.h() == Blocks.cp.h();
    }

    private int incrementFeedCount(ItemStack stack) {
        if (stack.h() == Blocks.cq.h()) {
            return ++this.redMushroomsFed;
        }
        return ++this.brownMushroomsFed;
    }

    private EnumInteractionResult feedMushroom(EntityHuman player, ItemStack stack) {
        this.an().a((Entity)this, (byte)18);
        this.a(SoundEffects.gN, 1.0f, 1.0f);
        if (this.incrementFeedCount(stack) < this.an().purpurConfig.cowFeedMushrooms) {
            if (!player.gC().d) {
                stack.h(1);
            }
            return EnumInteractionResult.c;
        }
        EntityMushroomCow mooshroom = EntityTypes.aJ.a(this.an(), EntitySpawnReason.i);
        if (mooshroom == null) {
            return EnumInteractionResult.e;
        }
        if (stack.h() == Blocks.cp.h()) {
            mooshroom.a(EntityMushroomCow.Type.b);
        } else {
            mooshroom.a(EntityMushroomCow.Type.a);
        }
        mooshroom.b(this.dK(), this.dM(), this.dQ(), this.dX(), this.dZ());
        mooshroom.x(this.eU());
        mooshroom.c_(this.aa_());
        mooshroom.x(this);
        mooshroom.s(this.bB);
        mooshroom.r(this.cN());
        mooshroom.ab = this.ab;
        mooshroom.ac = this.ac;
        if (this.k_()) {
            mooshroom.b(this.ar());
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, mooshroom, EntityTransformEvent.TransformReason.INFECTION).isCancelled()) {
            return EnumInteractionResult.e;
        }
        this.an().b(mooshroom);
        this.remove(Entity.RemovalReason.b, EntityRemoveEvent.Cause.DISCARD);
        if (!player.gC().d) {
            stack.h(1);
        }
        for (int i2 = 0; i2 < 15; ++i2) {
            ((WorldServer)this.an()).sendParticlesSource(((WorldServer)this.an()).C(), null, Particles.R, false, true, this.dK() + (double)this.as.i(), this.dM() + (double)(this.as.i() * 2.0f), this.dQ() + (double)this.as.i(), 1, this.as.k() * 0.05, this.as.k() * 0.05, this.as.k() * 0.05, 0.0);
        }
        return EnumInteractionResult.a;
    }
}

