/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.annotation.DoNotUse;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int cw = 6000;
    private static final int ct = 0;
    public int cu = 0;
    @Nullable
    public EntityReference<EntityPlayer> cv;
    @Nullable
    public ItemStack breedItem;

    public abstract int getPurpurBreedTime();

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> type, World level) {
        super((EntityTypes<? extends EntityAgeable>)type, level);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    public static AttributeProvider.Builder gN() {
        return EntityInsentient.I().a(GenericAttributes.F, 10.0);
    }

    @Override
    protected void a(WorldServer level) {
        if (this.aa_() != 0) {
            this.cu = 0;
        }
        super.a(level);
    }

    @Override
    public void e_() {
        super.e_();
        if (this.aa_() != 0) {
            this.cu = 0;
        }
        if (this.cu > 0) {
            --this.cu;
            if (this.cu % 10 == 0) {
                double d2 = this.as.k() * 0.02;
                double d1 = this.as.k() * 0.02;
                double d22 = this.as.k() * 0.02;
                this.an().a(Particles.T, this.e(1.0), this.dN() + 0.5, this.h(1.0), d2, d1, d22);
            }
        }
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(level, damageSource, amount, event);
        if (!damageResult) {
            return false;
        }
        this.gT();
        return true;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return level.a_(pos.e()).a(Blocks.i) ? 10.0f : level.y(pos);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("InLove", this.cu);
        EntityReference.a(this.cv, output, "LoveCause");
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.cu = input.a("InLove", 0);
        this.cv = EntityReference.a(input, "LoveCause");
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        boolean flag = EntitySpawnReason.b(spawnReason) || EntityAnimal.a(level, pos);
        return level.a_(pos.e()).a(TagsBlock.ck) && flag;
    }

    protected static boolean a(IBlockLightAccess level, BlockPosition pos) {
        return level.b(pos, 0) > 8;
    }

    @Override
    public int W() {
        return 120;
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected int f(WorldServer level) {
        return 1 + this.as.a(3);
    }

    public abstract boolean i(ItemStack var1);

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (this.i(itemInHand)) {
            int age = this.aa_();
            if (player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                if (age == 0 && this.gP() && (this.an().purpurConfig.animalBreedingCooldownSeconds <= 0 || !this.an().hasBreedingCooldown(player.cT(), this.getClass()))) {
                    ItemStack breedCopy = itemInHand.v();
                    this.a(player, hand, itemInHand);
                    this.setInLove(serverPlayer, breedCopy);
                    this.gO();
                    return EnumInteractionResult.b;
                }
            }
            if (this.g_()) {
                this.a(player, hand, itemInHand);
                this.a(EntityAnimal.d_(-age), true);
                this.gO();
                return EnumInteractionResult.a;
            }
            if (this.an().D_()) {
                return EnumInteractionResult.c;
            }
        }
        return super.b(player, hand);
    }

    protected void gO() {
    }

    public boolean gP() {
        return this.cu <= 0;
    }

    @Deprecated
    @DoNotUse
    public void h(@Nullable EntityHuman player) {
        this.setInLove(player, null);
    }

    public void setInLove(@Nullable EntityHuman player, @Nullable ItemStack breedItemCopy) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent;
        if (breedItemCopy != null) {
            this.breedItem = breedItemCopy;
        }
        if ((entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(player, this, 600)).isCancelled()) {
            this.breedItem = null;
            return;
        }
        this.cu = entityEnterLoveModeEvent.getTicksInLove();
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            this.cv = EntityReference.a(serverPlayer);
        }
        this.an().a((Entity)this, (byte)18);
    }

    public void r(int inLove) {
        this.cu = inLove;
    }

    public int gQ() {
        return this.cu;
    }

    @Nullable
    public EntityPlayer gR() {
        return EntityReference.a(this.cv, this.an(), EntityPlayer.class);
    }

    public boolean gS() {
        return this.cu > 0;
    }

    public void gT() {
        this.cu = 0;
    }

    public boolean a(EntityAnimal otherAnimal) {
        return otherAnimal != this && otherAnimal.getClass() == this.getClass() && this.gS() && otherAnimal.gS();
    }

    public void a(WorldServer level, EntityAnimal partner) {
        EntityAgeable breedOffspring = this.a(level, (EntityAgeable)partner);
        if (breedOffspring != null) {
            EntityPlayer breeder = Optional.ofNullable(this.gR()).or(() -> Optional.ofNullable(partner.gR())).orElse(null);
            if (breeder != null && level.purpurConfig.animalBreedingCooldownSeconds > 0) {
                if (level.hasBreedingCooldown(breeder.cT(), this.getClass())) {
                    return;
                }
                level.addBreedingCooldown(breeder.cT(), this.getClass());
            }
            breedOffspring.a(true);
            breedOffspring.b(this.dK(), this.dM(), this.dQ(), 0.0f, 0.0f);
            int experience = this.ek().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(breedOffspring, this, partner, breeder, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                this.gT();
                partner.gT();
                return;
            }
            experience = entityBreedEvent.getExperience();
            this.finalizeSpawnChildFromBreeding(level, partner, breedOffspring, experience);
            level.addFreshEntityWithPassengers(breedOffspring, CreatureSpawnEvent.SpawnReason.BREEDING);
        }
    }

    public void a(WorldServer level, EntityAnimal animal, @Nullable EntityAgeable baby) {
        this.finalizeSpawnChildFromBreeding(level, animal, baby, this.ek().a(7) + 1);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer level, EntityAnimal animal, @Nullable EntityAgeable baby, int experience) {
        EntityPlayer player = this.gR();
        if (player == null) {
            player = animal.gR();
        }
        if (player != null) {
            player.a(StatisticList.Q);
            CriterionTriggers.p.a(player, this, animal, baby);
        }
        this.c_(this.getPurpurBreedTime());
        animal.c_(animal.getPurpurBreedTime());
        this.gT();
        animal.gT();
        level.a((Entity)this, (byte)18);
        if (experience > 0 && level.S().c(GameRules.g)) {
            level.b(new EntityExperienceOrb(level, this.dD(), Vec3D.c, experience, ExperienceOrb.SpawnReason.BREED, player, baby));
        }
    }

    @Override
    public void b(byte id) {
        if (id == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d2 = this.as.k() * 0.02;
                double d1 = this.as.k() * 0.02;
                double d22 = this.as.k() * 0.02;
                this.an().a(Particles.T, this.e(1.0), this.dN() + 0.5, this.h(1.0), d2, d1, d22);
            }
        } else {
            super.b(id);
        }
    }
}

