/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.debug.DebugBeeInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockFlowers;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Bee;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.purpurmc.purpur.controller.FlyingMoveControllerWASD;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;
import org.purpurmc.purpur.event.entity.BeeFoundFlowerEvent;
import org.purpurmc.purpur.event.entity.BeeStartedPollinatingEvent;
import org.purpurmc.purpur.event.entity.BeeStopPollinatingEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityBee
extends EntityAnimal
implements IEntityAngerable,
EntityBird {
    public static final float ct = 120.32113f;
    public static final int cu = MathHelper.f(1.4959966f);
    private static final DataWatcherObject<Byte> cE = DataWatcher.a(EntityBee.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> cF = DataWatcher.a(EntityBee.class, DataWatcherRegistry.b);
    private static final int cG = 2;
    private static final int cH = 4;
    private static final int cI = 8;
    private static final int cJ = 1200;
    private static final int cK = 600;
    private static final int cL = 3600;
    private static final int cM = 4;
    private static final int cN = 10;
    private static final int cO = 10;
    private static final int cP = 18;
    private static final int cS = 48;
    private static final int cT = 2;
    private static final int cU = 24;
    private static final int cV = 16;
    private static final int cW = 16;
    private static final int cX = 20;
    public static final String cv = "CropsGrownSincePollination";
    public static final String cx = "CannotEnterHiveTicks";
    public static final String cy = "TicksSincePollination";
    public static final String cz = "HasStung";
    public static final String cA = "HasNectar";
    public static final String cB = "flower_pos";
    public static final String cC = "hive_pos";
    public static final boolean cD = false;
    private static final boolean cY = false;
    private static final int cZ = 0;
    private static final int da = 0;
    private static final int db = 0;
    private static final UniformInt dc = TimeRange.a(20, 39);
    @Nullable
    private UUID dd;
    private float de;
    private float df;
    public int dg;
    public int dh = 0;
    public int di = 0;
    public int dj = 0;
    private static final int dk = 200;
    int dl;
    private static final int dm = 200;
    private static final int dn = 20;
    private static final int do = 60;
    int dp = MathHelper.a(this.as, 20, 60);
    @Nullable
    BlockPosition dq;
    @Nullable
    public BlockPosition dr;
    k ds;
    e dt;
    private f du;
    private int dv;
    public TriState rollingOverride = TriState.NOT_SET;

    public EntityBee(EntityTypes<? extends EntityBee> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        final FlyingMoveControllerWASD flyingController = new FlyingMoveControllerWASD(this, 0.25f, 1.0f, false);
        class BeeFlyingMoveControl
        extends ControllerMoveFlying {
            public BeeFlyingMoveControl(EntityInsentient mob, int maxTurn, boolean hoversInPlace) {
                super(mob, maxTurn, hoversInPlace);
            }

            @Override
            public void a() {
                if (this.d.getRider() != null && this.d.isControllable()) {
                    flyingController.purpurTick(this.d.getRider());
                    return;
                }
                if (this.d.dM() <= (double)EntityBee.this.an().M_()) {
                    this.d.g(false);
                }
                super.a();
            }

            @Override
            public boolean b() {
                return this.d.getRider() != null || !this.d.isControllable() || super.b();
            }
        }
        this.cn = new BeeFlyingMoveControl(this, 20, true);
        this.cm = new j(this);
        this.a(PathType.n, -1.0f);
        if (this.an().purpurConfig.beeCanInstantlyStartDrowning || this.fG()) {
            this.a(PathType.j, -1.0f);
        }
        this.a(PathType.k, 16.0f);
        this.a(PathType.x, -1.0f);
        this.a(PathType.h, -1.0f);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.beeRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.beeRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.beeControllable;
    }

    @Override
    public double getMaxY() {
        return this.an().purpurConfig.beeMaxY;
    }

    @Override
    public void m(Vec3D vec3) {
        super.m(vec3);
        if (this.getRider() != null && this.isControllable() && !((Entity)this).bc) {
            float speed = (float)this.i(GenericAttributes.m) * 2.0f;
            this.B(speed);
            Vec3D mot = this.dI();
            this.a(EnumMoveType.a, mot.d(speed, speed, speed));
            this.k(mot.c(0.9));
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cE, (byte)0);
        builder.a(cF, 0);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return level.a_(pos).l() ? 10.0f : 0.0f;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        this.cq.a(0, new b(this, 1.4f, true));
        this.cq.a(1, new d());
        this.cq.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cq.a(3, new PathfinderGoalTempt(this, 1.25, stack -> stack.a(TagsItem.ar), false));
        this.cq.a(3, new n());
        this.cq.a(3, new m());
        this.ds = new k();
        this.cq.a(4, this.ds);
        this.cq.a(5, new PathfinderGoalFollowParent(this, 1.25));
        this.cq.a(5, new i());
        this.dt = new e();
        this.cq.a(5, this.dt);
        this.du = new f();
        this.cq.a(6, this.du);
        this.cq.a(7, new g());
        this.cq.a(8, new l());
        this.cq.a(9, new PathfinderGoalFloat(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new h(this).a(new Class[0]));
        this.cr.a(2, new c(this));
        this.cr.a(3, new PathfinderGoalUniversalAngerReset<EntityBee>(this, true));
    }

    @Override
    protected void a(ValueOutput output) {
        this.addAdditionalSaveData(output, true);
    }

    @Override
    public void addAdditionalSaveData(ValueOutput output, boolean saveAll) {
        super.a(output);
        if (saveAll) {
            output.b(cC, BlockPosition.a, this.dr);
            output.b(cB, BlockPosition.a, this.dq);
        }
        output.a(cA, this.gU());
        output.a(cz, this.gV());
        output.a(cy, this.dh);
        output.a(cx, this.di);
        output.a(cv, this.dj);
        this.a_(output);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a(cA, false));
        this.y(input.a(cz, false));
        this.dh = input.a(cy, 0);
        this.di = input.a(cx, 0);
        this.dj = input.a(cv, 0);
        this.dr = input.a(cC, BlockPosition.a).orElse(null);
        this.dq = input.a(cB, BlockPosition.a).orElse(null);
        this.a(this.an(), input);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        DamageSource damageSource = this.ei().a(this);
        boolean flag = target.a(level, damageSource, (float)((int)this.i(GenericAttributes.c)));
        if (flag) {
            EnchantmentManager.a(level, target, damageSource);
            if (target instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)target;
                livingEntity.p(livingEntity.fm() + 1);
                int i2 = 0;
                if (this.an().aq() == EnumDifficulty.c) {
                    i2 = 10;
                } else if (this.an().aq() == EnumDifficulty.d) {
                    i2 = 18;
                }
                if (i2 > 0) {
                    livingEntity.addEffect(new MobEffect(MobEffects.s, i2 * 20, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
            this.y(true);
            this.i();
            this.a(SoundEffects.bT, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public void g() {
        super.g();
        if (this.gU() && this.hf() < 10 && this.as.i() < 0.05f) {
            for (int i2 = 0; i2 < this.as.a(2) + 1; ++i2) {
                this.a(this.an(), this.dK() - (double)0.3f, this.dK() + (double)0.3f, this.dQ() - (double)0.3f, this.dQ() + (double)0.3f, this.f(0.5), Particles.aC);
            }
        }
        this.hd();
    }

    private void a(World level, double startX, double endX, double startZ, double endZ, double posY, ParticleParam options) {
        level.a(options, MathHelper.d(level.z.j(), startX, endX), posY, MathHelper.d(level.z.j(), startZ, endZ), 0.0, 0.0, 0.0);
    }

    void j(BlockPosition pos) {
        Vec3D posTowards;
        Vec3D vec3 = Vec3D.c(pos);
        int i2 = 0;
        BlockPosition blockPos = this.dF();
        int i1 = (int)vec3.h - blockPos.v();
        if (i1 > 2) {
            i2 = 4;
        } else if (i1 < -2) {
            i2 = -4;
        }
        int i22 = 6;
        int i3 = 8;
        int i4 = blockPos.k(pos);
        if (i4 < 15) {
            i22 = i4 / 2;
            i3 = i4 / 2;
        }
        if ((posTowards = AirRandomPos.a(this, i22, i3, i2, vec3, 0.3141592741012573)) != null) {
            this.cp.b(0.5f);
            this.cp.a(posTowards.g, posTowards.h, posTowards.i, 1.0);
        }
    }

    @Nullable
    public BlockPosition m() {
        return this.dq;
    }

    public boolean n() {
        return this.dq != null;
    }

    public void h(BlockPosition savedFlowerPos) {
        this.dq = savedFlowerPos;
    }

    @VisibleForDebug
    public int s() {
        return Math.max(this.dt.d, this.du.d);
    }

    @VisibleForDebug
    public List<BlockPosition> gI() {
        return this.dt.f;
    }

    private boolean gZ() {
        return this.dh > 3600;
    }

    void ha() {
        this.dr = null;
        this.dl = 200;
    }

    void hb() {
        this.dq = null;
        this.dp = MathHelper.a(this.as, 20, 60);
    }

    boolean hc() {
        if (this.di <= 0 && !this.ds.l() && !this.gV() && this.e() == null) {
            boolean flag = this.gZ() || EntityBee.c(this.an()) || this.gU();
            return flag && !this.he();
        }
        return false;
    }

    public static boolean c(World level) {
        return level.H_().g() && (level.ab() && !level.purpurConfig.beeCanWorkAtNight || level.aj() && !level.purpurConfig.beeCanWorkInRain);
    }

    public void s(int stayOutOfHiveCountdown) {
        this.di = stayOutOfHiveCountdown;
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.df, this.de);
    }

    private void hd() {
        this.df = this.de;
        this.de = this.hk() ? Math.min(1.0f, this.de + 0.2f) : Math.max(0.0f, this.de - 0.24f);
    }

    @Override
    protected void a(WorldServer level) {
        boolean hasStung = this.gV();
        this.dv = this.an().purpurConfig.beeCanInstantlyStartDrowning && this.bu() ? ++this.dv : 0;
        if (this.dv > 20) {
            this.a(level, this.ei().i(), 1.0f);
        }
        if (hasStung && !this.an().purpurConfig.beeDiesAfterSting) {
            this.y(false);
        } else if (hasStung) {
            ++this.dg;
            if (this.dg % 5 == 0 && this.as.a(MathHelper.a(1200 - this.dg, 1, 1200)) == 0) {
                this.a(level, this.ei().p(), this.eU());
            }
        }
        if (!this.gU()) {
            ++this.dh;
        }
        this.a(level, false);
    }

    public void gJ() {
        this.dh = 0;
    }

    private boolean he() {
        TileEntityBeehive beehiveBlockEntity = this.hi();
        return beehiveBlockEntity != null && beehiveBlockEntity.a();
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.beeMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.beeScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.beeBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.beeTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.beeAlwaysDropExp;
    }

    @Override
    public int a() {
        return this.az.a(cF);
    }

    @Override
    public void a(int time) {
        this.az.a(cF, time);
    }

    @Override
    @Nullable
    public UUID b() {
        return this.dd;
    }

    @Override
    public void a(@Nullable UUID target) {
        this.dd = target;
    }

    @Override
    public void c() {
        this.a(dc.a(this.as));
    }

    private boolean k(BlockPosition hivePos) {
        TileEntity blockEntity = this.an().c_(hivePos);
        return blockEntity instanceof TileEntityBeehive && !((TileEntityBeehive)blockEntity).d();
    }

    @VisibleForDebug
    public boolean gK() {
        return this.dr != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPosition gL() {
        return this.dr;
    }

    @VisibleForDebug
    public PathfinderGoalSelector gM() {
        return this.cq;
    }

    int hf() {
        return this.dj;
    }

    private void hg() {
        this.dj = 0;
    }

    void hh() {
        ++this.dj;
    }

    @Override
    public void e_() {
        super.e_();
        if (!this.an().D_()) {
            if (this.di > 0) {
                --this.di;
            }
            if (this.dl > 0) {
                --this.dl;
            }
            if (this.dp > 0) {
                --this.dp;
            }
            boolean flag = this.ae_() && !this.gV() && this.e() != null && this.e().g(this) < 4.0;
            this.z(flag);
            if (this.at % 20 == 0 && !this.hj()) {
                this.dr = null;
            }
        }
    }

    @Nullable
    TileEntityBeehive hi() {
        if (this.dr == null) {
            return null;
        }
        return this.l(this.dr) || this.an().getChunkIfLoadedImmediately(this.dr.u() >> 4, this.dr.w() >> 4) == null ? null : (TileEntityBeehive)this.an().a(this.dr, TileEntityTypes.I).orElse(null);
    }

    boolean hj() {
        return this.hi() != null;
    }

    public boolean gU() {
        return this.t(8);
    }

    public void x(boolean hasNectar) {
        if (hasNectar) {
            this.gJ();
        }
        this.d(8, hasNectar);
    }

    public boolean gV() {
        return this.t(4);
    }

    public void y(boolean hasStung) {
        this.d(4, hasStung);
    }

    public boolean hk() {
        return this.t(2);
    }

    public void z(boolean isRolling) {
        isRolling = this.rollingOverride.toBooleanOrElse(isRolling);
        this.d(2, isRolling);
    }

    boolean l(BlockPosition pos) {
        return !this.b(pos, 48);
    }

    private void d(int flagId, boolean value) {
        if (value) {
            this.az.a(cE, (byte)(this.az.a(cE) | flagId));
        } else {
            this.az.a(cE, (byte)(this.az.a(cE) & ~flagId));
        }
    }

    private boolean t(int flagId) {
        return (this.az.a(cE) & flagId) != 0;
    }

    public static AttributeProvider.Builder gW() {
        return EntityAnimal.gN().a(GenericAttributes.t, 10.0).a(GenericAttributes.m, 0.6f).a(GenericAttributes.w, 0.3f).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        NavigationFlying flyingPathNavigation = new NavigationFlying(this, level){

            @Override
            public boolean a(BlockPosition pos) {
                return !this.b.a_(pos.e()).l();
            }

            @Override
            public void d() {
                if (!EntityBee.this.ds.l()) {
                    super.d();
                }
            }
        };
        flyingPathNavigation.e(false);
        flyingPathNavigation.a(false);
        flyingPathNavigation.a(48.0f);
        return flyingPathNavigation;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        BlockFlowers flowerBlock;
        MobEffect beeInteractionEffect;
        ItemBlock blockItem;
        IMaterial iMaterial;
        ItemStack itemInHand = player.b(hand);
        if (this.i(itemInHand) && (iMaterial = itemInHand.h()) instanceof ItemBlock && (iMaterial = (blockItem = (ItemBlock)iMaterial).c()) instanceof BlockFlowers && (beeInteractionEffect = (flowerBlock = (BlockFlowers)iMaterial).b()) != null) {
            this.a(player, hand, itemInHand);
            if (!this.an().D_()) {
                this.addEffect(beeInteractionEffect, EntityPotionEffectEvent.Cause.FOOD);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.ar);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
    }

    @Override
    public SoundEffect p() {
        return null;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.bQ;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.bP;
    }

    @Override
    public float ft() {
        return 0.4f;
    }

    @Nullable
    public EntityBee b(WorldServer level, EntityAgeable partner) {
        return EntityTypes.n.a(level, EntitySpawnReason.e);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public boolean bl() {
        return this.gX() && this.at % cu == 0;
    }

    @Override
    public boolean gX() {
        return !this.aS();
    }

    public void gY() {
        this.x(false);
        this.hg();
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        this.ds.m();
        return true;
    }

    @Override
    protected void c(TagKey<FluidType> fluidTag) {
        this.k(this.dI().b(0.0, 0.01, 0.0));
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.5f * this.df(), this.dA() * 0.2f);
    }

    boolean b(BlockPosition pos, int distance) {
        return pos.a(this.dF(), (double)distance);
    }

    public void i(BlockPosition hivePos) {
        this.dr = hivePos;
    }

    public static boolean c(IBlockData state) {
        return state.a(TagsBlock.ar) && state.a(BlockProperties.I, false) == false && (!state.a(Blocks.jv) || state.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.a);
    }

    @Override
    public void a(WorldServer level, DebugValueSource.a registrar) {
        super.a(level, registrar);
        registrar.a(DebugSubscriptions.b, () -> new DebugBeeInfo(Optional.ofNullable(this.gL()), Optional.ofNullable(this.m()), this.s(), this.gI()));
    }

    class j
    extends LookControllerWASD {
        j(EntityInsentient mob) {
            super(mob);
        }

        @Override
        public void vanillaTick() {
            if (!EntityBee.this.ae_()) {
                super.vanillaTick();
            }
        }

        @Override
        protected boolean c() {
            return !EntityBee.this.ds.l();
        }
    }

    class b
    extends PathfinderGoalMeleeAttack {
        b(EntityCreature mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(mob, speedModifier, followingTargetEvenIfNotSeen);
        }

        @Override
        public boolean b() {
            return super.b() && EntityBee.this.ae_() && !EntityBee.this.gV();
        }

        @Override
        public boolean c() {
            return super.c() && EntityBee.this.ae_() && !EntityBee.this.gV();
        }
    }

    class d
    extends a {
        d() {
        }

        @Override
        public boolean h() {
            TileEntityBeehive beehiveBlockEntity;
            if (EntityBee.this.dr != null && EntityBee.this.hc() && EntityBee.this.dr.a(EntityBee.this.dD(), 2.0) && (beehiveBlockEntity = EntityBee.this.hi()) != null) {
                if (!beehiveBlockEntity.d()) {
                    return true;
                }
                EntityBee.this.dr = null;
            }
            return false;
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void d() {
            TileEntityBeehive beehiveBlockEntity = EntityBee.this.hi();
            if (beehiveBlockEntity != null) {
                beehiveBlockEntity.a(EntityBee.this);
            }
        }
    }

    class n
    extends a {
        private final int c;
        private long d;

        n() {
            this.c = MathHelper.a(EntityBee.this.as, 20, 40);
            this.d = -1L;
        }

        @Override
        public void d() {
            if (EntityBee.this.dr != null && EntityBee.this.an().p(EntityBee.this.dr) && !EntityBee.this.hj()) {
                EntityBee.this.ha();
            }
            this.d = EntityBee.this.an().ag();
        }

        @Override
        public boolean h() {
            return EntityBee.this.an().ag() > this.d + (long)this.c;
        }

        @Override
        public boolean i() {
            return false;
        }
    }

    class m
    extends a {
        private final int c;
        private long d;

        m() {
            this.c = MathHelper.a(EntityBee.this.as, 20, 40);
            this.d = -1L;
        }

        @Override
        public void d() {
            if (EntityBee.this.dq != null && EntityBee.this.an().p(EntityBee.this.dq) && !this.a(EntityBee.this.dq)) {
                EntityBee.this.hb();
            }
            this.d = EntityBee.this.an().ag();
        }

        @Override
        public boolean h() {
            return EntityBee.this.an().ag() > this.d + (long)this.c;
        }

        @Override
        public boolean i() {
            return false;
        }

        private boolean a(BlockPosition pos) {
            return EntityBee.c(EntityBee.this.an().a_(pos));
        }
    }

    class k
    extends a {
        private static final int c = 400;
        private static final double d = 0.1;
        private static final int e = 25;
        private static final float f = 0.35f;
        private static final float g = 0.6f;
        private static final float h = 0.33333334f;
        private static final int i = 5;
        private int j;
        private int k;
        private boolean l;
        @Nullable
        private Vec3D m;
        private int n;
        private static final int o = 600;
        private Long2LongOpenHashMap p;

        k() {
            this.p = new Long2LongOpenHashMap();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            if (EntityBee.this.dp > 0) {
                return false;
            }
            if (EntityBee.this.gU()) {
                return false;
            }
            if (EntityBee.this.an().aj()) {
                return false;
            }
            Optional<BlockPosition> optional = this.p();
            if (optional.isPresent()) {
                EntityBee.this.dq = optional.get();
                EntityBee.this.cp.a((double)EntityBee.this.dq.u() + 0.5, (double)EntityBee.this.dq.v() + 0.5, (double)EntityBee.this.dq.w() + 0.5, 1.2f);
                new BeeFoundFlowerEvent((Bee)EntityBee.this.getBukkitEntity(), CraftLocation.toBukkit((BaseBlockPosition)EntityBee.this.dq, EntityBee.this.an())).callEvent();
                return true;
            }
            EntityBee.this.dp = MathHelper.a(EntityBee.this.as, 20, 60);
            return false;
        }

        @Override
        public boolean i() {
            return this.l && EntityBee.this.n() && !EntityBee.this.an().aj() && (!this.k() || EntityBee.this.as.i() < 0.2f);
        }

        private boolean k() {
            return this.j > 400;
        }

        boolean l() {
            return this.l;
        }

        void m() {
            this.l = false;
        }

        @Override
        public void d() {
            this.j = 0;
            this.n = 0;
            this.k = 0;
            this.l = true;
            EntityBee.this.gJ();
        }

        @Override
        public void e() {
            if (this.k()) {
                EntityBee.this.x(true);
            }
            this.l = false;
            EntityBee.this.cp.n();
            EntityBee.this.dp = 200;
            new BeeStopPollinatingEvent((Bee)EntityBee.this.getBukkitEntity(), EntityBee.this.dq == null ? null : CraftLocation.toBukkit((BaseBlockPosition)EntityBee.this.dq, EntityBee.this.an()), EntityBee.this.gU()).callEvent();
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            if (EntityBee.this.n()) {
                ++this.n;
                if (this.n > 600) {
                    EntityBee.this.hb();
                    this.l = false;
                    EntityBee.this.dp = 200;
                } else if (EntityBee.this.dq != null) {
                    Vec3D vec3 = Vec3D.c(EntityBee.this.dq).b(0.0, 0.6f, 0.0);
                    if (vec3.f(EntityBee.this.dD()) > 1.0) {
                        this.m = vec3;
                        this.n();
                    } else {
                        if (this.m == null) {
                            this.m = vec3;
                        }
                        boolean flag = EntityBee.this.dD().f(this.m) <= 0.1;
                        boolean flag1 = true;
                        if (!flag && this.n > 600) {
                            EntityBee.this.hb();
                        } else {
                            if (flag) {
                                boolean flag2;
                                boolean bl = flag2 = EntityBee.this.as.a(25) == 0;
                                if (flag2) {
                                    this.m = new Vec3D(vec3.a() + (double)this.o(), vec3.b(), vec3.c() + (double)this.o());
                                    EntityBee.this.cp.n();
                                } else {
                                    flag1 = false;
                                }
                                EntityBee.this.P().a(vec3.a(), vec3.b(), vec3.c());
                            }
                            if (flag1) {
                                this.n();
                            }
                            if (this.j == 0) {
                                new BeeStartedPollinatingEvent((Bee)EntityBee.this.getBukkitEntity(), CraftLocation.toBukkit((BaseBlockPosition)EntityBee.this.dq, EntityBee.this.an())).callEvent();
                            }
                            ++this.j;
                            if (EntityBee.this.as.i() < 0.05f && this.j > this.k + 60) {
                                this.k = this.j;
                                EntityBee.this.a(SoundEffects.bU, 1.0f, 1.0f);
                            }
                        }
                    }
                }
            }
        }

        private void n() {
            EntityBee.this.Q().a(this.m.a(), this.m.b(), this.m.c(), 0.35f);
        }

        private float o() {
            return (EntityBee.this.as.i() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPosition> p() {
            Iterable<BlockPosition> iterable = BlockPosition.a(EntityBee.this.dF(), 5, 5, 5);
            Long2LongOpenHashMap map = new Long2LongOpenHashMap();
            for (BlockPosition blockPos : iterable) {
                long orDefault = this.p.getOrDefault(blockPos.a(), Long.MIN_VALUE);
                if (EntityBee.this.an().ag() < orDefault) {
                    map.put(blockPos.a(), orDefault);
                    continue;
                }
                if (!EntityBee.c(EntityBee.this.an().a_(blockPos))) continue;
                PathEntity path = EntityBee.this.cp.a(blockPos, 1);
                if (path != null && path.j()) {
                    return Optional.of(blockPos);
                }
                map.put(blockPos.a(), EntityBee.this.an().ag() + 600L);
            }
            this.p = map;
            return Optional.empty();
        }
    }

    class i
    extends a {
        i() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.dl == 0 && !EntityBee.this.gK() && EntityBee.this.hc();
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void d() {
            EntityBee.this.dl = 200;
            List<BlockPosition> list = this.k();
            if (!list.isEmpty()) {
                for (BlockPosition blockPos : list) {
                    if (EntityBee.this.dt.b(blockPos)) continue;
                    EntityBee.this.dr = blockPos;
                    return;
                }
                EntityBee.this.dt.k();
                EntityBee.this.dr = list.get(0);
            }
        }

        private List<BlockPosition> k() {
            BlockPosition blockPos = EntityBee.this.dF();
            VillagePlace poiManager = ((WorldServer)EntityBee.this.an()).D();
            Stream<VillagePlaceRecord> inRange = poiManager.c(poiRecord -> poiRecord.a(PoiTypeTags.c), blockPos, 20, VillagePlace.Occupancy.c);
            return inRange.map(VillagePlaceRecord::g).filter(EntityBee.this::k).sorted(Comparator.comparingDouble(pos -> pos.j(blockPos))).collect(Collectors.toList());
        }
    }

    @VisibleForDebug
    public class e
    extends a {
        public static final int b = 2400;
        int d;
        private static final int e = 3;
        final List<BlockPosition> f;
        @Nullable
        private PathEntity g;
        private static final int h = 60;
        private int i;

        e() {
            this.f = Lists.newArrayList();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.dr != null && !EntityBee.this.l(EntityBee.this.dr) && !EntityBee.this.gw() && EntityBee.this.hc() && !this.d(EntityBee.this.dr) && EntityBee.this.an().a_(EntityBee.this.dr).a(TagsBlock.aU);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void d() {
            this.d = 0;
            this.i = 0;
            super.d();
        }

        @Override
        public void e() {
            this.d = 0;
            this.i = 0;
            EntityBee.this.cp.n();
            EntityBee.this.cp.g();
        }

        @Override
        public void a() {
            if (EntityBee.this.dr != null) {
                ++this.d;
                if (this.d > this.a(2400)) {
                    this.l();
                } else if (!EntityBee.this.cp.m()) {
                    if (!EntityBee.this.b(EntityBee.this.dr, 16)) {
                        if (EntityBee.this.l(EntityBee.this.dr)) {
                            EntityBee.this.ha();
                        } else {
                            EntityBee.this.j(EntityBee.this.dr);
                        }
                    } else {
                        boolean flag = this.a(EntityBee.this.dr);
                        if (!flag) {
                            this.l();
                        } else if (this.g != null && EntityBee.this.cp.j().a(this.g)) {
                            ++this.i;
                            if (this.i > 60) {
                                EntityBee.this.ha();
                                this.i = 0;
                            }
                        } else {
                            this.g = EntityBee.this.cp.j();
                        }
                    }
                }
            }
        }

        private boolean a(BlockPosition pos) {
            int i2 = EntityBee.this.b(pos, 3) ? 1 : 2;
            EntityBee.this.cp.b(10.0f);
            EntityBee.this.cp.a(pos.u(), (double)pos.v(), pos.w(), i2, 1.0);
            return EntityBee.this.cp.j() != null && EntityBee.this.cp.j().j();
        }

        boolean b(BlockPosition pos) {
            return this.f.contains(pos);
        }

        private void c(BlockPosition pos) {
            this.f.add(pos);
            while (this.f.size() > 3) {
                this.f.remove(0);
            }
        }

        void k() {
            this.f.clear();
        }

        private void l() {
            if (EntityBee.this.dr != null) {
                this.c(EntityBee.this.dr);
            }
            EntityBee.this.ha();
        }

        private boolean d(BlockPosition pos) {
            if (EntityBee.this.b(pos, 2)) {
                return true;
            }
            PathEntity path = EntityBee.this.cp.j();
            return path != null && path.l().equals(pos) && path.j() && path.c();
        }
    }

    public class f
    extends a {
        private static final int c = 2400;
        int d;

        f() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.dq != null && !EntityBee.this.gw() && this.k() && !EntityBee.this.b(EntityBee.this.dq, 2);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void d() {
            this.d = 0;
            super.d();
        }

        @Override
        public void e() {
            this.d = 0;
            EntityBee.this.cp.n();
            EntityBee.this.cp.g();
        }

        @Override
        public void a() {
            if (EntityBee.this.dq != null) {
                ++this.d;
                if (this.d > this.a(2400)) {
                    EntityBee.this.hb();
                } else if (!EntityBee.this.cp.m()) {
                    if (EntityBee.this.l(EntityBee.this.dq)) {
                        EntityBee.this.hb();
                    } else {
                        EntityBee.this.j(EntityBee.this.dq);
                    }
                }
            }
        }

        private boolean k() {
            return EntityBee.this.dh > 600;
        }
    }

    class g
    extends a {
        static final int b = 30;

        g() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.hf() < 10 && !(EntityBee.this.as.i() < 0.3f) && EntityBee.this.gU() && EntityBee.this.hj();
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void a() {
            if (EntityBee.this.as.a(this.a(30)) == 0) {
                for (int i2 = 1; i2 <= 2; ++i2) {
                    IBlockFragilePlantElement bonemealableBlock;
                    BlockPosition blockPos = EntityBee.this.dF().c(i2);
                    IBlockData blockState = EntityBee.this.an().a_(blockPos);
                    Block block = blockState.b();
                    IBlockData blockState1 = null;
                    if (!blockState.a(TagsBlock.aW)) continue;
                    if (block instanceof BlockCrops) {
                        BlockCrops cropBlock = (BlockCrops)block;
                        if (!cropBlock.n(blockState)) {
                            blockState1 = cropBlock.b(cropBlock.i(blockState) + 1);
                        }
                    } else if (block instanceof BlockStem) {
                        int ageValue = blockState.c(BlockStem.c);
                        if (ageValue < 7) {
                            blockState1 = (IBlockData)blockState.b(BlockStem.c, ageValue + 1);
                        }
                    } else if (blockState.a(Blocks.pg)) {
                        int ageValue = blockState.c(BlockSweetBerryBush.c);
                        if (ageValue < 3) {
                            blockState1 = (IBlockData)blockState.b(BlockSweetBerryBush.c, ageValue + 1);
                        }
                    } else if ((blockState.a(Blocks.tS) || blockState.a(Blocks.tT)) && (bonemealableBlock = (IBlockFragilePlantElement)((Object)blockState.b())).a(EntityBee.this.an(), blockPos, blockState)) {
                        bonemealableBlock.a((WorldServer)EntityBee.this.an(), EntityBee.this.as, blockPos, blockState);
                        blockState1 = EntityBee.this.an().a_(blockPos);
                    }
                    if (blockState1 == null || !CraftEventFactory.callEntityChangeBlockEvent(EntityBee.this, blockPos, blockState1)) continue;
                    EntityBee.this.an().c(2011, blockPos, 15);
                    EntityBee.this.an().c(blockPos, blockState1);
                    EntityBee.this.hh();
                }
            }
        }
    }

    class l
    extends PathfinderGoal {
        l() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return EntityBee.this.cp.l() && EntityBee.this.as.a(10) == 0;
        }

        @Override
        public boolean c() {
            return EntityBee.this.cp.m();
        }

        @Override
        public void d() {
            Vec3D vec3 = this.h();
            if (vec3 != null) {
                EntityBee.this.cp.a(EntityBee.this.cp.a(BlockPosition.a(vec3), 1), 1.0);
            }
        }

        @Nullable
        private Vec3D h() {
            Vec3D vec31;
            if (EntityBee.this.hj() && !EntityBee.this.b(EntityBee.this.dr, this.i())) {
                Vec3D vec3 = Vec3D.b(EntityBee.this.dr);
                vec31 = vec3.d(EntityBee.this.dD()).d();
            } else {
                vec31 = EntityBee.this.h(0.0f);
            }
            int i2 = 8;
            Vec3D pos = HoverRandomPos.a(EntityBee.this, 8, 7, vec31.g, vec31.i, 1.5707964f, 3, 1);
            return pos != null ? pos : AirAndWaterRandomPos.a(EntityBee.this, 8, 4, -2, vec31.g, vec31.i, 1.5707963705062866);
        }

        private int i() {
            int i2 = !EntityBee.this.gK() && !EntityBee.this.n() ? 16 : 24;
            return 48 - i2;
        }
    }

    class h
    extends PathfinderGoalHurtByTarget {
        h(EntityBee mob) {
            super(mob, new Class[0]);
        }

        @Override
        public boolean c() {
            return EntityBee.this.ae_() && super.c();
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityBee && this.e.F(target)) {
                mob.setTarget(target, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY);
            }
        }
    }

    static class c
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        c(EntityBee mob) {
            super(mob, EntityHuman.class, 10, true, false, mob::a);
        }

        @Override
        public boolean b() {
            return this.i() && super.b();
        }

        @Override
        public boolean c() {
            boolean flag = this.i();
            if (flag && this.e.e() != null) {
                return super.c();
            }
            this.g = null;
            return false;
        }

        private boolean i() {
            EntityBee bee = (EntityBee)this.e;
            return bee.ae_() && !bee.gV();
        }
    }

    abstract class a
    extends PathfinderGoal {
        a() {
        }

        public abstract boolean h();

        public abstract boolean i();

        @Override
        public boolean b() {
            return this.h() && !EntityBee.this.ae_();
        }

        @Override
        public boolean c() {
            return this.i() && !EntityBee.this.ae_();
        }
    }
}

