/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCatSitOnBed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalJumpOnBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOcelotAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.CatVariants;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityCat
extends EntityTameableAnimal {
    public static final double cx = 0.6;
    public static final double cy = 0.8;
    public static final double cz = 1.33;
    private static final DataWatcherObject<Holder<CatVariant>> cA = DataWatcher.a(EntityCat.class, DataWatcherRegistry.w);
    private static final DataWatcherObject<Boolean> cB = DataWatcher.a(EntityCat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cC = DataWatcher.a(EntityCat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cD = DataWatcher.a(EntityCat.class, DataWatcherRegistry.b);
    private static final ResourceKey<CatVariant> cE = CatVariants.b;
    private static final EnumColor cF = EnumColor.o;
    @Nullable
    private a<EntityHuman> cG;
    @Nullable
    private PathfinderGoalTempt cH;
    private float cI;
    private float cJ;
    private float cK;
    private float cL;
    private boolean cM;
    private float cN;
    private float cO;

    public EntityCat(EntityTypes<? extends EntityCat> type, World level) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, level);
        this.ha();
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.catRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.catRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.catControllable;
    }

    @Override
    public void onMount(EntityHuman rider) {
        super.onMount(rider);
        this.y(false);
        this.A(false);
        this.B(false);
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.catMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.catScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.catBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.catTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.catAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cH = new PathfinderGoalTemptChance(this, 0.6, stack -> stack.a(TagsItem.aI), true);
        this.cq.a(1, new PathfinderGoalFloat(this));
        this.cq.a(1, new HasRider(this));
        this.cq.a(1, new EntityTameableAnimal.a(1.5));
        this.cq.a(2, new PathfinderGoalSit(this));
        this.cq.a(3, new b(this));
        this.cq.a(4, this.cH);
        this.cq.a(5, new PathfinderGoalCatSitOnBed(this, 1.1, 8));
        this.cq.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 5.0f));
        this.cq.a(7, new PathfinderGoalJumpOnBlock(this, 0.8));
        this.cq.a(8, new PathfinderGoalLeapAtTarget(this, 0.3f));
        this.cq.a(9, new PathfinderGoalOcelotAttack(this));
        this.cq.a(10, new PathfinderGoalBreed(this, 0.8));
        this.cq.a(11, new PathfinderGoalRandomStrollLand((EntityCreature)this, 0.8, 1.0000001E-5f));
        this.cq.a(12, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
        this.cr.a(1, new HasRider(this));
        this.cr.a(1, new PathfinderGoalRandomTargetNonTamed<EntityRabbit>(this, EntityRabbit.class, false, null));
        this.cr.a(1, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.ct));
    }

    public Holder<CatVariant> gU() {
        return this.az.a(cA);
    }

    public void b(Holder<CatVariant> variant) {
        this.az.a(cA, variant);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        if (component == DataComponents.aP) {
            return EntityCat.c(component, this.gU());
        }
        return component == DataComponents.aQ ? EntityCat.c(component, this.gW()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aP);
        this.a(componentGetter, DataComponents.aQ);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aP) {
            this.b(EntityCat.c(DataComponents.aP, value));
            return true;
        }
        if (component == DataComponents.aQ) {
            this.a(EntityCat.c(DataComponents.aQ, value));
            return true;
        }
        return super.b(component, value);
    }

    public void A(boolean lying) {
        this.az.a(cB, lying);
    }

    public boolean gV() {
        return this.az.a(cB);
    }

    public void B(boolean relaxStateOne) {
        this.az.a(cC, relaxStateOne);
    }

    public boolean hb() {
        return this.az.a(cC);
    }

    public EnumColor gW() {
        return EnumColor.a(this.az.a(cD));
    }

    public void a(EnumColor color) {
        this.az.a(cD, color.a());
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cA, VariantUtils.a(this.ej(), cE));
        builder.a(cB, false);
        builder.a(cC, false);
        builder.a(cD, cF.a());
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        VariantUtils.a(output, this.gU());
        output.a("CollarColor", EnumColor.s, this.gW());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        VariantUtils.a(input, Registries.aO).ifPresent(this::b);
        this.a(input.a("CollarColor", EnumColor.s).orElse(cF));
    }

    @Override
    public void a(WorldServer level) {
        if (this.Q().b()) {
            double speedModifier = this.Q().c();
            if (speedModifier == 0.6) {
                this.c(EntityPose.f);
                this.i(false);
            } else if (speedModifier == 1.33) {
                this.c(EntityPose.a);
                this.i(true);
            } else {
                this.c(EntityPose.a);
                this.i(false);
            }
        } else {
            this.c(EntityPose.a);
            this.i(false);
        }
    }

    @Override
    @Nullable
    public SoundEffect p() {
        if (this.m()) {
            if (this.gS()) {
                return SoundEffects.ec;
            }
            return this.as.a(4) == 0 ? SoundEffects.ed : SoundEffects.dV;
        }
        return SoundEffects.dW;
    }

    @Override
    public int W() {
        return 120;
    }

    public void gX() {
        this.b(SoundEffects.dZ);
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.eb;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.dX;
    }

    public static AttributeProvider.Builder gY() {
        return EntityAnimal.gN().a(GenericAttributes.t, 10.0).a(GenericAttributes.w, 0.3f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected void gO() {
        this.a(SoundEffects.dY, 1.0f, 1.0f);
    }

    @Override
    public void g() {
        super.g();
        if (this.cH != null && this.cH.k() && !this.m() && this.at % 100 == 0) {
            this.a(SoundEffects.ea, 1.0f, 1.0f);
        }
        this.hc();
    }

    private void hc() {
        if ((this.gV() || this.hb()) && this.at % 5 == 0) {
            this.a(SoundEffects.ec, 0.6f + 0.4f * (this.as.i() - this.as.i()), 1.0f);
        }
        this.hd();
        this.he();
        this.cM = false;
        if (this.gV()) {
            BlockPosition blockPos = this.dF();
            for (EntityHuman player : this.an().a(EntityHuman.class, new AxisAlignedBB(blockPos).c(2.0, 2.0, 2.0))) {
                if (!player.gg()) continue;
                this.cM = true;
                break;
            }
        }
    }

    public boolean gZ() {
        return this.cM;
    }

    private void hd() {
        this.cJ = this.cI;
        this.cL = this.cK;
        if (this.gV()) {
            this.cI = Math.min(1.0f, this.cI + 0.15f);
            this.cK = Math.min(1.0f, this.cK + 0.08f);
        } else {
            this.cI = Math.max(0.0f, this.cI - 0.22f);
            this.cK = Math.max(0.0f, this.cK - 0.13f);
        }
    }

    private void he() {
        this.cO = this.cN;
        this.cN = this.hb() ? Math.min(1.0f, this.cN + 0.1f) : Math.max(0.0f, this.cN - 0.13f);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cJ, this.cI);
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cL, this.cK);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cO, this.cN);
    }

    @Nullable
    public EntityCat b(WorldServer level, EntityAgeable partner) {
        EntityCat cat = EntityTypes.w.a(level, EntitySpawnReason.e);
        if (cat != null && partner instanceof EntityCat) {
            EntityCat cat1 = (EntityCat)partner;
            if (this.as.h()) {
                cat.b(this.gU());
            } else {
                cat.b(cat1.gU());
            }
            if (this.m()) {
                ((EntityTameableAnimal)cat).a(this.d());
                cat.a(true, true);
                EnumColor collarColor = this.gW();
                EnumColor collarColor1 = cat1.gW();
                cat.a(EnumColor.a(level, collarColor, collarColor1));
            }
        }
        return cat;
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        EntityCat cat;
        return this.m() && otherAnimal instanceof EntityCat && (cat = (EntityCat)otherAnimal).m() && super.a(otherAnimal);
    }

    @Override
    public void g(EntityHuman player) {
        this.a(this.an().purpurConfig.catDefaultCollarColor);
        super.g(player);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        VariantUtils.a(SpawnContext.a(level, this.dF()), Registries.aO).ifPresent(this::b);
        return spawnGroupData;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult;
        if (this.getRider() != null) {
            return EnumInteractionResult.e;
        }
        ItemStack itemInHand = player.b(hand);
        Item item = itemInHand.h();
        if (this.m()) {
            if (this.j(player)) {
                EnumInteractionResult interactionResult2;
                if (item instanceof ItemDye) {
                    ItemDye dyeItem = (ItemDye)item;
                    EnumColor dyeColor = dyeItem.a();
                    if (dyeColor != this.gW()) {
                        EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)dyeColor.a())), (Player)((EntityPlayer)player).getBukkitEntity());
                        if (!event.callEvent()) {
                            return EnumInteractionResult.d;
                        }
                        dyeColor = EnumColor.a(event.getColor().getWoolData());
                        if (!this.an().D_()) {
                            this.a(dyeColor);
                            itemInHand.a(1, (EntityLiving)player);
                            this.gq();
                        }
                        return EnumInteractionResult.a;
                    }
                } else if (this.i(itemInHand) && this.eU() < this.fj()) {
                    if (!this.an().D_()) {
                        this.a(player, hand, itemInHand);
                        FoodInfo foodProperties = itemInHand.a(DataComponents.v);
                        this.heal(foodProperties != null ? (float)foodProperties.a() : 1.0f, EntityRegainHealthEvent.RegainReason.EATING);
                        this.gO();
                    }
                    return EnumInteractionResult.a;
                }
                if (!(interactionResult2 = super.b(player, hand)).a()) {
                    this.z(!this.gI());
                    return EnumInteractionResult.a;
                }
                return interactionResult2;
            }
        } else if (this.i(itemInHand)) {
            if (!this.an().D_()) {
                this.a(player, hand, itemInHand);
                this.i(player);
                this.gq();
                this.gO();
            }
            return EnumInteractionResult.a;
        }
        if ((interactionResult = super.b(player, hand)).a()) {
            this.gq();
        }
        return interactionResult;
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aI);
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return !this.m() && this.at > 2400;
    }

    @Override
    public void a(boolean tame, boolean applyTamingSideEffects) {
        super.a(tame, applyTamingSideEffects);
        this.ha();
    }

    protected void ha() {
        if (this.cG == null) {
            this.cG = new a<EntityHuman>(this, EntityHuman.class, 16.0f, 0.8, 1.33);
        }
        this.cq.a(this.cG);
        if (!this.m()) {
            this.cq.a(4, this.cG);
        }
    }

    private void i(EntityHuman player) {
        if ((this.an().purpurConfig.alwaysTameInCreative && player.gk() || this.as.a(3) == 0) && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
            this.g(player);
            this.z(true);
            this.an().a((Entity)this, (byte)7);
        } else {
            this.an().a((Entity)this, (byte)6);
        }
    }

    @Override
    public boolean cq() {
        return this.cu() || super.cq();
    }

    static class PathfinderGoalTemptChance
    extends PathfinderGoalTempt {
        @Nullable
        private EntityLiving selectedPlayer;
        private final EntityCat e;

        public PathfinderGoalTemptChance(EntityCat cat, double speedModifier, Predicate<ItemStack> items, boolean canScare) {
            super(cat, speedModifier, items, canScare);
            this.e = cat;
        }

        @Override
        public void a() {
            super.a();
            if (this.selectedPlayer == null && this.a.ek().a(this.a(600)) == 0) {
                this.selectedPlayer = this.player;
            } else if (this.a.ek().a(this.a(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        @Override
        protected boolean h() {
            return (this.selectedPlayer == null || !this.selectedPlayer.equals(this.player)) && super.h();
        }

        @Override
        public boolean b() {
            return super.b() && !this.e.m();
        }
    }

    static class b
    extends PathfinderGoal {
        private final EntityCat a;
        @Nullable
        private EntityHuman b;
        @Nullable
        private BlockPosition c;
        private int d;

        public b(EntityCat cat) {
            this.a = cat;
        }

        @Override
        public boolean b() {
            if (!this.a.m()) {
                return false;
            }
            if (this.a.gI()) {
                return false;
            }
            EntityLiving owner = this.a.V_();
            if (owner instanceof EntityHuman) {
                EntityHuman player;
                this.b = player = (EntityHuman)owner;
                if (!owner.gg()) {
                    return false;
                }
                if (this.a.g((Entity)this.b) > 100.0) {
                    return false;
                }
                BlockPosition blockPos = this.b.dF();
                IBlockData blockState = this.a.an().a_(blockPos);
                if (blockState.a(TagsBlock.R)) {
                    this.c = blockState.d(BlockFacingHorizontal.f).map(pos -> blockPos.a(pos.g())).orElseGet(() -> new BlockPosition(blockPos));
                    return !this.h();
                }
            }
            return false;
        }

        private boolean h() {
            for (EntityCat cat : this.a.an().a(EntityCat.class, new AxisAlignedBB(this.c).g(2.0))) {
                if (cat == this.a || !cat.gV() && !cat.hb()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean c() {
            return this.a.m() && !this.a.gI() && this.b != null && this.b.gg() && this.c != null && !this.h();
        }

        @Override
        public void d() {
            if (this.c != null) {
                this.a.y(false);
                this.a.S().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
            }
        }

        @Override
        public void e() {
            this.a.A(false);
            float timeOfDay = this.a.an().f(1.0f);
            if (this.b.gH() >= 100 && (double)timeOfDay > 0.77 && (double)timeOfDay < 0.8 && (double)this.a.an().I_().i() < 0.7) {
                this.i();
            }
            this.d = 0;
            this.a.B(false);
            this.a.S().n();
        }

        private void i() {
            RandomSource random = this.a.ek();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            mutableBlockPos.g(this.a.T_() ? this.a.ak_().dF() : this.a.dF());
            this.a.b(mutableBlockPos.u() + random.a(11) - 5, mutableBlockPos.v() + random.a(5) - 2, mutableBlockPos.w() + random.a(11) - 5, false);
            mutableBlockPos.g(this.a.dF());
            this.a.a(net.minecraft.world.entity.animal.EntityCat$b.a(this.a), LootTables.aq, (WorldServer level, ItemStack stack) -> {
                EntityItem item = new EntityItem((World)level, (double)mutableBlockPos.u() - (double)MathHelper.a(this.a.bB * ((float)Math.PI / 180)), mutableBlockPos.v(), (double)mutableBlockPos.w() + (double)MathHelper.b(this.a.bB * ((float)Math.PI / 180)), (ItemStack)stack);
                EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.a.getBukkitEntity(), (org.bukkit.entity.Item)item.getBukkitEntity());
                if (!event.callEvent()) {
                    return;
                }
                level.b(item);
            });
        }

        @Override
        public void a() {
            if (this.b != null && this.c != null) {
                this.a.y(false);
                this.a.S().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
                if (this.a.g((Entity)this.b) < 2.5) {
                    ++this.d;
                    if (this.d > this.a(16)) {
                        this.a.A(true);
                        this.a.B(false);
                    } else {
                        this.a.a((Entity)this.b, 45.0f, 45.0f);
                        this.a.B(true);
                    }
                } else {
                    this.a.A(false);
                }
            }
        }
    }

    static class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityCat i;

        public a(EntityCat cat, Class<T> avoidClass, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(cat, avoidClass, maxDist, walkSpeedModifier, sprintSpeedModifier, IEntitySelector.e::test);
            this.i = cat;
        }

        @Override
        public boolean b() {
            return !this.i.m() && super.b();
        }

        @Override
        public boolean c() {
            return !this.i.m() && super.c();
        }
    }
}

