/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.ChickenVariants;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityChicken
extends EntityAnimal {
    private static final EntitySize cB = EntityTypes.B.n().a(0.5f).b(0.2975f);
    private static final DataWatcherObject<Holder<ChickenVariant>> cC = DataWatcher.a(EntityChicken.class, DataWatcherRegistry.x);
    private static final boolean cD = false;
    public float ct;
    public float cu;
    public float cv;
    public float cx;
    public float cy = 1.0f;
    private float cE = 1.0f;
    public int cz = this.as.a(6000) + 6000;
    public boolean cA = false;

    public EntityChicken(EntityTypes<? extends EntityChicken> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.a(PathType.j, 0.0f);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.chickenRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.chickenRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.chickenControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.chickenMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.chickenScale);
        if (this.an().purpurConfig.chickenRetaliate) {
            this.h(GenericAttributes.c).a(2.0);
        }
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.chickenBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.chickenTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.chickenAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(0, new HasRider(this));
        this.cq.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cq.a(3, new PathfinderGoalTempt(this, 1.0, itemStack -> itemStack.a(TagsItem.aQ), false));
        this.cq.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.cq.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cq.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cq.a(7, new PathfinderGoalRandomLookaround(this));
        if (this.an().purpurConfig.chickenRetaliate) {
            this.cq.a(1, new PathfinderGoalMeleeAttack(this, 1.0, false));
            this.cr.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        } else {
            this.cq.a(1, new PathfinderGoalPanic(this, 1.4));
        }
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.g_() ? cB : super.b(pose);
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gN().a(GenericAttributes.t, 4.0).a(GenericAttributes.w, 0.25).a(GenericAttributes.c, 0.0);
    }

    @Override
    public void e_() {
        super.e_();
        this.cx = this.ct;
        this.cv = this.cu;
        this.cu += (this.aS() ? -1.0f : 4.0f) * 0.3f;
        this.cu = MathHelper.a(this.cu, 0.0f, 1.0f);
        if (!this.aS() && this.cy < 1.0f) {
            this.cy = 1.0f;
        }
        this.cy *= 0.9f;
        Vec3D deltaMovement = this.dI();
        if (!this.aS() && deltaMovement.h < 0.0) {
            this.k(deltaMovement.d(1.0, 0.6, 1.0));
        }
        this.ct += this.cy * 2.0f;
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.bX() && !this.g_() && !this.s() && --this.cz <= 0) {
                this.forceDrops = true;
                if (this.a(serverLevel, LootTables.aI, this::a)) {
                    this.a(SoundEffects.eY, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                    this.c(GameEvent.t);
                }
                this.forceDrops = false;
                this.cz = this.as.a(6000) + 6000;
            }
        }
    }

    @Override
    protected boolean bl() {
        return this.am > this.cE;
    }

    @Override
    protected void bk() {
        this.cE = this.am + this.cu / 2.0f;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.eW;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.eZ;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.eX;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.fa, 0.15f, 1.0f);
    }

    @Nullable
    public EntityChicken b(WorldServer level, EntityAgeable partner) {
        EntityChicken chicken = EntityTypes.B.a(level, EntitySpawnReason.e);
        if (chicken != null && partner instanceof EntityChicken) {
            EntityChicken chicken1 = (EntityChicken)partner;
            chicken.b(this.as.h() ? this.n() : chicken1.n());
        }
        return chicken;
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        VariantUtils.a(SpawnContext.a(level, this.dF()), Registries.aQ).ifPresent(this::b);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aQ);
    }

    @Override
    protected int f(WorldServer level) {
        return this.s() ? 10 : super.f(level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cC, VariantUtils.a(this.ej(), ChickenVariants.a));
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.cA = input.a("IsChickenJockey", false);
        input.e("EggLayTime").ifPresent(integer -> {
            this.cz = integer;
        });
        VariantUtils.a(input, Registries.aQ).ifPresent(this::b);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("IsChickenJockey", this.cA);
        output.a("EggLayTime", this.cz);
        VariantUtils.a(output, this.n());
    }

    public void b(Holder<ChickenVariant> variant) {
        this.az.a(cC, variant);
    }

    public Holder<ChickenVariant> n() {
        return this.az.a(cC);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aJ ? EntityChicken.c(component, new EitherHolder<ChickenVariant>(this.n())) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aJ);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aJ) {
            Optional<Holder<ChickenVariant>> optional = EntityChicken.c(DataComponents.aJ, value).a(this.ej());
            if (optional.isPresent()) {
                this.b(optional.get());
                return true;
            }
            return false;
        }
        return super.b(component, value);
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return this.s();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction callback) {
        super.a(passenger, callback);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).bB = this.bB;
        }
    }

    public boolean s() {
        return this.cA;
    }

    public void x(boolean isChickenJockey) {
        this.cA = isChickenJockey;
    }
}

