/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.AbstractCow;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.CowVariants;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class EntityCow
extends AbstractCow {
    private boolean isNaturallyAggressiveToPlayers;
    private static final DataWatcherObject<Holder<CowVariant>> ct = DataWatcher.a(EntityCow.class, DataWatcherRegistry.y);

    public EntityCow(EntityTypes<? extends EntityCow> type, World level) {
        super((EntityTypes<? extends AbstractCow>)type, level);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.cowRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.cowRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.cowControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.cowMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.cowScale);
        this.h(GenericAttributes.c).a(this.an().purpurConfig.cowNaturallyAggressiveToPlayersDamage);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.cowBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.cowTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.cowAlwaysDropExp;
    }

    @Override
    protected void H() {
        super.H();
        this.cq.a(1, new PathfinderGoalMeleeAttack(this, 1.2f, true));
        this.cr.a(0, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (ignored, ignored2) -> this.isNaturallyAggressiveToPlayers));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ct, VariantUtils.a(this.ej(), CowVariants.a));
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        VariantUtils.a(output, this.n());
    }

    public static AttributeProvider.Builder m() {
        return AbstractCow.m().a(GenericAttributes.c, 0.0);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        VariantUtils.a(input, Registries.aT).ifPresent(this::b);
    }

    @Nullable
    public EntityCow b(WorldServer level, EntityAgeable partner) {
        EntityCow cow = EntityTypes.F.a(level, EntitySpawnReason.e);
        if (cow != null && partner instanceof EntityCow) {
            EntityCow cow1 = (EntityCow)partner;
            cow.b(this.as.h() ? this.n() : cow1.n());
        }
        return cow;
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.isNaturallyAggressiveToPlayers = level.a().purpurConfig.cowNaturallyAggressiveToPlayersChance > 0.0 && this.as.j() <= level.a().purpurConfig.cowNaturallyAggressiveToPlayersChance;
        VariantUtils.a(SpawnContext.a(level, this.dF()), Registries.aT).ifPresent(this::b);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public void b(Holder<CowVariant> variant) {
        this.az.a(ct, variant);
    }

    public Holder<CowVariant> n() {
        return this.az.a(ct);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aI ? EntityCow.c(component, this.n()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aI);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aI) {
            this.b(EntityCow.c(DataComponents.aI, value));
            return true;
        }
        return super.b(component, value);
    }
}

