/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreath;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowBoat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomSwim;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWater;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJump;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.util.Vector;
import org.purpurmc.purpur.controller.WaterMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;
import org.purpurmc.purpur.entity.projectile.DolphinSpit;

public class EntityDolphin
extends AgeableWaterCreature {
    private static final DataWatcherObject<Boolean> cw = DataWatcher.a(EntityDolphin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cx = DataWatcher.a(EntityDolphin.class, DataWatcherRegistry.b);
    static final PathfinderTargetCondition cy = PathfinderTargetCondition.b().a(10.0).d();
    public static final int ct = 4800;
    private static final int cz = 2400;
    public static final Predicate<EntityItem> cu = itemEntity -> !itemEntity.n() && itemEntity.bX() && itemEntity.bu();
    public static final float cv = 0.65f;
    private static final boolean cA = false;
    @Nullable
    public BlockPosition cB;
    private boolean isNaturallyAggressiveToPlayers;
    private int spitCooldown;

    public EntityDolphin(EntityTypes<? extends EntityDolphin> type, World level) {
        super((EntityTypes<? extends AgeableWaterCreature>)type, level);
        class DolphinMoveControl
        extends SmoothSwimmingMoveControl {
            private final WaterMoveControllerWASD waterMoveControllerWASD;
            private final EntityDolphin dolphin;

            public DolphinMoveControl(EntityDolphin this$0, EntityDolphin dolphin, int pitchChange, int yawChange, float speedInWater, float speedInAir, boolean buoyant) {
                super(dolphin, pitchChange, yawChange, speedInWater, speedInAir, buoyant);
                this.dolphin = dolphin;
                this.waterMoveControllerWASD = new WaterMoveControllerWASD(dolphin);
            }

            @Override
            public void a() {
                if (this.dolphin.getRider() != null && this.dolphin.isControllable()) {
                    this.purpurTick(this.dolphin.getRider());
                } else {
                    super.a();
                }
            }

            public void purpurTick(EntityHuman rider) {
                if (this.dolphin.cF() < 150) {
                    super.a();
                } else {
                    this.waterMoveControllerWASD.purpurTick(rider);
                    this.dolphin.k(this.dolphin.dI().b(0.0, 0.005, 0.0));
                }
            }
        }
        this.cn = new DolphinMoveControl(this, this, 85, 10, 0.02f, 0.1f, true);
        this.cm = new SmoothSwimmingLookControl(this, 10);
        this.a_(true);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.dolphinRidable;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.dolphinControllable;
    }

    @Override
    public boolean onSpacebar() {
        if (this.spitCooldown == 0 && this.getRider() != null) {
            this.spitCooldown = this.an().purpurConfig.dolphinSpitCooldown;
            CraftPlayer player = (CraftPlayer)this.getRider().getBukkitEntity();
            if (!player.hasPermission("allow.special.dolphin")) {
                return false;
            }
            Location loc = player.getEyeLocation();
            loc.setPitch(loc.getPitch() - 10.0f);
            Vector target = loc.getDirection().normalize().multiply(10).add(loc.toVector());
            DolphinSpit spit = new DolphinSpit(this.an(), this);
            spit.c(target.getX() - this.dK(), target.getY() - this.dM(), target.getZ() - this.dQ(), this.an().purpurConfig.dolphinSpitSpeed, 5.0f);
            this.an().b(spit);
            this.a(SoundEffects.ia, 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
            return true;
        }
        return false;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.dolphinMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.dolphinScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.dolphinTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.dolphinAlwaysDropExp;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.j(this.cE());
        this.w(0.0f);
        GroupDataEntity spawnGroupData1 = Objects.requireNonNullElseGet(spawnGroupData, () -> new EntityAgeable.a(0.1f));
        this.isNaturallyAggressiveToPlayers = level.a().purpurConfig.dolphinNaturallyAggressiveToPlayersChance > 0.0 && this.as.j() <= level.a().purpurConfig.dolphinNaturallyAggressiveToPlayersChance;
        return super.a(level, difficulty, spawnReason, spawnGroupData1);
    }

    @Nullable
    public EntityDolphin b(WorldServer level, EntityAgeable partner) {
        return EntityTypes.K.a(level, EntitySpawnReason.e);
    }

    @Override
    public int getDefaultMaxAirSupply() {
        return 4800;
    }

    @Override
    public float ez() {
        return this.g_() ? 0.65f : 1.0f;
    }

    @Override
    protected void r(int airSupply) {
    }

    public boolean m() {
        return this.az.a(cw);
    }

    public void x(boolean gotFish) {
        this.az.a(cw, gotFish);
    }

    public int n() {
        return this.az.a(cx);
    }

    public void s(int moistnessLevel) {
        this.az.a(cx, moistnessLevel);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cw, false);
        builder.a(cx, 2400);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("GotFish", this.m());
        output.a("Moistness", this.n());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a("GotFish", false));
        this.s(input.a("Moistness", 2400));
    }

    @Override
    protected void H() {
        this.cq.a(0, new PathfinderGoalBreath(this));
        this.cq.a(0, new PathfinderGoalWater(this));
        this.cq.a(1, new PathfinderGoalMeleeAttack(this, 1.2f, true));
        this.cq.a(0, new HasRider(this));
        this.cq.a(1, new a(this));
        this.cq.a(2, new b(this, 4.0));
        this.cq.a(4, new PathfinderGoalRandomSwim(this, 1.0, 10));
        this.cq.a(4, new PathfinderGoalRandomLookaround(this));
        this.cq.a(5, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cq.a(5, new PathfinderGoalWaterJump(this, 10));
        this.cq.a(8, new c());
        this.cq.a(8, new PathfinderGoalFollowBoat(this));
        this.cq.a(9, new PathfinderGoalAvoidTarget<EntityGuardian>(this, EntityGuardian.class, 8.0f, 1.0, 1.0));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, EntityGuardian.class).a(new Class[0]));
        this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (ignored, ignored2) -> this.isNaturallyAggressiveToPlayers));
    }

    public static AttributeProvider.Builder s() {
        return EntityInsentient.I().a(GenericAttributes.t, 10.0).a(GenericAttributes.w, 1.2f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new NavigationGuardian(this, level);
    }

    @Override
    public void gB() {
        this.a(SoundEffects.ia, 1.0f, 1.0f);
    }

    @Override
    public boolean c(EntityLiving target) {
        return !this.g_() && super.c(target);
    }

    @Override
    public int cE() {
        return this.maxAirTicks;
    }

    @Override
    protected int m(int currentAirSupply) {
        return this.cE();
    }

    @Override
    public int af() {
        return 1;
    }

    @Override
    public int ah() {
        return 1;
    }

    @Override
    protected boolean p(Entity entity) {
        return this.X <= 0;
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.a && this.gc();
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        ItemStack item;
        if (this.a(EnumItemSlot.a).f() && this.g(item = entity.e())) {
            if (CraftEventFactory.callEntityPickupItemEvent(this, entity, 0, false).isCancelled()) {
                return;
            }
            item = entity.e();
            this.a(entity);
            this.a(EnumItemSlot.a, item);
            this.g(EnumItemSlot.a);
            this.a((Entity)entity, item.M());
            entity.discard(EntityRemoveEvent.Cause.PICKUP);
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.spitCooldown > 0) {
            --this.spitCooldown;
        }
        if (this.gx()) {
            this.j(this.cE());
        } else {
            if (this.bw()) {
                this.s(2400);
            } else {
                this.s(this.n() - 1);
                if (this.n() <= 0) {
                    this.a(this.ei().t(), 1.0f);
                }
                if (this.aS()) {
                    this.k(this.dI().b((this.as.i() * 2.0f - 1.0f) * 0.2f, 0.5, (this.as.i() * 2.0f - 1.0f) * 0.2f));
                    this.v(this.as.i() * 360.0f);
                    this.e(false);
                    this.aF = true;
                }
            }
            if (this.an().D_() && this.bu() && this.dI().h() > 0.03) {
                Vec3D viewVector = this.h(0.0f);
                float f2 = MathHelper.b(this.dX() * ((float)Math.PI / 180)) * 0.3f;
                float f1 = MathHelper.a(this.dX() * ((float)Math.PI / 180)) * 0.3f;
                float f22 = 1.2f - this.as.i() * 0.7f;
                for (int i2 = 0; i2 < 2; ++i2) {
                    this.an().a(Particles.aw, this.dK() - viewVector.g * (double)f22 + (double)f2, this.dM() - viewVector.h, this.dQ() - viewVector.i * (double)f22 + (double)f1, 0.0, 0.0, 0.0);
                    this.an().a(Particles.aw, this.dK() - viewVector.g * (double)f22 - (double)f2, this.dM() - viewVector.h, this.dQ() - viewVector.i * (double)f22 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void b(byte id) {
        if (id == 38) {
            this.a(Particles.R);
        } else {
            super.b(id);
        }
    }

    private void a(ParticleParam options) {
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = this.as.k() * 0.01;
            double d1 = this.as.k() * 0.01;
            double d22 = this.as.k() * 0.01;
            this.an().a(options, this.e(1.0), this.dN() + 0.2, this.h(1.0), d2, d1, d22);
        }
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.f() && itemInHand.a(TagsItem.bj)) {
            if (!this.an().D_()) {
                this.a(SoundEffects.ic, 1.0f, 1.0f);
            }
            if (this.g_()) {
                itemInHand.a(1, (EntityLiving)player);
                this.a(EntityDolphin.d_(-this.d), true);
            } else {
                this.x(true);
                itemInHand.a(1, (EntityLiving)player);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.id;
    }

    @Override
    @Nullable
    public SoundEffect f_() {
        return SoundEffects.ib;
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return this.bu() ? SoundEffects.hZ : SoundEffects.hY;
    }

    @Override
    public SoundEffect bh() {
        return SoundEffects.ig;
    }

    @Override
    public SoundEffect bg() {
        return SoundEffects.ih;
    }

    protected boolean gI() {
        BlockPosition targetPos = this.S().h();
        return targetPos != null && targetPos.a(this.dD(), 12.0);
    }

    @Override
    public void m(Vec3D travelVector) {
        if (this.bu()) {
            this.a(this.fD(), travelVector);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c(0.9));
            if (this.e() == null) {
                this.k(this.dI().b(0.0, -0.005, 0.0));
            }
        } else {
            super.m(travelVector);
        }
    }

    @Override
    public boolean v() {
        return true;
    }

    static class a
    extends PathfinderGoal {
        private final EntityDolphin a;
        private boolean b;

        a(EntityDolphin dolphin) {
            this.a = dolphin;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean X_() {
            return false;
        }

        @Override
        public boolean b() {
            if (this.a.an().purpurConfig.dolphinDisableTreasureSearching) {
                return false;
            }
            return this.a.m() && this.a.cF() >= 100;
        }

        @Override
        public boolean c() {
            BlockPosition blockPos = this.a.cB;
            return blockPos != null && !BlockPosition.a((double)blockPos.u(), this.a.dM(), (double)blockPos.w()).a(this.a.dD(), 4.0) && !this.b && this.a.cF() >= 100;
        }

        @Override
        public void d() {
            if (this.a.an() instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)this.a.an();
                this.b = false;
                this.a.S().n();
                BlockPosition blockPos = this.a.dF();
                BlockPosition blockPos1 = serverLevel.a(StructureTags.b, blockPos, 50, false);
                if (blockPos1 != null) {
                    this.a.cB = blockPos1;
                    serverLevel.a((Entity)this.a, (byte)38);
                } else {
                    this.b = true;
                }
            }
        }

        @Override
        public void e() {
            BlockPosition blockPos = this.a.cB;
            if (blockPos == null || BlockPosition.a((double)blockPos.u(), this.a.dM(), (double)blockPos.w()).a(this.a.dD(), 4.0) || this.b) {
                this.a.x(false);
            }
        }

        @Override
        public void a() {
            if (this.a.cB != null) {
                World level = this.a.an();
                if (this.a.gI() || this.a.S().l()) {
                    BlockPosition blockPos;
                    Vec3D vec3 = Vec3D.b(this.a.cB);
                    Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 1, vec3, 0.3926991f);
                    if (posTowards == null) {
                        posTowards = DefaultRandomPos.a((EntityCreature)this.a, 8, 4, vec3, 1.5707963705062866);
                    }
                    if (!(posTowards == null || level.b_(blockPos = BlockPosition.a(posTowards)).a(TagsFluid.a) && level.a_(blockPos).a(PathMode.b))) {
                        posTowards = DefaultRandomPos.a((EntityCreature)this.a, 8, 5, vec3, 1.5707963705062866);
                    }
                    if (posTowards == null) {
                        this.b = true;
                        return;
                    }
                    this.a.P().a(posTowards.g, posTowards.h, posTowards.i, this.a.ah() + 20, this.a.af());
                    this.a.S().a(posTowards.g, posTowards.h, posTowards.i, 1.3);
                    if (level.z.a(this.a(80)) == 0) {
                        level.a((Entity)this.a, (byte)38);
                    }
                }
            }
        }
    }

    static class b
    extends PathfinderGoal {
        private final EntityDolphin a;
        private final double b;
        @Nullable
        private EntityHuman c;

        b(EntityDolphin dolphin, double speedModifier) {
            this.a = dolphin;
            this.b = speedModifier;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            this.c = net.minecraft.world.entity.animal.EntityDolphin$b.a(this.a).a(cy, this.a);
            return this.c != null && this.c.cw() && this.a.e() != this.c;
        }

        @Override
        public boolean c() {
            return this.c != null && this.c.cw() && this.a.g((Entity)this.c) < 256.0;
        }

        @Override
        public void d() {
            this.c.addEffect(new MobEffect(MobEffects.D, 100), this.a, EntityPotionEffectEvent.Cause.DOLPHIN);
        }

        @Override
        public void e() {
            this.c = null;
            this.a.S().n();
        }

        @Override
        public void a() {
            this.a.P().a(this.c, (float)(this.a.ah() + 20), (float)this.a.af());
            if (this.a.g((Entity)this.c) < 6.25) {
                this.a.S().n();
            } else {
                this.a.S().a((Entity)this.c, this.b);
            }
            if (this.c.cw() && this.c.an().z.a(6) == 0) {
                this.c.addEffect(new MobEffect(MobEffects.D, 100), this.a, EntityPotionEffectEvent.Cause.DOLPHIN);
            }
        }
    }

    class c
    extends PathfinderGoal {
        private int b;

        c() {
        }

        @Override
        public boolean b() {
            if (this.b > EntityDolphin.this.at) {
                return false;
            }
            List<EntityItem> entitiesOfClass = EntityDolphin.this.an().a(EntityItem.class, EntityDolphin.this.de().c(8.0, 8.0, 8.0), cu);
            return !entitiesOfClass.isEmpty() || !EntityDolphin.this.a(EnumItemSlot.a).f();
        }

        @Override
        public void d() {
            List<EntityItem> entitiesOfClass = EntityDolphin.this.an().a(EntityItem.class, EntityDolphin.this.de().c(8.0, 8.0, 8.0), cu);
            if (!entitiesOfClass.isEmpty()) {
                EntityDolphin.this.S().a((Entity)entitiesOfClass.get(0), (double)1.2f);
                EntityDolphin.this.a(SoundEffects.if, 1.0f, 1.0f);
            }
            this.b = 0;
        }

        @Override
        public void e() {
            ItemStack itemBySlot = EntityDolphin.this.a(EnumItemSlot.a);
            if (!itemBySlot.f()) {
                this.a(itemBySlot);
                EntityDolphin.this.a(EnumItemSlot.a, ItemStack.l);
                this.b = EntityDolphin.this.at + EntityDolphin.this.as.a(100);
            }
        }

        @Override
        public void a() {
            List<EntityItem> entitiesOfClass = EntityDolphin.this.an().a(EntityItem.class, EntityDolphin.this.de().c(8.0, 8.0, 8.0), cu);
            ItemStack itemBySlot = EntityDolphin.this.a(EnumItemSlot.a);
            if (!itemBySlot.f()) {
                this.a(itemBySlot);
                EntityDolphin.this.a(EnumItemSlot.a, ItemStack.l);
            } else if (!entitiesOfClass.isEmpty()) {
                EntityDolphin.this.S().a((Entity)entitiesOfClass.get(0), (double)1.2f);
            }
        }

        private void a(ItemStack stack) {
            if (!stack.f()) {
                double d2 = EntityDolphin.this.dO() - (double)0.3f;
                EntityItem itemEntity = new EntityItem(EntityDolphin.this.an(), EntityDolphin.this.dK(), d2, EntityDolphin.this.dQ(), stack);
                itemEntity.b(40);
                itemEntity.b((Entity)EntityDolphin.this);
                float f2 = 0.3f;
                float f1 = EntityDolphin.this.as.i() * ((float)Math.PI * 2);
                float f22 = 0.02f * EntityDolphin.this.as.i();
                itemEntity.m(0.3f * -MathHelper.a(EntityDolphin.this.dX() * ((float)Math.PI / 180)) * MathHelper.b(EntityDolphin.this.dZ() * ((float)Math.PI / 180)) + MathHelper.b(f1) * f22, 0.3f * MathHelper.a(EntityDolphin.this.dZ() * ((float)Math.PI / 180)) * 1.5f, 0.3f * MathHelper.b(EntityDolphin.this.dX() * ((float)Math.PI / 180)) * MathHelper.b(EntityDolphin.this.dZ() * ((float)Math.PI / 180)) + MathHelper.a(f1) * f22);
                EntityDolphin.this.spawnAtLocation(net.minecraft.world.entity.animal.EntityDolphin$c.a(EntityDolphin.this), itemEntity);
            }
        }
    }
}

