/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOfferFlower;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillageGolem;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalDefendVillage;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;
import org.purpurmc.purpur.entity.ai.HasRider;
import org.purpurmc.purpur.entity.ai.ReceiveFlower;

public class EntityIronGolem
extends EntityGolem
implements IEntityAngerable {
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityIronGolem.class, DataWatcherRegistry.a);
    private static final int d = 25;
    private static final boolean e = false;
    private int f;
    private int ct;
    private static final UniformInt cu = TimeRange.a(20, 39);
    private int cv;
    @Nullable
    private UUID cw;
    @Nullable
    private UUID summoner;

    public EntityIronGolem(EntityTypes<? extends EntityIronGolem> type, World level) {
        super((EntityTypes<? extends EntityGolem>)type, level);
    }

    @Nullable
    public UUID getSummoner() {
        return this.summoner;
    }

    public void setSummoner(@Nullable UUID summoner) {
        this.summoner = summoner;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.ironGolemRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.ironGolemRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.ironGolemControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.ironGolemMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.ironGolemScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.ironGolemTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.ironGolemAlwaysDropExp;
    }

    @Override
    protected void H() {
        if (this.an().purpurConfig.ironGolemPoppyCalm) {
            this.cq.a(0, new ReceiveFlower(this));
        }
        if (this.an().purpurConfig.ironGolemCanSwim) {
            this.cq.a(0, new PathfinderGoalFloat(this));
        }
        this.cq.a(0, new HasRider(this));
        this.cq.a(1, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.cq.a(2, new PathfinderGoalMoveTowardsTarget(this, 0.9, 32.0f));
        this.cq.a(2, new PathfinderGoalStrollVillage((EntityCreature)this, 0.6, false));
        this.cq.a(4, new PathfinderGoalStrollVillageGolem(this, 0.6));
        this.cq.a(5, new PathfinderGoalOfferFlower(this));
        this.cq.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cq.a(8, new PathfinderGoalRandomLookaround(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalDefendVillage(this));
        this.cr.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 5, false, false, (entity, level) -> entity instanceof IMonster && !(entity instanceof EntityCreeper)));
        this.cr.a(4, new PathfinderGoalUniversalAngerReset<EntityIronGolem>(this, false));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, (byte)0);
    }

    public static AttributeProvider.Builder k() {
        return EntityInsentient.I().a(GenericAttributes.t, 100.0).a(GenericAttributes.w, 0.25).a(GenericAttributes.q, 1.0).a(GenericAttributes.c, 15.0).a(GenericAttributes.C, 1.0);
    }

    @Override
    protected int l(int air) {
        return air;
    }

    @Override
    protected void E(Entity entity) {
        if (entity instanceof IMonster && !(entity instanceof EntityCreeper) && this.ek().a(20) == 0) {
            this.setTarget((EntityLiving)entity, EntityTargetEvent.TargetReason.COLLISION);
        }
        super.E(entity);
    }

    @Override
    public void e_() {
        super.e_();
        if (this.f > 0) {
            --this.f;
        }
        if (this.ct > 0) {
            --this.ct;
        }
        if (!this.an().D_()) {
            this.a((WorldServer)this.an(), true);
        }
    }

    @Override
    public boolean bH() {
        return this.dI().j() > 2.500000277905201E-7 && this.as.a(5) == 0;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return (!this.gI() || type != EntityTypes.bX) && type != EntityTypes.H && super.a(type);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("PlayerCreated", this.gI());
        output.b("Purpur.Summoner", UUIDUtil.a, this.getSummoner());
        this.a_(output);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.y(input.a("PlayerCreated", false));
        this.setSummoner(input.a("Purpur.Summoner", UUIDUtil.a).orElse(null));
        this.a(this.an(), input);
    }

    @Override
    public void c() {
        this.a(cu.a(this.as));
    }

    @Override
    public void a(int time) {
        this.cv = time;
    }

    @Override
    public int a() {
        return this.cv;
    }

    @Override
    public void a(@Nullable UUID target) {
        this.cw = target;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cw;
    }

    private float gJ() {
        return (float)this.i(GenericAttributes.c);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        this.f = 10;
        level.a((Entity)this, (byte)4);
        float attackDamage = this.gJ();
        float f2 = (int)attackDamage > 0 ? attackDamage / 2.0f + (float)this.as.a((int)attackDamage) : attackDamage;
        DamageSource damageSource = this.ei().b(this);
        boolean flag = target.a(level, damageSource, f2);
        if (flag) {
            double d2;
            if (target instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)target;
                d2 = livingEntity.i(GenericAttributes.q);
            } else {
                d2 = 0.0;
            }
            double d3 = d2;
            double max = Math.max(0.0, 1.0 - d3);
            target.k(target.dI().b(0.0, (double)0.4f * max, 0.0));
            EnchantmentManager.a(level, target, damageSource);
        }
        this.a(SoundEffects.oW, 1.0f, 1.0f);
        return flag;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Crackiness.a crackiness = this.m();
        boolean flag = super.a(level, damageSource, amount);
        if (flag && this.m() != crackiness) {
            this.a(SoundEffects.oX, 1.0f, 1.0f);
        }
        return flag;
    }

    public Crackiness.a m() {
        return Crackiness.a.a(this.eU() / this.fj());
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.f = 10;
            this.a(SoundEffects.oW, 1.0f, 1.0f);
        } else if (id == 11) {
            this.ct = 400;
        } else if (id == 34) {
            this.ct = 0;
        } else {
            super.b(id);
        }
    }

    public int n() {
        return this.f;
    }

    public void x(boolean offeringFlower) {
        if (offeringFlower) {
            this.ct = 400;
            this.an().a((Entity)this, (byte)11);
        } else {
            this.ct = 0;
            this.an().a((Entity)this, (byte)34);
        }
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.oZ;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.oY;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.a(Items.qg)) {
            return this.tryRide(player, hand);
        }
        float health = this.eU();
        this.d(25.0f);
        if (this.eU() == health) {
            return this.tryRide(player, hand);
        }
        float f2 = 1.0f + (this.as.i() - this.as.i()) * 0.2f;
        this.a(SoundEffects.pa, 1.0f, f2);
        itemInHand.a(1, (EntityLiving)player);
        if (this.an().purpurConfig.ironGolemHealCalm && this.ae_() && this.eU() == this.fj()) {
            this.i();
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.pb, 1.0f, 1.0f);
    }

    public int s() {
        return this.ct;
    }

    public boolean gI() {
        return (this.az.a(c) & 1) != 0;
    }

    public void y(boolean playerCreated) {
        byte b2 = this.az.a(c);
        if (playerCreated) {
            this.az.a(c, (byte)(b2 | 1));
        } else {
            this.az.a(c, (byte)(b2 & 0xFFFFFFFE));
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
    }

    @Override
    public boolean a(IWorldReader level) {
        BlockPosition blockPos = this.dF();
        BlockPosition blockPos1 = blockPos.e();
        IBlockData blockState = level.a_(blockPos1);
        if (!blockState.b((IBlockAccess)level, blockPos1, this) && !this.an().paperConfig().entities.spawning.ironGolemsCanSpawnInAir) {
            return false;
        }
        for (int i2 = 1; i2 < 3; ++i2) {
            IBlockData blockState1;
            BlockPosition blockPos2 = blockPos.b(i2);
            if (SpawnerCreature.a(level, blockPos2, blockState1 = level.a_(blockPos2), blockState1.y(), EntityTypes.at)) continue;
            return false;
        }
        return SpawnerCreature.a(level, blockPos, level.a_(blockPos), FluidTypes.a.g(), EntityTypes.at) && level.f(this);
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.875f * this.df(), this.dA() * 0.4f);
    }
}

