/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOcelotAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityOcelot
extends EntityAnimal {
    public static final double ct = 0.6;
    public static final double cu = 0.8;
    public static final double cv = 1.33;
    private static final DataWatcherObject<Boolean> cx = DataWatcher.a(EntityOcelot.class, DataWatcherRegistry.k);
    private static final boolean cy = false;
    @Nullable
    private a<EntityHuman> cz;
    @Nullable
    private b cA;

    public EntityOcelot(EntityTypes<? extends EntityOcelot> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.n();
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.ocelotRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.ocelotRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.ocelotControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.ocelotMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.ocelotScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.ocelotBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.ocelotTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.ocelotAlwaysDropExp;
    }

    public boolean s() {
        return this.az.a(cx);
    }

    public void x(boolean trusting) {
        this.az.a(cx, trusting);
        this.n();
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Trusting", this.s());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a("Trusting", false));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cx, false);
    }

    @Override
    protected void H() {
        this.cA = new b(this, 0.6, itemStack -> itemStack.a(TagsItem.aV), true);
        this.cq.a(1, new PathfinderGoalFloat(this));
        this.cq.a(1, new HasRider(this));
        this.cq.a(3, this.cA);
        this.cq.a(7, new PathfinderGoalLeapAtTarget(this, 0.3f));
        this.cq.a(8, new PathfinderGoalOcelotAttack(this));
        this.cq.a(9, new PathfinderGoalBreed(this, 0.8));
        this.cq.a(10, new PathfinderGoalRandomStrollLand((EntityCreature)this, 0.8, 1.0000001E-5f));
        this.cq.a(11, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalNearestAttackableTarget<EntityChicken>((EntityInsentient)this, EntityChicken.class, false));
        this.cr.a(1, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.ct));
    }

    @Override
    public void a(WorldServer level) {
        if (this.Q().b()) {
            double speedModifier = this.Q().c();
            if (speedModifier == 0.6) {
                this.c(EntityPose.f);
                this.i(false);
            } else if (speedModifier == 1.33) {
                this.c(EntityPose.a);
                this.i(true);
            } else {
                this.c(EntityPose.a);
                this.i(false);
            }
        } else {
            this.c(EntityPose.a);
            this.i(false);
        }
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return !this.s() && this.at > 2400 && !this.k_() && !this.T_();
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gN().a(GenericAttributes.t, 10.0).a(GenericAttributes.w, 0.3f).a(GenericAttributes.c, 3.0);
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return SoundEffects.ug;
    }

    @Override
    public int W() {
        return 900;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.uf;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.uh;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if ((this.cA == null || this.cA.k()) && !this.s() && this.i(itemInHand) && player.g(this) < 9.0) {
            this.a(player, hand, itemInHand);
            if (!this.an().D_()) {
                if (this.as.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                    this.x(true);
                    this.y(true);
                    this.an().a((Entity)this, (byte)41);
                } else {
                    this.y(false);
                    this.an().a((Entity)this, (byte)40);
                }
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public void b(byte id) {
        if (id == 41) {
            this.y(true);
        } else if (id == 40) {
            this.y(false);
        } else {
            super.b(id);
        }
    }

    private void y(boolean isTrusted) {
        ParticleType particleOptions = Particles.T;
        if (!isTrusted) {
            particleOptions = Particles.ai;
        }
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = this.as.k() * 0.02;
            double d1 = this.as.k() * 0.02;
            double d22 = this.as.k() * 0.02;
            this.an().a(particleOptions, this.e(1.0), this.dN() + 0.5, this.h(1.0), d2, d1, d22);
        }
    }

    protected void n() {
        if (this.cz == null) {
            this.cz = new a<EntityHuman>(this, EntityHuman.class, 16.0f, 0.8, 1.33);
        }
        this.cq.a(this.cz);
        if (!this.s()) {
            this.cq.a(4, this.cz);
        }
    }

    @Nullable
    public EntityOcelot b(WorldServer level, EntityAgeable partner) {
        return EntityTypes.aN.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aV);
    }

    public static boolean c(EntityTypes<EntityOcelot> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return random.a(3) != 0;
    }

    @Override
    public boolean a(IWorldReader level) {
        if (level.f(this) && !level.d(this.de())) {
            BlockPosition blockPos = this.dF();
            if (!this.an().purpurConfig.ocelotSpawnUnderSeaLevel && blockPos.v() < level.T()) {
                return false;
            }
            IBlockData blockState = level.a_(blockPos.e());
            if (blockState.a(Blocks.i) || blockState.a(TagsBlock.M)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(1.0f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.5f * this.df(), this.dA() * 0.4f);
    }

    @Override
    public boolean cq() {
        return this.cu() || super.cq();
    }

    static class b
    extends PathfinderGoalTempt {
        private final EntityOcelot d;

        public b(EntityOcelot ocelot, double speedModifier, Predicate<ItemStack> items, boolean canScare) {
            super(ocelot, speedModifier, items, canScare);
            this.d = ocelot;
        }

        @Override
        protected boolean h() {
            return super.h() && !this.d.s();
        }
    }

    static class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityOcelot i;

        public a(EntityOcelot ocelot, Class<T> avoidClass, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(ocelot, avoidClass, maxDist, walkSpeedModifier, sprintSpeedModifier, IEntitySelector.e::test);
            this.i = ocelot;
        }

        @Override
        public boolean b() {
            return !this.i.s() && super.b();
        }

        @Override
        public boolean c() {
            return !this.i.s() && super.c();
        }
    }
}

