/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.mojang.serialization.Codec;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.purpurmc.purpur.controller.MoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityPanda
extends EntityAnimal {
    private static final DataWatcherObject<Integer> cv = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cx = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cy = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> cz = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> cA = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> cB = DataWatcher.a(EntityPanda.class, DataWatcherRegistry.a);
    static final PathfinderTargetCondition cC = PathfinderTargetCondition.b().a(8.0);
    private static final EntitySize cD = EntityTypes.aS.n().a(0.5f).a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, 0.40625f, 0.0f));
    private static final int cE = 2;
    private static final int cF = 4;
    private static final int cG = 8;
    private static final int cH = 16;
    private static final int cI = 5;
    public static final int ct = 32;
    private static final int cJ = 32;
    boolean cK;
    boolean cL;
    public int cu;
    private Vec3D cM;
    private float cN;
    private float cO;
    private float cP;
    private float cS;
    private float cT;
    private float cU;
    g cV;

    public EntityPanda(EntityTypes<? extends EntityPanda> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.cn = new h(this);
        if (!this.g_()) {
            this.a_(true);
        }
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.pandaRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.pandaRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.pandaControllable;
    }

    @Override
    public void onMount(EntityHuman rider) {
        super.onMount(rider);
        this.setForwardMot(0.0f);
        this.x(false);
        this.z(false);
        this.y(false);
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.pandaMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.pandaScale);
        this.hd();
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.pandaBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.pandaTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.pandaAlwaysDropExp;
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.a && this.gc();
    }

    public int m() {
        return this.az.a(cv);
    }

    public void s(int unhappyCounter) {
        this.az.a(cv, unhappyCounter);
    }

    public boolean n() {
        return this.v(2);
    }

    public boolean s() {
        return this.v(8);
    }

    public void x(boolean sitting) {
        if (!new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        this.d(8, sitting);
    }

    public boolean gI() {
        return this.v(16);
    }

    public void y(boolean onBack) {
        this.d(16, onBack);
    }

    public boolean gJ() {
        return this.az.a(cy) > 0;
    }

    public void z(boolean eating) {
        this.az.a(cy, eating ? 1 : 0);
    }

    public int hf() {
        return this.az.a(cy);
    }

    public void u(int eatCounter) {
        this.az.a(cy, eatCounter);
    }

    public void A(boolean sneezing) {
        this.d(2, sneezing);
        if (!sneezing) {
            this.t(0);
        }
    }

    public int gK() {
        return this.az.a(cx);
    }

    public void t(int sneezeCounter) {
        this.az.a(cx, sneezeCounter);
    }

    public Gene gL() {
        return Gene.a(this.az.a(cz).byteValue());
    }

    public void a(Gene pandaType) {
        if (pandaType.a() > 6) {
            pandaType = Gene.a(this.as);
        }
        this.az.a(cz, (byte)pandaType.a());
    }

    public Gene gM() {
        return Gene.a(this.az.a(cA).byteValue());
    }

    public void b(Gene pandaType) {
        if (pandaType.a() > 6) {
            pandaType = Gene.a(this.as);
        }
        this.az.a(cA, (byte)pandaType.a());
    }

    public boolean gU() {
        return this.v(4);
    }

    public void B(boolean rolling) {
        this.d(4, rolling);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cv, 0);
        builder.a(cx, 0);
        builder.a(cz, (byte)0);
        builder.a(cA, (byte)0);
        builder.a(cB, (byte)0);
        builder.a(cy, 0);
    }

    private boolean v(int flag) {
        return (this.az.a(cB) & flag) != 0;
    }

    private void d(int flagId, boolean value) {
        byte b2 = this.az.a(cB);
        if (value) {
            this.az.a(cB, (byte)(b2 | flagId));
        } else {
            this.az.a(cB, (byte)(b2 & ~flagId));
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("MainGene", Gene.h, this.gL());
        output.a("HiddenGene", Gene.h, this.gM());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("MainGene", Gene.h).orElse(Gene.a));
        this.b(input.a("HiddenGene", Gene.h).orElse(Gene.a));
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        EntityPanda panda = EntityTypes.aS.a(level, EntitySpawnReason.e);
        if (panda != null) {
            if (partner instanceof EntityPanda) {
                EntityPanda panda1 = (EntityPanda)partner;
                panda.a(this, panda1);
            }
            panda.hd();
        }
        return panda;
    }

    @Override
    protected void H() {
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(0, new HasRider(this));
        this.cq.a(2, new i(this, 2.0));
        this.cq.a(2, new d(this, 1.0));
        this.cq.a(3, new b(this, (double)1.2f, true));
        this.cq.a(4, new PathfinderGoalTempt(this, 1.0, stack -> stack.a(TagsItem.aW), false));
        this.cq.a(6, new c<EntityHuman>(this, EntityHuman.class, 8.0f, 2.0, 2.0));
        this.cq.a(6, new c<EntityMonster>(this, EntityMonster.class, 4.0f, 2.0, 2.0));
        this.cq.a(7, new k());
        this.cq.a(8, new f(this));
        this.cq.a(8, new l(this));
        this.cV = new g(this, EntityHuman.class, 6.0f);
        this.cq.a(9, this.cV);
        this.cq.a(10, new PathfinderGoalRandomLookaround(this));
        this.cq.a(12, new j(this));
        this.cq.a(13, new PathfinderGoalFollowParent(this, 1.25));
        this.cq.a(14, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new e(this, new Class[0]).a(new Class[0]));
    }

    public static AttributeProvider.Builder gV() {
        return EntityAnimal.gN().a(GenericAttributes.w, 0.15f).a(GenericAttributes.c, 6.0);
    }

    public Gene gW() {
        return Gene.a(this.gL(), this.gM());
    }

    public boolean gX() {
        return this.gW() == Gene.b;
    }

    public boolean gY() {
        return this.gW() == Gene.c;
    }

    public boolean gZ() {
        return this.gW() == Gene.d;
    }

    public boolean ha() {
        return this.gW() == Gene.e;
    }

    public boolean hb() {
        return this.gW() == Gene.f;
    }

    @Override
    public boolean gz() {
        return this.gW() == Gene.g;
    }

    @Override
    public boolean v() {
        return false;
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        if (!this.gz()) {
            this.cL = true;
        }
        return super.c(level, target);
    }

    @Override
    public void gB() {
        this.a(SoundEffects.uw, 1.0f, 1.0f);
    }

    @Override
    public void g() {
        EntityLiving target;
        super.g();
        if (this.gY()) {
            if (this.an().ai() && !this.bu()) {
                this.x(true);
                this.z(false);
            } else if (!this.gJ()) {
                this.x(false);
            }
        }
        if ((target = this.e()) == null) {
            this.cK = false;
            this.cL = false;
        }
        if (this.m() > 0) {
            if (target != null) {
                this.a((Entity)target, 90.0f, 90.0f);
            }
            if (this.m() == 29 || this.m() == 14) {
                this.a(SoundEffects.us, 1.0f, 1.0f);
            }
            this.s(this.m() - 1);
        }
        if (this.n()) {
            this.t(this.gK() + 1);
            if (this.gK() > 20) {
                this.A(false);
                this.hm();
            } else if (this.gK() == 1) {
                this.a(SoundEffects.um, 1.0f, 1.0f);
            }
        }
        if (this.gU()) {
            this.hl();
        } else {
            this.cu = 0;
        }
        if (this.s()) {
            this.w(0.0f);
        }
        this.hi();
        this.hg();
        this.hj();
        this.hk();
    }

    public boolean hc() {
        return this.gY() && this.an().ai();
    }

    private void hg() {
        if (!this.gJ() && this.s() && !this.hc() && !this.a(EnumItemSlot.a).f() && this.as.a(80) == 1) {
            this.z(true);
        } else if (this.a(EnumItemSlot.a).f() || !this.s()) {
            this.z(false);
        }
        if (this.gJ()) {
            this.hh();
            if (!this.an().D_() && this.hf() > 80 && this.as.a(20) == 1) {
                if (this.hf() > 100 && this.a(EnumItemSlot.a).a(TagsItem.aX)) {
                    if (!this.an().D_()) {
                        this.a(EnumItemSlot.a, ItemStack.l);
                        this.c(GameEvent.m);
                    }
                    this.x(false);
                }
                this.z(false);
                return;
            }
            this.u(this.hf() + 1);
        }
    }

    private void hh() {
        if (this.hf() % 5 == 0) {
            this.a(SoundEffects.uq, 0.5f + 0.5f * (float)this.as.a(2), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
            for (int i2 = 0; i2 < 6; ++i2) {
                Vec3D vec3 = new Vec3D(((double)this.as.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.as.i() - 0.5) * 0.1);
                vec3 = vec3.a(-this.dZ() * ((float)Math.PI / 180));
                vec3 = vec3.b(-this.dX() * ((float)Math.PI / 180));
                double d2 = (double)(-this.as.i()) * 0.6 - 0.3;
                Vec3D vec31 = new Vec3D(((double)this.as.i() - 0.5) * 0.8, d2, 1.0 + ((double)this.as.i() - 0.5) * 0.4);
                vec31 = vec31.b(-this.bB * ((float)Math.PI / 180));
                vec31 = vec31.b(this.dK(), this.dO() + 1.0, this.dQ());
                this.an().a(new ParticleParamItem(Particles.V, this.a(EnumItemSlot.a)), vec31.g, vec31.h, vec31.i, vec3.g, vec3.h + 0.05, vec3.i);
            }
        }
    }

    private void hi() {
        this.cO = this.cN;
        this.cN = this.s() ? Math.min(1.0f, this.cN + 0.15f) : Math.max(0.0f, this.cN - 0.19f);
    }

    private void hj() {
        this.cS = this.cP;
        this.cP = this.gI() ? Math.min(1.0f, this.cP + 0.15f) : Math.max(0.0f, this.cP - 0.19f);
    }

    private void hk() {
        this.cU = this.cT;
        this.cT = this.gU() ? Math.min(1.0f, this.cT + 0.15f) : Math.max(0.0f, this.cT - 0.19f);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cO, this.cN);
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cS, this.cP);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cU, this.cT);
    }

    private void hl() {
        ++this.cu;
        if (this.cu > 32) {
            this.B(false);
        } else if (!this.an().D_()) {
            Vec3D deltaMovement = this.dI();
            if (this.cu == 1) {
                float f2 = this.dX() * ((float)Math.PI / 180);
                float f1 = this.g_() ? 0.1f : 0.2f;
                this.cM = new Vec3D(deltaMovement.g + (double)(-MathHelper.a(f2) * f1), 0.0, deltaMovement.i + (double)(MathHelper.b(f2) * f1));
                this.k(this.cM.b(0.0, 0.27, 0.0));
            } else if ((float)this.cu != 7.0f && (float)this.cu != 15.0f && (float)this.cu != 23.0f) {
                this.m(this.cM.g, deltaMovement.h, this.cM.i);
            } else {
                this.m(0.0, this.aS() ? 0.27 : deltaMovement.h, 0.0);
            }
        }
    }

    private void hm() {
        WorldServer serverLevel;
        Vec3D deltaMovement = this.dI();
        World level = this.an();
        level.a(Particles.ak, this.dK() - (double)(this.dA() + 1.0f) * 0.5 * (double)MathHelper.a(this.bB * ((float)Math.PI / 180)), this.dO() - (double)0.1f, this.dQ() + (double)(this.dA() + 1.0f) * 0.5 * (double)MathHelper.b(this.bB * ((float)Math.PI / 180)), deltaMovement.g, 0.0, deltaMovement.i);
        this.a(SoundEffects.un, 1.0f, 1.0f);
        for (EntityPanda panda : level.a(EntityPanda.class, this.de().g(10.0))) {
            if (panda.g_() || !panda.aS() || panda.bu() || !panda.he()) continue;
            if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                panda.u();
                continue;
            }
            this.t(false);
        }
        World world = this.an();
        if (world instanceof WorldServer && (serverLevel = (WorldServer)world).S().c(GameRules.g)) {
            this.forceDrops = true;
            this.a(serverLevel, LootTables.aH, this::a);
            this.forceDrops = false;
        }
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        if (!CraftEventFactory.callEntityPickupItemEvent(this, entity, 0, !this.a(EnumItemSlot.a).f() || !EntityPanda.b(entity)).isCancelled()) {
            this.a(entity);
            ItemStack item = entity.e();
            this.a(EnumItemSlot.a, item);
            this.g(EnumItemSlot.a);
            this.a((Entity)entity, item.M());
            entity.discard(EntityRemoveEvent.Cause.PICKUP);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        this.x(false);
        return super.a(level, damageSource, amount);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.I_();
        this.a(Gene.a(random));
        this.b(Gene.a(random));
        this.hd();
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(0.2f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public void a(EntityPanda father, @Nullable EntityPanda mother) {
        if (mother == null) {
            if (this.as.h()) {
                this.a(father.hn());
                this.b(Gene.a(this.as));
            } else {
                this.a(Gene.a(this.as));
                this.b(father.hn());
            }
        } else if (this.as.h()) {
            this.a(father.hn());
            this.b(mother.hn());
        } else {
            this.a(mother.hn());
            this.b(father.hn());
        }
        if (this.as.a(32) == 0) {
            this.a(Gene.a(this.as));
        }
        if (this.as.a(32) == 0) {
            this.b(Gene.a(this.as));
        }
    }

    private Gene hn() {
        return this.as.h() ? this.gL() : this.gM();
    }

    public void hd() {
        if (this.hb()) {
            AttributeModifiable maxHealth = this.h(GenericAttributes.t);
            maxHealth.a(maxHealth.g() / 2.0);
        }
        if (this.gX()) {
            this.h(GenericAttributes.w).a(0.07f);
        }
    }

    void ho() {
        if (!this.bu()) {
            this.G(0.0f);
            this.S().n();
            this.x(true);
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        block7: {
            block9: {
                WorldServer serverLevel;
                ItemStack itemInHand;
                block12: {
                    block11: {
                        block10: {
                            block8: {
                                itemInHand = player.b(hand);
                                if (this.hc()) {
                                    return this.tryRide(player, hand);
                                }
                                if (this.gI()) {
                                    this.y(false);
                                    return EnumInteractionResult.a;
                                }
                                if (!this.i(itemInHand)) break block7;
                                if (this.e() != null) {
                                    this.cK = true;
                                }
                                if (!this.g_()) break block8;
                                this.a(player, hand, itemInHand);
                                this.a((int)((float)(-this.aa_() / 20) * 0.1f), true);
                                break block9;
                            }
                            if (this.an().D_() || this.aa_() != 0 || !this.gP()) break block10;
                            ItemStack breedCopy = itemInHand.v();
                            this.a(player, hand, itemInHand);
                            this.setInLove(player, breedCopy);
                            break block9;
                        }
                        World world = this.an();
                        if (!(world instanceof WorldServer)) break block11;
                        serverLevel = (WorldServer)world;
                        if (!this.s() && !this.bu()) break block12;
                    }
                    return EnumInteractionResult.e;
                }
                this.ho();
                this.z(true);
                ItemStack itemBySlot = this.a(EnumItemSlot.a);
                if (!itemBySlot.f() && !player.gk()) {
                    this.forceDrops = true;
                    this.a(serverLevel, itemBySlot);
                    this.forceDrops = false;
                }
                this.a(EnumItemSlot.a, new ItemStack(itemInHand.h(), 1));
                this.a(player, hand, itemInHand);
            }
            return EnumInteractionResult.b;
        }
        return this.tryRide(player, hand);
    }

    @Override
    @Nullable
    public SoundEffect p() {
        if (this.gz()) {
            return SoundEffects.ut;
        }
        return this.gY() ? SoundEffects.uu : SoundEffects.uo;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.ur, 0.15f, 1.0f);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aW);
    }

    @Override
    @Nullable
    public SoundEffect f_() {
        return SoundEffects.up;
    }

    @Override
    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.uv;
    }

    public boolean he() {
        return !this.gI() && !this.hc() && !this.gJ() && !this.gU() && !this.s();
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.g_() ? cD : super.b(pose);
    }

    private static boolean b(EntityItem itemEntity) {
        return itemEntity.e().a(TagsItem.aX) && itemEntity.bX() && !itemEntity.n();
    }

    static class h
    extends MoveControllerWASD {
        private final EntityPanda l;

        public h(EntityPanda mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void vanillaTick() {
            if (this.l.he()) {
                super.vanillaTick();
            }
        }
    }

    public static final class Gene
    extends Enum<Gene>
    implements INamable {
        public static final /* enum */ Gene a = new Gene(0, "normal", false);
        public static final /* enum */ Gene b = new Gene(1, "lazy", false);
        public static final /* enum */ Gene c = new Gene(2, "worried", false);
        public static final /* enum */ Gene d = new Gene(3, "playful", false);
        public static final /* enum */ Gene e = new Gene(4, "brown", true);
        public static final /* enum */ Gene f = new Gene(5, "weak", true);
        public static final /* enum */ Gene g = new Gene(6, "aggressive", false);
        public static final Codec<Gene> h;
        private static final IntFunction<Gene> i;
        private static final int j = 6;
        private final int k;
        private final String l;
        private final boolean m;
        private static final /* synthetic */ Gene[] n;

        public static Gene[] values() {
            return (Gene[])n.clone();
        }

        public static Gene valueOf(String name) {
            return Enum.valueOf(Gene.class, name);
        }

        private Gene(int id, String name, boolean isRecessive) {
            this.k = id;
            this.l = name;
            this.m = isRecessive;
        }

        public int a() {
            return this.k;
        }

        @Override
        public String c() {
            return this.l;
        }

        public boolean b() {
            return this.m;
        }

        static Gene a(Gene mainGene, Gene hiddenGene) {
            if (mainGene.b()) {
                return mainGene == hiddenGene ? mainGene : a;
            }
            return mainGene;
        }

        public static Gene a(int id) {
            return i.apply(id);
        }

        public static Gene a(RandomSource random) {
            int randomInt = random.a(16);
            if (randomInt == 0) {
                return b;
            }
            if (randomInt == 1) {
                return c;
            }
            if (randomInt == 2) {
                return d;
            }
            if (randomInt == 4) {
                return g;
            }
            if (randomInt < 9) {
                return f;
            }
            return randomInt < 11 ? e : a;
        }

        private static /* synthetic */ Gene[] d() {
            return new Gene[]{a, b, c, d, e, f, g};
        }

        static {
            n = Gene.d();
            h = INamable.a(Gene::values);
            i = ByIdMap.a(Gene::a, Gene.values(), ByIdMap.a.a);
        }
    }

    static class i
    extends PathfinderGoalPanic {
        private final EntityPanda a;

        public i(EntityPanda panda, double speedModifier) {
            super((EntityCreature)panda, speedModifier, DamageTypeTags.G);
            this.a = panda;
        }

        @Override
        public boolean c() {
            if (this.a.s()) {
                this.a.S().n();
                return false;
            }
            return super.c();
        }
    }

    static class d
    extends PathfinderGoalBreed {
        private final EntityPanda d;
        private int e;

        public d(EntityPanda panda, double speedModifier) {
            super(panda, speedModifier);
            this.d = panda;
        }

        @Override
        public boolean b() {
            if (!super.b() || this.d.m() != 0) {
                return false;
            }
            if (!this.h()) {
                if (this.e <= this.d.at) {
                    this.d.s(32);
                    this.e = this.d.at + 600;
                    if (this.d.dt()) {
                        EntityHuman nearestPlayer = this.b.a(cC, this.d);
                        this.d.cV.a(nearestPlayer);
                    }
                }
                return false;
            }
            return true;
        }

        private boolean h() {
            BlockPosition blockPos = this.d.dF();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (int i2 = 0; i2 < 3; ++i2) {
                for (int i1 = 0; i1 < 8; ++i1) {
                    int i22 = 0;
                    while (i22 <= i1) {
                        int i3;
                        int n2 = i3 = i22 < i1 && i22 > -i1 ? i1 : 0;
                        while (i3 <= i1) {
                            mutableBlockPos.a(blockPos, i22, i2, i3);
                            if (this.b.a_(mutableBlockPos).a(Blocks.nW)) {
                                return true;
                            }
                            i3 = i3 > 0 ? -i3 : 1 - i3;
                        }
                        i22 = i22 > 0 ? -i22 : 1 - i22;
                    }
                }
            }
            return false;
        }
    }

    static class b
    extends PathfinderGoalMeleeAttack {
        private final EntityPanda b;

        public b(EntityPanda panda, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(panda, speedModifier, followingTargetEvenIfNotSeen);
            this.b = panda;
        }

        @Override
        public boolean b() {
            return this.b.he() && super.b();
        }
    }

    static class c<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityPanda i;

        public c(EntityPanda panda, Class<T> avoidClass, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(panda, avoidClass, maxDist, walkSpeedModifier, sprintSpeedModifier, IEntitySelector.f::test);
            this.i = panda;
        }

        @Override
        public boolean b() {
            return this.i.gY() && this.i.he() && super.b();
        }
    }

    class k
    extends PathfinderGoal {
        private int b;

        public k() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return this.b <= EntityPanda.this.at && !EntityPanda.this.g_() && !EntityPanda.this.bu() && EntityPanda.this.he() && EntityPanda.this.m() <= 0 && (!EntityPanda.this.a(EnumItemSlot.a).f() || !EntityPanda.this.an().a(EntityItem.class, EntityPanda.this.de().c(6.0, 6.0, 6.0), EntityPanda::b).isEmpty());
        }

        @Override
        public boolean c() {
            return !EntityPanda.this.bu() && (EntityPanda.this.gX() || EntityPanda.this.as.a(k.b(600)) != 1) && EntityPanda.this.as.a(k.b(2000)) != 1;
        }

        @Override
        public void a() {
            if (!EntityPanda.this.s() && !EntityPanda.this.a(EnumItemSlot.a).f()) {
                EntityPanda.this.ho();
            }
        }

        @Override
        public void d() {
            if (EntityPanda.this.a(EnumItemSlot.a).f()) {
                List<EntityItem> entitiesOfClass = EntityPanda.this.an().a(EntityItem.class, EntityPanda.this.de().c(8.0, 8.0, 8.0), EntityPanda::b);
                if (!entitiesOfClass.isEmpty()) {
                    EntityPanda.this.S().a((Entity)entitiesOfClass.getFirst(), (double)1.2f);
                }
            } else {
                EntityPanda.this.ho();
            }
            this.b = 0;
        }

        @Override
        public void e() {
            ItemStack itemBySlot = EntityPanda.this.a(EnumItemSlot.a);
            if (!itemBySlot.f()) {
                EntityPanda.this.forceDrops = true;
                EntityPanda.this.a(k.a(EntityPanda.this.an()), itemBySlot);
                EntityPanda.this.forceDrops = false;
                EntityPanda.this.a(EnumItemSlot.a, ItemStack.l);
                int i2 = EntityPanda.this.gX() ? EntityPanda.this.as.a(50) + 10 : EntityPanda.this.as.a(150) + 10;
                this.b = EntityPanda.this.at + i2 * 20;
            }
            EntityPanda.this.x(false);
        }
    }

    static class f
    extends PathfinderGoal {
        private final EntityPanda a;
        private int b;

        public f(EntityPanda panda) {
            this.a = panda;
        }

        @Override
        public boolean b() {
            return this.b < this.a.at && this.a.gX() && this.a.he() && this.a.as.a(net.minecraft.world.entity.animal.EntityPanda$f.b(400)) == 1;
        }

        @Override
        public boolean c() {
            return !this.a.bu() && (this.a.gX() || this.a.as.a(net.minecraft.world.entity.animal.EntityPanda$f.b(600)) != 1) && this.a.as.a(net.minecraft.world.entity.animal.EntityPanda$f.b(2000)) != 1;
        }

        @Override
        public void d() {
            this.a.y(true);
            this.b = 0;
        }

        @Override
        public void e() {
            this.a.y(false);
            this.b = this.a.at + 200;
        }
    }

    static class l
    extends PathfinderGoal {
        private final EntityPanda a;

        public l(EntityPanda panda) {
            this.a = panda;
        }

        @Override
        public boolean b() {
            return this.a.g_() && this.a.he() && (this.a.hb() && this.a.as.a(l.b(500)) == 1 || this.a.as.a(l.b(6000)) == 1);
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void d() {
            this.a.A(true);
        }
    }

    static class g
    extends PathfinderGoalLookAtPlayer {
        private final EntityPanda h;

        public g(EntityPanda panda, Class<? extends EntityLiving> lookAtType, float lookDistance) {
            super(panda, lookAtType, lookDistance);
            this.h = panda;
        }

        public void a(EntityLiving lookAt) {
            this.c = lookAt;
        }

        @Override
        public boolean c() {
            return this.c != null && super.c();
        }

        @Override
        public boolean b() {
            if (this.b.ek().i() >= this.e) {
                return false;
            }
            if (this.c == null) {
                WorldServer serverLevel = g.a(this.b);
                this.c = this.f == EntityHuman.class ? serverLevel.a(this.g, this.b, this.b.dK(), this.b.dO(), this.b.dQ()) : serverLevel.a(this.b.an().a(this.f, this.b.de().c(this.d, 3.0, this.d), entity -> true), this.g, this.b, this.b.dK(), this.b.dO(), this.b.dQ());
            }
            return this.h.he() && this.c != null;
        }

        @Override
        public void a() {
            if (this.c != null) {
                super.a();
            }
        }
    }

    static class j
    extends PathfinderGoal {
        private final EntityPanda a;

        public j(EntityPanda panda) {
            this.a = panda;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean b() {
            if ((this.a.g_() || this.a.gZ()) && this.a.aS()) {
                if (!this.a.he()) {
                    return false;
                }
                float f2 = this.a.dX() * ((float)Math.PI / 180);
                float f1 = -MathHelper.a(f2);
                float cos = MathHelper.b(f2);
                int i2 = (double)Math.abs(f1) > 0.5 ? MathHelper.k((double)f1) : 0;
                int i1 = (double)Math.abs(cos) > 0.5 ? MathHelper.k((double)cos) : 0;
                return this.a.an().a_(this.a.dF().b(i2, -1, i1)).l() || this.a.gZ() && this.a.as.a(j.b(60)) == 1 || this.a.as.a(j.b(500)) == 1;
            }
            return false;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void d() {
            this.a.B(true);
        }

        @Override
        public boolean X_() {
            return false;
        }
    }

    static class e
    extends PathfinderGoalHurtByTarget {
        private final EntityPanda a;

        public e(EntityPanda panda, Class<?> ... toIgnoreDamage) {
            super(panda, toIgnoreDamage);
            this.a = panda;
        }

        @Override
        public boolean c() {
            if (!this.a.cK && !this.a.cL) {
                return super.c();
            }
            this.a.g((EntityLiving)null);
            return false;
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityPanda && mob.gz()) {
                mob.setTarget(target, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY);
            }
        }
    }
}

