/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityPerchable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.purpurmc.purpur.controller.FlyingWithSpacebarMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityParrot
extends EntityPerchable
implements EntityBird {
    private static final DataWatcherObject<Integer> cB = DataWatcher.a(EntityParrot.class, DataWatcherRegistry.b);
    private static final Predicate<EntityInsentient> cC = new Predicate<EntityInsentient>(){

        public boolean a(@Nullable EntityInsentient mob) {
            return mob != null && cD.containsKey(mob.ax());
        }
    };
    static final Map<EntityTypes<?>, SoundEffect> cD = SystemUtils.a(Maps.newHashMap(), (? super T map) -> {
        map.put(EntityTypes.q, SoundEffects.uC);
        map.put(EntityTypes.s, SoundEffects.uD);
        map.put(EntityTypes.t, SoundEffects.uE);
        map.put(EntityTypes.x, SoundEffects.vb);
        map.put(EntityTypes.G, SoundEffects.uF);
        map.put(EntityTypes.H, SoundEffects.uG);
        map.put(EntityTypes.N, SoundEffects.uH);
        map.put(EntityTypes.P, SoundEffects.uI);
        map.put(EntityTypes.S, SoundEffects.uJ);
        map.put(EntityTypes.R, SoundEffects.uK);
        map.put(EntityTypes.V, SoundEffects.uL);
        map.put(EntityTypes.ag, SoundEffects.uM);
        map.put(EntityTypes.ah, SoundEffects.sP);
        map.put(EntityTypes.am, SoundEffects.uN);
        map.put(EntityTypes.an, SoundEffects.uO);
        map.put(EntityTypes.aq, SoundEffects.uP);
        map.put(EntityTypes.ar, SoundEffects.uQ);
        map.put(EntityTypes.aD, SoundEffects.uR);
        map.put(EntityTypes.aU, SoundEffects.uS);
        map.put(EntityTypes.aW, SoundEffects.uT);
        map.put(EntityTypes.aX, SoundEffects.uU);
        map.put(EntityTypes.aY, SoundEffects.uV);
        map.put(EntityTypes.be, SoundEffects.uW);
        map.put(EntityTypes.bh, SoundEffects.uX);
        map.put(EntityTypes.bj, SoundEffects.uY);
        map.put(EntityTypes.bk, SoundEffects.uZ);
        map.put(EntityTypes.bm, SoundEffects.va);
        map.put(EntityTypes.bt, SoundEffects.vb);
        map.put(EntityTypes.bx, SoundEffects.vc);
        map.put(EntityTypes.bH, SoundEffects.vd);
        map.put(EntityTypes.bJ, SoundEffects.ve);
        map.put(EntityTypes.bL, SoundEffects.vf);
        map.put(EntityTypes.bN, SoundEffects.vg);
        map.put(EntityTypes.bO, SoundEffects.vh);
        map.put(EntityTypes.bP, SoundEffects.vi);
        map.put(EntityTypes.bS, SoundEffects.vj);
        map.put(EntityTypes.bT, SoundEffects.vk);
        map.put(EntityTypes.bV, SoundEffects.vl);
    });
    public float cx;
    public float cy;
    public float cz;
    public float cA;
    private float cE = 1.0f;
    private float cF = 1.0f;
    private boolean cG;
    @Nullable
    private BlockPosition cH;

    public EntityParrot(EntityTypes<? extends EntityParrot> type, World level) {
        super((EntityTypes<? extends EntityPerchable>)type, level);
        final FlyingWithSpacebarMoveControllerWASD flyingController = new FlyingWithSpacebarMoveControllerWASD((EntityInsentient)this, 0.3f);
        class ParrotMoveControl
        extends ControllerMoveFlying {
            public ParrotMoveControl(EntityInsentient entity, int maxPitchChange, boolean noGravity) {
                super(entity, maxPitchChange, noGravity);
            }

            @Override
            public void a() {
                if (this.d.getRider() != null && this.d.isControllable()) {
                    flyingController.purpurTick(this.d.getRider());
                } else {
                    super.a();
                }
            }

            @Override
            public boolean b() {
                return this.d.getRider() != null && this.d.isControllable() ? EntityParrot.this.getForwardMot() != 0.0f || EntityParrot.this.getStrafeMot() != 0.0f : super.b();
            }
        }
        this.cn = new ParrotMoveControl(this, 10, false);
        this.a(PathType.n, -1.0f);
        this.a(PathType.o, -1.0f);
        this.a(PathType.x, -1.0f);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.parrotRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.parrotRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.parrotControllable;
    }

    @Override
    public double getMaxY() {
        return this.an().purpurConfig.parrotMaxY;
    }

    @Override
    public void m(Vec3D vec3) {
        super.m(vec3);
        if (this.getRider() != null && this.isControllable() && !((Entity)this).bc) {
            float speed = (float)this.i(GenericAttributes.m) * 2.0f;
            this.B(speed);
            Vec3D mot = this.dI();
            this.a(EnumMoveType.a, mot.d(speed, 0.25, speed));
            this.k(mot.c(0.9));
        }
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.parrotMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.parrotScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return 6000;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.parrotTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.parrotAlwaysDropExp;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.a(SystemUtils.a(Variant.values(), level.I_()));
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(false);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean g_() {
        return false;
    }

    @Override
    protected void H() {
        this.cq.a(0, new PathfinderGoalFloat(this));
        if (this.an().purpurConfig.parrotBreedable) {
            this.cq.a(1, new PathfinderGoalBreed(this, 1.0));
        }
        this.cq.a(0, new HasRider(this));
        this.cq.a(1, new EntityTameableAnimal.a(1.25));
        this.cq.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(2, new PathfinderGoalSit(this));
        this.cq.a(2, new PathfinderGoalFollowOwner(this, 1.0, 5.0f, 1.0f));
        this.cq.a(2, new a(this, 1.0));
        this.cq.a(3, new PathfinderGoalPerch(this));
        this.cq.a(3, new PathfinderGoalFollowEntity(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeProvider.Builder gU() {
        return EntityAnimal.gN().a(GenericAttributes.t, 6.0).a(GenericAttributes.m, 0.4f).a(GenericAttributes.w, 0.2f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        NavigationFlying flyingPathNavigation = new NavigationFlying(this, level);
        flyingPathNavigation.e(false);
        flyingPathNavigation.a(true);
        return flyingPathNavigation;
    }

    @Override
    public void e_() {
        if (this.cH == null || !this.cH.a(this.dD(), 3.46) || !this.an().a_(this.cH).a(Blocks.ew)) {
            this.cG = false;
            this.cH = null;
        }
        if (this.an().z.a(400) == 0) {
            EntityParrot.a(this.an(), this);
        }
        super.e_();
        this.gZ();
    }

    @Override
    public void a(BlockPosition pos, boolean isPartying) {
        this.cH = pos;
        this.cG = isPartying;
    }

    public boolean gV() {
        return this.cG;
    }

    private void gZ() {
        this.cA = this.cx;
        this.cz = this.cy;
        this.cy += (float)(!this.aS() && !this.cl() ? 4 : -1) * 0.3f;
        this.cy = MathHelper.a(this.cy, 0.0f, 1.0f);
        if (!this.aS() && this.cE < 1.0f) {
            this.cE = 1.0f;
        }
        this.cE *= 0.9f;
        Vec3D deltaMovement = this.dI();
        if (!this.aS() && deltaMovement.h < 0.0) {
            this.k(deltaMovement.d(1.0, 0.6, 1.0));
        }
        this.cx += this.cE * 2.0f;
    }

    public static boolean a(World level, Entity parrot) {
        if (parrot.bX() && !parrot.bm() && level.z.a(2) == 0) {
            EntityInsentient mob;
            List<EntityInsentient> entitiesOfClass = level.a(EntityInsentient.class, parrot.de().g(20.0), cC);
            if (!entitiesOfClass.isEmpty() && !(mob = entitiesOfClass.get(level.z.a(entitiesOfClass.size()))).bm()) {
                SoundEffect imitatedSound = EntityParrot.b(mob.ax());
                level.a(null, parrot.dK(), parrot.dM(), parrot.dQ(), imitatedSound, parrot.dw(), 0.7f, EntityParrot.a(level.z));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (!this.m() && itemInHand.a(TagsItem.bd)) {
            this.a(player, hand, itemInHand);
            if (!this.bm()) {
                this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.uz, this.dw(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
            }
            if (!this.an().D_()) {
                if ((this.an().purpurConfig.alwaysTameInCreative && player.gk() || this.as.a(10) == 0) && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                    this.g(player);
                    this.an().a((Entity)this, (byte)7);
                } else {
                    this.an().a((Entity)this, (byte)6);
                }
            }
            if (this.an().purpurConfig.parrotBreedable) {
                return super.b(player, hand);
            }
            return EnumInteractionResult.a;
        }
        if (!itemInHand.a(TagsItem.be)) {
            if (!this.gX() && this.m() && this.j(player)) {
                if (!this.an().D_()) {
                    this.z(!this.gI());
                }
                return EnumInteractionResult.a;
            }
            return super.b(player, hand);
        }
        this.a(player, hand, itemInHand);
        this.addEffect(new MobEffect(MobEffects.s, 900), EntityPotionEffectEvent.Cause.FOOD);
        if (player.gQ() || !this.cP()) {
            this.a(this.ei().a(player), Float.MAX_VALUE);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean i(ItemStack stack) {
        return this.an().purpurConfig.parrotBreedable && stack.a(TagsItem.bd);
    }

    public static boolean c(EntityTypes<EntityParrot> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cp) && EntityParrot.a(level, pos);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return super.a(otherAnimal);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return level.purpurConfig.parrotBreedable ? (EntityAgeable)EntityTypes.aT.a(level, EntitySpawnReason.e) : null;
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return EntityParrot.a(this.an(), this.an().z);
    }

    public static SoundEffect a(World level, RandomSource random) {
        if (level.aq() != EnumDifficulty.a && random.a(1000) == 0) {
            ArrayList list = Lists.newArrayList(cD.keySet());
            return EntityParrot.b((EntityTypes)list.get(random.a(list.size())));
        }
        return SoundEffects.ux;
    }

    private static SoundEffect b(EntityTypes<?> type) {
        return cD.getOrDefault(type, SoundEffects.ux);
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.uB;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.uy;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.vm, 0.15f, 1.0f);
    }

    @Override
    protected boolean bl() {
        return this.am > this.cF;
    }

    @Override
    protected void bk() {
        this.a(SoundEffects.uA, 0.15f, 1.0f);
        this.cF = this.am + this.cy / 2.0f;
    }

    @Override
    public float fu() {
        return EntityParrot.a(this.as);
    }

    public static float a(RandomSource random) {
        return (random.i() - random.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.g;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return super.isCollidable(ignoreClimbing);
    }

    @Override
    protected void E(Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            super.E(entity);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        this.z(false);
        return true;
    }

    public Variant gW() {
        return Variant.a(this.az.a(cB));
    }

    public void a(Variant variant) {
        this.az.a(cB, variant.k);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aB ? EntityParrot.c(component, this.gW()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aB);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aB) {
            this.a(EntityParrot.c(DataComponents.aB, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cB, Variant.f.k);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Variant", Variant.h, this.gW());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("Variant", Variant.h).orElse(Variant.f));
    }

    @Override
    public boolean gX() {
        return !this.aS();
    }

    @Override
    protected boolean gM() {
        return true;
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.5f * this.df(), this.dA() * 0.4f);
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "red_blue");
        public static final /* enum */ Variant b = new Variant(1, "blue");
        public static final /* enum */ Variant c = new Variant(2, "green");
        public static final /* enum */ Variant d = new Variant(3, "yellow_blue");
        public static final /* enum */ Variant e = new Variant(4, "gray");
        public static final Variant f;
        private static final IntFunction<Variant> j;
        public static final Codec<Variant> g;
        @Deprecated
        public static final Codec<Variant> h;
        public static final StreamCodec<ByteBuf, Variant> i;
        final int k;
        private final String l;
        private static final /* synthetic */ Variant[] m;

        public static Variant[] values() {
            return (Variant[])m.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name) {
            this.k = id;
            this.l = name;
        }

        public int a() {
            return this.k;
        }

        public static Variant a(int id) {
            return j.apply(id);
        }

        @Override
        public String c() {
            return this.l;
        }

        private static /* synthetic */ Variant[] b() {
            return new Variant[]{a, b, c, d, e};
        }

        static {
            m = Variant.b();
            f = a;
            j = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
            g = INamable.a(Variant::values);
            h = Codec.INT.xmap(j::apply, Variant::a);
            i = ByteBufCodecs.a(j, Variant::a);
        }
    }

    static class a
    extends PathfinderGoalRandomFly {
        public a(EntityCreature mob, double speedModifier) {
            super(mob, speedModifier);
        }

        @Override
        @Nullable
        protected Vec3D h() {
            Vec3D vec3 = null;
            if (this.b.bu()) {
                vec3 = LandRandomPos.a(this.b, 15, 15);
            }
            if (this.b.ek().i() >= this.j) {
                vec3 = this.k();
            }
            return vec3 == null ? super.h() : vec3;
        }

        @Nullable
        private Vec3D k() {
            BlockPosition blockPos = this.b.dF();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition mutableBlockPos1 = new BlockPosition.MutableBlockPosition();
            for (BlockPosition blockPos1 : BlockPosition.b(MathHelper.a(this.b.dK() - 3.0), MathHelper.a(this.b.dM() - 6.0), MathHelper.a(this.b.dQ() - 3.0), MathHelper.a(this.b.dK() + 3.0), MathHelper.a(this.b.dM() + 6.0), MathHelper.a(this.b.dQ() + 3.0))) {
                IBlockData blockState;
                boolean flag;
                if (blockPos.equals(blockPos1) || !(flag = (blockState = this.b.an().a_(mutableBlockPos1.a((BaseBlockPosition)blockPos1, EnumDirection.a))).b() instanceof BlockLeaves || blockState.a(TagsBlock.E)) || !this.b.an().w(blockPos1) || !this.b.an().w(mutableBlockPos.a((BaseBlockPosition)blockPos1, EnumDirection.b))) continue;
                return Vec3D.c(blockPos1);
            }
            return null;
        }
    }
}

