/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityPig
extends EntityAnimal
implements ISteerable {
    private static final DataWatcherObject<Integer> ct = DataWatcher.a(EntityPig.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<PigVariant>> cu = DataWatcher.a(EntityPig.class, DataWatcherRegistry.C);
    public final SaddleStorage cv;

    public EntityPig(EntityTypes<? extends EntityPig> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.cv = new SaddleStorage(this.az, ct);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.pigRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.pigRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.pigControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.pigMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.pigScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.pigBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.pigTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.pigAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(0, new HasRider(this));
        this.cq.a(1, new PathfinderGoalPanic(this, 1.25));
        this.cq.a(3, new PathfinderGoalBreed(this, 1.0));
        this.cq.a(4, new PathfinderGoalTempt(this, 1.2, itemStack -> itemStack.a(Items.pn), false));
        this.cq.a(4, new PathfinderGoalTempt(this, 1.2, itemStack -> itemStack.a(TagsItem.aY), false));
        this.cq.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.cq.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cq.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cq.a(8, new PathfinderGoalRandomLookaround(this));
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gN().a(GenericAttributes.t, 10.0).a(GenericAttributes.w, 0.25);
    }

    @Override
    @Nullable
    public EntityLiving dg() {
        EntityHuman player;
        Entity entity;
        return this.am() && (entity = this.dj()) instanceof EntityHuman && (player = (EntityHuman)entity).b(Items.pn) ? player : super.dg();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (ct.equals(key) && this.an().D_()) {
            this.cv.a();
        }
        super.a(key);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ct, 0);
        builder.a(cu, VariantUtils.a(this.ej(), PigVariants.d));
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        VariantUtils.a(output, this.n());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        VariantUtils.a(input, Registries.bi).ifPresent(this::b);
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.vt;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.vv;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.vu;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.vx, 0.15f, 1.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean isFood = this.i(player.b(hand));
        if (this.an().purpurConfig.pigGiveSaddleBack && player.gp() && !isFood && this.am() && !this.cm()) {
            this.a(EnumItemSlot.h, ItemStack.l);
            if (!player.gC().d) {
                ItemStack saddle = new ItemStack(Items.oR);
                if (!player.gB().g(saddle)) {
                    player.a(saddle, false);
                }
            }
            return EnumInteractionResult.a;
        }
        if (!isFood && this.am() && !this.cm() && !player.gp()) {
            if (!this.an().D_()) {
                player.o(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (!interactionResult.a()) {
            ItemStack itemInHand = player.b(hand);
            return this.a(itemInHand, EnumItemSlot.h) ? itemInHand.a(player, (EntityLiving)this, hand) : EnumInteractionResult.e;
        }
        return interactionResult;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.h ? super.e(slot) : this.bX() && !this.g_();
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.h || super.f(slot);
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return slot == EnumItemSlot.h ? SoundEffects.vw : super.a(slot, stack, equippable);
    }

    @Override
    public Vec3D b(EntityLiving livingEntity) {
        EnumDirection motionDirection = this.dc();
        if (motionDirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(livingEntity);
        }
        int[][] ints = DismountUtil.a(motionDirection);
        BlockPosition blockPos = this.dF();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (EntityPose pose : livingEntity.gd()) {
            AxisAlignedBB localBoundsForPose = livingEntity.f(pose);
            for (int[] ints1 : ints) {
                mutableBlockPos.d(blockPos.u() + ints1[0], blockPos.v(), blockPos.w() + ints1[1]);
                double blockFloorHeight = this.an().j(mutableBlockPos);
                if (!DismountUtil.a(blockFloorHeight)) continue;
                Vec3D vec3 = Vec3D.a(mutableBlockPos, blockFloorHeight);
                if (!DismountUtil.a(this.an(), livingEntity, localBoundsForPose.c(vec3))) continue;
                livingEntity.c(pose);
                return vec3;
            }
        }
        return super.b(livingEntity);
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        if (level.aq() != EnumDifficulty.a) {
            EntityPigZombie zombifiedPiglin = this.convertTo(EntityTypes.bW, ConversionParams.a(this, false, true), (T mob) -> {
                if (this.fq().f()) {
                    mob.a(EnumItemSlot.a, new ItemStack(Items.qC));
                }
                mob.gq();
            }, null, null);
            if (CraftEventFactory.callPigZapEvent(this, lightning, zombifiedPiglin).isCancelled()) {
                return;
            }
            level.addFreshEntity(zombifiedPiglin, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            if (zombifiedPiglin == null) {
                super.a(level, lightning);
            }
        } else {
            super.a(level, lightning);
        }
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        this.a(player.dX(), player.dZ() * 0.5f);
        this.bB = this.bD = this.dX();
        this.ab = this.bD;
        this.cv.b();
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float f(EntityHuman player) {
        return (float)(this.i(GenericAttributes.w) * 0.225 * (double)this.cv.c());
    }

    @Override
    public boolean a() {
        return this.cv.a(this.ek());
    }

    @Nullable
    public EntityPig b(WorldServer level, EntityAgeable partner) {
        EntityPig pig = EntityTypes.aV.a(level, EntitySpawnReason.e);
        if (pig != null && partner instanceof EntityPig) {
            EntityPig pig1 = (EntityPig)partner;
            pig.b(this.as.h() ? this.n() : pig1.n());
        }
        return pig;
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aY);
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.6f * this.df(), this.dA() * 0.4f);
    }

    public void b(Holder<PigVariant> variant) {
        this.az.a(cu, variant);
    }

    public Holder<PigVariant> n() {
        return this.az.a(cu);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aH ? EntityPig.c(component, this.n()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aH);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aH) {
            this.b(EntityPig.c(DataComponents.aH, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        VariantUtils.a(SpawnContext.a(level, this.dF()), Registries.bi).ifPresent(this::b);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }
}

