/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityPolarBear
extends EntityAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> ct = DataWatcher.a(EntityPolarBear.class, DataWatcherRegistry.k);
    private static final float cu = 6.0f;
    private float cv;
    private float cx;
    private int cy;
    private static final UniformInt cz = TimeRange.a(20, 39);
    private int cA;
    @Nullable
    private UUID cB;
    private int standTimer = 0;

    public EntityPolarBear(EntityTypes<? extends EntityPolarBear> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (other == this) {
            return false;
        }
        if (this.s()) {
            return false;
        }
        if (this.e() != null) {
            return false;
        }
        if (!(other instanceof EntityPolarBear)) {
            return false;
        }
        EntityPolarBear bear = (EntityPolarBear)other;
        if (bear.s()) {
            return false;
        }
        if (bear.e() != null) {
            return false;
        }
        return this.gS() && bear.gS();
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.polarBearRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.polarBearRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.polarBearControllable;
    }

    @Override
    public boolean onSpacebar() {
        if (!this.s() && this.getRider() != null && this.getRider().getForwardMot() == 0.0f && this.getRider().getStrafeMot() == 0.0f) {
            this.x(true);
            this.a(SoundEffects.wu, 1.0f, 1.0f);
        }
        return false;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.polarBearMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.polarBearScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.polarBearBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.polarBearTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.polarBearAlwaysDropExp;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.aZ.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean i(ItemStack stack) {
        return this.an().purpurConfig.polarBearBreedableItem != null && stack.h() == this.an().purpurConfig.polarBearBreedableItem;
    }

    @Override
    protected void H() {
        super.H();
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(0, new HasRider(this));
        this.cq.a(1, new c());
        this.cq.a(1, new PathfinderGoalPanic((EntityCreature)this, 2.0, mob -> mob.g_() ? DamageTypeTags.F : DamageTypeTags.G));
        if (this.an().purpurConfig.polarBearBreedableItem != null) {
            this.cq.a(2, new PathfinderGoalBreed(this, 1.0));
            this.cq.a(3, new PathfinderGoalTempt(this, 1.0, RecipeItemStack.a((IMaterial)this.an().purpurConfig.polarBearBreedableItem), false));
        }
        this.cq.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.cq.a(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.cq.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cq.a(7, new PathfinderGoalRandomLookaround(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new b());
        this.cr.a(2, new a());
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.cr.a(4, new PathfinderGoalNearestAttackableTarget<EntityFox>(this, EntityFox.class, 10, true, true, null));
        this.cr.a(5, new PathfinderGoalUniversalAngerReset<EntityPolarBear>(this, false));
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gN().a(GenericAttributes.t, 30.0).a(GenericAttributes.n, 20.0).a(GenericAttributes.w, 0.25).a(GenericAttributes.c, 6.0);
    }

    public static boolean c(EntityTypes<EntityPolarBear> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        Holder<BiomeBase> biome = level.v(pos);
        return !biome.a(BiomeTags.aq) ? EntityPolarBear.b(entityType, level, spawnReason, pos, random) : EntityPolarBear.a(level, pos) && level.a_(pos.e()).a(TagsBlock.cq);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(this.an(), input);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        this.a_(output);
    }

    @Override
    public void c() {
        this.a(cz.a(this.as));
    }

    @Override
    public void a(int time) {
        this.cA = time;
    }

    @Override
    public int a() {
        return this.cA;
    }

    @Override
    public void a(@Nullable UUID target) {
        this.cB = target;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cB;
    }

    @Override
    public SoundEffect p() {
        return this.g_() ? SoundEffects.wq : SoundEffects.wp;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.ws;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.wr;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.wt, 0.15f, 1.0f);
    }

    protected void n() {
        if (this.cy <= 0) {
            this.b(SoundEffects.wu);
            this.cy = 40;
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ct, false);
    }

    @Override
    public void g() {
        super.g();
        if (this.an().D_()) {
            if (this.cx != this.cv) {
                this.l_();
            }
            this.cv = this.cx;
            this.cx = this.s() ? MathHelper.a(this.cx + 1.0f, 0.0f, 6.0f) : MathHelper.a(this.cx - 1.0f, 0.0f, 6.0f);
        }
        if (this.cy > 0) {
            --this.cy;
        }
        if (!this.an().D_()) {
            this.a((WorldServer)this.an(), true);
        }
        if (this.s() && --this.standTimer <= 0) {
            this.x(false);
        }
    }

    @Override
    public EntitySize b(EntityPose pose) {
        if (this.cx > 0.0f) {
            float f2 = this.cx / 6.0f;
            float f1 = 1.0f + f2;
            return super.b(pose).a(1.0f, f1);
        }
        return super.b(pose);
    }

    public boolean s() {
        return this.az.a(ct);
    }

    public void x(boolean standing) {
        this.az.a(ct, standing);
        this.standTimer = standing ? 20 : -1;
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cv, this.cx) / 6.0f;
    }

    @Override
    protected float fz() {
        return 0.98f;
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(1.0f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    class c
    extends PathfinderGoalMeleeAttack {
        public c() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        protected void a(EntityLiving target) {
            if (this.b(target)) {
                this.h();
                this.a.c(net.minecraft.world.entity.animal.EntityPolarBear$c.a(this.a), (Entity)target);
                EntityPolarBear.this.x(false);
            } else if (this.a.g((Entity)target) < (double)((target.dA() + 3.0f) * (target.dA() + 3.0f))) {
                if (this.i()) {
                    EntityPolarBear.this.x(false);
                    this.h();
                }
                if (this.k() <= 10) {
                    EntityPolarBear.this.x(true);
                    EntityPolarBear.this.n();
                }
            } else {
                this.h();
                EntityPolarBear.this.x(false);
            }
        }

        @Override
        public void e() {
            EntityPolarBear.this.x(false);
            super.e();
        }
    }

    class b
    extends PathfinderGoalHurtByTarget {
        public b() {
            super(EntityPolarBear.this, new Class[0]);
        }

        @Override
        public void d() {
            super.d();
            if (EntityPolarBear.this.g_()) {
                this.h();
                this.e();
            }
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityPolarBear && !mob.g_()) {
                super.a(mob, target);
            }
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public a() {
            super(EntityPolarBear.this, EntityHuman.class, 20, true, true, null);
        }

        @Override
        public boolean b() {
            if (EntityPolarBear.this.g_()) {
                return false;
            }
            if (super.b()) {
                for (EntityPolarBear polarBear : EntityPolarBear.this.an().a(EntityPolarBear.class, EntityPolarBear.this.de().c(8.0, 4.0, 8.0))) {
                    if (!polarBear.g_()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected double l() {
            return super.l() * 0.5;
        }
    }
}

