/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.PufferFishStateChangeEvent;
import java.util.List;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.entity.PufferFish;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityPufferFish
extends EntityFish {
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityPufferFish.class, DataWatcherRegistry.b);
    int f;
    int ct;
    private static final PathfinderTargetCondition.a cu = (entity, level) -> {
        EntityHuman player;
        return (!(entity instanceof EntityHuman) || !(player = (EntityHuman)entity).gQ()) && !entity.ax().a(TagsEntity.A);
    };
    static final PathfinderTargetCondition cv = PathfinderTargetCondition.b().e().d().a(cu);
    public static final int a = 0;
    public static final int b = 1;
    public static final int c = 2;
    private static final int cw = 0;

    public EntityPufferFish(EntityTypes<? extends EntityPufferFish> type, World level) {
        super((EntityTypes<? extends EntityFish>)type, level);
        this.l_();
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.pufferfishRidable;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.pufferfishControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.pufferfishMaxHealth);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.pufferfishTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.pufferfishAlwaysDropExp;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(e, 0);
    }

    public int gJ() {
        return this.az.a(e);
    }

    public void b(int puffState) {
        this.az.a(e, puffState);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (e.equals(key)) {
            this.l_();
        }
        super.a(key);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("PuffState", this.gJ());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.b(Math.min(input.a("PuffState", 0), 2));
    }

    @Override
    public ItemStack a() {
        return new ItemStack(Items.sr);
    }

    @Override
    protected void H() {
        super.H();
        this.cq.a(1, new a(this));
    }

    @Override
    public void g() {
        if (!this.an().D_() && this.bX() && this.dt()) {
            if (this.f > 0) {
                boolean increase = true;
                if (this.gJ() == 0) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 1).callEvent()) {
                        this.b(SoundEffects.wJ);
                        this.b(1);
                    } else {
                        increase = false;
                    }
                } else if (this.f > 40 && this.gJ() == 1) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 2).callEvent()) {
                        this.b(SoundEffects.wJ);
                        this.b(2);
                    } else {
                        increase = false;
                    }
                }
                if (increase) {
                    ++this.f;
                }
            } else if (this.gJ() != 0) {
                boolean increase = true;
                if (this.ct > 60 && this.gJ() == 2) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 1).callEvent()) {
                        this.b(SoundEffects.wI);
                        this.b(1);
                    } else {
                        increase = false;
                    }
                } else if (this.ct > 100 && this.gJ() == 1) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 0).callEvent()) {
                        this.b(SoundEffects.wI);
                        this.b(0);
                    } else {
                        increase = false;
                    }
                }
                if (increase) {
                    ++this.ct;
                }
            }
        }
        super.g();
    }

    @Override
    public void e_() {
        super.e_();
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.bX() && this.gJ() > 0) {
                for (EntityInsentient mob : this.an().a(EntityInsentient.class, this.de().g(0.3), (? super T mob1) -> cv.a(serverLevel, this, (EntityLiving)mob1))) {
                    if (!mob.bX()) continue;
                    this.a(serverLevel, mob);
                }
            }
        }
    }

    private void a(WorldServer level, EntityInsentient mob) {
        int puffState = this.gJ();
        if (mob.a(level, this.ei().b(this), (float)(1 + puffState))) {
            mob.addEffect(new MobEffect(MobEffects.s, 60 * puffState, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
            this.a(SoundEffects.wN, 1.0f, 1.0f);
        }
    }

    @Override
    public void a_(EntityHuman entity) {
        int puffState = this.gJ();
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            if (puffState > 0 && entity.a(serverPlayer.A(), this.ei().b(this), (float)(1 + puffState))) {
                if (!this.bm()) {
                    serverPlayer.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.k, 0.0f));
                }
                entity.addEffect(new MobEffect(MobEffects.s, 60 * puffState, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.wK;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.wM;
    }

    @Override
    protected SoundEffect gI() {
        return SoundEffects.wL;
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return super.b(pose).a(EntityPufferFish.c(this.gJ()));
    }

    private static float c(int puffState) {
        switch (puffState) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.7f;
            }
        }
        return 1.0f;
    }

    static class a
    extends PathfinderGoal {
        private final EntityPufferFish a;

        public a(EntityPufferFish fish) {
            this.a = fish;
        }

        @Override
        public boolean b() {
            List<EntityLiving> entitiesOfClass = this.a.an().a(EntityLiving.class, this.a.de().g(2.0), entity -> cv.a(net.minecraft.world.entity.animal.EntityPufferFish$a.a(this.a), this.a, (EntityLiving)entity));
            return !entitiesOfClass.isEmpty();
        }

        @Override
        public void d() {
            this.a.f = 1;
            this.a.ct = 0;
        }

        @Override
        public void e() {
            this.a.f = 0;
        }
    }
}

