/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCarrots;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.purpurmc.purpur.controller.MoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityRabbit
extends EntityAnimal {
    public static final double ct = 0.6;
    public static final double cu = 0.8;
    public static final double cv = 1.0;
    public static final double cx = 2.2;
    public static final double cy = 1.4;
    private static final DataWatcherObject<Integer> cz = DataWatcher.a(EntityRabbit.class, DataWatcherRegistry.b);
    private static final int cA = 0;
    private static final MinecraftKey cB = MinecraftKey.b("killer_bunny");
    private static final int cC = 3;
    private static final int cD = 5;
    private static final MinecraftKey cE = MinecraftKey.b("evil");
    private static final int cF = 8;
    private static final int cG = 40;
    private int cH;
    private int cI;
    private boolean cJ;
    private int cK;
    public int cL = 0;
    private boolean actualJump;

    public EntityRabbit(EntityTypes<? extends EntityRabbit> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.co = new ControllerJumpRabbit(this);
        this.cn = new ControllerMoveRabbit(this);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.rabbitRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.rabbitRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.rabbitControllable;
    }

    @Override
    public boolean onSpacebar() {
        if (((Entity)this).bc) {
            this.actualJump = true;
            this.u();
            this.actualJump = false;
        }
        return true;
    }

    private void handleJumping() {
        if (((Entity)this).bc) {
            ControllerJumpRabbit jumpController = (ControllerJumpRabbit)this.co;
            if (!this.cJ) {
                this.t(false);
                jumpController.a(false);
            }
            if (!jumpController.c()) {
                if (this.cn.b()) {
                    this.m();
                }
            } else if (!jumpController.d()) {
                jumpController.a(true);
            }
        }
        this.cJ = ((Entity)this).bc;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.rabbitMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.rabbitScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.rabbitBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.rabbitTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.rabbitAlwaysDropExp;
    }

    @Override
    public void H() {
        this.cq.a(1, new PathfinderGoalFloat(this));
        this.cq.a(1, new HasRider(this));
        this.cq.a(1, new ClimbOnTopOfPowderSnowGoal(this, this.an()));
        this.cq.a(1, new PathfinderGoalRabbitPanic(this, 2.2));
        this.cq.a(2, new PathfinderGoalBreed(this, 0.8));
        this.cq.a(3, new PathfinderGoalTempt(this, 1.0, stack -> stack.a(TagsItem.aZ), false));
        this.cq.a(4, new PathfinderGoalRabbitAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 2.2, 2.2));
        this.cq.a(4, new PathfinderGoalRabbitAvoidTarget<EntityWolf>(this, EntityWolf.class, 10.0f, 2.2, 2.2));
        this.cq.a(4, new PathfinderGoalRabbitAvoidTarget<EntityMonster>(this, EntityMonster.class, 4.0f, 2.2, 2.2));
        this.cq.a(5, new PathfinderGoalEatCarrots(this));
        this.cq.a(6, new PathfinderGoalRandomStrollLand(this, 0.6));
        this.cq.a(11, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
    }

    @Override
    protected float fw() {
        PathEntity path;
        if (this.getRider() != null && this.isControllable()) {
            if (this.getForwardMot() < 0.0f) {
                this.B(this.getForwardMot() * 2.0f);
            }
            return this.actualJump ? 0.5f : 0.3f;
        }
        float f2 = 0.3f;
        if (this.cn.c() <= 0.6) {
            f2 = 0.2f;
        }
        if ((path = this.cp.j()) != null && !path.c()) {
            Vec3D nextEntityPos = path.a(this);
            if (nextEntityPos.h > this.dM() + 0.5) {
                f2 = 0.5f;
            }
        }
        if (this.ad || this.bL && this.cn.e() > this.dM() + 0.5) {
            f2 = 0.5f;
        }
        return super.z(f2 / 0.42f);
    }

    @Override
    public void u() {
        double d2;
        super.u();
        double speedModifier = this.cn.c();
        if (speedModifier > 0.0 && (d2 = this.dI().j()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
        if (!this.an().D_()) {
            this.an().a((Entity)this, (byte)1);
        }
    }

    public float J(float partialTick) {
        return this.cI == 0 ? 0.0f : ((float)this.cH + partialTick) / (float)this.cI;
    }

    public void j(double speedModifier) {
        this.S().a(speedModifier);
        this.cn.a(this.cn.d(), this.cn.e(), this.cn.f(), speedModifier);
    }

    @Override
    public void t(boolean jumping) {
        super.t(jumping);
        if (jumping) {
            this.a(this.s(), this.ft(), ((this.as.i() - this.as.i()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void m() {
        this.t(true);
        this.cI = 10;
        this.cH = 0;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cz, Variant.h.m);
    }

    @Override
    public void a(WorldServer level) {
        if (this.getRider() != null && this.isControllable()) {
            this.handleJumping();
            return;
        }
        if (this.cK > 0) {
            --this.cK;
        }
        if (this.cL > 0) {
            this.cL -= this.as.a(3);
            if (this.cL < 0) {
                this.cL = 0;
            }
        }
        if (this.aS()) {
            ControllerJumpRabbit rabbitJumpControl;
            EntityLiving target;
            if (!this.cJ) {
                this.t(false);
                this.gM();
            }
            if (this.gI() == Variant.g && this.cK == 0 && (target = this.e()) != null && this.g((Entity)target) < 16.0) {
                this.c(target.dK(), target.dQ());
                this.cn.a(target.dK(), target.dM(), target.dQ(), this.cn.c());
                this.m();
                this.cJ = true;
            }
            if (!(rabbitJumpControl = (ControllerJumpRabbit)this.co).c()) {
                if (this.cn.b() && this.cK == 0) {
                    PathEntity path = this.cp.j();
                    Vec3D vec3 = new Vec3D(this.cn.d(), this.cn.e(), this.cn.f());
                    if (path != null && !path.c()) {
                        vec3 = path.a(this);
                    }
                    this.c(vec3.g, vec3.i);
                    this.m();
                }
            } else if (!rabbitJumpControl.d()) {
                this.gJ();
            }
        }
        this.cJ = this.aS();
    }

    @Override
    public boolean bH() {
        return false;
    }

    private void c(double x2, double z2) {
        this.v((float)(MathHelper.d(z2 - this.dQ(), x2 - this.dK()) * 180.0 / 3.1415927410125732) - 90.0f);
    }

    private void gJ() {
        ((ControllerJumpRabbit)this.co).a(true);
    }

    private void gK() {
        ((ControllerJumpRabbit)this.co).a(false);
    }

    private void gL() {
        this.cK = this.cn.c() < 2.2 ? 10 : 1;
    }

    private void gM() {
        this.gL();
        this.gK();
    }

    @Override
    public void e_() {
        super.e_();
        if (this.cH != this.cI) {
            ++this.cH;
        } else if (this.cI != 0) {
            this.cH = 0;
            this.cI = 0;
            this.t(false);
        }
    }

    public static AttributeProvider.Builder n() {
        return EntityAnimal.gN().a(GenericAttributes.t, 3.0).a(GenericAttributes.w, 0.3f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("RabbitType", Variant.j, this.gI());
        output.a("MoreCarrotTicks", this.cL);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("RabbitType", Variant.j).orElse(Variant.h));
        this.cL = input.a("MoreCarrotTicks", 0);
    }

    protected SoundEffect s() {
        return SoundEffects.wT;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.wP;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.wS;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.wR;
    }

    @Override
    public void gB() {
        if (this.gI() == Variant.g) {
            this.a(SoundEffects.wQ, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 1.0f);
        }
    }

    @Override
    public SoundCategory dw() {
        return this.gI() == Variant.g ? SoundCategory.f : SoundCategory.g;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public EntityRabbit b(WorldServer level, EntityAgeable partner) {
        block2: {
            block3: {
                rabbit = EntityTypes.bd.a(level, EntitySpawnReason.e);
                if (rabbit == null) break block2;
                randomRabbitVariant = EntityRabbit.a((GeneratorAccess)level, this.dF());
                if (this.as.a(20) == 0) break block3;
                if (!(partner instanceof EntityRabbit)) ** GOTO lbl-1000
                rabbit1 = (EntityRabbit)partner;
                if (this.as.h()) {
                    randomRabbitVariant = rabbit1.gI();
                } else lbl-1000:
                // 2 sources

                {
                    randomRabbitVariant = this.gI();
                }
            }
            rabbit.a(randomRabbitVariant);
        }
        return rabbit;
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aZ);
    }

    public Variant gI() {
        return Variant.a(this.az.a(cz));
    }

    public void a(Variant variant) {
        if (variant == Variant.g) {
            this.h(GenericAttributes.a).a(8.0);
            this.cq.a(4, new PathfinderGoalMeleeAttack(this, 1.4, true));
            this.cr.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
            this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
            this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityWolf>((EntityInsentient)this, EntityWolf.class, true));
            this.h(GenericAttributes.c).a(new AttributeModifier(cE, 5.0, AttributeModifier.Operation.a));
            if (!this.k_()) {
                this.b(IChatBaseComponent.c(SystemUtils.a("entity", cB)));
            }
        } else {
            this.h(GenericAttributes.c).c(cE);
        }
        this.az.a(cz, variant.m);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aG ? EntityRabbit.c(component, this.gI()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aG);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aG) {
            this.a(EntityRabbit.c(DataComponents.aG, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        Variant randomRabbitVariant = EntityRabbit.a(level, this.dF());
        if (spawnGroupData instanceof GroupDataRabbit) {
            randomRabbitVariant = ((GroupDataRabbit)spawnGroupData).a;
        } else {
            spawnGroupData = new GroupDataRabbit(randomRabbitVariant);
        }
        this.a(randomRabbitVariant);
        if (randomRabbitVariant != Variant.g && level.a().purpurConfig.rabbitNaturalToast > 0.0 && this.as.j() <= level.a().purpurConfig.rabbitNaturalToast) {
            this.b(IChatBaseComponent.c("Toast"));
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private static Variant a(GeneratorAccess level, BlockPosition pos) {
        WorldServer world = level.getMinecraftWorld();
        if (world.purpurConfig.rabbitNaturalKiller > 0.0 && world.I_().j() <= world.purpurConfig.rabbitNaturalKiller) {
            return Variant.g;
        }
        Holder<BiomeBase> biome = level.v(pos);
        int randomInt = level.I_().a(100);
        if (biome.a(BiomeTags.an)) {
            return randomInt < 80 ? Variant.b : Variant.d;
        }
        if (biome.a(BiomeTags.am)) {
            return Variant.e;
        }
        return randomInt < 50 ? Variant.a : (randomInt < 90 ? Variant.f : Variant.c);
    }

    public static boolean c(EntityTypes<EntityRabbit> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cr) && EntityRabbit.a(level, pos);
    }

    boolean gU() {
        return this.cL <= 0;
    }

    @Override
    public void b(byte id) {
        if (id == 1) {
            this.bI();
            this.cI = 10;
            this.cH = 0;
        } else {
            super.b(id);
        }
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.6f * this.df(), this.dA() * 0.4f);
    }

    public static class ControllerJumpRabbit
    extends ControllerJump {
        private final EntityRabbit b;
        private boolean c;

        public ControllerJumpRabbit(EntityRabbit mob) {
            super(mob);
            this.b = mob;
        }

        public boolean c() {
            return this.a;
        }

        public boolean d() {
            return this.c;
        }

        public void a(boolean canJump) {
            this.c = canJump;
        }

        @Override
        public void b() {
            if (this.a) {
                this.b.m();
                this.a = false;
            }
        }
    }

    static class ControllerMoveRabbit
    extends MoveControllerWASD {
        private final EntityRabbit l;
        private double m;

        public ControllerMoveRabbit(EntityRabbit mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void vanillaTick() {
            if (this.l.aS() && !this.l.bL && !((ControllerJumpRabbit)this.l.co).c()) {
                this.l.j(0.0);
            } else if (this.b() || this.k == ControllerMove.Operation.d) {
                this.l.j(this.m);
            }
            super.vanillaTick();
        }

        @Override
        public void a(double x2, double y2, double z2, double speedModifier) {
            if (this.l.bu()) {
                speedModifier = 1.5;
            }
            super.a(x2, y2, z2, speedModifier);
            if (speedModifier > 0.0) {
                this.m = speedModifier;
            }
        }
    }

    static class PathfinderGoalRabbitPanic
    extends PathfinderGoalPanic {
        private final EntityRabbit a;

        public PathfinderGoalRabbitPanic(EntityRabbit rabbit, double speedModifier) {
            super(rabbit, speedModifier);
            this.a = rabbit;
        }

        @Override
        public void a() {
            super.a();
            this.a.j(this.d);
        }
    }

    static class PathfinderGoalRabbitAvoidTarget<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityRabbit i;

        public PathfinderGoalRabbitAvoidTarget(EntityRabbit rabbit, Class<T> avoidClass, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(rabbit, avoidClass, maxDist, walkSpeedModifier, sprintSpeedModifier);
            this.i = rabbit;
        }

        @Override
        public boolean b() {
            return this.i.gI() != Variant.g && super.b();
        }
    }

    static class PathfinderGoalEatCarrots
    extends PathfinderGoalGotoTarget {
        private final EntityRabbit g;
        private boolean h;
        private boolean i;

        public PathfinderGoalEatCarrots(EntityRabbit rabbit) {
            super(rabbit, 0.7f, 16);
            this.g = rabbit;
        }

        @Override
        public boolean b() {
            if (this.c <= 0) {
                if (!PathfinderGoalEatCarrots.a(this.g).S().getBoolean(GameRules.d, PathfinderGoalEatCarrots.a((Entity)this.g).purpurConfig.rabbitMobGriefingOverride)) {
                    return false;
                }
                this.i = false;
                this.h = this.g.gU();
            }
            return super.b();
        }

        @Override
        public boolean c() {
            return this.i && super.c();
        }

        @Override
        public void a() {
            super.a();
            this.g.P().a((double)this.e.u() + 0.5, this.e.v() + 1, (double)this.e.w() + 0.5, 10.0f, this.g.af());
            if (this.m()) {
                World level = this.g.an();
                BlockPosition blockPos = this.e.d();
                IBlockData blockState = level.a_(blockPos);
                Block block = blockState.b();
                if (this.i && block instanceof BlockCarrots) {
                    int ageValue = blockState.c(BlockCrops.f);
                    if (ageValue == 0) {
                        if (!CraftEventFactory.callEntityChangeBlockEvent(this.g, blockPos, blockState.y().g())) {
                            return;
                        }
                        level.a(blockPos, Blocks.a.m(), 2);
                        level.a(blockPos, true, this.g);
                    } else {
                        if (!CraftEventFactory.callEntityChangeBlockEvent(this.g, blockPos, (IBlockData)blockState.b(BlockCrops.f, ageValue - 1))) {
                            return;
                        }
                        level.a(blockPos, (IBlockData)blockState.b(BlockCrops.f, ageValue - 1), 2);
                        level.a(GameEvent.c, blockPos, GameEvent.a.a(this.g));
                        level.c(2001, blockPos, Block.j(blockState));
                    }
                    this.g.cL = 40;
                }
                this.i = false;
                this.c = 10;
            }
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            IBlockData blockState = level.a_(pos);
            if (blockState.a(Blocks.cZ) && this.h && !this.i && (blockState = level.a_(pos.d())).b() instanceof BlockCarrots && ((BlockCarrots)blockState.b()).n(blockState)) {
                this.i = true;
                return true;
            }
            return false;
        }
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "brown");
        public static final /* enum */ Variant b = new Variant(1, "white");
        public static final /* enum */ Variant c = new Variant(2, "black");
        public static final /* enum */ Variant d = new Variant(3, "white_splotched");
        public static final /* enum */ Variant e = new Variant(4, "gold");
        public static final /* enum */ Variant f = new Variant(5, "salt");
        public static final /* enum */ Variant g = new Variant(99, "evil");
        public static final Variant h;
        private static final IntFunction<Variant> l;
        public static final Codec<Variant> i;
        @Deprecated
        public static final Codec<Variant> j;
        public static final StreamCodec<ByteBuf, Variant> k;
        final int m;
        private final String n;
        private static final /* synthetic */ Variant[] o;

        public static Variant[] values() {
            return (Variant[])o.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name) {
            this.m = id;
            this.n = name;
        }

        @Override
        public String c() {
            return this.n;
        }

        public int a() {
            return this.m;
        }

        public static Variant a(int id) {
            return l.apply(id);
        }

        private static /* synthetic */ Variant[] b() {
            return new Variant[]{a, b, c, d, e, f, g};
        }

        static {
            o = Variant.b();
            h = a;
            l = ByIdMap.a(Variant::a, Variant.values(), h);
            i = INamable.a(Variant::values);
            j = Codec.INT.xmap(l::apply, Variant::a);
            k = ByteBufCodecs.a(l, Variant::a);
        }
    }

    public static class GroupDataRabbit
    extends EntityAgeable.a {
        public final Variant a;

        public GroupDataRabbit(Variant variant) {
            super(1.0f);
            this.a = variant;
        }
    }
}

