/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.util.Vector;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntitySquid
extends AgeableWaterCreature {
    public float ct;
    public float cu;
    public float cv;
    public float cw;
    public float cx;
    public float cy;
    public float cz;
    public float cA;
    private float cB;
    private float cC;
    private float cD;
    Vec3D cE = Vec3D.c;

    public EntitySquid(EntityTypes<? extends EntitySquid> type, World level) {
        super((EntityTypes<? extends AgeableWaterCreature>)type, level);
        if (!level.purpurConfig.entitySharedRandom) {
            this.as.b((long)this.az());
        }
        this.cC = 1.0f / (this.as.i() + 1.0f) * 0.2f;
    }

    @Override
    public AxisAlignedBB getAxisForFluidCheck() {
        return super.getAxisForFluidCheck().offsetY(this.an().purpurConfig.squidOffsetWaterCheck);
    }

    public boolean canFly() {
        return this.an().purpurConfig.squidsCanFly;
    }

    @Override
    public boolean bu() {
        return this.au || this.canFly();
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.squidRidable;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.squidControllable;
    }

    protected static void rotateVectorAroundY(Vector vector, double degrees) {
        double rad = Math.toRadians(degrees);
        double cos = Math.cos(rad);
        double sine = Math.sin(rad);
        double x2 = vector.getX();
        double z2 = vector.getZ();
        vector.setX(cos * x2 - sine * z2);
        vector.setZ(sine * x2 + cos * z2);
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.squidMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.squidScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.squidTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.squidAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cq.a(0, new PathfinderGoalSquid(this));
        this.cq.a(0, new HasRider(this));
        this.cq.a(1, new a());
    }

    public static AttributeProvider.Builder gI() {
        return EntityInsentient.I().a(GenericAttributes.t, 10.0);
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.Bs;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.Bu;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.Bt;
    }

    protected SoundEffect n() {
        return SoundEffects.Bv;
    }

    @Override
    public boolean v() {
        return true;
    }

    @Override
    public float ft() {
        return 0.4f;
    }

    @Override
    protected Entity.MovementEmission br() {
        return Entity.MovementEmission.c;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.bw.a(level, EntitySpawnReason.e);
    }

    @Override
    protected double bo() {
        return 0.08;
    }

    @Override
    public void e_() {
        super.e_();
        this.cu = this.ct;
        this.cw = this.cv;
        this.cy = this.cx;
        this.cA = this.cz;
        this.cx += this.cC;
        if ((double)this.cx > Math.PI * 2) {
            if (this.an().D_()) {
                this.cx = (float)Math.PI * 2;
            } else {
                this.cx -= (float)Math.PI * 2;
                if (this.as.a(10) == 0) {
                    this.cC = 1.0f / (this.as.i() + 1.0f) * 0.2f;
                }
                this.an().a((Entity)this, (byte)19);
            }
        }
        if (this.bu()) {
            if (this.canFly()) {
                this.g(!this.au);
            }
            if (this.cx < (float)Math.PI) {
                float f2 = this.cx / (float)Math.PI;
                this.cz = MathHelper.a(f2 * f2 * (float)Math.PI) * (float)Math.PI * 0.25f;
                if ((double)f2 > 0.75) {
                    if (this.dq()) {
                        this.k(this.cE);
                    }
                    this.cD = 1.0f;
                } else {
                    this.cD *= 0.8f;
                }
            } else {
                this.cz = 0.0f;
                if (this.dq()) {
                    this.k(this.dI().c(0.9));
                }
                this.cD *= 0.99f;
            }
            Vec3D deltaMovement = this.dI();
            double d2 = deltaMovement.i();
            this.bB += (-((float)MathHelper.d(deltaMovement.g, deltaMovement.i)) * 57.295776f - this.bB) * 0.1f;
            this.v(this.bB);
            this.cv += (float)Math.PI * this.cD * 1.5f;
            this.ct += (-((float)MathHelper.d(d2, deltaMovement.h)) * 57.295776f - this.ct) * 0.1f;
        } else {
            this.cz = MathHelper.e(MathHelper.a(this.cx)) * (float)Math.PI * 0.25f;
            if (!this.an().D_()) {
                double d1 = this.dI().h;
                d1 = this.d(MobEffects.y) ? 0.05 * (double)(this.e(MobEffects.y).e() + 1) : (d1 -= this.bp());
                this.m(0.0, d1 * (double)0.98f, 0.0);
            }
            this.ct += (-90.0f - this.ct) * 0.02f;
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (super.a(level, damageSource, amount) && this.eF() != null) {
            this.s();
            return true;
        }
        return false;
    }

    private Vec3D o(Vec3D vector) {
        Vec3D vec3 = vector.a(this.cu * ((float)Math.PI / 180));
        return vec3.b(-this.bC * ((float)Math.PI / 180));
    }

    private void s() {
        this.b(this.n());
        Vec3D vec3 = this.o(new Vec3D(0.0, -1.0, 0.0)).b(this.dK(), this.dM(), this.dQ());
        for (int i2 = 0; i2 < 30; ++i2) {
            Vec3D vec31 = this.o(new Vec3D((double)this.as.i() * 0.6 - 0.3, -1.0, (double)this.as.i() * 0.6 - 0.3));
            float f2 = this.g_() ? 0.1f : 0.3f;
            Vec3D vec32 = vec31.c((double)(f2 + this.as.i() * 2.0f));
            ((WorldServer)this.an()).a(this.m(), vec3.g, vec3.h + 0.5, vec3.i, 0, vec32.g, vec32.h, vec32.i, (double)0.1f);
        }
    }

    protected ParticleParam m() {
        return Particles.am;
    }

    @Override
    public void m(Vec3D travelVector) {
        this.a(EnumMoveType.a, this.dI());
    }

    @Override
    public void b(byte id) {
        if (id == 19) {
            this.cx = 0.0f;
        } else {
            super.b(id);
        }
    }

    public boolean gJ() {
        return this.cE.h() > (double)1.0E-5f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        GroupDataEntity spawnGroupData1 = Objects.requireNonNullElseGet(spawnGroupData, () -> new EntityAgeable.a(0.05f));
        return super.a(level, difficulty, spawnReason, spawnGroupData1);
    }

    static class PathfinderGoalSquid
    extends PathfinderGoal {
        private final EntitySquid a;

        public PathfinderGoalSquid(EntitySquid squid) {
            this.a = squid;
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public void a() {
            EntityHuman rider = this.a.getRider();
            if (rider != null && this.a.isControllable()) {
                if (rider.bL) {
                    this.a.onSpacebar();
                }
                float forward = rider.getForwardMot();
                float strafe = rider.getStrafeMot();
                float speed = (float)this.a.i(GenericAttributes.w) * 10.0f;
                if (forward < 0.0f) {
                    speed = (float)((double)speed * -0.5);
                }
                Vector dir = rider.getBukkitEntity().getEyeLocation().getDirection().normalize().multiply(speed / 20.0f);
                if (strafe != 0.0f) {
                    if (forward == 0.0f) {
                        dir.setY(0);
                        EntitySquid.rotateVectorAroundY(dir, strafe > 0.0f ? -90.0 : 90.0);
                    } else if (forward < 0.0f) {
                        EntitySquid.rotateVectorAroundY(dir, strafe > 0.0f ? 45.0 : -45.0);
                    } else {
                        EntitySquid.rotateVectorAroundY(dir, strafe > 0.0f ? -45.0 : 45.0);
                    }
                }
                this.a.cE = forward != 0.0f || strafe != 0.0f ? new Vec3D((float)dir.getX(), (float)dir.getY(), (float)dir.getZ()) : Vec3D.c;
                return;
            }
            int noActionTime = this.a.eK();
            if (noActionTime > 100) {
                this.a.cE = Vec3D.c;
            } else if (this.a.ek().a(PathfinderGoalSquid.b(50)) == 0 || !this.a.bu() || !this.a.gJ()) {
                float f2 = this.a.ek().i() * ((float)Math.PI * 2);
                this.a.cE = new Vec3D(MathHelper.b(f2) * 0.2f, -0.1f + this.a.ek().i() * 0.2f, MathHelper.a(f2) * 0.2f);
            }
        }
    }

    class a
    extends PathfinderGoal {
        private static final float b = 3.0f;
        private static final float c = 5.0f;
        private static final float d = 10.0f;
        private int e;

        a() {
        }

        @Override
        public boolean b() {
            EntityLiving lastHurtByMob = EntitySquid.this.eF();
            return EntitySquid.this.bu() && lastHurtByMob != null && EntitySquid.this.g((Entity)lastHurtByMob) < 100.0;
        }

        @Override
        public void d() {
            this.e = 0;
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            ++this.e;
            EntityLiving lastHurtByMob = EntitySquid.this.eF();
            if (lastHurtByMob != null) {
                Vec3D vec3 = new Vec3D(EntitySquid.this.dK() - lastHurtByMob.dK(), EntitySquid.this.dM() - lastHurtByMob.dM(), EntitySquid.this.dQ() - lastHurtByMob.dQ());
                IBlockData blockState = EntitySquid.this.an().a_(BlockPosition.a(EntitySquid.this.dK() + vec3.g, EntitySquid.this.dM() + vec3.h, EntitySquid.this.dQ() + vec3.i));
                Fluid fluidState = EntitySquid.this.an().b_(BlockPosition.a(EntitySquid.this.dK() + vec3.g, EntitySquid.this.dM() + vec3.h, EntitySquid.this.dQ() + vec3.i));
                if (fluidState.a(TagsFluid.a) || blockState.l()) {
                    double len = vec3.g();
                    if (len > 0.0) {
                        vec3.d();
                        double d2 = 3.0;
                        if (len > 5.0) {
                            d2 -= (len - 5.0) / 5.0;
                        }
                        if (d2 > 0.0) {
                            vec3 = vec3.c(d2);
                        }
                    }
                    if (blockState.l()) {
                        vec3 = vec3.a(0.0, vec3.h, 0.0);
                    }
                    EntitySquid.this.cE = new Vec3D(vec3.g / 20.0, vec3.h / 20.0, vec3.i / 20.0);
                }
                if (this.e % 10 == 5) {
                    EntitySquid.this.an().a(Particles.d, EntitySquid.this.dK(), EntitySquid.this.dM(), EntitySquid.this.dQ(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

