/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.destroystokyo.paper.event.entity.TurtleGoHomeEvent;
import com.destroystokyo.paper.event.entity.TurtleLayEggEvent;
import com.destroystokyo.paper.event.entity.TurtleStartDiggingEvent;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTurtleEgg;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Turtle;
import org.purpurmc.purpur.controller.MoveControllerWASD;
import org.purpurmc.purpur.controller.WaterMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityTurtle
extends EntityAnimal {
    private static final DataWatcherObject<Boolean> cu = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cv = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final float cx = 0.3f;
    private static final EntitySize cy = EntityTypes.bG.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bG.m(), -0.25f)).a(0.3f);
    private static final boolean cz = false;
    int cA;
    public static final PathfinderTargetCondition.a ct = (entity, level) -> entity.g_() && !entity.bu();
    public BlockPosition cB = BlockPosition.c;
    @Nullable
    BlockPosition cC;
    public boolean cD;

    public EntityTurtle(EntityTypes<? extends EntityTurtle> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.a(PathType.j, 0.0f);
        this.a(PathType.t, -1.0f);
        this.a(PathType.s, -1.0f);
        this.a(PathType.r, -1.0f);
        this.cn = new e(this);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.turtleRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.turtleRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.turtleControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.turtleMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.turtleScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.turtleBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.turtleTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.turtleAlwaysDropExp;
    }

    public void h(BlockPosition homePos) {
        this.cB = homePos;
    }

    public boolean m() {
        return this.az.a(cu);
    }

    public void x(boolean hasEgg) {
        this.az.a(cu, hasEgg);
    }

    public boolean n() {
        return this.az.a(cv);
    }

    void y(boolean isLayingEgg) {
        this.cA = isLayingEgg ? 1 : 0;
        this.az.a(cv, isLayingEgg);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cu, false);
        builder.a(cv, false);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("home_pos", BlockPosition.a, this.cB);
        output.a("has_egg", this.m());
    }

    @Override
    protected void a(ValueInput input) {
        this.h(input.a("home_pos", BlockPosition.a).orElse(this.dF()));
        super.a(input);
        this.x(input.a("has_egg", false));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.h(this.dF());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static boolean c(EntityTypes<EntityTurtle> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return pos.v() < level.T() + 4 && BlockTurtleEgg.a(level, pos) && EntityTurtle.a(level, pos);
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        this.cq.a(0, new f(this, 1.2));
        this.cq.a(1, new a(this, 1.0));
        this.cq.a(1, new d(this, 1.0));
        this.cq.a(2, new PathfinderGoalTempt(this, 1.1, itemStack -> itemStack.a(TagsItem.bc), false));
        this.cq.a(3, new c(this, 1.0));
        this.cq.a(4, new b(this, 1.0));
        this.cq.a(7, new i(this, 1.0));
        this.cq.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(9, new h(this, 1.0, 100));
    }

    public static AttributeProvider.Builder s() {
        return EntityAnimal.gN().a(GenericAttributes.t, 30.0).a(GenericAttributes.w, 0.25).a(GenericAttributes.C, 1.0);
    }

    @Override
    public boolean cW() {
        return false;
    }

    @Override
    public int W() {
        return 200;
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return !this.bu() && this.aS() && !this.g_() ? SoundEffects.Cy : super.p();
    }

    @Override
    protected void g(float volume) {
        super.g(volume * 1.5f);
    }

    @Override
    public SoundEffect bg() {
        return SoundEffects.CJ;
    }

    @Override
    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return this.g_() ? SoundEffects.CF : SoundEffects.CE;
    }

    @Override
    @Nullable
    public SoundEffect f_() {
        return this.g_() ? SoundEffects.CA : SoundEffects.Cz;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        SoundEffect soundEvent = this.g_() ? SoundEffects.CI : SoundEffects.CH;
        this.a(soundEvent, 0.15f, 1.0f);
    }

    @Override
    public boolean gP() {
        return super.gP() && !this.m();
    }

    @Override
    protected float bf() {
        return this.al + 0.15f;
    }

    @Override
    public float ez() {
        return this.g_() ? 0.3f : 1.0f;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new g(this, level);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.bG.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.bc);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (!this.cD && level.b_(pos).a(TagsFluid.a)) {
            return 10.0f;
        }
        return BlockTurtleEgg.a(level, pos) ? 10.0f : level.y(pos);
    }

    @Override
    public void e_() {
        super.e_();
        if (this.bX() && this.n() && this.cA >= 1 && this.cA % 5 == 0) {
            BlockPosition blockPos = this.dF();
            if (BlockTurtleEgg.a(this.an(), blockPos)) {
                this.an().c(2001, blockPos, Block.j(this.an().a_(blockPos.e())));
                this.c(GameEvent.u);
            }
        }
    }

    @Override
    protected void h() {
        WorldServer serverLevel;
        World world;
        super.h();
        if (!this.g_() && (world = this.an()) instanceof WorldServer && (serverLevel = (WorldServer)world).S().c(GameRules.g)) {
            this.forceDrops = true;
            this.a(serverLevel, LootTables.aK, this::a);
            this.forceDrops = false;
        }
    }

    @Override
    public void m(Vec3D travelVector) {
        if (this.bu()) {
            this.a(0.1f, travelVector);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c(0.9));
            if (!(this.e() != null || this.cD && this.cB.a(this.dD(), 20.0))) {
                this.k(this.dI().b(0.0, -0.005, 0.0));
            }
        } else {
            super.m(travelVector);
        }
    }

    @Override
    public boolean v() {
        return false;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        this.a(level, this.ei().c().eventEntityDamager(lightning), Float.MAX_VALUE);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.g_() ? cy : super.b(pose);
    }

    static class e
    extends MoveControllerWASD {
        private final EntityTurtle l;
        private final WaterMoveControllerWASD waterController;

        e(EntityTurtle mob) {
            super(mob);
            this.l = mob;
            this.waterController = new WaterMoveControllerWASD(this.l, 0.25);
        }

        private void h() {
            if (this.l.bu()) {
                this.l.k(this.l.dI().b(0.0, 0.005, 0.0));
                if (!this.l.cB.a(this.l.dD(), 16.0)) {
                    this.l.B(Math.max(this.l.fD() / 2.0f, 0.08f));
                }
                if (this.l.g_()) {
                    this.l.B(Math.max(this.l.fD() / 3.0f, 0.06f));
                }
            } else if (this.l.aS()) {
                this.l.B(Math.max(this.l.fD() / 2.0f, 0.06f));
            }
        }

        @Override
        public void vanillaTick() {
            this.h();
            if (this.k == ControllerMove.Operation.b && !this.l.S().l()) {
                double d2;
                double d1;
                double d3 = this.e - this.l.dK();
                double squareRoot = Math.sqrt(d3 * d3 + (d1 = this.f - this.l.dM()) * d1 + (d2 = this.g - this.l.dQ()) * d2);
                if (squareRoot < (double)1.0E-5f) {
                    this.d.B(0.0f);
                } else {
                    d1 /= squareRoot;
                    float f2 = (float)(MathHelper.d(d2, d3) * 180.0 / 3.1415927410125732) - 90.0f;
                    this.l.v(this.b(this.l.dX(), f2, 90.0f));
                    this.l.bB = this.l.dX();
                    float f1 = (float)(this.c() * this.l.i(GenericAttributes.w));
                    this.l.B(MathHelper.h(0.125f, this.l.fD(), f1));
                    this.l.k(this.l.dI().b(0.0, (double)this.l.fD() * d1 * 0.1, 0.0));
                }
            } else {
                this.l.B(0.0f);
            }
        }
    }

    static class f
    extends PathfinderGoalPanic {
        f(EntityTurtle turtle, double speedModifier) {
            super(turtle, speedModifier);
        }

        @Override
        public boolean b() {
            if (!this.h()) {
                return false;
            }
            BlockPosition blockPos = this.a(this.c.an(), this.c, 7);
            if (blockPos != null) {
                this.e = blockPos.u();
                this.f = blockPos.v();
                this.g = blockPos.w();
                return true;
            }
            return this.i();
        }
    }

    static class a
    extends PathfinderGoalBreed {
        private final EntityTurtle d;

        a(EntityTurtle turtle, double speedModifier) {
            super(turtle, speedModifier);
            this.d = turtle;
        }

        @Override
        public boolean b() {
            return super.b() && !this.d.m();
        }

        @Override
        protected void g() {
            EntityFertilizeEggEvent event;
            EntityPlayer loveCause = this.a.gR();
            if (loveCause == null && this.c.gR() != null) {
                loveCause = this.c.gR();
            }
            if ((event = CraftEventFactory.callEntityFertilizeEggEvent(this.a, this.c)).isCancelled()) {
                return;
            }
            if (loveCause != null) {
                loveCause.a(StatisticList.Q);
                CriterionTriggers.p.a(loveCause, this.a, this.c, null);
            }
            this.d.x(true);
            this.a.c_(this.a.getPurpurBreedTime());
            this.c.c_(this.c.getPurpurBreedTime());
            this.a.gT();
            this.c.gT();
            RandomSource random = this.a.ek();
            if (net.minecraft.world.entity.animal.EntityTurtle$a.a(this.b).S().c(GameRules.g) && event.getExperience() > 0) {
                this.b.b(new EntityExperienceOrb(this.b, this.a.dD(), Vec3D.c, event.getExperience(), ExperienceOrb.SpawnReason.BREED, loveCause, this.d));
            }
        }
    }

    static class d
    extends PathfinderGoalGotoTarget {
        private final EntityTurtle g;

        d(EntityTurtle turtle, double speedModifier) {
            super(turtle, speedModifier, 16);
            this.g = turtle;
        }

        @Override
        public boolean b() {
            return this.g.m() && this.g.cB.a(this.g.dD(), 9.0) && super.b();
        }

        @Override
        public boolean c() {
            return super.c() && this.g.m() && this.g.cB.a(this.g.dD(), 9.0);
        }

        @Override
        public void a() {
            super.a();
            BlockPosition blockPos = this.g.dF();
            if (!this.g.bu() && this.m()) {
                if (this.g.cA < 1) {
                    this.g.y(new TurtleStartDiggingEvent((Turtle)this.g.getBukkitEntity(), CraftLocation.toBukkit((BaseBlockPosition)this.e, this.g.an())).callEvent());
                } else if (this.g.cA > this.a(200)) {
                    int eggCount = this.g.as.a(4) + 1;
                    TurtleLayEggEvent layEggEvent = new TurtleLayEggEvent((Turtle)this.g.getBukkitEntity(), CraftLocation.toBukkit((BaseBlockPosition)this.e.d(), this.g.an()), eggCount);
                    if (layEggEvent.callEvent() && CraftEventFactory.callEntityChangeBlockEvent(this.g, this.e.d(), (IBlockData)Blocks.nb.m().b(BlockTurtleEgg.c, layEggEvent.getEggCount()))) {
                        World level = this.g.an();
                        level.a(null, blockPos, SoundEffects.CG, SoundCategory.e, 0.3f, 0.9f + level.z.i() * 0.2f);
                        BlockPosition blockPos1 = this.e.d();
                        IBlockData blockState = (IBlockData)Blocks.nb.m().b(BlockTurtleEgg.c, layEggEvent.getEggCount());
                        level.a(blockPos1, blockState, 3);
                        level.a(GameEvent.i, blockPos1, GameEvent.a.a(this.g, blockState));
                    }
                    this.g.x(false);
                    this.g.y(false);
                    this.g.r(600);
                }
                if (this.g.n()) {
                    ++this.g.cA;
                }
            }
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            return level.w(pos.d()) && BlockTurtleEgg.b(level, pos);
        }
    }

    static class c
    extends PathfinderGoalGotoTarget {
        private static final int g = 1200;
        private final EntityTurtle h;

        c(EntityTurtle turtle, double speedModifier) {
            super(turtle, turtle.g_() ? 2.0 : speedModifier, 24);
            this.h = turtle;
            this.f = -1;
        }

        @Override
        public boolean c() {
            return !this.h.bu() && this.d <= 1200 && this.a(this.h.an(), this.e);
        }

        @Override
        public boolean b() {
            return this.h.g_() && !this.h.bu() ? super.b() : !this.h.cD && !this.h.bu() && !this.h.m() && super.b();
        }

        @Override
        public boolean l() {
            return this.d % 160 == 0;
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            return level.a_(pos).a(Blocks.J);
        }
    }

    static class b
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;
        private int d;
        private static final int e = 600;

        b(EntityTurtle turtle, double speedModifier) {
            this.a = turtle;
            this.b = speedModifier;
        }

        @Override
        public boolean b() {
            return !this.a.g_() && (this.a.m() || this.a.ek().a(net.minecraft.world.entity.animal.EntityTurtle$b.b(700)) == 0 && !this.a.cB.a(this.a.dD(), 64.0)) && new TurtleGoHomeEvent((Turtle)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void d() {
            this.a.cD = true;
            this.c = false;
            this.d = 0;
        }

        @Override
        public void e() {
            this.a.cD = false;
        }

        @Override
        public boolean c() {
            return !this.a.cB.a(this.a.dD(), 7.0) && !this.c && this.d <= this.a(600);
        }

        @Override
        public void a() {
            BlockPosition blockPos = this.a.cB;
            boolean flag = blockPos.a(this.a.dD(), 16.0);
            if (flag) {
                ++this.d;
            }
            if (this.a.S().l()) {
                Vec3D vec3 = Vec3D.c(blockPos);
                Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3, 0.3141592741012573);
                if (posTowards == null) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3, 1.5707963705062866);
                }
                if (posTowards != null && !flag && !this.a.an().a_(BlockPosition.a(posTowards)).a(Blocks.J)) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 5, vec3, 1.5707963705062866);
                }
                if (posTowards == null) {
                    this.c = true;
                    return;
                }
                this.a.S().a(posTowards.g, posTowards.h, posTowards.i, this.b);
            }
        }
    }

    static class i
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;

        i(EntityTurtle turtle, double speedModifier) {
            this.a = turtle;
            this.b = speedModifier;
        }

        @Override
        public boolean b() {
            return !this.a.cD && !this.a.m() && this.a.bu();
        }

        @Override
        public void d() {
            int i2 = 512;
            int i1 = 4;
            RandomSource randomSource = this.a.as;
            int i22 = randomSource.a(1025) - 512;
            int i3 = randomSource.a(9) - 4;
            int i4 = randomSource.a(1025) - 512;
            if ((double)i3 + this.a.dM() > (double)(this.a.an().T() - 1)) {
                i3 = 0;
            }
            this.a.cC = BlockPosition.a((double)i22 + this.a.dK(), (double)i3 + this.a.dM(), (double)i4 + this.a.dQ());
            this.c = false;
        }

        @Override
        public void a() {
            if (this.a.cC == null) {
                this.c = true;
            } else if (this.a.S().l()) {
                Vec3D vec3 = Vec3D.c(this.a.cC);
                Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3, 0.3141592741012573);
                if (posTowards == null) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3, 1.5707963705062866);
                }
                if (posTowards != null) {
                    int floor = MathHelper.a(posTowards.g);
                    int floor1 = MathHelper.a(posTowards.i);
                    int i2 = 34;
                    if (!this.a.an().b(floor - 34, floor1 - 34, floor + 34, floor1 + 34)) {
                        posTowards = null;
                    }
                }
                if (posTowards == null) {
                    this.c = true;
                    return;
                }
                this.a.S().a(posTowards.g, posTowards.h, posTowards.i, this.b);
            }
        }

        @Override
        public boolean c() {
            return !this.a.S().l() && !this.c && !this.a.cD && !this.a.gS() && !this.a.m();
        }

        @Override
        public void e() {
            this.a.cC = null;
            super.e();
        }
    }

    static class h
    extends PathfinderGoalRandomStroll {
        private final EntityTurtle i;

        h(EntityTurtle turtle, double speedModifier, int interval) {
            super(turtle, speedModifier, interval);
            this.i = turtle;
        }

        @Override
        public boolean b() {
            return !this.b.bu() && !this.i.cD && !this.i.m() && super.b();
        }
    }

    static class g
    extends AmphibiousPathNavigation {
        g(EntityTurtle turtle, World level) {
            super(turtle, level);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean a(BlockPosition pos) {
            block3: {
                block2: {
                    EntityInsentient entityInsentient = this.a;
                    if (!(entityInsentient instanceof EntityTurtle)) break block2;
                    EntityTurtle turtle = (EntityTurtle)entityInsentient;
                    if (turtle.cC != null) break block3;
                }
                if (this.b.a_(pos.e()).l()) return false;
                return true;
            }
            boolean bl = this.b.a_(pos).a(Blocks.J);
            return bl;
        }
    }
}

