/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Dynamic;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.HappyGhastAi;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.Nullable;

public class HappyGhast
extends EntityAnimal {
    public static final float ct = 0.2375f;
    public static final int cu = 16;
    public static final int cv = 32;
    public static final int cx = 64;
    public static final int cy = 16;
    public static final int cz = 20;
    public static final int cA = 600;
    public static final int cB = 4;
    private static final int cE = 60;
    private static final int cF = 10;
    public static final float cC = 2.0f;
    public static final Predicate<ItemStack> cD = itemStack -> itemStack.a(TagsItem.aM);
    private int cG = 0;
    private int cH;
    private static final DataWatcherObject<Boolean> cI = DataWatcher.a(HappyGhast.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cJ = DataWatcher.a(HappyGhast.class, DataWatcherRegistry.k);
    private static final float cK = 1.0f;

    public HappyGhast(EntityTypes<? extends HappyGhast> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.cn = new EntityGhast.ControllerGhast((EntityInsentient)this, true, this::gI);
        this.cm = new d();
    }

    private void s(int serverStillTimeout) {
        World world;
        if (this.cH <= 0 && serverStillTimeout > 0 && (world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.e(this.dK(), this.dM(), this.dQ());
            serverLevel.n().a.a(this, ClientboundEntityPositionSyncPacket.a(this));
        }
        this.cH = serverStillTimeout;
        this.gV();
    }

    private NavigationAbstract c(World level) {
        return new a(this, level);
    }

    @Override
    protected void H() {
        this.cq.a(3, new c());
        this.cq.a(4, new PathfinderGoalTempt.a((EntityInsentient)this, 1.0, itemStack -> !this.go() && !this.g_() ? itemStack.a(TagsItem.aN) : cD.test((ItemStack)itemStack), false, 7.0));
        this.cq.a(5, new EntityGhast.PathfinderGoalGhastIdleMove(this, 16));
    }

    private void gJ() {
        this.cn = new EntityGhast.ControllerGhast((EntityInsentient)this, true, this::gI);
        this.cm = new d();
        this.cp = this.b(this.an());
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.c((PathfinderGoal goal) -> true);
            this.H();
            this.bY.b(serverLevel, this);
            this.bY.a();
        }
    }

    private void gK() {
        this.cn = new ControllerMoveFlying(this, 180, true);
        this.cm = new ControllerLook(this);
        this.cp = this.c(this.an());
        this.s(0);
        this.c((PathfinderGoal goal) -> true);
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.happyGhastRidableInWater;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.happyGhastMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.happyGhastScale);
        this.h(GenericAttributes.F).a(this.an().purpurConfig.happyGhastTemptRange);
        this.h(GenericAttributes.m).a(this.an().purpurConfig.happyGhastFlyingSpeed);
        this.h(GenericAttributes.w).a(this.an().purpurConfig.happyGhastMovementSpeed);
        this.h(GenericAttributes.n).a(this.an().purpurConfig.happyGhastFollowRange);
        this.h(GenericAttributes.i).a(this.an().purpurConfig.happyGhastCameraDistance);
    }

    @Override
    public int getPurpurBreedTime() {
        return 6000;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.happyGhastTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.happyGhastAlwaysDropExp;
    }

    @Override
    protected void h() {
        if (this.g_()) {
            this.gK();
        } else {
            this.gJ();
        }
        super.h();
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gN().a(GenericAttributes.t, 20.0).a(GenericAttributes.F, 16.0).a(GenericAttributes.m, 0.05).a(GenericAttributes.w, 0.05).a(GenericAttributes.n, 16.0).a(GenericAttributes.i, 8.0);
    }

    @Override
    protected float c(float scale) {
        return Math.min(scale, 1.0f);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public boolean fe() {
        return false;
    }

    @Override
    public void m(Vec3D travelVector) {
        float f2 = (float)this.i(GenericAttributes.m) * 5.0f / 3.0f;
        this.a(travelVector, f2, f2, f2);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (!level.w(pos)) {
            return 0.0f;
        }
        return level.w(pos.e()) && !level.w(pos.c(2)) ? 10.0f : 5.0f;
    }

    @Override
    public boolean et() {
        return this.g_() || super.et();
    }

    @Override
    protected boolean gG() {
        return false;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
    }

    @Override
    public float fu() {
        return 1.0f;
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.g;
    }

    @Override
    public int W() {
        int i2 = super.W();
        return this.cm() ? i2 * 6 : i2;
    }

    @Override
    public SoundEffect p() {
        return this.g_() ? SoundEffects.lI : SoundEffects.nc;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.g_() ? SoundEffects.lK : SoundEffects.ne;
    }

    @Override
    public SoundEffect f_() {
        return this.g_() ? SoundEffects.lJ : SoundEffects.nd;
    }

    @Override
    public float ft() {
        return this.g_() ? 1.0f : 4.0f;
    }

    @Override
    public int ak() {
        return 1;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.ah.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean gP() {
        return false;
    }

    @Override
    public float ez() {
        return this.g_() ? 0.2375f : 1.0f;
    }

    @Override
    public boolean i(ItemStack stack) {
        return cD.test(stack);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.g ? super.e(slot) : this.bX() && !this.g_();
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.g;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult;
        if (this.g_()) {
            return super.b(player, hand);
        }
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.f() && (interactionResult = itemInHand.a(player, (EntityLiving)this, hand)).a()) {
            return interactionResult;
        }
        if (this.go() && !player.gp()) {
            this.g(player);
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    private void g(EntityHuman player) {
        if (!this.an().D_()) {
            player.o(this);
        }
    }

    @Override
    protected void q(Entity passenger) {
        if (!this.cm()) {
            this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.nO, this.dw(), 1.0f, 1.0f);
        }
        super.q(passenger);
        if (!this.an().D_()) {
            if (!this.gW()) {
                this.s(0);
            } else if (this.cH > 10) {
                this.s(10);
            }
        }
    }

    @Override
    protected boolean removePassenger(Entity passenger, boolean suppressCancellation) {
        if (!super.removePassenger(passenger, suppressCancellation)) {
            return false;
        }
        if (!this.an().D_()) {
            this.s(10);
        }
        if (!this.cm()) {
            this.gv();
            this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.nN, this.dw(), 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    protected boolean s(Entity passenger) {
        return this.di().size() < 4;
    }

    @Override
    @Nullable
    public EntityLiving dg() {
        EntityLiving entityLiving;
        Entity entity;
        if (this.go() && !this.gI() && (entity = this.dj()) instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            entityLiving = player;
        } else {
            entityLiving = super.dg();
        }
        return entityLiving;
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        float f2 = player.bM;
        float f1 = 0.0f;
        float f22 = 0.0f;
        if (player.bO != 0.0f) {
            float cos = MathHelper.b(player.dZ() * ((float)Math.PI / 180));
            float f3 = -MathHelper.a(player.dZ() * ((float)Math.PI / 180));
            if (player.bO < 0.0f) {
                cos *= -0.5f;
                f3 *= -0.5f;
            }
            f22 = f3;
            f1 = cos;
        }
        if (player.fH()) {
            f22 += 0.5f;
        }
        return new Vec3D(f2, f22, f1).c((double)3.9f * this.i(GenericAttributes.m));
    }

    protected Vec2F i(EntityLiving entity) {
        return new Vec2F(entity.dZ() * 0.5f, entity.dX());
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        Vec2F riddenRotation = this.i(player);
        float yRot = this.dX();
        float f2 = MathHelper.h(riddenRotation.k - yRot);
        float f1 = 0.08f;
        this.a(yRot += f2 * 0.08f, riddenRotation.j);
        this.bB = this.bD = yRot;
        this.ab = this.bD;
    }

    protected BehaviorController.b<HappyGhast> er() {
        return HappyGhastAi.a();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return HappyGhastAi.a(this.er().a(dynamic));
    }

    @Override
    protected void a(WorldServer level) {
        if (this.g_()) {
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a("happyGhastBrain");
            this.bY.a(level, this);
            profilerFiller.c();
            profilerFiller.a("happyGhastActivityUpdate");
            HappyGhastAi.a(this);
            profilerFiller.c();
        }
        this.gM();
        super.a(level);
    }

    @Override
    public void g() {
        super.g();
        if (!this.an().D_()) {
            if (this.cG > 0) {
                --this.cG;
            }
            this.x(this.cG > 0);
            if (this.cH > 0) {
                if (this.at > 60) {
                    --this.cH;
                }
                this.s(this.cH);
            }
            if (this.gW()) {
                this.s(10);
            }
        }
    }

    @Override
    public void e_() {
        if (!this.an().D_()) {
            this.c(this.gI());
        }
        super.e_();
        this.gU();
    }

    private int gL() {
        return !this.g_() && this.a(EnumItemSlot.g).f() ? 64 : 32;
    }

    private void gM() {
        if (!this.T_() && !this.cm()) {
            int happyGhastRestrictionRadius = this.gL();
            if (!this.gw() || !this.gt().a(this.dF(), (double)(happyGhastRestrictionRadius + 16)) || happyGhastRestrictionRadius != this.gu()) {
                this.a(this.dF(), happyGhastRestrictionRadius);
            }
        }
    }

    private void gU() {
        World world = this.an();
        if (world instanceof WorldServer) {
            boolean flag;
            WorldServer serverLevel = (WorldServer)world;
            if (this.bX() && this.bv == 0 && this.fj() != this.eU() && this.at % ((flag = serverLevel.H_().j() && (this.bA() || serverLevel.s(this.dF()) != BiomeBase.Precipitation.a)) ? 20 : 600) == 0) {
                this.d(1.0f);
            }
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cI, false);
        builder.a(cJ, false);
    }

    private void x(boolean leashHolder) {
        this.az.a(cI, leashHolder);
    }

    public boolean n() {
        return this.az.a(cI);
    }

    private void gV() {
        this.az.a(cJ, this.cH > 0);
    }

    public boolean s() {
        return this.az.a(cJ);
    }

    @Override
    public boolean dT() {
        return true;
    }

    @Override
    public Vec3D[] dS() {
        return Leashable.a(this, -0.03125, 0.4375, 0.46875, 0.03125);
    }

    @Override
    public Vec3D F() {
        return Vec3D.c;
    }

    @Override
    public double B() {
        return 10.0;
    }

    @Override
    public double A() {
        return 16.0;
    }

    @Override
    public void z() {
        super.z();
        this.Q().g();
    }

    @Override
    public void a(Leashable leashHolder) {
        if (leashHolder.D()) {
            this.cG = 5;
        }
    }

    @Override
    public void a(ValueOutput output) {
        super.a(output);
        output.a("still_timeout", this.cH);
    }

    @Override
    public void a(ValueInput input) {
        super.a(input);
        this.s(input.a("still_timeout", 0));
    }

    public boolean gI() {
        return this.s() || this.cH > 0;
    }

    private boolean gW() {
        AxisAlignedBB boundingBox = this.de();
        AxisAlignedBB aabb = new AxisAlignedBB(boundingBox.a - 1.0, boundingBox.e - (double)1.0E-5f, boundingBox.c - 1.0, boundingBox.d + 1.0, boundingBox.e + boundingBox.c() / 2.0, boundingBox.f + 1.0);
        for (EntityHuman entityHuman : this.an().C()) {
            Entity rootVehicle;
            if (entityHuman.at() || (rootVehicle = entityHuman.dp()) instanceof HappyGhast || !aabb.d(rootVehicle.dD())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected EntityAIBodyControl N() {
        return new b();
    }

    @Override
    public boolean j(@Nullable Entity entity) {
        return !this.g_() && this.bX() && (this.an().D_() && entity instanceof EntityHuman && entity.dD().h >= this.de().e || this.cm() && entity instanceof HappyGhast || this.gI());
    }

    @Override
    public boolean eh() {
        return !this.g_();
    }

    class d
    extends ControllerLook {
        d() {
            super(HappyGhast.this);
        }

        @Override
        public void a() {
            if (HappyGhast.this.gI()) {
                float f2 = net.minecraft.world.entity.animal.HappyGhast$d.a(HappyGhast.this.dX());
                HappyGhast.this.v(HappyGhast.this.dX() - f2);
                HappyGhast.this.r(HappyGhast.this.dX());
            } else if (this.d > 0) {
                --this.d;
                double d2 = this.e - HappyGhast.this.dK();
                double d1 = this.g - HappyGhast.this.dQ();
                HappyGhast.this.v(-((float)MathHelper.d(d2, d1)) * 57.295776f);
                HappyGhast.this.bD = HappyGhast.this.bB = HappyGhast.this.dX();
            } else {
                EntityGhast.a(this.a);
            }
        }

        public static float a(float degrees) {
            float f2 = degrees % 90.0f;
            if (f2 >= 45.0f) {
                f2 -= 90.0f;
            }
            if (f2 < -45.0f) {
                f2 += 90.0f;
            }
            return f2;
        }
    }

    static class a
    extends NavigationFlying {
        public a(HappyGhast ghast, World level) {
            super(ghast, level);
            this.e(false);
            this.a(true);
            this.a(48.0f);
        }

        @Override
        protected boolean a(Vec3D currentPos, Vec3D nextPos) {
            return net.minecraft.world.entity.animal.HappyGhast$a.a(this.a, currentPos, nextPos, false);
        }
    }

    class c
    extends PathfinderGoalFloat {
        public c() {
            super(HappyGhast.this);
        }

        @Override
        public boolean b() {
            return !HappyGhast.this.gI() && super.b();
        }
    }

    class b
    extends EntityAIBodyControl {
        public b() {
            super(HappyGhast.this);
        }

        @Override
        public void a() {
            if (HappyGhast.this.cm()) {
                HappyGhast.this.bB = HappyGhast.this.bD = HappyGhast.this.dX();
            }
            super.a();
        }
    }
}

