/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.armadillo;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.armadillo.ArmadilloAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.event.entity.EntityDamageEvent;

public class Armadillo
extends EntityAnimal {
    public static final float ct = 0.6f;
    public static final float cu = 32.5f;
    public static final int cv = 80;
    private static final double cA = 7.0;
    private static final double cB = 2.0;
    private static final DataWatcherObject<a> cC = DataWatcher.a(Armadillo.class, DataWatcherRegistry.E);
    private long cD = 0L;
    public final AnimationState cx = new AnimationState();
    public final AnimationState cy = new AnimationState();
    public final AnimationState cz = new AnimationState();
    private int cE;
    private boolean cF = false;

    public Armadillo(EntityTypes<? extends EntityAnimal> type, World level) {
        super(type, level);
        this.S().a(true);
        this.cE = this.gU();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.g.a(level, EntitySpawnReason.e);
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gN().a(GenericAttributes.t, 12.0).a(GenericAttributes.w, 0.14);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.armadilloRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.armadilloRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.armadilloControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.armadilloMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.armadilloScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.armadilloBreedingTicks;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cC, net.minecraft.world.entity.animal.armadillo.Armadillo$a.a);
    }

    public boolean n() {
        return this.az.a(cC) != net.minecraft.world.entity.animal.armadillo.Armadillo$a.a;
    }

    public boolean s() {
        return this.gJ().a(this.cD);
    }

    public boolean gI() {
        return this.gJ() == net.minecraft.world.entity.animal.armadillo.Armadillo$a.b && this.cD > (long)net.minecraft.world.entity.animal.armadillo.Armadillo$a.b.b();
    }

    public a gJ() {
        return this.az.a(cC);
    }

    public void a(a state) {
        this.az.a(cC, state);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cC.equals(key)) {
            this.cD = 0L;
        }
        super.a(key);
    }

    protected BehaviorController.b<Armadillo> er() {
        return ArmadilloAi.a();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return ArmadilloAi.a(this.er().a(dynamic));
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("armadilloBrain");
        this.bY.a(level, this);
        profilerFiller.c();
        profilerFiller.a("armadilloActivityUpdate");
        ArmadilloAi.a(this);
        profilerFiller.c();
        if (this.bX() && !this.g_() && --this.cE <= 0) {
            this.forceDrops = true;
            if (this.a(level, LootTables.aJ, this::a)) {
                this.a(SoundEffects.ak, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                this.c(GameEvent.t);
            }
            this.forceDrops = false;
            this.cE = this.gU();
        }
        super.a(level);
    }

    private int gU() {
        return this.as.a(20 * TimeRange.e * 5) + 20 * TimeRange.e * 5;
    }

    @Override
    public void g() {
        super.g();
        if (this.an().D_()) {
            this.gV();
        }
        if (this.n()) {
            this.ai();
        }
        ++this.cD;
    }

    @Override
    public float ez() {
        return this.g_() ? 0.6f : 1.0f;
    }

    private void gV() {
        switch (this.gJ().ordinal()) {
            case 0: {
                this.cx.a();
                this.cy.a();
                this.cz.a();
                break;
            }
            case 1: {
                this.cx.a();
                this.cy.b(this.at);
                this.cz.a();
                break;
            }
            case 2: {
                this.cx.a();
                this.cy.a();
                if (this.cF) {
                    this.cz.a();
                    this.cF = false;
                }
                if (this.cD == 0L) {
                    this.cz.a(this.at);
                    this.cz.a(net.minecraft.world.entity.animal.armadillo.Armadillo$a.c.b(), 1.0f);
                    break;
                }
                this.cz.b(this.at);
                break;
            }
            case 3: {
                this.cx.b(this.at);
                this.cy.a();
                this.cz.a();
            }
        }
    }

    @Override
    public void b(byte id) {
        if (id == 64 && this.an().D_()) {
            this.cF = true;
            this.an().a(this.dK(), this.dM(), this.dQ(), SoundEffects.am, this.dw(), 1.0f, 1.0f, false);
        } else {
            super.b(id);
        }
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aP);
    }

    public static boolean c(EntityTypes<Armadillo> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cl) && Armadillo.a(level, pos);
    }

    public boolean i(EntityLiving entity) {
        EntityHuman player;
        return this.de().c(7.0, 2.0, 7.0).c(entity.de()) && (entity.ax().a(TagsEntity.d) || this.eF() == entity || entity instanceof EntityHuman && !(player = (EntityHuman)entity).at() && (player.cv() || player.cl()));
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("state", net.minecraft.world.entity.animal.armadillo.Armadillo$a.f, this.gJ());
        output.a("scute_time", this.cE);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("state", net.minecraft.world.entity.animal.armadillo.Armadillo$a.f).orElse(net.minecraft.world.entity.animal.armadillo.Armadillo$a.a));
        input.e("scute_time").ifPresent(integer -> {
            this.cE = integer;
        });
    }

    public void gK() {
        if (!this.n()) {
            this.aa();
            this.gT();
            this.c(GameEvent.u);
            this.b(SoundEffects.ai);
            this.a(net.minecraft.world.entity.animal.armadillo.Armadillo$a.b);
        }
    }

    public void gL() {
        if (this.n()) {
            this.c(GameEvent.u);
            this.b(SoundEffects.al);
            this.a(net.minecraft.world.entity.animal.armadillo.Armadillo$a.a);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.n()) {
            amount = (amount - 1.0f) / 2.0f;
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(level, damageSource, amount, event);
        if (!damageResult) {
            return false;
        }
        if (!this.gx() && !this.eV()) {
            if (damageSource.d() instanceof EntityLiving) {
                this.eq().a(MemoryModuleType.H, true, 80L);
                if (this.gM()) {
                    this.gK();
                }
            } else if (damageSource.a(DamageTypeTags.G)) {
                this.gL();
            }
        }
        return true;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.zJ) && this.a((Entity)player, itemInHand)) {
            itemInHand.a(16, (EntityLiving)player, hand.a());
            return EnumInteractionResult.a;
        }
        return this.n() ? EnumInteractionResult.d : super.b(player, hand);
    }

    public boolean a(@Nullable Entity entity, ItemStack stack) {
        if (this.g_()) {
            return false;
        }
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.forceDrops = true;
            this.a(serverLevel, LootTables.aV, entity, stack, this::a);
            this.forceDrops = false;
            this.a(SoundEffects.ao);
            this.c(GameEvent.r);
        }
        return true;
    }

    public boolean gM() {
        return !this.gF() && !this.bx() && !this.T_() && !this.cl() && !this.cm();
    }

    @Override
    public boolean gP() {
        return super.gP() && !this.n();
    }

    @Override
    public SoundEffect p() {
        return this.n() ? null : SoundEffects.af;
    }

    @Override
    protected void gO() {
        this.b(SoundEffects.ac);
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.ah;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.n() ? SoundEffects.ae : SoundEffects.ad;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.ag, 0.15f, 1.0f);
    }

    @Override
    public int ah() {
        return this.n() ? 0 : 32;
    }

    @Override
    protected EntityAIBodyControl N() {
        return new EntityAIBodyControl(this){

            @Override
            public void a() {
                if (!Armadillo.this.n()) {
                    super.a();
                }
            }
        };
    }

    public static abstract sealed class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a a = new a("idle", false, 0, 0){

            @Override
            public boolean a(long inStateTicks) {
                return false;
            }
        };
        public static final /* enum */ a b = new a("rolling", true, 10, 1){

            @Override
            public boolean a(long inStateTicks) {
                return inStateTicks > 5L;
            }
        };
        public static final /* enum */ a c = new a("scared", true, 50, 2){

            @Override
            public boolean a(long inStateTicks) {
                return true;
            }
        };
        public static final /* enum */ a d = new a("unrolling", true, 30, 3){

            @Override
            public boolean a(long inStateTicks) {
                return inStateTicks < 26L;
            }
        };
        static final Codec<a> f;
        private static final IntFunction<a> g;
        public static final StreamCodec<ByteBuf, a> e;
        private final String h;
        private final boolean i;
        private final int j;
        private final int k;
        private static final /* synthetic */ a[] l;

        public static a[] values() {
            return (a[])l.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(String name, boolean isThreatened, int animationDuration, int id) {
            this.h = name;
            this.i = isThreatened;
            this.j = animationDuration;
            this.k = id;
        }

        @Override
        public String c() {
            return this.h;
        }

        private int d() {
            return this.k;
        }

        public abstract boolean a(long var1);

        public boolean a() {
            return this.i;
        }

        public int b() {
            return this.j;
        }

        private static /* synthetic */ a[] e() {
            return new a[]{a, b, c, d};
        }

        static {
            l = net.minecraft.world.entity.animal.armadillo.Armadillo$a.e();
            f = INamable.a(a::values);
            g = ByIdMap.a(a::d, net.minecraft.world.entity.animal.armadillo.Armadillo$a.values(), ByIdMap.a.a);
            e = ByteBufCodecs.a(g, a::d);
        }
    }
}

