/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.BinaryAnimator;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.purpurmc.purpur.controller.WaterMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class Axolotl
extends EntityAnimal
implements Bucketable {
    public static final int ct = 200;
    private static final int cE = 10;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Axolotl>>> cu = ImmutableList.of(SensorType.c, SensorType.o, SensorType.f, SensorType.q, SensorType.r);
    protected static final ImmutableList<? extends MemoryModuleType<?>> cv = ImmutableList.of(MemoryModuleType.s, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.o, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.L, (Object[])new MemoryModuleType[]{MemoryModuleType.z, MemoryModuleType.O, MemoryModuleType.C, MemoryModuleType.P, MemoryModuleType.Q, MemoryModuleType.S, MemoryModuleType.V, MemoryModuleType.aa});
    private static final DataWatcherObject<Integer> cF = DataWatcher.a(Axolotl.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cG = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cH = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    public static final double cx = 20.0;
    public static final int cy = 1200;
    private static final int cI = 6000;
    public static final String cz = "Variant";
    private static final int cJ = 1800;
    private static final int cK = 2400;
    private static final boolean cL = false;
    public final BinaryAnimator cA = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator cB = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator cC = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator cD = new BinaryAnimator(10, MathHelper::m);
    private static final int cM = 100;

    public Axolotl(EntityTypes<? extends Axolotl> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.a(PathType.j, 0.0f);
        this.cn = new d(this);
        this.cm = new c(this, 20);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.axolotlRidable;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.axolotlControllable;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.axolotlMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.axolotlScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.axolotlBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.axolotlTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.axolotlAlwaysDropExp;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cF, 0);
        builder.a(cG, false);
        builder.a(cH, false);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a(cz, Variant.i, this.gI());
        output.a("FromBucket", this.m());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a(cz, Variant.i).orElse(Variant.f));
        this.x(input.a("FromBucket", false));
    }

    @Override
    public void X() {
        if (!this.gJ()) {
            super.X();
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        boolean flag = false;
        if (spawnReason == EntitySpawnReason.l) {
            return spawnGroupData;
        }
        RandomSource random = level.I_();
        if (spawnGroupData instanceof b) {
            if (((b)spawnGroupData).a() >= 2) {
                flag = true;
            }
        } else {
            spawnGroupData = new b(Variant.a(random), Variant.a(random));
        }
        this.a(((b)spawnGroupData).a(random));
        if (flag) {
            this.c_(-24000);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public void aH() {
        World world;
        int airSupply = this.cF();
        super.aH();
        if (!this.gx() && (world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel, airSupply);
        }
        if (this.an().D_()) {
            this.gL();
        }
    }

    private void gL() {
        a animationState = this.gJ() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.a : (this.bu() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.b : (this.aS() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.c : net.minecraft.world.entity.animal.axolotl.Axolotl$a.d));
        this.cA.a(animationState == net.minecraft.world.entity.animal.axolotl.Axolotl$a.a);
        this.cB.a(animationState == net.minecraft.world.entity.animal.axolotl.Axolotl$a.b);
        this.cC.a(animationState == net.minecraft.world.entity.animal.axolotl.Axolotl$a.c);
        boolean flag = this.bz.d() || this.dZ() != this.ac || this.dX() != this.ab;
        this.cD.a(flag);
    }

    protected void a(WorldServer level, int airSupply) {
        if (this.bX() && !this.bw()) {
            this.j(airSupply - 1);
            if (this.ev()) {
                this.j(0);
                this.a(level, this.ei().t(), 2.0f);
            }
        } else {
            this.j(this.cE());
        }
    }

    public void s() {
        int i2 = this.cF() + 1800;
        this.j(Math.min(i2, this.cE()));
    }

    @Override
    public int cE() {
        return this.maxAirTicks;
    }

    public Variant gI() {
        return Variant.a(this.az.a(cF));
    }

    public void a(Variant variant) {
        this.az.a(cF, variant.a());
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aO ? Axolotl.c(component, this.gI()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aO);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aO) {
            this.a(Axolotl.c(DataComponents.aO, value));
            return true;
        }
        return super.b(component, value);
    }

    private static boolean a(RandomSource random) {
        return random.a(1200) == 0;
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    @Override
    public boolean cW() {
        return false;
    }

    public void y(boolean playingDead) {
        this.az.a(cG, playingDead);
    }

    public boolean gJ() {
        return this.az.a(cG);
    }

    @Override
    public boolean m() {
        return this.az.a(cH);
    }

    @Override
    public void x(boolean fromBucket) {
        this.az.a(cH, fromBucket);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        Axolotl axolotl = EntityTypes.j.a(level, EntitySpawnReason.e);
        if (axolotl != null) {
            Variant rareSpawnVariant = Axolotl.a(this.as) ? Variant.b(this.as) : (this.as.h() ? this.gI() : ((Axolotl)partner).gI());
            axolotl.a(rareSpawnVariant);
            axolotl.gq();
        }
        return axolotl;
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.bf);
    }

    @Override
    public boolean v() {
        return true;
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("axolotlBrain");
        if (this.getRider() == null || !this.isControllable()) {
            this.eq().a(level, this);
        }
        profilerFiller.c();
        profilerFiller.a("axolotlActivityUpdate");
        AxolotlAi.a(this);
        profilerFiller.c();
        if (!this.gx()) {
            Optional<Integer> memory = this.eq().c(MemoryModuleType.O);
            this.y(memory.isPresent() && memory.get() > 0);
        }
    }

    public static AttributeProvider.Builder gK() {
        return EntityAnimal.gN().a(GenericAttributes.t, 14.0).a(GenericAttributes.w, 1.0).a(GenericAttributes.c, 2.0).a(GenericAttributes.C, 1.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new AmphibiousPathNavigation(this, level);
    }

    @Override
    public void gB() {
        this.a(SoundEffects.aL, 1.0f, 1.0f);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        float health = this.eU();
        if (!this.gx() && this.an().z.a(3) == 0 && ((float)this.an().z.a(3) < amount || health / this.fj() < 0.5f) && amount < health && this.bu() && (damageSource.d() != null || damageSource.c() != null) && !this.gJ()) {
            this.bY.a(MemoryModuleType.O, Integer.valueOf(200));
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public int af() {
        return 1;
    }

    @Override
    public int ah() {
        return 1;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    public void a_(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        stack.a(DataComponents.aO, (DataComponentGetter)this);
        CustomData.a(DataComponents.Z, stack, (NBTTagCompound tag) -> {
            tag.a("Age", this.aa_());
            BehaviorController<Axolotl> brain = this.eq();
            if (brain.a(MemoryModuleType.V)) {
                tag.a("HuntingCooldown", brain.e(MemoryModuleType.V));
            }
        });
    }

    @Override
    public void a(NBTTagCompound tag) {
        Bucketable.a((EntityInsentient)this, tag);
        this.c_(tag.b("Age", 0));
        tag.f("HuntingCooldown").ifPresentOrElse(_long -> this.eq().a(MemoryModuleType.V, true, tag.b("HuntingCooldown", 0L)), () -> this.eq().a(MemoryModuleType.V, Optional.empty()));
    }

    @Override
    public ItemStack a() {
        return new ItemStack(Items.sv);
    }

    @Override
    public SoundEffect n() {
        return SoundEffects.dl;
    }

    @Override
    public boolean eN() {
        return !this.gJ() && super.eN();
    }

    public static void a(WorldServer level, Axolotl axolotl, EntityLiving target) {
        Entity entity;
        DamageSource lastDamageSource;
        if (target.eV() && (lastDamageSource = target.eW()) != null && (entity = lastDamageSource.d()) != null && entity.ax() == EntityTypes.bX) {
            EntityHuman player = (EntityHuman)entity;
            List<EntityHuman> entitiesOfClass = level.a(EntityHuman.class, axolotl.de().g(20.0));
            if (entitiesOfClass.contains(player)) {
                axolotl.g(player);
            }
        }
    }

    public void g(EntityHuman player) {
        MobEffect effect = player.e(MobEffects.j);
        if (effect == null || effect.a(2399)) {
            int i2 = effect != null ? effect.d() : 0;
            int min = Math.min(2400, 100 + i2);
            player.addEffect(new MobEffect(MobEffects.j, min, 0), this, EntityPotionEffectEvent.Cause.AXOLOTL);
        }
        player.removeEffect(MobEffects.d, EntityPotionEffectEvent.Cause.AXOLOTL);
    }

    @Override
    public boolean ae() {
        return super.ae() || this.m();
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.aN;
    }

    @Override
    @Nullable
    public SoundEffect f_() {
        return SoundEffects.aM;
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return this.bu() ? SoundEffects.aP : SoundEffects.aO;
    }

    @Override
    public SoundEffect bh() {
        return SoundEffects.aQ;
    }

    @Override
    public SoundEffect bg() {
        return SoundEffects.aR;
    }

    protected BehaviorController.b<Axolotl> er() {
        return BehaviorController.a(cv, cu);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return AxolotlAi.a(this.er().a(dynamic));
    }

    public BehaviorController<Axolotl> eq() {
        return super.eq();
    }

    @Override
    public void m(Vec3D travelVector) {
        if (this.bu()) {
            this.a(this.fD(), travelVector);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c(0.9));
        } else {
            super.m(travelVector);
        }
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (stack.a(Items.su)) {
            player.a(hand, ItemLiquidUtil.a(stack, player, new ItemStack(Items.sl)));
        } else {
            super.a(player, hand, stack);
        }
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return !this.m() && !this.k_();
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.U();
    }

    public static boolean a(EntityTypes<? extends EntityLiving> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cm);
    }

    @Override
    public int getDefaultMaxAirSupply() {
        return 6000;
    }

    static class d
    extends SmoothSwimmingMoveControl {
        private final Axolotl l;
        private final WaterMoveControllerWASD waterController;

        public d(Axolotl axolotl) {
            super(axolotl, 85, 10, 0.1f, 0.5f, false);
            this.l = axolotl;
            this.waterController = new WaterMoveControllerWASD(axolotl, 0.5);
        }

        @Override
        public void a() {
            if (this.l.getRider() != null && this.l.isControllable()) {
                this.waterController.purpurTick(this.l.getRider());
                return;
            }
            if (!this.l.gJ()) {
                super.a();
            }
        }
    }

    class c
    extends SmoothSwimmingLookControl {
        public c(Axolotl mob, int maxYRotFromCenter) {
            super(mob, maxYRotFromCenter);
        }

        @Override
        public void vanillaTick() {
            if (!Axolotl.this.gJ()) {
                super.vanillaTick();
            }
        }
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "lucy", true);
        public static final /* enum */ Variant b = new Variant(1, "wild", true);
        public static final /* enum */ Variant c = new Variant(2, "gold", true);
        public static final /* enum */ Variant d = new Variant(3, "cyan", true);
        public static final /* enum */ Variant e = new Variant(4, "blue", false);
        public static final Variant f;
        private static final IntFunction<Variant> j;
        public static final StreamCodec<ByteBuf, Variant> g;
        public static final Codec<Variant> h;
        @Deprecated
        public static final Codec<Variant> i;
        private final int k;
        private final String l;
        private final boolean m;
        private static final /* synthetic */ Variant[] n;

        public static Variant[] values() {
            return (Variant[])n.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name, boolean common) {
            this.k = id;
            this.l = name;
            this.m = common;
        }

        public int a() {
            return this.k;
        }

        public String b() {
            return this.l;
        }

        @Override
        public String c() {
            return this.l;
        }

        public static Variant a(int id) {
            return j.apply(id);
        }

        public static Variant a(RandomSource random) {
            return Variant.a(random, true);
        }

        public static Variant b(RandomSource random) {
            return Variant.a(random, false);
        }

        private static Variant a(RandomSource random, boolean common) {
            Variant[] variants = (Variant[])Arrays.stream(Variant.values()).filter(variant -> variant.m == common).toArray(Variant[]::new);
            return SystemUtils.a(variants, random);
        }

        private static /* synthetic */ Variant[] d() {
            return new Variant[]{a, b, c, d, e};
        }

        static {
            n = Variant.d();
            f = a;
            j = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.a);
            g = ByteBufCodecs.a(j, Variant::a);
            h = INamable.a(Variant::values);
            i = Codec.INT.xmap(j::apply, Variant::a);
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Variant[] a;

        public b(Variant ... types) {
            super(false);
            this.a = types;
        }

        public Variant a(RandomSource random) {
            return this.a[random.a(this.a.length)];
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        public static final /* enum */ a d = new a();
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c, d};
        }

        static {
            e = net.minecraft.world.entity.animal.axolotl.Axolotl$a.a();
        }
    }
}

