/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.camel.CamelAi;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class Camel
extends EntityHorseAbstract {
    public static final float ct = 0.45f;
    public static final int cu = 55;
    public static final int cv = 30;
    private static final float cS = 0.1f;
    private static final float cT = 1.4285f;
    private static final float cU = 22.2222f;
    private static final int cV = 5;
    private static final int cW = 40;
    private static final int cX = 52;
    private static final int cY = 80;
    private static final float cZ = 1.43f;
    private static final long da = 0L;
    public static final DataWatcherObject<Boolean> cx = DataWatcher.a(Camel.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Long> cy = DataWatcher.a(Camel.class, DataWatcherRegistry.c);
    public final AnimationState cz = new AnimationState();
    public final AnimationState cA = new AnimationState();
    public final AnimationState cB = new AnimationState();
    public final AnimationState cC = new AnimationState();
    public final AnimationState cD = new AnimationState();
    private static final EntitySize db = EntitySize.b(EntityTypes.v.l(), EntityTypes.v.m() - 1.43f).b(0.845f);
    private int dc = 0;
    private int dd = 0;

    public Camel(EntityTypes<? extends Camel> type, World level) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, level);
        this.cn = new c();
        this.cm = new b();
        Navigation groundPathNavigation = (Navigation)this.S();
        groundPathNavigation.a(true);
        groundPathNavigation.c(true);
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.camelRidableInWater;
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.camelBreedingTicks;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("LastPoseTick", this.az.a(cy));
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        long longOr = input.a("LastPoseTick", 0L);
        if (longOr < 0L) {
            this.c(EntityPose.k);
        }
        this.a(longOr);
    }

    public static AttributeProvider.Builder m() {
        return Camel.hi().a(GenericAttributes.t, 32.0).a(GenericAttributes.w, 0.09f).a(GenericAttributes.p, 0.42f).a(GenericAttributes.C, 1.5);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cx, false);
        builder.a(cy, 0L);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        CamelAi.a(this, level.I_());
        this.b(level.a().ag());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static boolean c(EntityTypes<Camel> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cw) && Camel.a(level, pos);
    }

    protected BehaviorController.b<Camel> er() {
        return CamelAi.a();
    }

    @Override
    protected void H() {
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return CamelAi.a(this.er().a(dynamic));
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return pose == EntityPose.k ? db.a(this.ez()) : super.b(pose);
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("camelBrain");
        BehaviorController<?> brain = this.eq();
        brain.a(level, this);
        profilerFiller.c();
        profilerFiller.a("camelActivityUpdate");
        CamelAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public void g() {
        super.g();
        if (this.s() && this.dc < 50 && (this.aS() || this.bx() || this.cl())) {
            this.x(false);
        }
        if (this.dc > 0) {
            --this.dc;
            if (this.dc == 0) {
                this.an().a(null, this.dF(), SoundEffects.dE, SoundCategory.g, 1.0f, 1.0f);
            }
        }
        if (this.an().D_()) {
            this.hs();
        }
        if (this.n()) {
            this.ai();
        }
        if (this.gL() && this.bu()) {
            this.gX();
        }
    }

    private void hs() {
        if (this.dd <= 0) {
            this.dd = this.as.a(40) + 80;
            this.cC.a(this.at);
        } else {
            --this.dd;
        }
        if (this.gM()) {
            this.cB.a();
            this.cD.a();
            if (this.ht()) {
                this.cz.b(this.at);
                this.cA.a();
            } else {
                this.cz.a();
                this.cA.b(this.at);
            }
        } else {
            this.cz.a();
            this.cA.a();
            this.cD.a(this.s(), this.at);
            this.cB.a(this.gU() && this.gY() >= 0L, this.at);
        }
    }

    @Override
    protected void A(float partialTick) {
        float min = this.aE() == EntityPose.a && !this.cD.b() ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.bz.a(min, 0.2f, this.g_() ? 3.0f : 1.0f);
    }

    @Override
    public void m(Vec3D travelVector) {
        if (this.n() && this.aS()) {
            this.k(this.dI().d(0.0, 1.0, 0.0));
            travelVector = travelVector.d(0.0, 1.0, 0.0);
        }
        super.m(travelVector);
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        if (player.bO > 0.0f && this.gL() && !this.gU()) {
            this.gW();
        }
    }

    public boolean n() {
        return this.gL() || this.gU();
    }

    @Override
    protected float f(EntityHuman player) {
        float f2 = player.cv() && this.c() == 0 ? 0.1f : 0.0f;
        return (float)this.i(GenericAttributes.w) + f2;
    }

    @Override
    protected Vec2F i(EntityLiving entity) {
        return this.n() ? new Vec2F(this.dZ(), this.dX()) : super.i(entity);
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return this.n() ? Vec3D.c : super.b(player, travelVector);
    }

    @Override
    public boolean a() {
        return !this.n() && super.a();
    }

    @Override
    public void b(int jumpPower) {
        if (this.am() && this.dc <= 0 && this.aS()) {
            super.b(jumpPower);
        }
    }

    @Override
    public boolean ea() {
        return true;
    }

    @Override
    protected void b(float playerJumpPendingScale, Vec3D travelVector) {
        double d2 = this.fw();
        this.l(this.cf().d(1.0, 0.0, 1.0).d().c((double)(22.2222f * playerJumpPendingScale) * this.i(GenericAttributes.w) * (double)this.be()).b(0.0, (double)(1.4285f * playerJumpPendingScale) * d2, 0.0));
        this.dc = 55;
        this.x(true);
        this.aF = true;
    }

    public boolean s() {
        return this.az.a(cx);
    }

    public void x(boolean dashing) {
        this.az.a(cx, dashing);
    }

    @Override
    public void c(int jumpPower) {
        this.b(SoundEffects.dD);
        this.c(GameEvent.u);
        this.x(true);
    }

    @Override
    public void b() {
    }

    @Override
    public int c() {
        return this.dc;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(this.an().purpurConfig.camelMaxHealthMin, this.an().purpurConfig.camelMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(this.an().purpurConfig.camelJumpStrengthMin, this.an().purpurConfig.camelJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(this.an().purpurConfig.camelMovementSpeedMin, this.an().purpurConfig.camelMovementSpeedMax);
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.dC;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.dF;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.dH;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        if (block.a(TagsBlock.bB)) {
            this.a(SoundEffects.dM, 1.0f, 1.0f);
        } else {
            this.a(SoundEffects.dL, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aO);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (player.gp() && !this.g_()) {
            this.b(player);
            return EnumInteractionResult.a;
        }
        EnumInteractionResult interactionResult = itemInHand.a(player, (EntityLiving)this, hand);
        if (interactionResult.a()) {
            return interactionResult;
        }
        if (this.i(itemInHand)) {
            return this.c(player, itemInHand);
        }
        if (this.di().size() < 2 && !this.g_()) {
            this.g(player);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public void z() {
        super.z();
        if (this.gL() && !this.gU() && this.gI()) {
            this.gW();
        }
    }

    @Override
    public Vec3D[] E() {
        return Leashable.a(this, 0.02, 0.48, 0.25, 0.82);
    }

    public boolean gI() {
        return this.g(this.gL() ? EntityPose.a : EntityPose.k);
    }

    @Override
    protected boolean a(EntityHuman player, ItemStack stack) {
        SoundEffect eatingSound;
        boolean isBaby;
        boolean flag1;
        boolean flag;
        if (!this.i(stack)) {
            return false;
        }
        boolean bl = flag = this.eU() < this.fj();
        if (flag) {
            this.heal(2.0f, EntityRegainHealthEvent.RegainReason.EATING);
        }
        boolean bl2 = flag1 = this.gZ() && this.aa_() == 0 && this.gP();
        if (flag1) {
            this.setInLove(player, stack.v());
        }
        if (isBaby = this.g_()) {
            this.an().a(Particles.R, this.e(1.0), this.dN() + 0.5, this.h(1.0), 0.0, 0.0, 0.0);
            if (!this.an().D_()) {
                this.b_(10);
            }
        }
        if (!(flag || flag1 || isBaby)) {
            return false;
        }
        if (!this.bm() && (eatingSound = this.gK()) != null) {
            this.an().a(null, this.dK(), this.dM(), this.dQ(), eatingSound, this.dw(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
        }
        this.c(GameEvent.m);
        return true;
    }

    @Override
    protected boolean gJ() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean a(EntityAnimal partner) {
        if (partner == this) return false;
        if (!(partner instanceof Camel)) return false;
        Camel camel = (Camel)partner;
        if (!this.hq()) return false;
        if (!camel.hq()) return false;
        return true;
    }

    @Nullable
    public Camel b(WorldServer level, EntityAgeable partner) {
        return EntityTypes.v.a(level, EntitySpawnReason.e);
    }

    @Override
    @Nullable
    protected SoundEffect gK() {
        return SoundEffects.dG;
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(level, damageSource, amount, event);
        if (!damageResult) {
            return false;
        }
        this.gX();
        return true;
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        int max = Math.max(this.di().indexOf(entity), 0);
        boolean flag = max == 0;
        float f2 = 0.5f;
        float f1 = (float)(this.ec() ? (double)0.01f : this.a(flag, 0.0f, dimensions, partialTick));
        if (this.di().size() > 1) {
            if (!flag) {
                f2 = -0.7f;
            }
            if (entity instanceof EntityAnimal) {
                f2 += 0.2f;
            }
        }
        return new Vec3D(0.0, f1, f2 * partialTick).b(-this.dX() * ((float)Math.PI / 180));
    }

    @Override
    public float ez() {
        return this.g_() ? 0.45f : 1.0f;
    }

    private double a(boolean firstPassenger, float partialTick, EntitySize dimensions, float scale) {
        double d2 = dimensions.b() - 0.375f * scale;
        float f2 = scale * 1.43f;
        float f1 = f2 - scale * 0.2f;
        float f22 = f2 - f1;
        boolean isInPoseTransition = this.gU();
        boolean isCamelSitting = this.gL();
        if (isInPoseTransition) {
            float f3;
            int i1;
            int i2;
            int n2 = i2 = isCamelSitting ? 40 : 52;
            if (isCamelSitting) {
                i1 = 28;
                f3 = firstPassenger ? 0.5f : 0.1f;
            } else {
                i1 = firstPassenger ? 24 : 32;
                f3 = firstPassenger ? 0.6f : 0.35f;
            }
            float f4 = MathHelper.a((float)this.gY() + partialTick, 0.0f, (float)i2);
            boolean flag = f4 < (float)i1;
            float f5 = flag ? f4 / (float)i1 : (f4 - (float)i1) / (float)(i2 - i1);
            float f6 = f2 - f3 * f1;
            d2 += isCamelSitting ? (double)MathHelper.h(f5, flag ? f2 : f6, flag ? f6 : f22) : (double)MathHelper.h(f5, flag ? f22 - f2 : f22 - f6, flag ? f22 - f6 : 0.0f);
        }
        if (isCamelSitting && !isInPoseTransition) {
            d2 += (double)f22;
        }
        return d2;
    }

    @Override
    public Vec3D a_(float partialTick) {
        EntitySize dimensions = this.a(this.aE());
        float ageScale = this.ez();
        return new Vec3D(0.0, this.a(true, partialTick, dimensions, ageScale) - (double)(0.2f * ageScale), dimensions.a() * 0.56f);
    }

    @Override
    public int ah() {
        return 30;
    }

    @Override
    protected boolean s(Entity passenger) {
        return this.di().size() <= 2;
    }

    public boolean gL() {
        return this.az.a(cy) < 0L;
    }

    public boolean gM() {
        return this.gY() < 0L != this.gL();
    }

    public boolean gU() {
        long poseTime = this.gY();
        return poseTime < (long)(this.gL() ? 40 : 52);
    }

    private boolean ht() {
        return this.gL() && this.gY() < 40L && this.gY() >= 0L;
    }

    public void gV() {
        if (!this.gL() && new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), true).callEvent()) {
            this.b(SoundEffects.dJ);
            this.c(EntityPose.k);
            this.c(GameEvent.u);
            this.a(-this.an().ag());
        }
    }

    public void gW() {
        if (this.gL() && new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), false).callEvent()) {
            this.b(SoundEffects.dK);
            this.c(EntityPose.a);
            this.c(GameEvent.u);
            this.a(this.an().ag());
        }
    }

    public void gX() {
        if (this.gL() && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), false).callEvent()) {
            return;
        }
        this.c(EntityPose.a);
        this.c(GameEvent.u);
        this.b(this.an().ag());
    }

    @VisibleForTesting
    public void a(long lastPoseChangeTick) {
        this.az.a(cy, lastPoseChangeTick);
    }

    private void b(long lastPoseChangedTick) {
        this.a(Math.max(0L, lastPoseChangedTick - 52L - 1L));
    }

    public long gY() {
        return this.an().ag() - Math.abs(this.az.a(cy));
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return slot == EnumItemSlot.h ? SoundEffects.dI : super.a(slot, stack, equippable);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (!this.ay && cx.equals(key)) {
            this.dc = this.dc == 0 ? 55 : this.dc;
        }
        super.a(key);
    }

    @Override
    public boolean gZ() {
        return true;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.an().D_()) {
            player.a(this, this.cK);
        }
    }

    @Override
    protected EntityAIBodyControl N() {
        return new a(this);
    }

    class c
    extends ControllerMove {
        public c() {
            super(Camel.this);
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b && !Camel.this.T_() && Camel.this.gL() && !Camel.this.gU() && Camel.this.gI()) {
                Camel.this.gW();
            }
            super.a();
        }
    }

    class b
    extends ControllerLook {
        b() {
            super(Camel.this);
        }

        @Override
        public void a() {
            if (!Camel.this.dh()) {
                super.a();
            }
        }
    }

    class a
    extends EntityAIBodyControl {
        public a(Camel mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (!Camel.this.n()) {
                super.a();
            }
        }
    }
}

