/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.coppergolem;

import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.animal.coppergolem.CopperGolemAi;
import net.minecraft.world.entity.animal.coppergolem.CopperGolemOxidationLevels;
import net.minecraft.world.entity.animal.coppergolem.CopperGolemState;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.CopperGolemStatueBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class CopperGolem
extends EntityGolem
implements ContainerUser,
IShearable {
    public static final long b = -2L;
    public static final long c = -1L;
    private static final int d = 504000;
    private static final int e = 552000;
    private static final int f = 200;
    private static final int ct = 240;
    private static final float cu = 10.0f;
    private static final float cv = 0.0058f;
    private static final int cw = 60;
    private static final int cx = 100;
    private static final DataWatcherObject<WeatheringCopper.a> cy = DataWatcher.a(CopperGolem.class, DataWatcherRegistry.G);
    private static final DataWatcherObject<CopperGolemState> cz = DataWatcher.a(CopperGolem.class, DataWatcherRegistry.H);
    @Nullable
    private BlockPosition cA;
    @Nullable
    private UUID cB;
    public long cC = -1L;
    private int cD = 0;
    private final AnimationState cE = new AnimationState();
    private final AnimationState cF = new AnimationState();
    private final AnimationState cG = new AnimationState();
    private final AnimationState cH = new AnimationState();
    private final AnimationState cI = new AnimationState();
    public static final EnumItemSlot a = EnumItemSlot.h;
    @Nullable
    private UUID summoner;

    public CopperGolem(EntityTypes<? extends EntityGolem> type, World level) {
        super(type, level);
        this.S().a(48.0f);
        this.S().e(true);
        this.gq();
        this.a(CopperGolemState.a);
        this.a(PathType.n, 16.0f);
        this.a(PathType.p, 16.0f);
        this.a(PathType.o, -1.0f);
        this.eq().a(MemoryModuleType.ae, Integer.valueOf(this.ek().b(60, 100)));
    }

    @Nullable
    public UUID getSummoner() {
        return this.summoner;
    }

    public void setSummoner(@Nullable UUID summoner) {
        this.summoner = summoner;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.copperGolemRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.copperGolemRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.copperGolemControllable;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.copperGolemMaxHealth);
        this.h(GenericAttributes.C).a(this.an().purpurConfig.copperGolemStepHeight);
        this.h(GenericAttributes.w).a(this.an().purpurConfig.copperGolemMovementSpeed);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.copperGolemScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.copperGolemTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.copperGolemAlwaysDropExp;
    }

    public static AttributeProvider.Builder k() {
        return EntityInsentient.I().a(GenericAttributes.w, 0.2f).a(GenericAttributes.C, 1.0).a(GenericAttributes.t, 12.0);
    }

    public CopperGolemState m() {
        return this.az.a(cz);
    }

    public void a(CopperGolemState state) {
        this.az.a(cz, state);
    }

    public WeatheringCopper.a n() {
        return this.az.a(cy);
    }

    public void a(WeatheringCopper.a weatherState) {
        this.az.a(cy, weatherState);
    }

    public void h(BlockPosition openedChestPos) {
        this.cA = openedChestPos;
    }

    public void s() {
        this.cA = null;
    }

    public AnimationState gI() {
        return this.cE;
    }

    public AnimationState gJ() {
        return this.cF;
    }

    public AnimationState gK() {
        return this.cG;
    }

    public AnimationState gL() {
        return this.cH;
    }

    public AnimationState gM() {
        return this.cI;
    }

    protected BehaviorController.b<CopperGolem> er() {
        return CopperGolemAi.a();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return CopperGolemAi.a(this.er().a(dynamic));
    }

    public BehaviorController<CopperGolem> eq() {
        return super.eq();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cy, WeatheringCopper.a.a);
        builder.a(cz, CopperGolemState.a);
    }

    @Override
    public void a(ValueOutput output) {
        super.a(output);
        output.a("next_weather_age", this.cC);
        output.a("weather_state", WeatheringCopper.a.f, this.n());
        output.b("Purpur.Summoner", UUIDUtil.a, this.getSummoner());
    }

    @Override
    public void a(ValueInput input) {
        super.a(input);
        this.cC = input.a("next_weather_age", -1L);
        this.a(input.a("weather_state", WeatheringCopper.a.f).orElse(WeatheringCopper.a.a));
        this.setSummoner(input.a("Purpur.Summoner", UUIDUtil.a).orElse(null));
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("copperGolemBrain");
        if (this.getRider() == null || !this.isControllable()) {
            this.eq().a(level, this);
        }
        profilerFiller.c();
        profilerFiller.a("copperGolemActivityUpdate");
        CopperGolemAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public void g() {
        super.g();
        if (this.an().D_()) {
            if (!this.gx()) {
                this.gO();
            }
        } else {
            this.a((WorldServer)this.an(), this.an().I_(), this.an().ag());
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        WeatheringCopper.a weatherState;
        ItemStack mainHandItem;
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.f() && !(mainHandItem = this.fq()).f()) {
            BehaviorUtil.a((EntityLiving)this, mainHandItem, player.dD());
            this.a(EnumHand.a, ItemStack.l);
            return EnumInteractionResult.a;
        }
        World level = this.an();
        if (itemInHand.a(Items.tZ) && this.a()) {
            if (level instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)level;
                List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return this.tryRide(player, hand);
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(serverLevel, SoundCategory.h, itemInHand, drops);
                this.a(GameEvent.M, (Entity)player);
                itemInHand.a(1, (EntityLiving)player, hand);
            }
            return EnumInteractionResult.a;
        }
        if (level.D_()) {
            return EnumInteractionResult.e;
        }
        if (itemInHand.a(Items.yO) && this.cC != -2L) {
            level.a((Entity)this, 3003, this.dF(), 0);
            this.cC = -2L;
            this.a(player, hand, itemInHand);
            return EnumInteractionResult.b;
        }
        if (itemInHand.a(TagsItem.bW) && this.cC == -2L) {
            level.a(null, this, SoundEffects.aJ, this.dw(), 1.0f, 1.0f);
            level.a((Entity)this, 3004, this.dF(), 0);
            this.cC = -1L;
            itemInHand.a(1, (EntityLiving)player, hand.a());
            return EnumInteractionResult.b;
        }
        if (itemInHand.a(TagsItem.bW) && (weatherState = this.n()) != WeatheringCopper.a.a) {
            level.a(null, this, SoundEffects.aJ, this.dw(), 1.0f, 1.0f);
            level.a((Entity)this, 3005, this.dF(), 0);
            this.cC = -1L;
            this.az.a(cy, weatherState.b(), true);
            itemInHand.a(1, (EntityLiving)player, hand.a());
            return EnumInteractionResult.b;
        }
        if (this.an().purpurConfig.villagerRidable && itemInHand.f()) {
            return this.tryRide(player, hand);
        }
        return super.b(player, hand);
    }

    private void a(WorldServer level, RandomSource random, long gameTime) {
        if (this.cC != -2L) {
            if (this.cC == -1L) {
                this.cC = gameTime + (long)random.a(504000, 552000);
            } else {
                WeatheringCopper.a weatherState = this.az.a(cy);
                boolean flag = weatherState.equals(WeatheringCopper.a.d);
                if (gameTime >= this.cC && !flag) {
                    WeatheringCopper.a weatherState1 = weatherState.a();
                    boolean flag1 = weatherState1.equals(WeatheringCopper.a.d);
                    this.a(weatherState1);
                    long l2 = this.cC = flag1 ? 0L : this.cC + (long)random.a(504000, 552000);
                }
                if (flag && this.c((World)level)) {
                    this.h(level);
                }
            }
        }
    }

    private boolean c(World level) {
        return level.a_(this.dF()).a(Blocks.a) && level.z.i() <= 0.0058f;
    }

    private void h(WorldServer level) {
        IBlockData newState;
        BlockPosition blockPos = this.dF();
        if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockPos, newState = (IBlockData)((IBlockData)Blocks.tD.m().b(CopperGolemStatueBlock.c, CopperGolemStatueBlock.a.values()[this.as.b(0, CopperGolemStatueBlock.a.values().length)])).b(CopperGolemStatueBlock.b, EnumDirection.a(this.dX())))) {
            return;
        }
        level.a(blockPos, newState, 3);
        TileEntity tileEntity = level.c_(blockPos);
        if (tileEntity instanceof CopperGolemStatueBlockEntity) {
            CopperGolemStatueBlockEntity copperGolemStatueBlockEntity = (CopperGolemStatueBlockEntity)tileEntity;
            copperGolemStatueBlockEntity.a(this);
            this.b(level);
            this.discard(null);
            this.a(SoundEffects.gq);
            if (this.T_()) {
                if (level.S().c(GameRules.j)) {
                    this.w();
                } else {
                    this.x();
                }
            }
        }
    }

    private void gO() {
        switch (this.m()) {
            case a: {
                this.cG.a();
                this.cF.a();
                this.cH.a();
                this.cI.a();
                if (this.cD == this.at) {
                    this.cE.a(this.at);
                } else if (this.cD == 0) {
                    this.cD = this.at + this.as.b(200, 240);
                }
                if ((float)this.at != (float)this.cD + 10.0f) break;
                this.gP();
                this.cD = 0;
                break;
            }
            case b: {
                this.cE.a();
                this.cD = 0;
                this.cG.a();
                this.cH.a();
                this.cI.a();
                this.cF.b(this.at);
                break;
            }
            case c: {
                this.cE.a();
                this.cD = 0;
                this.cF.a();
                this.cI.a();
                this.cH.a();
                this.cG.b(this.at);
                break;
            }
            case d: {
                this.cE.a();
                this.cD = 0;
                this.cF.a();
                this.cG.a();
                this.cI.a();
                this.cH.b(this.at);
                break;
            }
            case e: {
                this.cE.a();
                this.cD = 0;
                this.cF.a();
                this.cG.a();
                this.cH.a();
                this.cI.b(this.at);
            }
        }
    }

    public void b(WeatheringCopper.a weatherState) {
        this.a(weatherState);
        this.gN();
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.gN();
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public void gN() {
        this.a(SoundEffects.gw);
    }

    private void gP() {
        if (!this.bm()) {
            this.an().a(this.dK(), this.dM(), this.dQ(), this.gQ(), this.dw(), 1.0f, 1.0f, false);
        }
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return CopperGolemOxidationLevels.a(this.n()).b();
    }

    @Override
    public SoundEffect f_() {
        return CopperGolemOxidationLevels.a(this.n()).c();
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(CopperGolemOxidationLevels.a(this.n()).d(), 1.0f, 1.0f);
    }

    private SoundEffect gQ() {
        return CopperGolemOxidationLevels.a(this.n()).a();
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.75f * this.df(), 0.0);
    }

    @Override
    public boolean a(ContainerOpenersCounter openersCounter, BlockPosition pos) {
        if (this.cA == null) {
            return false;
        }
        IBlockData blockState = this.an().a_(this.cA);
        return this.cA.equals(pos) || blockState.b() instanceof BlockChest && blockState.c(BlockChest.d) != BlockPropertyChestType.a && BlockChest.b(this.cA, blockState).equals(pos);
    }

    @Override
    public double aq() {
        return 3.0;
    }

    @Override
    public void shear(WorldServer level, SoundCategory source, ItemStack shears, List<ItemStack> drops) {
        level.a(null, this, SoundEffects.gx, source, 1.0f, 1.0f);
        this.a(a, ItemStack.l);
        for (ItemStack drop : drops) {
            this.forceDrops = true;
            this.a(level, drop, 1.5f);
            this.forceDrops = false;
        }
    }

    @Override
    public void a(WorldServer level, SoundCategory source, ItemStack shears) {
        this.shear(level, source, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer serverLevel, ItemStack shears) {
        if (!this.a()) {
            return Collections.emptyList();
        }
        ObjectArrayList drops = new ObjectArrayList(1);
        drops.add(this.a(a).v());
        return drops;
    }

    @Override
    public boolean a() {
        return this.bX() && this.a(a).a(TagsItem.cm);
    }

    @Override
    protected void g(WorldServer level) {
        super.g(level);
        this.b(level);
    }

    @Override
    protected boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(level, damageSource, amount, event);
        if (!damageResult) {
            return false;
        }
        this.a(CopperGolemState.a);
        return true;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        super.a(level, lightning);
        UUID uuid = lightning.cT();
        if (!uuid.equals(this.cB)) {
            this.cB = uuid;
            WeatheringCopper.a weatherState = this.n();
            if (weatherState != WeatheringCopper.a.a) {
                this.cC = -1L;
                this.az.a(cy, weatherState.b(), true);
            }
        }
    }
}

