/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.frog.FrogAi;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.frog.FrogVariants;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.controller.MoveControllerWASD;
import org.purpurmc.purpur.controller.WaterMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class Frog
extends EntityAnimal {
    protected static final ImmutableList<SensorType<? extends Sensor<? super Frog>>> ct = ImmutableList.of(SensorType.c, SensorType.f, SensorType.x, SensorType.t, SensorType.y);
    protected static final ImmutableList<MemoryModuleType<?>> cu = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.s, MemoryModuleType.T, MemoryModuleType.U, MemoryModuleType.p, MemoryModuleType.P, MemoryModuleType.Q, (Object[])new MemoryModuleType[]{MemoryModuleType.S, MemoryModuleType.y, MemoryModuleType.z, MemoryModuleType.C, MemoryModuleType.Y, MemoryModuleType.Z, MemoryModuleType.aa, MemoryModuleType.ab});
    private static final DataWatcherObject<Holder<FrogVariant>> cA = DataWatcher.a(Frog.class, DataWatcherRegistry.B);
    private static final DataWatcherObject<OptionalInt> cB = DataWatcher.a(Frog.class, DataWatcherRegistry.u);
    private static final int cC = 5;
    private static final ResourceKey<FrogVariant> cD = FrogVariants.a;
    public final AnimationState cv = new AnimationState();
    public final AnimationState cx = new AnimationState();
    public final AnimationState cy = new AnimationState();
    public final AnimationState cz = new AnimationState();
    private MoveControllerWASD purpurLandController;
    private WaterMoveControllerWASD purpurWaterController;

    public Frog(EntityTypes<? extends EntityAnimal> type, World level) {
        super(type, level);
        this.cm = new a(this);
        this.a(PathType.j, 4.0f);
        this.a(PathType.e, -1.0f);
        this.cn = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
        this.purpurLandController = new MoveControllerWASD(this, 0.2f);
        this.purpurWaterController = new WaterMoveControllerWASD(this, 0.5);
        this.cn = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true){

            @Override
            public void a() {
                EntityHuman rider = this.d.getRider();
                if (rider != null && this.d.isControllable()) {
                    if (this.d.bu()) {
                        Frog.this.purpurWaterController.purpurTick(rider);
                        this.d.k(this.d.dI().b(0.0, -0.005, 0.0));
                    } else {
                        Frog.this.purpurLandController.purpurTick(rider);
                    }
                } else {
                    super.a();
                }
            }
        };
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.frogRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.frogRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.frogControllable;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        this.cr.a(0, new HasRider(this));
    }

    @Override
    public float fw() {
        return this.getRider() != null && this.isControllable() ? this.an().purpurConfig.frogRidableJumpHeight * this.bd() : super.fw();
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.frogBreedingTicks;
    }

    protected BehaviorController.b<Frog> er() {
        return BehaviorController.a(cu, ct);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return FrogAi.a(this.er().a(dynamic));
    }

    public BehaviorController<Frog> eq() {
        return super.eq();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        IRegistry<FrogVariant> registry = this.ej().f(Registries.bb);
        builder.a(cA, VariantUtils.a(this.ej(), cD));
        builder.a(cB, OptionalInt.empty());
    }

    public void m() {
        this.az.a(cB, OptionalInt.empty());
    }

    public Optional<Entity> n() {
        return this.az.a(cB).stream().mapToObj(this.an()::a).filter(Objects::nonNull).findFirst();
    }

    public void G(Entity tongueTarget) {
        this.az.a(cB, OptionalInt.of(tongueTarget.az()));
    }

    @Override
    public int aj() {
        return 35;
    }

    @Override
    public int ah() {
        return 5;
    }

    public Holder<FrogVariant> s() {
        return this.az.a(cA);
    }

    public void b(Holder<FrogVariant> variant) {
        this.az.a(cA, variant);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aK ? Frog.c(component, this.s()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aK);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aK) {
            this.b(Frog.c(DataComponents.aK, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        VariantUtils.a(output, this.s());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        VariantUtils.a(input, Registries.bb).ifPresent(this::b);
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("frogBrain");
        if (this.getRider() == null || !this.isControllable()) {
            this.eq().a(level, this);
        }
        profilerFiller.c();
        profilerFiller.a("frogActivityUpdate");
        FrogAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public void g() {
        if (this.an().D_()) {
            this.cz.a(this.bu() && !this.bz.d(), this.at);
        }
        super.g();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (Entity.aE.equals(key)) {
            EntityPose pose = this.aE();
            if (pose == EntityPose.g) {
                this.cv.a(this.at);
            } else {
                this.cv.a();
            }
            if (pose == EntityPose.i) {
                this.cx.a(this.at);
            } else {
                this.cx.a();
            }
            if (pose == EntityPose.j) {
                this.cy.a(this.at);
            } else {
                this.cy.a();
            }
        }
        super.a(key);
    }

    @Override
    protected void A(float partialTick) {
        float f2 = this.cv.b() ? 0.0f : Math.min(partialTick * 25.0f, 1.0f);
        this.bz.a(f2, 0.4f, this.g_() ? 3.0f : 1.0f);
    }

    @Override
    public void gO() {
        this.an().a(null, this, SoundEffects.lf, SoundCategory.g, 2.0f, 1.0f);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        Frog frog = EntityTypes.ae.a(level, EntitySpawnReason.e);
        if (frog != null) {
            FrogAi.a(frog, level.I_());
        }
        return frog;
    }

    @Override
    public boolean g_() {
        return false;
    }

    @Override
    public void a(boolean baby) {
    }

    @Override
    public void a(WorldServer level, EntityAnimal partner) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, partner);
        if (result.isCancelled()) {
            return;
        }
        this.finalizeSpawnChildFromBreeding(level, partner, null, result.getExperience());
        this.eq().a(MemoryModuleType.Z, Unit.a);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        VariantUtils.a(SpawnContext.a(level, this.dF()), Registries.bb).ifPresent(this::b);
        FrogAi.a(this, level.I_());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static AttributeProvider.Builder gI() {
        return EntityAnimal.gN().a(GenericAttributes.w, 1.0).a(GenericAttributes.t, 10.0).a(GenericAttributes.c, 10.0).a(GenericAttributes.C, 1.0);
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return SoundEffects.ld;
    }

    @Override
    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.lg;
    }

    @Override
    @Nullable
    public SoundEffect f_() {
        return SoundEffects.le;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.lj, 0.15f, 1.0f);
    }

    @Override
    public boolean cW() {
        return false;
    }

    @Override
    protected int a(double fallDistance, float damageMultiplier) {
        return super.a(fallDistance, damageMultiplier) - 5;
    }

    @Override
    public void m(Vec3D travelVector) {
        if (this.bu()) {
            this.a(this.fD(), travelVector);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c(0.9));
        } else {
            super.m(travelVector);
        }
    }

    public static boolean i(EntityLiving entity) {
        EntitySlime slime;
        return (!(entity instanceof EntitySlime) || (slime = (EntitySlime)entity).gI() == 1) && entity.ax().a(TagsEntity.n);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new c(this, level);
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.U();
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aR);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cu) && Frog.a(level, pos);
    }

    class a
    extends LookControllerWASD {
        a(EntityInsentient mob) {
            super(mob);
        }

        @Override
        protected boolean c() {
            return Frog.this.n().isEmpty();
        }
    }

    static class c
    extends AmphibiousPathNavigation {
        c(Frog mob, World level) {
            super(mob, level);
        }

        @Override
        public boolean b(PathType pathType) {
            return pathType != PathType.k && super.b(pathType);
        }

        @Override
        protected Pathfinder a(int maxVisitedNodes) {
            this.o = new b(true);
            return new Pathfinder(this.o, maxVisitedNodes);
        }
    }

    static class b
    extends AmphibiousNodeEvaluator {
        private final BlockPosition.MutableBlockPosition a = new BlockPosition.MutableBlockPosition();

        public b(boolean prefersShallowSwimming) {
            super(prefersShallowSwimming);
        }

        @Override
        public PathPoint a() {
            return !this.c.bu() ? super.a() : this.c(new BlockPosition(MathHelper.a(this.c.de().a), MathHelper.a(this.c.de().b), MathHelper.a(this.c.de().c)));
        }

        @Override
        public PathType a(PathfindingContext context, int x2, int y2, int z2) {
            this.a.d(x2, y2 - 1, z2);
            IBlockData blockState = context.a(this.a);
            return blockState.a(TagsBlock.cf) ? PathType.b : super.a(context, x2, y2, z2);
        }
    }
}

