/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.TadpoleAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.purpurmc.purpur.controller.WaterMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class Tadpole
extends EntityFish {
    private static final int ct = 0;
    @VisibleForTesting
    public static int a = Math.abs(-24000);
    public static final float b = 0.4f;
    public static final float c = 0.3f;
    public int cu = 0;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Tadpole>>> e = ImmutableList.of(SensorType.c, SensorType.d, SensorType.f, SensorType.t);
    protected static final ImmutableList<MemoryModuleType<?>> f = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.h, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.L, MemoryModuleType.Q, MemoryModuleType.S, MemoryModuleType.P, MemoryModuleType.s, MemoryModuleType.aa);
    public boolean ageLocked;
    private WaterMoveControllerWASD purpurController = new WaterMoveControllerWASD(this, 0.5);

    public Tadpole(EntityTypes<? extends EntityFish> type, World level) {
        super(type, level);
        this.cn = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true){

            @Override
            public void a() {
                EntityHuman rider = this.d.getRider();
                if (rider != null && this.d.isControllable()) {
                    Tadpole.this.purpurController.purpurTick(rider);
                    this.d.k(this.d.dI().b(0.0, 0.002, 0.0));
                } else {
                    super.a();
                }
            }
        };
        this.cm = new SmoothSwimmingLookControl(this, 10);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.tadpoleRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.tadpoleRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.tadpoleControllable;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new NavigationGuardian(this, level);
    }

    protected BehaviorController.b<Tadpole> er() {
        return BehaviorController.a(f, e);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return TadpoleAi.a(this.er().a(dynamic));
    }

    public BehaviorController<Tadpole> eq() {
        return super.eq();
    }

    @Override
    protected SoundEffect gI() {
        return SoundEffects.BN;
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("tadpoleBrain");
        if (this.getRider() == null || !this.isControllable()) {
            this.eq().a(level, this);
        }
        profilerFiller.c();
        profilerFiller.a("tadpoleActivityUpdate");
        TadpoleAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    public static AttributeProvider.Builder gJ() {
        return EntityAnimal.gN().a(GenericAttributes.w, 1.0).a(GenericAttributes.t, 6.0);
    }

    @Override
    public void e_() {
        super.e_();
        if (!this.an().D_() && !this.ageLocked) {
            this.c(this.cu + 1);
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Age", this.cu);
        output.a("AgeLocked", this.ageLocked);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.c(input.a("Age", 0));
        this.ageLocked = input.a("AgeLocked", false);
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return null;
    }

    @Override
    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.BP;
    }

    @Override
    @Nullable
    public SoundEffect f_() {
        return SoundEffects.BM;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (this.j(itemInHand)) {
            this.a(player, itemInHand);
            return EnumInteractionResult.a;
        }
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    public boolean m() {
        return true;
    }

    @Override
    public void x(boolean fromBucket) {
    }

    @Override
    public void a_(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        CustomData.a(DataComponents.Z, stack, (NBTTagCompound compoundTag) -> {
            compoundTag.a("Age", this.gK());
            compoundTag.a("AgeLocked", this.ageLocked);
        });
    }

    @Override
    public void a(NBTTagCompound tag) {
        Bucketable.a((EntityInsentient)this, tag);
        tag.e("Age").ifPresent(this::c);
        this.ageLocked = tag.b("AgeLocked", false);
    }

    @Override
    public ItemStack a() {
        return new ItemStack(Items.sw);
    }

    @Override
    public SoundEffect n() {
        return SoundEffects.dp;
    }

    private boolean j(ItemStack stack) {
        return stack.a(TagsItem.aR);
    }

    private void a(EntityHuman player, ItemStack stack) {
        this.b(player, stack);
        this.b(EntityAgeable.d_(this.gM()));
        this.an().a(Particles.R, this.e(1.0), this.dN() + 0.5, this.h(1.0), 0.0, 0.0, 0.0);
    }

    private void b(EntityHuman player, ItemStack stack) {
        stack.a(1, (EntityLiving)player);
    }

    private int gK() {
        return this.cu;
    }

    private void b(int offset) {
        if (this.ageLocked) {
            return;
        }
        this.c(this.cu + offset * 20);
    }

    private void c(int age) {
        this.cu = age;
        if (this.cu >= a) {
            this.gL();
        }
    }

    private void gL() {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Frog converted = this.convertTo(EntityTypes.ae, ConversionParams.a(this, false, false), (T mob) -> {
                mob.a((WorldAccess)serverLevel, this.an().d_(mob.dF()), EntitySpawnReason.i, null);
                mob.gq();
                mob.a(this.a(this.aE()));
                this.a(SoundEffects.BO, 0.15f, 1.0f);
            }, EntityTransformEvent.TransformReason.METAMORPHOSIS, CreatureSpawnEvent.SpawnReason.METAMORPHOSIS);
            if (converted == null) {
                this.c(0);
            }
        }
    }

    private int gM() {
        return Math.max(0, a - this.cu);
    }

    @Override
    public boolean eD() {
        return false;
    }
}

