/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.purpurmc.purpur.event.entity.GoatRamEntityEvent;

public class Goat
extends EntityAnimal {
    public static final EntitySize ct = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int cA = 2;
    private static final int cB = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> cu = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.o, SensorType.f, SensorType.s);
    protected static final ImmutableList<MemoryModuleType<?>> cv = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.h, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.az, MemoryModuleType.s, MemoryModuleType.T, MemoryModuleType.U, MemoryModuleType.P, MemoryModuleType.L, MemoryModuleType.Q, (Object[])new MemoryModuleType[]{MemoryModuleType.S, MemoryModuleType.W, MemoryModuleType.X, MemoryModuleType.aa});
    public static final int cx = 10;
    public static final double cy = 0.02;
    public static final double cz = (double)0.1f;
    private static final DataWatcherObject<Boolean> cC = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cD = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cE = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private static final boolean cF = false;
    private static final boolean cG = true;
    private static final boolean cH = true;
    private boolean cI;
    private int cJ;

    public Goat(EntityTypes<? extends Goat> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.S().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack m() {
        RandomSource randomSource = RandomSource.a(this.cT().hashCode());
        TagKey<Instrument> tagKey = this.gU() ? InstrumentTags.b : InstrumentTags.a;
        return this.an().L_().f(Registries.bc).a(tagKey, randomSource).map(holder -> InstrumentItem.a(Items.yv, holder)).orElseGet(() -> new ItemStack(Items.yv));
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.goatRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.goatRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.goatControllable;
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.goatBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.goatTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.goatAlwaysDropExp;
    }

    protected BehaviorController.b<Goat> er() {
        return BehaviorController.a(cv, cu);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.er().a(dynamic));
    }

    public static AttributeProvider.Builder n() {
        return EntityAnimal.gN().a(GenericAttributes.t, 10.0).a(GenericAttributes.w, 0.2f).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected void h() {
        if (this.g_()) {
            this.h(GenericAttributes.c).a(1.0);
            this.gM();
        } else {
            this.h(GenericAttributes.c).a(2.0);
            this.gL();
        }
    }

    @Override
    protected int a(double fallDistance, float damageMultiplier) {
        return super.a(fallDistance, damageMultiplier) - 10;
    }

    @Override
    public SoundEffect p() {
        return this.gU() ? SoundEffects.mp : SoundEffects.mg;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.gU() ? SoundEffects.ms : SoundEffects.mj;
    }

    @Override
    public SoundEffect f_() {
        return this.gU() ? SoundEffects.mq : SoundEffects.mh;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.mx, 0.15f, 1.0f);
    }

    protected SoundEffect s() {
        return this.gU() ? SoundEffects.mu : SoundEffects.ml;
    }

    @Nullable
    public Goat b(WorldServer level, EntityAgeable partner) {
        Goat goat = EntityTypes.al.a(level, EntitySpawnReason.e);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, level.I_());
            EntityAgeable ageableMob = level.I_().h() ? this : partner;
            boolean flag = ageableMob instanceof Goat && ((Goat)(goat1 = ageableMob)).gU() || level.I_().j() < 0.02;
            goat.x(flag);
        }
        return goat;
    }

    public BehaviorController<Goat> eq() {
        return super.eq();
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("goatBrain");
        if (this.getRider() == null || !this.isControllable()) {
            this.eq().a(level, this);
        }
        profilerFiller.c();
        profilerFiller.a("goatActivityUpdate");
        GoatAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public int ah() {
        return 15;
    }

    @Override
    public void r(float rotation) {
        int maxHeadYRot = this.ah();
        float f2 = MathHelper.c(this.bB, rotation);
        float f1 = MathHelper.a(f2, (float)(-maxHeadYRot), (float)maxHeadYRot);
        super.r(this.bB + f1);
    }

    @Override
    protected void gO() {
        this.an().a(null, this, this.gU() ? SoundEffects.mr : SoundEffects.mi, SoundCategory.g, 1.0f, MathHelper.b(this.an().z, 0.8f, 1.2f));
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aF);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.sk) && !this.g_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent(player.an(), player, this.dF(), this.dF(), null, itemInHand, Items.sq, hand);
            if (event.isCancelled()) {
                player.cl.b();
                return EnumInteractionResult.e;
            }
            player.a(this.s(), 1.0f, 1.0f);
            ItemStack itemStack = ItemLiquidUtil.a(itemInHand, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemStack);
            return EnumInteractionResult.a;
        }
        boolean isFood = this.i(itemInHand);
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a() && isFood) {
            this.gO();
        }
        return interactionResult;
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.I_();
        GoatAi.a(this, random);
        this.x(random.j() < 0.02);
        this.h();
        if (!this.g_() && random.i() < 0.1f) {
            DataWatcherObject<Boolean> entityDataAccessor = random.h() ? cD : cE;
            this.az.a(entityDataAccessor, false);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return pose == EntityPose.g ? ct.a(this.ez()) : super.b(pose);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("IsScreamingGoat", this.gU());
        output.a("HasLeftHorn", this.gI());
        output.a("HasRightHorn", this.gJ());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a("IsScreamingGoat", false));
        this.az.a(cD, input.a("HasLeftHorn", true));
        this.az.a(cE, input.a("HasRightHorn", true));
    }

    @Override
    public void b(byte id) {
        if (id == 58) {
            this.cI = true;
        } else if (id == 59) {
            this.cI = false;
        } else {
            super.b(id);
        }
    }

    @Override
    public void e_() {
        this.cJ = this.cI ? ++this.cJ : (this.cJ -= 2);
        this.cJ = MathHelper.a(this.cJ, 0, 20);
        super.e_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cC, false);
        builder.a(cD, true);
        builder.a(cE, true);
    }

    public boolean gI() {
        return this.az.a(cD);
    }

    public boolean gJ() {
        return this.az.a(cE);
    }

    public boolean gK() {
        boolean hasLeftHorn = this.gI();
        boolean hasRightHorn = this.gJ();
        if (!hasLeftHorn && !hasRightHorn) {
            return false;
        }
        DataWatcherObject<Boolean> entityDataAccessor = !hasLeftHorn ? cE : (!hasRightHorn ? cD : (this.as.h() ? cD : cE));
        this.az.a(entityDataAccessor, false);
        Vec3D vec3 = this.dD();
        ItemStack itemStack = this.m();
        double d2 = MathHelper.b(this.as, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.as, 0.3f, 0.7f);
        double d22 = MathHelper.b(this.as, -0.2f, 0.2f);
        EntityItem itemEntity = new EntityItem(this.an(), vec3.a(), vec3.b(), vec3.c(), itemStack, d2, d1, d22);
        return this.spawnAtLocation((WorldServer)this.an(), itemEntity) != null;
    }

    public void gL() {
        this.az.a(cD, true);
        this.az.a(cE, true);
    }

    public void gM() {
        this.az.a(cD, false);
        this.az.a(cE, false);
    }

    public boolean gU() {
        return this.az.a(cC);
    }

    public void x(boolean isScreamingGoat) {
        this.az.a(cC, isScreamingGoat);
    }

    public float gV() {
        return (float)this.cJ / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cn) && Goat.a(level, pos);
    }

    public void ram(EntityLiving entity) {
        if (!new GoatRamEntityEvent((org.bukkit.entity.Goat)this.getBukkitEntity(), (LivingEntity)entity.getBukkitLivingEntity()).callEvent()) {
            return;
        }
        BehaviorController<Goat> brain = this.eq();
        brain.a(MemoryModuleType.X, entity.dD());
        brain.b(MemoryModuleType.W);
        brain.b(MemoryModuleType.s);
        brain.b(MemoryModuleType.P);
        brain.a(Activity.r);
    }
}

