/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.HorseColor;
import net.minecraft.world.entity.animal.horse.HorseStyle;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class EntityHorse
extends EntityHorseAbstract {
    private static final DataWatcherObject<Integer> ct = DataWatcher.a(EntityHorse.class, DataWatcherRegistry.b);
    private static final EntitySize cu = EntityTypes.ap.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.ap.m() + 0.125f, 0.0f)).a(0.5f);
    private static final int cv = 0;

    public EntityHorse(EntityTypes<? extends EntityHorse> type, World level) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, level);
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.horseRidableInWater;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(this.an().purpurConfig.horseMaxHealthMin, this.an().purpurConfig.horseMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(this.an().purpurConfig.horseJumpStrengthMin, this.an().purpurConfig.horseJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(this.an().purpurConfig.horseMovementSpeedMin, this.an().purpurConfig.horseMovementSpeedMax);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.horseBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.horseTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.horseAlwaysDropExp;
    }

    @Override
    protected void a(RandomSource random) {
        this.h(GenericAttributes.t).a(EntityHorse.a(random::a));
        this.h(GenericAttributes.w).a(EntityHorse.b(random::j));
        this.h(GenericAttributes.p).a(EntityHorse.a(random::j));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ct, 0);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Variant", this.s());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a("Variant", 0));
    }

    private void x(int typeVariant) {
        this.az.a(ct, typeVariant);
    }

    private int s() {
        return this.az.a(ct);
    }

    public void a(HorseColor variant, HorseStyle marking) {
        this.x(variant.a() & 0xFF | marking.a() << 8 & 0xFF00);
    }

    public HorseColor m() {
        return HorseColor.a(this.s() & 0xFF);
    }

    private void a(HorseColor variant) {
        this.x(variant.a() & 0xFF | this.s() & 0xFFFFFF00);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aL ? EntityHorse.c(component, this.m()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aL);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aL) {
            this.a(EntityHorse.c(DataComponents.aL, value));
            return true;
        }
        return super.b(component, value);
    }

    public HorseStyle n() {
        return HorseStyle.a((this.s() & 0xFF00) >> 8);
    }

    @Override
    protected void a(SoundEffectType soundType) {
        super.a(soundType);
        if (this.as.a(10) == 0) {
            this.a(SoundEffects.om, soundType.a() * 0.6f, soundType.b());
        }
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.oi;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.on;
    }

    @Override
    @Nullable
    protected SoundEffect gK() {
        return SoundEffects.oo;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.oq;
    }

    @Override
    protected SoundEffect hh() {
        return SoundEffects.oj;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag;
        boolean bl = flag = !this.g_() && this.gZ() && player.gp();
        if (!this.cm() && !flag) {
            ItemStack itemInHand = player.b(hand);
            if (!itemInHand.f()) {
                if (this.i(itemInHand)) {
                    return this.c(player, itemInHand);
                }
                if (!this.gZ()) {
                    this.ho();
                    return EnumInteractionResult.a;
                }
            }
            return super.b(player, hand);
        }
        return super.b(player, hand);
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return otherAnimal != this && (otherAnimal instanceof EntityHorseDonkey || otherAnimal instanceof EntityHorse) && this.hq() && ((EntityHorseAbstract)otherAnimal).hq();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        if (partner instanceof EntityHorseDonkey) {
            EntityHorseMule mule = EntityTypes.aK.a(level, EntitySpawnReason.e);
            if (mule != null) {
                this.a(partner, mule);
            }
            return mule;
        }
        EntityHorse horse = (EntityHorse)partner;
        EntityHorse horse1 = EntityTypes.ap.a(level, EntitySpawnReason.e);
        if (horse1 != null) {
            int randomInt = this.as.a(9);
            HorseColor variant = randomInt < 4 ? this.m() : (randomInt < 8 ? horse.m() : SystemUtils.a(HorseColor.values(), this.as));
            int randomInt1 = this.as.a(5);
            HorseStyle markings = randomInt1 < 2 ? this.n() : (randomInt1 < 4 ? horse.n() : SystemUtils.a(HorseStyle.values(), this.as));
            horse1.a(variant, markings);
            this.a(partner, horse1);
        }
        return horse1;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return true;
    }

    @Override
    protected void c(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.g);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        HorseColor variant;
        RandomSource random = level.I_();
        if (spawnGroupData instanceof a) {
            variant = ((a)spawnGroupData).a;
        } else {
            variant = SystemUtils.a(HorseColor.values(), random);
            spawnGroupData = new a(variant);
        }
        this.a(variant, SystemUtils.a(HorseStyle.values(), random));
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.g_() ? cu : super.b(pose);
    }

    public static class a
    extends EntityAgeable.a {
        public final HorseColor a;

        public a(HorseColor variant) {
            super(true);
            this.a = variant;
        }
    }
}

