/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.InventoryHolder;
import org.purpurmc.purpur.entity.ai.HorseHasRider;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements HasCustomInventoryScreen,
OwnableEntity,
IJumpable {
    public static final int cE = 499;
    public static final int cF = 500;
    public static final double cG = 0.15;
    private static final float ct = (float)EntityHorseAbstract.b(() -> 0.0);
    private static final float cu = (float)EntityHorseAbstract.b(() -> 1.0);
    private static final float cv = (float)EntityHorseAbstract.a(() -> 0.0);
    private static final float cx = (float)EntityHorseAbstract.a(() -> 1.0);
    private static final float cy = EntityHorseAbstract.a((int i2) -> 0);
    private static final float cz = EntityHorseAbstract.a((int i2) -> i2 - 1);
    private static final float cA = 0.25f;
    private static final float cB = 0.5f;
    private static final PathfinderTargetCondition.a cC = (entity, level) -> {
        EntityHorseAbstract abstractHorse;
        return entity instanceof EntityHorseAbstract && (abstractHorse = (EntityHorseAbstract)entity).hd();
    };
    private static final PathfinderTargetCondition cD = PathfinderTargetCondition.b().a(16.0).d().a(cC);
    private static final DataWatcherObject<Byte> cS = DataWatcher.a(EntityHorseAbstract.class, DataWatcherRegistry.a);
    private static final int cT = 2;
    private static final int cU = 8;
    private static final int cV = 16;
    private static final int cW = 32;
    private static final int cX = 64;
    public static final int cH = 3;
    private static final int cY = 0;
    private static final boolean cZ = false;
    private static final boolean da = false;
    private static final boolean db = false;
    private int dc;
    private int dd;
    private int de;
    public int cI;
    public int cJ;
    public InventorySubcontainer cK;
    protected int cL = 0;
    protected float cM;
    protected boolean cN;
    private float df;
    private float dg;
    private float dh;
    private float di;
    private float dj;
    private float dk;
    protected boolean cO = true;
    protected int cP;
    @Nullable
    public EntityReference<EntityLiving> dl;
    public int maxDomestication = 100;

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.cn = new ControllerMove(this);
        this.cm = new ControllerLook(this);
        this.hg();
    }

    @Override
    public boolean isRidable() {
        return false;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.generateMaxHealth(this.as));
        this.h(GenericAttributes.w).a(this.generateSpeed(this.as));
        this.h(GenericAttributes.p).a(this.generateJumpStrength(this.as));
    }

    protected double generateMaxHealth(double min, double max) {
        if (min == max) {
            return min;
        }
        int diff = MathHelper.a(max - min);
        double base = max - (double)diff;
        int first = MathHelper.a((double)diff / 2.0);
        int rest = diff - first;
        return base + (double)this.as.a(first + 1) + (double)this.as.a(rest + 1);
    }

    protected double generateJumpStrength(double min, double max) {
        if (min == max) {
            return min;
        }
        return min + (max - min) * this.as.j();
    }

    protected double generateSpeed(double min, double max) {
        if (min == max) {
            return min;
        }
        return min + (max - min) * this.as.j();
    }

    protected float generateMaxHealth(RandomSource random) {
        return 15.0f + (float)random.a(8) + (float)random.a(9);
    }

    protected double generateJumpStrength(RandomSource random) {
        return (double)0.4f + random.j() * 0.2 + random.j() * 0.2 + random.j() * 0.2;
    }

    protected double generateSpeed(RandomSource random) {
        return ((double)0.45f + random.j() * 0.3 + random.j() * 0.3 + random.j() * 0.3) * 0.25;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HorseHasRider(this));
        this.cq.a(1, new PathfinderGoalPanic(this, 1.2));
        this.cq.a(1, new PathfinderGoalTame(this, 1.2));
        this.cq.a(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.cq.a(4, new PathfinderGoalFollowParent(this, 1.0));
        this.cq.a(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.cq.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cq.a(8, new PathfinderGoalRandomLookaround(this));
        if (this.gJ()) {
            this.cq.a(9, new RandomStandGoal(this));
        }
        this.cr.a(0, new HorseHasRider(this));
        this.ha();
    }

    protected void ha() {
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(3, new PathfinderGoalTempt(this, 1.25, stack -> stack.a(TagsItem.aK), false));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cS, (byte)0);
    }

    protected boolean s(int flagId) {
        return (this.az.a(cS) & flagId) != 0;
    }

    protected void d(int flagId, boolean value) {
        byte b2 = this.az.a(cS);
        if (value) {
            this.az.a(cS, (byte)(b2 | flagId));
        } else {
            this.az.a(cS, (byte)(b2 & ~flagId));
        }
    }

    public boolean gZ() {
        return this.s(2);
    }

    @Override
    @Nullable
    public EntityReference<EntityLiving> d() {
        return this.dl;
    }

    public void j(@Nullable EntityLiving owner) {
        this.dl = EntityReference.a(owner);
    }

    public void y(boolean tamed) {
        this.d(2, tamed);
    }

    @Override
    public void z() {
        super.z();
        if (this.hb()) {
            this.A(false);
        }
    }

    @Override
    public boolean D() {
        return true;
    }

    @Override
    public Vec3D[] E() {
        return Leashable.a(this, 0.04, 0.52, 0.23, 0.87);
    }

    public boolean hb() {
        return this.s(16);
    }

    public boolean hc() {
        return this.s(32);
    }

    public boolean hd() {
        return this.s(8);
    }

    public void z(boolean breeding) {
        this.d(8, breeding);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.h ? super.e(slot) : this.bX() && !this.g_() && this.gZ();
    }

    public void b(EntityHuman player, ItemStack stack) {
        if (this.a(stack, EnumItemSlot.g)) {
            this.h(stack.b(1, (EntityLiving)player));
        }
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return (slot == EnumItemSlot.g || slot == EnumItemSlot.h) && this.gZ() || super.f(slot);
    }

    public int he() {
        return this.cL;
    }

    public void t(int temper) {
        this.cL = temper;
    }

    public int u(int addedTemper) {
        int i2 = MathHelper.a(this.he() + addedTemper, 0, this.hj());
        this.t(i2);
        return i2;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return !this.cm();
    }

    private void m() {
        SoundEffect eatingSound;
        this.s();
        if (!this.bm() && (eatingSound = this.gK()) != null) {
            this.an().a(null, this.dK(), this.dM(), this.dQ(), eatingSound, this.dw(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
        }
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2;
        if (fallDistance > 1.0) {
            this.a(SoundEffects.os, 0.4f, 1.0f);
        }
        if ((i2 = this.a(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.a(damageSource, (float)i2);
        this.b(fallDistance, damageMultiplier, damageSource);
        this.ff();
        return true;
    }

    public final int hf() {
        return EntityHorseAbstract.v(this.ad_());
    }

    public static int v(int columns) {
        return columns * 3;
    }

    public void hg() {
        InventorySubcontainer simpleContainer = this.cK;
        this.cK = new InventorySubcontainer(this.hf(), (InventoryHolder)((AbstractHorse)this.getBukkitEntity()));
        if (simpleContainer != null) {
            int min = Math.min(simpleContainer.b(), this.cK.b());
            for (int i2 = 0; i2 < min; ++i2) {
                ItemStack item = simpleContainer.a(i2);
                if (item.f()) continue;
                this.cK.a(i2, item.v());
            }
        }
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return slot == EnumItemSlot.h ? SoundEffects.ot : super.a(slot, stack, equippable);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean flag = super.a(level, damageSource, amount);
        if (flag && this.as.a(3) == 0) {
            this.hn();
        }
        return flag;
    }

    protected boolean gJ() {
        return true;
    }

    @Nullable
    protected SoundEffect gK() {
        return null;
    }

    @Nullable
    protected SoundEffect hh() {
        return null;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        if (!block.n()) {
            IBlockData blockState = this.an().a_(pos.d());
            SoundEffectType soundType = block.A();
            if (blockState.a(Blocks.ep)) {
                soundType = blockState.A();
            }
            if (this.cm() && this.cO) {
                ++this.cP;
                if (this.cP > 5 && this.cP % 3 == 0) {
                    this.a(soundType);
                } else if (this.cP <= 5) {
                    this.a(SoundEffects.ov, soundType.a() * 0.15f, soundType.b());
                }
            } else if (this.b(soundType)) {
                this.a(SoundEffects.ov, soundType.a() * 0.15f, soundType.b());
            } else {
                this.a(SoundEffects.ou, soundType.a() * 0.15f, soundType.b());
            }
        }
    }

    private boolean b(SoundEffectType soundType) {
        return soundType == SoundEffectType.b || soundType == SoundEffectType.aW || soundType == SoundEffectType.B || soundType == SoundEffectType.aX || soundType == SoundEffectType.aV;
    }

    protected void a(SoundEffectType soundType) {
        this.a(SoundEffects.op, soundType.a() * 0.15f, soundType.b());
    }

    public static AttributeProvider.Builder hi() {
        return EntityAnimal.gN().a(GenericAttributes.p, 0.7).a(GenericAttributes.t, 53.0).a(GenericAttributes.w, 0.225f).a(GenericAttributes.C, 1.0).a(GenericAttributes.y, 6.0).a(GenericAttributes.l, 0.5);
    }

    @Override
    public int ak() {
        return 6;
    }

    public int hj() {
        return this.maxDomestication;
    }

    @Override
    public float ft() {
        return 0.8f;
    }

    @Override
    public int W() {
        return 400;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.an().D_() && (!this.cm() || this.z(player)) && this.gZ()) {
            player.a(this, this.cK);
        }
    }

    public EnumInteractionResult c(EntityHuman player, ItemStack stack) {
        boolean flag = this.a(player, stack);
        if (flag) {
            stack.a(1, (EntityLiving)player);
        }
        return (EnumInteractionResult)((Object)(!flag && !this.an().D_() ? EnumInteractionResult.e : EnumInteractionResult.b));
    }

    protected boolean a(EntityHuman player, ItemStack stack) {
        boolean flag = false;
        float f2 = 0.0f;
        int i2 = 0;
        int i1 = 0;
        if (stack.a(Items.rc)) {
            f2 = 2.0f;
            i2 = 20;
            i1 = 3;
        } else if (stack.a(Items.tE)) {
            f2 = 1.0f;
            i2 = 30;
            i1 = 3;
        } else if (stack.a(Blocks.jb.h())) {
            f2 = 20.0f;
            i2 = 180;
        } else if (stack.a(Items.pV)) {
            f2 = 3.0f;
            i2 = 60;
            i1 = 3;
        } else if (stack.a(Items.wn)) {
            f2 = 3.0f;
            i2 = 60;
            i1 = 3;
        } else if (stack.a(Items.ws)) {
            f2 = 4.0f;
            i2 = 60;
            i1 = 5;
            if (!this.an().D_() && this.gZ() && this.aa_() == 0 && !this.gS()) {
                flag = true;
                this.setInLove(player, stack.v());
            }
        } else if (stack.a(Items.rK) || stack.a(Items.rL)) {
            f2 = 10.0f;
            i2 = 240;
            i1 = 10;
            if (!this.an().D_() && this.gZ() && this.aa_() == 0 && !this.gS()) {
                flag = true;
                this.setInLove(player, stack.v());
            }
        }
        if (this.eU() < this.fj() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.g_() && i2 > 0) {
            this.an().a(Particles.R, this.e(1.0), this.dN() + 0.5, this.h(1.0), 0.0, 0.0, 0.0);
            if (!this.an().D_()) {
                this.b_(i2);
                flag = true;
            }
        }
        if (!(i1 <= 0 || !flag && this.gZ() || this.he() >= this.hj() || this.an().D_())) {
            this.u(i1);
            flag = true;
        }
        if (flag) {
            this.m();
            this.c(GameEvent.m);
        }
        return flag;
    }

    protected void g(EntityHuman player) {
        this.A(false);
        this.hl();
        if (!this.an().D_()) {
            player.v(this.dX());
            player.w(this.dZ());
            player.o(this);
        }
    }

    @Override
    public boolean fv() {
        return super.fv() && this.cm() && this.am() || this.hb() || this.hc();
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aJ);
    }

    private void n() {
        this.cI = 1;
    }

    @Override
    protected void g(WorldServer level) {
        super.g(level);
        if (this.cK != null) {
            for (int i2 = 0; i2 < this.cK.b(); ++i2) {
                ItemStack item = this.cK.a(i2);
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
                this.a(level, item);
            }
        }
    }

    @Override
    public void e_() {
        if (this.as.a(200) == 0) {
            this.n();
        }
        super.e_();
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.bX()) {
                if (this.as.a(900) == 0 && this.bv == 0) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if (this.hk()) {
                    if (!this.hb() && !this.cm() && this.as.a(300) == 0 && serverLevel.a_(this.dF().e()).a(Blocks.i)) {
                        this.A(true);
                    }
                    if (this.hb() && ++this.dc > 50) {
                        this.dc = 0;
                        this.A(false);
                    }
                }
                this.h(serverLevel);
            }
        }
    }

    protected void h(WorldServer level) {
        EntityHorseAbstract nearestEntity;
        if (this.hd() && this.g_() && !this.hb() && (nearestEntity = level.a(EntityHorseAbstract.class, cD, (EntityLiving)this, this.dK(), this.dM(), this.dQ(), this.de().g(16.0))) != null && this.g((Entity)nearestEntity) > 4.0) {
            this.cp.a((Entity)nearestEntity, 0);
        }
    }

    public boolean hk() {
        return true;
    }

    @Override
    public void g() {
        super.g();
        if (this.dd > 0 && ++this.dd > 30) {
            this.dd = 0;
            this.d(64, false);
        }
        if (this.de > 0 && --this.de <= 0) {
            this.hl();
        }
        if (this.cI > 0 && ++this.cI > 8) {
            this.cI = 0;
        }
        if (this.cJ > 0) {
            ++this.cJ;
            if (this.cJ > 300) {
                this.cJ = 0;
            }
        }
        this.dg = this.df;
        if (this.hb()) {
            this.df += (1.0f - this.df) * 0.4f + 0.05f;
            if (this.df > 1.0f) {
                this.df = 1.0f;
            }
        } else {
            this.df += (0.0f - this.df) * 0.4f - 0.05f;
            if (this.df < 0.0f) {
                this.df = 0.0f;
            }
        }
        this.di = this.dh;
        if (this.hc()) {
            this.dg = this.df = 0.0f;
            this.dh += (1.0f - this.dh) * 0.4f + 0.05f;
            if (this.dh > 1.0f) {
                this.dh = 1.0f;
            }
        } else {
            this.cN = false;
            this.dh += (0.8f * this.dh * this.dh * this.dh - this.dh) * 0.6f - 0.05f;
            if (this.dh < 0.0f) {
                this.dh = 0.0f;
            }
        }
        this.dk = this.dj;
        if (this.s(64)) {
            this.dj += (1.0f - this.dj) * 0.7f + 0.05f;
            if (this.dj > 1.0f) {
                this.dj = 1.0f;
            }
        } else {
            this.dj += (0.0f - this.dj) * 0.7f - 0.05f;
            if (this.dj < 0.0f) {
                this.dj = 0.0f;
            }
        }
    }

    public void setMouthOpen(boolean open) {
        this.d(64, open);
    }

    public boolean isMouthOpen() {
        return this.s(64);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        if (this.cm() || this.g_()) {
            return super.b(player, hand);
        }
        if (this.gZ() && player.gp()) {
            this.b(player);
            return EnumInteractionResult.a;
        }
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.f()) {
            EnumInteractionResult interactionResult = itemInHand.a(player, (EntityLiving)this, hand);
            if (interactionResult.a()) {
                return interactionResult;
            }
            if (this.a(itemInHand, EnumItemSlot.g) && !this.go()) {
                this.b(player, itemInHand);
                return EnumInteractionResult.a;
            }
        }
        this.g(player);
        return EnumInteractionResult.a;
    }

    private void s() {
        if (!this.an().D_()) {
            this.dd = 1;
            this.d(64, true);
        }
    }

    public void A(boolean eating) {
        this.d(16, eating);
    }

    public void w(int standCounter) {
        this.A(false);
        this.d(32, true);
        this.de = standCounter;
    }

    public void hl() {
        this.d(32, false);
        this.de = 0;
    }

    @Nullable
    public SoundEffect hm() {
        return this.p();
    }

    public void hn() {
        if (this.gJ() && (this.dt() || !this.an().D_())) {
            this.w(20);
        }
    }

    public void ho() {
        if (!this.hc() && !this.an().D_()) {
            this.hn();
            this.b(this.hh());
        }
    }

    public boolean i(EntityHuman player) {
        this.j(player);
        this.y(true);
        if (player instanceof EntityPlayer) {
            CriterionTriggers.y.a((EntityPlayer)player, this);
        }
        this.an().a((Entity)this, (byte)7);
        return true;
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        Vec2F riddenRotation = this.i((EntityLiving)player);
        this.a(riddenRotation.k, riddenRotation.j);
        this.bB = this.bD = this.dX();
        this.ab = this.bD;
        if (this.dq()) {
            if (travelVector.i <= 0.0) {
                this.cP = 0;
            }
            if (this.aS()) {
                if (this.cM > 0.0f && !this.fH()) {
                    this.b(this.cM, travelVector);
                }
                this.cM = 0.0f;
            }
        }
    }

    protected Vec2F i(EntityLiving entity) {
        return new Vec2F(entity.dZ() * 0.5f, entity.dX());
    }

    @Override
    protected void q(Entity passenger) {
        super.q(passenger);
        passenger.b(this.j(0.0f), this.i(0.0f));
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        if (this.aS() && this.cM == 0.0f && this.hc() && !this.cN) {
            return Vec3D.c;
        }
        float f2 = player.bM * 0.5f;
        float f1 = player.bO;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3D(f2, 0.0, f1);
    }

    @Override
    protected float f(EntityHuman player) {
        return (float)this.i(GenericAttributes.w);
    }

    protected void b(float playerJumpPendingScale, Vec3D travelVector) {
        double d2 = this.z(playerJumpPendingScale);
        Vec3D deltaMovement = this.dI();
        this.m(deltaMovement.g, d2, deltaMovement.i);
        this.aF = true;
        if (travelVector.i > 0.0) {
            float sin = MathHelper.a(this.dX() * ((float)Math.PI / 180));
            float cos = MathHelper.b(this.dX() * ((float)Math.PI / 180));
            this.k(this.dI().b(-0.4f * sin * playerJumpPendingScale, 0.0, 0.4f * cos * playerJumpPendingScale));
        }
    }

    protected void hp() {
        this.a(SoundEffects.or, 0.4f, 1.0f);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("EatingHaystack", this.hb());
        output.a("Bred", this.hd());
        output.a("Temper", this.he());
        output.a("Tame", this.gZ());
        EntityReference.a(this.dl, output, "Owner");
        output.a("Bukkit.MaxDomestication", this.maxDomestication);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.A(input.a("EatingHaystack", false));
        this.z(input.a("Bred", false));
        this.t(input.a("Temper", 0));
        this.y(input.a("Tame", false));
        this.dl = EntityReference.a(input, "Owner", this.an());
        this.maxDomestication = input.a("Bukkit.MaxDomestication", this instanceof EntityLlama ? 30 : 100);
    }

    @Override
    public boolean a(EntityAnimal partner) {
        return false;
    }

    protected boolean hq() {
        return !this.cm() && !this.cl() && this.gZ() && !this.g_() && this.eU() >= this.fj() && this.gS();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return null;
    }

    protected void a(EntityAgeable parent, EntityHorseAbstract child) {
        this.a(parent, child, GenericAttributes.t, (double)cy, (double)cz);
        this.a(parent, child, GenericAttributes.p, (double)cv, (double)cx);
        this.a(parent, child, GenericAttributes.w, (double)ct, (double)cu);
    }

    private void a(EntityAgeable parent, EntityHorseAbstract child, Holder<AttributeBase> attribute, double min, double max) {
        double d2 = EntityHorseAbstract.a(this.j(attribute), parent.j(attribute), min, max, this.as);
        child.h(attribute).a(d2);
    }

    static double a(double value1, double value2, double min, double max, RandomSource random) {
        double d3;
        if (max <= min) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        value1 = MathHelper.a(value1, min, max);
        value2 = MathHelper.a(value2, min, max);
        double d2 = 0.15 * (max - min);
        double d22 = (value1 + value2) / 2.0;
        double d1 = Math.abs(value1 - value2) + d2 * 2.0;
        double d4 = d22 + d1 * (d3 = (random.j() + random.j() + random.j()) / 3.0 - 0.5);
        if (d4 > max) {
            double d5 = d4 - max;
            return max - d5;
        }
        if (d4 < min) {
            double d5 = min - d4;
            return min + d5;
        }
        return d4;
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.dg, this.df);
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.di, this.dh);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.dk, this.dj);
    }

    @Override
    public void b(int jumpPower) {
        if (this.am()) {
            if (jumpPower < 0) {
                jumpPower = 0;
            } else {
                this.cN = true;
                this.hn();
            }
            this.cM = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
        }
    }

    @Override
    public boolean a() {
        return this.am();
    }

    @Override
    public void c(int jumpPower) {
        float power = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
        if (!CraftEventFactory.callHorseJumpEvent(this, power)) {
            return;
        }
        this.cN = true;
        this.hn();
        this.hp();
    }

    @Override
    public void b() {
    }

    protected void B(boolean tamed) {
        ParticleType particleOptions = tamed ? Particles.T : Particles.ai;
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = this.as.k() * 0.02;
            double d1 = this.as.k() * 0.02;
            double d22 = this.as.k() * 0.02;
            this.an().a(particleOptions, this.e(1.0), this.dN() + 0.5, this.h(1.0), d2, d1, d22);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 7) {
            this.B(true);
        } else if (id == 6) {
            this.B(false);
        } else {
            super.b(id);
        }
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction callback) {
        super.a(passenger, callback);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).bB = this.bB;
        }
    }

    protected static float a(IntUnaryOperator operator) {
        return 15.0f + (float)operator.applyAsInt(8) + (float)operator.applyAsInt(9);
    }

    protected static double a(DoubleSupplier supplier) {
        return (double)0.4f + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2;
    }

    protected static double b(DoubleSupplier supplier) {
        return ((double)0.45f + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean fe() {
        return false;
    }

    @Override
    public SlotAccess a_(int slot) {
        int i2 = slot - 500;
        return i2 >= 0 && i2 < this.cK.b() ? SlotAccess.a(this.cK, i2) : super.a_(slot);
    }

    @Override
    @Nullable
    public EntityLiving dg() {
        EntityLiving entityLiving;
        Entity entity;
        if (this.am() && (entity = this.dj()) instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            entityLiving = player;
        } else {
            entityLiving = super.dg();
        }
        return entityLiving;
    }

    @Nullable
    private Vec3D a(Vec3D direction, EntityLiving passenger) {
        double d2 = this.dK() + direction.g;
        double d1 = this.de().b;
        double d22 = this.dQ() + direction.i;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose pose : passenger.gd()) {
            mutableBlockPos.b(d2, d1, d22);
            double d3 = this.de().e + 0.75;
            do {
                double blockFloorHeight = this.an().j(mutableBlockPos);
                if ((double)mutableBlockPos.v() + blockFloorHeight > d3) continue block0;
                if (DismountUtil.a(blockFloorHeight)) {
                    AxisAlignedBB localBoundsForPose = passenger.f(pose);
                    Vec3D vec3 = new Vec3D(d2, (double)mutableBlockPos.v() + blockFloorHeight, d22);
                    if (DismountUtil.a(this.an(), passenger, localBoundsForPose.c(vec3))) {
                        passenger.c(pose);
                        return vec3;
                    }
                }
                mutableBlockPos.c(EnumDirection.b);
            } while ((double)mutableBlockPos.v() < d3);
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving livingEntity) {
        Vec3D collisionHorizontalEscapeVector = EntityHorseAbstract.a(this.dA(), (double)livingEntity.dA(), this.dX() + (livingEntity.as() == EnumMainHand.b ? 90.0f : -90.0f));
        Vec3D dismountLocationInDirection = this.a(collisionHorizontalEscapeVector, livingEntity);
        if (dismountLocationInDirection != null) {
            return dismountLocationInDirection;
        }
        Vec3D collisionHorizontalEscapeVector1 = EntityHorseAbstract.a(this.dA(), (double)livingEntity.dA(), this.dX() + (livingEntity.as() == EnumMainHand.a ? 90.0f : -90.0f));
        Vec3D dismountLocationInDirection1 = this.a(collisionHorizontalEscapeVector1, livingEntity);
        return dismountLocationInDirection1 != null ? dismountLocationInDirection1 : this.dD();
    }

    protected void a(RandomSource random) {
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(0.2f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public boolean a(IInventory inventory) {
        return this.cK != inventory;
    }

    public int hr() {
        return this.W();
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return super.a(entity, dimensions, partialTick).e(new Vec3D(0.0, 0.15 * (double)this.di * (double)partialTick, -0.7 * (double)this.di * (double)partialTick).b(-this.dX() * ((float)Math.PI / 180)));
    }

    public int ad_() {
        return 0;
    }
}

