/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.level.World;

public class EntityHorseDonkey
extends EntityHorseChestedAbstract {
    public EntityHorseDonkey(EntityTypes<? extends EntityHorseDonkey> type, World level) {
        super((EntityTypes<? extends EntityHorseChestedAbstract>)type, level);
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.donkeyRidableInWater;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(this.an().purpurConfig.donkeyMaxHealthMin, this.an().purpurConfig.donkeyMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(this.an().purpurConfig.donkeyJumpStrengthMin, this.an().purpurConfig.donkeyJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(this.an().purpurConfig.donkeyMovementSpeedMin, this.an().purpurConfig.donkeyMovementSpeedMax);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.donkeyBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.donkeyTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.donkeyAlwaysDropExp;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.ii;
    }

    @Override
    protected SoundEffect hh() {
        return SoundEffects.ij;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.il;
    }

    @Override
    @Nullable
    protected SoundEffect gK() {
        return SoundEffects.im;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.in;
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return otherAnimal != this && (otherAnimal instanceof EntityHorseDonkey || otherAnimal instanceof EntityHorse) && this.hq() && ((EntityHorseAbstract)otherAnimal).hq();
    }

    @Override
    protected void hp() {
        this.a(SoundEffects.io, 0.4f, 1.0f);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        EntityTypes<EntityHorseChestedAbstract> entityType = partner instanceof EntityHorse ? EntityTypes.aK : EntityTypes.L;
        EntityHorseAbstract abstractHorse = entityType.a(level, EntitySpawnReason.e);
        if (abstractHorse != null) {
            this.a(partner, abstractHorse);
        }
        return abstractHorse;
    }
}

