/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.PathfinderGoalHorseTrap;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityHorseSkeleton
extends EntityHorseAbstract {
    private final PathfinderGoalHorseTrap ct = new PathfinderGoalHorseTrap(this);
    private static final int cu = 18000;
    private static final boolean cv = false;
    private static final int cx = 0;
    private static final EntitySize cy = EntityTypes.bl.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bl.m() - 0.03125f, 0.0f)).a(0.5f);
    private boolean cz = false;
    public int cA = 0;

    public EntityHorseSkeleton(EntityTypes<? extends EntityHorseSkeleton> type, World level) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, level);
    }

    @Override
    public boolean gZ() {
        return super.gZ() || this.an().purpurConfig.skeletonHorseRidable;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(this.an().purpurConfig.skeletonHorseMaxHealthMin, this.an().purpurConfig.skeletonHorseMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(this.an().purpurConfig.skeletonHorseJumpStrengthMin, this.an().purpurConfig.skeletonHorseJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(this.an().purpurConfig.skeletonHorseMovementSpeedMin, this.an().purpurConfig.skeletonHorseMovementSpeedMax);
    }

    @Override
    public int getPurpurBreedTime() {
        return 6000;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.skeletonHorseTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.skeletonHorseAlwaysDropExp;
    }

    public static AttributeProvider.Builder m() {
        return EntityHorseSkeleton.hi().a(GenericAttributes.t, 15.0).a(GenericAttributes.w, 0.2f);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !EntitySpawnReason.a(spawnReason) ? EntityAnimal.b(entityType, level, spawnReason, pos, random) : EntitySpawnReason.b(spawnReason) || EntityHorseSkeleton.a(level, pos);
    }

    @Override
    protected void a(RandomSource random) {
        this.h(GenericAttributes.p).a(EntityHorseSkeleton.a(random::j));
    }

    @Override
    protected void ha() {
        if (this.an().purpurConfig.skeletonHorseCanSwim) {
            this.cq.a(0, new PathfinderGoalFloat(this));
        }
    }

    @Override
    public SoundEffect p() {
        return ((Entity)this).a(TagsFluid.a) ? SoundEffects.zn : SoundEffects.zj;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.zk;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.zl;
    }

    @Override
    public SoundEffect bg() {
        if (this.aS()) {
            if (!this.cm()) {
                return SoundEffects.zq;
            }
            ++this.cP;
            if (this.cP > 5 && this.cP % 3 == 0) {
                return SoundEffects.zo;
            }
            if (this.cP <= 5) {
                return SoundEffects.zq;
            }
        }
        return SoundEffects.zm;
    }

    @Override
    protected void g(float volume) {
        if (this.aS()) {
            super.g(0.3f);
        } else {
            super.g(Math.min(0.1f, volume * 25.0f));
        }
    }

    @Override
    protected void hp() {
        if (this.bu()) {
            this.a(SoundEffects.zp, 0.4f, 1.0f);
        } else {
            super.hp();
        }
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.g_() ? cy : super.b(pose);
    }

    @Override
    public void e_() {
        super.e_();
        if (this.n() && this.cA++ >= 18000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("SkeletonTrap", this.n());
        output.a("SkeletonTrapTime", this.cA);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a("SkeletonTrap", false));
        this.cA = input.a("SkeletonTrapTime", 0);
    }

    @Override
    protected float fz() {
        return 0.96f;
    }

    public boolean n() {
        return this.cz;
    }

    public void x(boolean isTrap) {
        if (isTrap != this.cz) {
            this.cz = isTrap;
            if (isTrap) {
                this.cq.a(1, this.ct);
            } else {
                this.cq.a(this.ct);
            }
        }
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.bl.a(level, EntitySpawnReason.e);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return !this.gZ() ? EnumInteractionResult.e : super.b(player, hand);
    }
}

