/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;

public class EntityHorseZombie
extends EntityHorseAbstract {
    private static final EntitySize ct = EntityTypes.bU.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bU.m() - 0.03125f, 0.0f)).a(0.5f);

    public EntityHorseZombie(EntityTypes<? extends EntityHorseZombie> type, World level) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, level);
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.zombieHorseRidableInWater;
    }

    @Override
    public boolean gZ() {
        return super.gZ() || this.an().purpurConfig.zombieHorseRidable;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(this.an().purpurConfig.zombieHorseMaxHealthMin, this.an().purpurConfig.zombieHorseMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(this.an().purpurConfig.zombieHorseJumpStrengthMin, this.an().purpurConfig.zombieHorseJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(this.an().purpurConfig.zombieHorseMovementSpeedMin, this.an().purpurConfig.zombieHorseMovementSpeedMax);
    }

    @Override
    public int getPurpurBreedTime() {
        return 6000;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.zombieHorseTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.zombieHorseAlwaysDropExp;
    }

    public static AttributeProvider.Builder m() {
        return EntityHorseZombie.hi().a(GenericAttributes.t, 15.0).a(GenericAttributes.w, 0.2f);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !EntitySpawnReason.a(spawnReason) ? EntityAnimal.b(entityType, level, spawnReason, pos, random) : EntitySpawnReason.b(spawnReason) || EntityHorseZombie.a(level, pos);
    }

    @Override
    protected void a(RandomSource random) {
        this.h(GenericAttributes.p).a(EntityHorseZombie.a(random::j));
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.FO;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.FP;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.FQ;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.bU.a(level, EntitySpawnReason.e);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return !this.gZ() ? EnumInteractionResult.e : super.b(player, hand);
    }

    @Override
    protected void ha() {
        if (this.an().purpurConfig.zombieHorseCanSwim) {
            this.cq.a(0, new PathfinderGoalFloat(this));
        }
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.g_() ? ct : super.b(pose);
    }
}

