/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLlamaFollow;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Llama;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.controller.MoveControllerWASD;
import org.purpurmc.purpur.entity.ai.LlamaHasRider;
import org.purpurmc.purpur.event.entity.LlamaJoinCaravanEvent;
import org.purpurmc.purpur.event.entity.LlamaLeaveCaravanEvent;

public class EntityLlama
extends EntityHorseChestedAbstract
implements IRangedEntity {
    private static final int ct = 5;
    private static final DataWatcherObject<Integer> cu = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cv = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final EntitySize cx = EntityTypes.aB.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.aB.m() - 0.8125f, -0.3f)).a(0.5f);
    boolean cy;
    @Nullable
    private EntityLlama cz;
    @Nullable
    public EntityLlama cA;
    public boolean shouldJoinCaravan = true;

    public EntityLlama(EntityTypes<? extends EntityLlama> type, World level) {
        super((EntityTypes<? extends EntityHorseChestedAbstract>)type, level);
        this.S().a(40.0f);
        this.maxDomestication = 30;
        this.cn = new MoveControllerWASD(this){

            @Override
            public void a() {
                if (this.entity.getRider() != null && this.entity.isControllable() && EntityLlama.this.am()) {
                    this.purpurTick(this.entity.getRider());
                } else {
                    this.vanillaTick();
                }
            }
        };
        this.cm = new LookControllerWASD(this){

            @Override
            public void a() {
                if (this.entity.getRider() != null && this.entity.isControllable() && EntityLlama.this.am()) {
                    this.purpurTick(this.entity.getRider());
                } else {
                    this.vanillaTick();
                }
            }
        };
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.llamaRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.llamaRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.llamaControllable;
    }

    @Override
    public boolean am() {
        return super.go() || this.gZ();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public EntityLiving dg() {
        Entity firstPassenger = this.dj();
        if (this.gx()) return null;
        if (!(firstPassenger instanceof EntityInsentient)) return null;
        EntityInsentient mob = (EntityInsentient)firstPassenger;
        if (!firstPassenger.co()) return null;
        EntityInsentient entityInsentient = mob;
        return entityInsentient;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(this.an().purpurConfig.llamaMaxHealthMin, this.an().purpurConfig.llamaMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(this.an().purpurConfig.llamaJumpStrengthMin, this.an().purpurConfig.llamaJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(this.an().purpurConfig.llamaMovementSpeedMin, this.an().purpurConfig.llamaMovementSpeedMax);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.llamaBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.llamaTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.llamaAlwaysDropExp;
    }

    public boolean gL() {
        return false;
    }

    public void x(int strength) {
        this.az.a(cu, Math.max(1, Math.min(5, strength)));
    }

    private void b(RandomSource random) {
        int i2 = random.i() < 0.04f ? 5 : 3;
        this.x(1 + random.a(i2));
    }

    public int gM() {
        return this.az.a(cu);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Variant", Variant.g, this.gV());
        output.a("Strength", this.gM());
        output.a("Purpur.ShouldJoinCaravan", this.shouldJoinCaravan);
    }

    @Override
    protected void a(ValueInput input) {
        this.x(input.a("Strength", 0));
        super.a(input);
        this.a(input.a("Variant", Variant.g).orElse(Variant.e));
        this.shouldJoinCaravan = input.a("Purpur.ShouldJoinCaravan", true);
    }

    @Override
    protected void H() {
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(0, new LlamaHasRider(this));
        this.cq.a(1, new PathfinderGoalTame(this, 1.2));
        this.cq.a(2, new PathfinderGoalLlamaFollow(this, 2.1f));
        this.cq.a(3, new PathfinderGoalArrowAttack(this, 1.25, 40, 20.0f));
        this.cq.a(3, new PathfinderGoalPanic(this, 1.2));
        this.cq.a(4, new PathfinderGoalBreed(this, 1.0));
        this.cq.a(5, new PathfinderGoalTempt(this, 1.25, itemStack -> itemStack.a(TagsItem.aU), false));
        this.cq.a(6, new PathfinderGoalFollowParent(this, 1.0));
        this.cq.a(7, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.cq.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cq.a(9, new PathfinderGoalRandomLookaround(this));
        this.cr.a(0, new LlamaHasRider(this));
        this.cr.a(1, new c(this));
        this.cr.a(2, new a(this));
    }

    public static AttributeProvider.Builder gU() {
        return EntityLlama.m();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cu, 0);
        builder.a(cv, 0);
    }

    public Variant gV() {
        return Variant.a(this.az.a(cv));
    }

    public void a(Variant variant) {
        this.az.a(cv, variant.j);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aN ? EntityLlama.c(component, this.gV()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aN);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aN) {
            this.a(EntityLlama.c(DataComponents.aN, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aT);
    }

    @Override
    protected boolean a(EntityHuman player, ItemStack stack) {
        SoundEffect eatingSound;
        int i2 = 0;
        int i1 = 0;
        float f2 = 0.0f;
        boolean flag = false;
        if (stack.a(Items.rc)) {
            i2 = 10;
            i1 = 3;
            f2 = 2.0f;
        } else if (stack.a(Blocks.jb.h())) {
            i2 = 90;
            i1 = 6;
            f2 = 10.0f;
            if (this.gZ() && this.aa_() == 0 && this.gP()) {
                flag = true;
                this.setInLove(player, stack.v());
            }
        }
        if (this.eU() < this.fj() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.g_() && i2 > 0) {
            this.an().a(Particles.R, this.e(1.0), this.dN() + 0.5, this.h(1.0), 0.0, 0.0, 0.0);
            if (!this.an().D_()) {
                this.b_(i2);
                flag = true;
            }
        }
        if (!(i1 <= 0 || !flag && this.gZ() || this.he() >= this.hj() || this.an().D_())) {
            this.u(i1);
            flag = true;
        }
        if (flag && !this.bm() && (eatingSound = this.gK()) != null) {
            this.an().a(null, this.dK(), this.dM(), this.dQ(), this.gK(), this.dw(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
        }
        return flag;
    }

    @Override
    public boolean fv() {
        return this.eV() || this.hb();
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        Variant variant;
        RandomSource random = level.I_();
        this.b(random);
        if (spawnGroupData instanceof b) {
            variant = ((b)spawnGroupData).a;
        } else {
            variant = SystemUtils.a(Variant.values(), random);
            spawnGroupData = new b(variant);
        }
        this.a(variant);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected boolean gJ() {
        return false;
    }

    @Override
    protected SoundEffect hh() {
        return SoundEffects.pN;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.pM;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.pR;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.pP;
    }

    @Override
    @Nullable
    protected SoundEffect gK() {
        return SoundEffects.pQ;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.pT, 0.15f, 1.0f);
    }

    @Override
    protected void s() {
        this.a(SoundEffects.pO, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 1.0f);
    }

    @Override
    public int ad_() {
        return this.n() ? this.gM() : 0;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return true;
    }

    @Override
    public int hj() {
        return super.hj();
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return otherAnimal != this && otherAnimal instanceof EntityLlama && this.hq() && ((EntityLlama)otherAnimal).hq();
    }

    @Nullable
    public EntityLlama b(WorldServer level, EntityAgeable partner) {
        EntityLlama llama = this.gW();
        if (llama != null) {
            this.a(partner, llama);
            EntityLlama llama1 = (EntityLlama)partner;
            int i2 = this.as.a(Math.max(this.gM(), llama1.gM())) + 1;
            if (this.as.i() < 0.03f) {
                ++i2;
            }
            llama.x(i2);
            llama.a(this.as.h() ? this.gV() : llama1.gV());
        }
        return llama;
    }

    @Nullable
    protected EntityLlama gW() {
        return EntityTypes.aB.a(this.an(), EntitySpawnReason.e);
    }

    private void k(EntityLiving target) {
        EntityLlamaSpit llamaSpit = new EntityLlamaSpit(this.an(), this);
        double d2 = target.dK() - this.dK();
        double d1 = target.f(0.3333333333333333) - llamaSpit.dM();
        double d22 = target.dQ() - this.dQ();
        double d3 = Math.sqrt(d2 * d2 + d22 * d22) * (double)0.2f;
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            IProjectile.a(llamaSpit, serverLevel, ItemStack.l, d2, d1 + d3, d22, 1.5f, 10.0f);
        }
        if (!this.bm()) {
            this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.pS, this.dw(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
        }
        this.cy = true;
    }

    void C(boolean didSpit) {
        this.cy = didSpit;
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2 = this.a(fallDistance, damageMultiplier);
        if (i2 <= 0) {
            return false;
        }
        if (fallDistance >= 6.0) {
            this.a(damageSource, (float)i2);
            this.b(fallDistance, damageMultiplier, damageSource);
        }
        this.ff();
        return true;
    }

    public void gX() {
        if (this.cz != null) {
            new LlamaLeaveCaravanEvent((Llama)this.getBukkitEntity()).callEvent();
            this.cz.cA = null;
        }
        this.cz = null;
    }

    public void a(EntityLlama caravanHead) {
        if (!(this.an().purpurConfig.llamaJoinCaravans && this.shouldJoinCaravan && new LlamaJoinCaravanEvent((Llama)this.getBukkitEntity(), (Llama)caravanHead.getBukkitEntity()).callEvent())) {
            return;
        }
        this.cz = caravanHead;
        this.cz.cA = this;
    }

    public boolean gY() {
        return this.cA != null;
    }

    public boolean hs() {
        return this.cz != null;
    }

    @Nullable
    public EntityLlama ht() {
        return this.cz;
    }

    @Override
    protected double gH() {
        return 2.0;
    }

    @Override
    public boolean D() {
        return false;
    }

    @Override
    protected void h(WorldServer level) {
        if (!this.hs() && this.g_()) {
            super.h(level);
        }
    }

    @Override
    public boolean hk() {
        return false;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.k(target);
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.75 * (double)this.df(), (double)this.dA() * 0.5);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.g_() ? cx : super.b(pose);
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return EntityLlama.a((Entity)this, entity, dimensions.d());
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "creamy");
        public static final /* enum */ Variant b = new Variant(1, "white");
        public static final /* enum */ Variant c = new Variant(2, "brown");
        public static final /* enum */ Variant d = new Variant(3, "gray");
        public static final Variant e;
        private static final IntFunction<Variant> i;
        public static final Codec<Variant> f;
        @Deprecated
        public static final Codec<Variant> g;
        public static final StreamCodec<ByteBuf, Variant> h;
        final int j;
        private final String k;
        private static final /* synthetic */ Variant[] l;

        public static Variant[] values() {
            return (Variant[])l.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name) {
            this.j = id;
            this.k = name;
        }

        public int a() {
            return this.j;
        }

        public static Variant a(int id) {
            return i.apply(id);
        }

        @Override
        public String c() {
            return this.k;
        }

        private static /* synthetic */ Variant[] b() {
            return new Variant[]{a, b, c, d};
        }

        static {
            l = Variant.b();
            e = a;
            i = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
            f = INamable.a(Variant::values);
            g = Codec.INT.xmap(i::apply, Variant::a);
            h = ByteBufCodecs.a(i, Variant::a);
        }
    }

    static class c
    extends PathfinderGoalHurtByTarget {
        public c(EntityLlama llama) {
            super(llama, new Class[0]);
        }

        @Override
        public boolean c() {
            EntityInsentient entityInsentient = this.e;
            if (entityInsentient instanceof EntityLlama) {
                EntityLlama llama = (EntityLlama)entityInsentient;
                if (llama.cy) {
                    llama.C(false);
                    return false;
                }
            }
            return super.c();
        }
    }

    static class a
    extends PathfinderGoalNearestAttackableTarget<EntityWolf> {
        public a(EntityLlama llama) {
            super(llama, EntityWolf.class, 16, false, true, (entity, level) -> !((EntityWolf)entity).m());
        }

        @Override
        protected double l() {
            return super.l() * 0.25;
        }
    }

    static class b
    extends EntityAgeable.a {
        public final Variant a;

        b(Variant variant) {
            super(true);
            this.a = variant;
        }
    }
}

