/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class Sniffer
extends EntityAnimal {
    private static final int cz = 1700;
    private static final int cA = 6000;
    private static final int cB = 30;
    private static final int cC = 120;
    private static final int cD = 48000;
    private static final float cE = 0.4f;
    private static final EntitySize cF = EntitySize.b(EntityTypes.bo.l(), EntityTypes.bo.m() - 0.4f).b(0.81f);
    private static final DataWatcherObject<State> cG = DataWatcher.a(Sniffer.class, DataWatcherRegistry.F);
    private static final DataWatcherObject<Integer> cH = DataWatcher.a(Sniffer.class, DataWatcherRegistry.b);
    public final AnimationState ct = new AnimationState();
    public final AnimationState cu = new AnimationState();
    public final AnimationState cv = new AnimationState();
    public final AnimationState cx = new AnimationState();
    public final AnimationState cy = new AnimationState();

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gN().a(GenericAttributes.w, 0.1f).a(GenericAttributes.t, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> type, World level) {
        super(type, level);
        this.S().a(true);
        this.a(PathType.j, -1.0f);
        this.a(PathType.g, -1.0f);
        this.a(PathType.y, -1.0f);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.snifferRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.snifferRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.snifferControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.snifferMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.snifferScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.snifferBreedingTicks;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cG, State.a);
        builder.a(cH, 0);
    }

    @Override
    public void K() {
        super.K();
        if (this.ck() || this.bu()) {
            this.a(PathType.j, 0.0f);
        }
    }

    @Override
    public void L() {
        this.a(PathType.j, -1.0f);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.gV() == State.f ? cF.a(this.ez()) : super.b(pose);
    }

    public boolean n() {
        return this.gV() == State.e;
    }

    public boolean s() {
        return this.bY.c(MemoryModuleType.S).orElse(false);
    }

    public boolean gI() {
        return !this.s() && !this.gF() && !this.bu() && !this.gS() && this.aS() && !this.cl() && !this.T_();
    }

    public boolean gJ() {
        return this.gV() == State.f || this.gV() == State.e;
    }

    private BlockPosition gM() {
        Vec3D headPosition = this.gU();
        return BlockPosition.a(headPosition.a(), this.dM() + (double)0.2f, headPosition.c());
    }

    private Vec3D gU() {
        return this.dD().e(this.ch().c(2.25));
    }

    @Override
    public boolean D() {
        return true;
    }

    @Override
    public Vec3D[] E() {
        return Leashable.a(this, -0.01, 0.63, 0.38, 1.15);
    }

    public State gV() {
        return this.az.a(cG);
    }

    private Sniffer b(State state) {
        this.az.a(cG, state);
        return this;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cG.equals(key)) {
            State state = this.gV();
            this.gW();
            switch (state.ordinal()) {
                case 1: {
                    this.ct.b(this.at);
                    break;
                }
                case 2: {
                    this.cu.b(this.at);
                    break;
                }
                case 3: {
                    this.cv.b(this.at);
                }
                default: {
                    break;
                }
                case 5: {
                    this.cx.b(this.at);
                    break;
                }
                case 6: {
                    this.cy.b(this.at);
                }
            }
            this.l_();
        }
        super.a(key);
    }

    private void gW() {
        this.cx.a();
        this.cv.a();
        this.cy.a();
        this.ct.a();
        this.cu.a();
    }

    public Sniffer a(State state) {
        switch (state.ordinal()) {
            case 0: {
                this.b(State.a);
                break;
            }
            case 1: {
                this.a(SoundEffects.AP, 1.0f, 1.0f);
                this.b(State.b);
                break;
            }
            case 2: {
                this.b(State.c).gX();
                break;
            }
            case 3: {
                this.a(SoundEffects.AL, 1.0f, 1.0f);
                this.b(State.d);
                break;
            }
            case 4: {
                this.b(State.e);
                break;
            }
            case 5: {
                this.b(State.f).gY();
                break;
            }
            case 6: {
                this.a(SoundEffects.AO, 1.0f, 1.0f);
                this.b(State.g);
            }
        }
        return this;
    }

    private Sniffer gX() {
        this.a(SoundEffects.AK, 1.0f, this.g_() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer gY() {
        this.az.a(cH, this.at + 120);
        this.an().a((Entity)this, (byte)63);
        return this;
    }

    public Sniffer x(boolean storeExploredPosition) {
        if (storeExploredPosition) {
            this.i(this.bc());
        }
        return this;
    }

    public Optional<BlockPosition> gK() {
        return IntStream.range(0, 5).mapToObj(i2 -> LandRandomPos.a(this, 10 + 2 * i2, 3)).filter(Objects::nonNull).map(BlockPosition::a).filter(blockPos -> this.an().u().a((BlockPosition)blockPos)).map(BlockPosition::e).filter(this::h).findFirst();
    }

    public boolean gL() {
        return !this.gF() && !this.s() && !this.g_() && !this.bu() && this.aS() && !this.cl() && this.h(this.gM().e());
    }

    private boolean h(BlockPosition pos) {
        return this.an().a_(pos).a(TagsBlock.cI) && this.ha().noneMatch(globalPos -> GlobalPos.a(this.an().al(), pos).equals(globalPos)) && Optional.ofNullable(this.S().a(pos, 1)).map(PathEntity::j).orElse(false) != false;
    }

    private void gZ() {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.az.a(cH) == this.at) {
                BlockPosition headBlock = this.gM();
                this.a(serverLevel, LootTables.aG, (WorldServer serverLevel1, ItemStack itemStack) -> {
                    EntityItem itemEntity = new EntityItem(this.an(), headBlock.u(), headBlock.v(), headBlock.w(), (ItemStack)itemStack);
                    itemEntity.i();
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itemEntity.getBukkitEntity());
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    serverLevel1.b(itemEntity);
                });
                this.a(SoundEffects.AJ, 1.0f, 1.0f);
            }
        }
    }

    private Sniffer a(AnimationState animationState) {
        boolean flag;
        boolean bl = flag = animationState.a((float)this.at) > 1700L && animationState.a((float)this.at) < 6000L;
        if (flag) {
            BlockPosition headBlock = this.gM();
            IBlockData blockState = this.an().a_(headBlock.e());
            if (blockState.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    Vec3D vec3 = Vec3D.b(headBlock).b(0.0, -0.65f, 0.0);
                    this.an().a(new ParticleParamBlock(Particles.b, blockState), vec3.g, vec3.h, vec3.i, 0.0, 0.0, 0.0);
                }
                if (this.at % 10 == 0) {
                    this.an().a(this.dK(), this.dM(), this.dQ(), blockState.A().f(), this.dw(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.at % 10 == 0) {
            this.an().a(GameEvent.u, this.gM(), GameEvent.a.a(this));
        }
        return this;
    }

    public Sniffer i(BlockPosition pos) {
        List list = this.ha().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.a(this.an().al(), pos));
        this.eq().a(MemoryModuleType.aU, list);
        return this;
    }

    public Stream<GlobalPos> ha() {
        return this.eq().c(MemoryModuleType.aU).stream().flatMap(Collection::stream);
    }

    @Override
    public void u() {
        double d2;
        super.u();
        double speedModifier = this.cn.c();
        if (speedModifier > 0.0 && (d2 = this.dI().j()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void a(WorldServer level, EntityAnimal partner) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, partner);
        if (result.isCancelled()) {
            return;
        }
        ItemStack itemStack = new ItemStack(Items.lj);
        EntityItem itemEntity = new EntityItem(level, this.dD().a(), this.dD().b(), this.dD().c(), itemStack);
        itemEntity.i();
        this.finalizeSpawnChildFromBreeding(level, partner, null, result.getExperience());
        if (this.spawnAtLocation(level, itemEntity) != null) {
            this.a(SoundEffects.AQ, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 0.5f);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        this.a(State.a);
        super.a(damageSource);
    }

    @Override
    public void g() {
        switch (this.gV().ordinal()) {
            case 4: {
                this.hb();
                break;
            }
            case 5: {
                this.a(this.cx).gZ();
            }
        }
        super.g();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        boolean isFood = this.i(itemInHand);
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a() && isFood) {
            this.gO();
        }
        return interactionResult;
    }

    @Override
    protected void gO() {
        this.an().a(null, this, SoundEffects.AF, SoundCategory.g, 1.0f, MathHelper.b(this.an().z, 0.8f, 1.2f));
    }

    private void hb() {
        if (this.an().D_() && this.at % 20 == 0) {
            this.an().a(this.dK(), this.dM(), this.dQ(), SoundEffects.AM, this.dw(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.AE, 0.15f, 1.0f);
    }

    @Override
    public SoundEffect p() {
        return Set.of(State.f, State.e).contains((Object)this.gV()) ? null : SoundEffects.AG;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.AH;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.AI;
    }

    @Override
    public int ah() {
        return 50;
    }

    @Override
    public void a(boolean baby) {
        this.c_(baby ? -48000 : 0);
    }

    @Override
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.bo.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        if (!(otherAnimal instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)otherAnimal;
        Set<State> set = Set.of(State.a, State.c, State.b);
        return set.contains((Object)this.gV()) && set.contains((Object)sniffer.gV()) && super.a(otherAnimal);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aB);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return SnifferAi.a(this.er().a(dynamic));
    }

    public BehaviorController<Sniffer> eq() {
        return super.eq();
    }

    protected BehaviorController.b<Sniffer> er() {
        return BehaviorController.a(SnifferAi.b, SnifferAi.a);
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("snifferBrain");
        if (this.getRider() == null || !this.isControllable()) {
            this.eq().a(level, this);
        }
        profilerFiller.b("snifferActivityUpdate");
        SnifferAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State a = new State(0);
        public static final /* enum */ State b = new State(1);
        public static final /* enum */ State c = new State(2);
        public static final /* enum */ State d = new State(3);
        public static final /* enum */ State e = new State(4);
        public static final /* enum */ State f = new State(5);
        public static final /* enum */ State g = new State(6);
        public static final IntFunction<State> h;
        public static final StreamCodec<ByteBuf, State> i;
        private final int j;
        private static final /* synthetic */ State[] k;

        public static State[] values() {
            return (State[])k.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        private State(int id) {
            this.j = id;
        }

        public int a() {
            return this.j;
        }

        private static /* synthetic */ State[] b() {
            return new State[]{a, b, c, d, e, f, g};
        }

        static {
            k = State.b();
            h = ByIdMap.a(State::a, State.values(), ByIdMap.a.a);
            i = ByteBufCodecs.a(h, State::a);
        }
    }
}

