/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> cz = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cA = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cB = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<WolfVariant>> cC = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.z);
    private static final DataWatcherObject<Holder<WolfSoundVariant>> cD = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.A);
    public static final PathfinderTargetCondition.a cx = (entity, level) -> {
        EntityTypes<?> type = entity.ax();
        return type == EntityTypes.bg || type == EntityTypes.bd || type == EntityTypes.ad;
    };
    private boolean isRabid = false;
    private static final PathfinderTargetCondition.a RABID_PREDICATE = (entity, ignored) -> entity instanceof EntityPlayer || entity instanceof EntityInsentient;
    private final PathfinderGoal PATHFINDER_VANILLA = new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, cx);
    private final PathfinderGoal PATHFINDER_RABID = new PathfinderGoalRandomTargetNonTamed<EntityLiving>(this, EntityLiving.class, false, RABID_PREDICATE);
    private static final float cE = 8.0f;
    private static final float cF = 40.0f;
    private static final float cG = 0.125f;
    public static final float cy = 0.62831855f;
    private static final EnumColor cH = EnumColor.o;
    private float cI;
    private float cJ;
    public boolean cK;
    private boolean cL;
    private float cM;
    private float cN;
    private static final UniformInt cO = TimeRange.a(20, 39);
    @Nullable
    private UUID cP;

    public EntityWolf(EntityTypes<? extends EntityWolf> type, World level) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, level);
        this.a(false, false);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public boolean isRabid() {
        return this.isRabid;
    }

    public void setRabid(boolean isRabid) {
        this.isRabid = isRabid;
        this.updatePathfinders(true);
    }

    public void updatePathfinders(boolean modifyEffects) {
        this.cr.a(this.PATHFINDER_VANILLA);
        this.cr.a(this.PATHFINDER_RABID);
        if (this.isRabid) {
            ((EntityTameableAnimal)this).a((EntityReference<EntityLiving>)null);
            this.a(false, true);
            this.cr.a(5, this.PATHFINDER_RABID);
            if (modifyEffects) {
                this.a(new MobEffect(MobEffects.i, 1200));
            }
        } else {
            this.cr.a(5, this.PATHFINDER_VANILLA);
            this.i();
            if (modifyEffects) {
                this.g(MobEffects.i);
            }
        }
    }

    @Override
    public void g(EntityHuman player) {
        this.a(this.an().purpurConfig.wolfDefaultCollarColor);
        super.g(player);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.wolfRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.wolfRidableInWater;
    }

    @Override
    public void onMount(EntityHuman rider) {
        super.onMount(rider);
        this.y(false);
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.wolfControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.wolfMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.wolfScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.wolfBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.wolfTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.wolfAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cq.a(1, new PathfinderGoalFloat(this));
        this.cq.a(1, new HasRider(this));
        this.cq.a(1, new EntityTameableAnimal.a(1.5, DamageTypeTags.G));
        this.cq.a(2, new PathfinderGoalSit(this));
        this.cq.a(3, new a<EntityLlama>(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.cq.a(3, new AvoidRabidWolfGoal(this, 24.0f, 1.5, 1.5));
        this.cq.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.cq.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.cq.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.cq.a(7, new PathfinderGoalBreed(this, 1.0));
        this.cq.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cq.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.cq.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(10, new PathfinderGoalRandomLookaround(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.cr.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.cr.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.cr.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.cr.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.ct));
        this.cr.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.cr.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public MinecraftKey gU() {
        WolfVariant wolfVariant = this.gZ().a();
        if (this.m()) {
            return wolfVariant.b().b().b();
        }
        return this.ae_() ? wolfVariant.b().c().b() : wolfVariant.b().a().b();
    }

    public Holder<WolfVariant> gZ() {
        return this.az.a(cC);
    }

    public void b(Holder<WolfVariant> variant) {
        this.az.a(cC, variant);
    }

    public Holder<WolfSoundVariant> ha() {
        return this.az.a(cD);
    }

    public void k(Holder<WolfSoundVariant> soundVariant) {
        this.az.a(cD, soundVariant);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        if (component == DataComponents.aw) {
            return EntityWolf.c(component, this.gZ());
        }
        if (component == DataComponents.ax) {
            return EntityWolf.c(component, this.ha());
        }
        return component == DataComponents.ay ? EntityWolf.c(component, this.gX()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aw);
        this.a(componentGetter, DataComponents.ax);
        this.a(componentGetter, DataComponents.ay);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aw) {
            this.b(EntityWolf.c(DataComponents.aw, value));
            return true;
        }
        if (component == DataComponents.ax) {
            this.k(EntityWolf.c(DataComponents.ax, value));
            return true;
        }
        if (component == DataComponents.ay) {
            this.a(EntityWolf.c(DataComponents.ay, value));
            return true;
        }
        return super.b(component, value);
    }

    public static AttributeProvider.Builder gV() {
        return EntityAnimal.gN().a(GenericAttributes.w, 0.3f).a(GenericAttributes.t, 8.0).a(GenericAttributes.c, 4.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        IRegistry<WolfSoundVariant> registry = this.ej().f(Registries.bv);
        builder.a(cC, VariantUtils.a(this.ej(), WolfVariants.j));
        builder.a(cD, (Holder)registry.a(WolfSoundVariants.a).or(registry::a).orElseThrow());
        builder.a(cz, false);
        builder.a(cA, cH.a());
        builder.a(cB, 0);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.Fh, 0.15f, 1.0f);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("CollarColor", EnumColor.s, this.gX());
        output.a("Purpur.IsRabid", this.isRabid);
        VariantUtils.a(output, this.gZ());
        this.a_(output);
        this.ha().e().ifPresent(resourceKey -> output.a("sound_variant", ResourceKey.a(Registries.bv), resourceKey));
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        VariantUtils.a(input, Registries.bu).ifPresent(this::b);
        this.a(input.a("CollarColor", EnumColor.s).orElse(cH));
        this.isRabid = input.a("Purpur.IsRabid", false);
        this.updatePathfinders(false);
        this.a(this.an(), input);
        input.a("sound_variant", ResourceKey.a(Registries.bv)).flatMap(resourceKey -> this.ej().f(Registries.bv).a((ResourceKey)resourceKey)).ifPresent(this::k);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData instanceof b) {
            b wolfPackData = (b)spawnGroupData;
            this.b(wolfPackData.a);
        } else {
            Optional optional = VariantUtils.a(SpawnContext.a(level, this.dF()), Registries.bu);
            if (optional.isPresent()) {
                this.b(optional.get());
                spawnGroupData = new b(optional.get());
            }
        }
        this.k(WolfSoundVariants.a(this.ej(), level.I_()));
        this.isRabid = level.a().purpurConfig.wolfNaturalRabid > 0.0 && this.as.j() <= level.a().purpurConfig.wolfNaturalRabid;
        this.updatePathfinders(false);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public SoundEffect p() {
        if (this.ae_()) {
            return this.ha().a().c().a();
        }
        if (this.as.a(3) == 0) {
            return this.m() && this.eU() < 20.0f ? this.ha().a().f().a() : this.ha().a().e().a();
        }
        return this.ha().a().a().a();
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.i(damageSource) ? SoundEffects.Fe : this.ha().a().d().a();
    }

    @Override
    public SoundEffect f_() {
        return this.ha().a().b().a();
    }

    @Override
    public float ft() {
        return 0.4f;
    }

    @Override
    public void e_() {
        super.e_();
        if (!this.an().D_() && this.cK && !this.cL && !this.gE() && this.aS()) {
            this.cL = true;
            this.cM = 0.0f;
            this.cN = 0.0f;
            this.an().a((Entity)this, (byte)8);
        }
        if (!this.an().D_()) {
            this.a((WorldServer)this.an(), true);
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.bX()) {
            if (this.d % 300 == 0 && this.isRabid()) {
                this.a(new MobEffect(MobEffects.i, 400));
            }
            this.cJ = this.cI;
            this.cI = this.gY() ? (this.cI += (1.0f - this.cI) * 0.4f) : (this.cI += (0.0f - this.cI) * 0.4f);
            if (this.bw()) {
                this.cK = true;
                if (this.cL && !this.an().D_()) {
                    this.an().a((Entity)this, (byte)56);
                    this.hb();
                }
            } else if ((this.cK || this.cL) && this.cL) {
                if (this.cM == 0.0f) {
                    this.a(SoundEffects.Fg, this.ft(), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                    this.c(GameEvent.u);
                }
                this.cN = this.cM;
                this.cM += 0.05f;
                if (this.cN >= 2.0f) {
                    this.cK = false;
                    this.cL = false;
                    this.cN = 0.0f;
                    this.cM = 0.0f;
                }
                if (this.cM > 0.4f) {
                    float f2 = (float)this.dM();
                    int i2 = (int)(MathHelper.a((this.cM - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3D deltaMovement = this.dI();
                    for (int i1 = 0; i1 < i2; ++i1) {
                        float f1 = (this.as.i() * 2.0f - 1.0f) * this.dA() * 0.5f;
                        float f22 = (this.as.i() * 2.0f - 1.0f) * this.dA() * 0.5f;
                        this.an().a(Particles.aq, this.dK() + (double)f1, (double)(f2 + 0.8f), this.dQ() + (double)f22, deltaMovement.g, deltaMovement.h, deltaMovement.i);
                    }
                }
            }
        }
    }

    private void hb() {
        this.cL = false;
        this.cM = 0.0f;
        this.cN = 0.0f;
    }

    @Override
    public void a(DamageSource damageSource) {
        this.cK = false;
        this.cL = false;
        this.cN = 0.0f;
        this.cM = 0.0f;
        super.a(damageSource);
    }

    public float J(float partialTick) {
        return !this.cK ? 1.0f : Math.min(0.75f + MathHelper.h(partialTick, this.cN, this.cM) / 2.0f * 0.25f, 1.0f);
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cN, this.cM);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cJ, this.cI) * 0.15f * (float)Math.PI;
    }

    @Override
    public int af() {
        return this.s() ? 20 : super.af();
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        this.z(false);
        return true;
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        if (!this.i(damageSource)) {
            return super.actuallyHurt(level, damageSource, amount, event);
        }
        if (event.isCancelled()) {
            return false;
        }
        ItemStack bodyArmorItem = this.al();
        int damageValue = bodyArmorItem.o();
        int maxDamage = bodyArmorItem.p();
        bodyArmorItem.a(MathHelper.f(amount), (EntityLiving)this, EnumItemSlot.g);
        if (Crackiness.b.a(damageValue, maxDamage) != Crackiness.b.a(this.al())) {
            this.a(SoundEffects.Fd);
            level.a(new ParticleParamItem(Particles.V, Items.pR.m()), this.dK(), this.dM() + 1.0, this.dQ(), 20, 0.2, 0.1, 0.2, 0.1);
        }
        return true;
    }

    private boolean i(DamageSource damageSource) {
        return this.al().a(Items.pS) && !damageSource.a(DamageTypeTags.C);
    }

    @Override
    protected void n() {
        if (this.m()) {
            this.h(GenericAttributes.t).a(40.0);
            this.x(this.fj());
        } else {
            this.h(GenericAttributes.t).a(8.0);
        }
    }

    @Override
    protected void c(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.g);
    }

    @Override
    protected boolean a(EntityHuman player) {
        return this.j(player);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        block17: {
            ItemStack itemInHand;
            block14: {
                ItemDye dyeItem;
                block16: {
                    block15: {
                        itemInHand = player.b(hand);
                        Item item = itemInHand.h();
                        if (!this.m()) break block14;
                        if (this.i(itemInHand) && this.eU() < this.fj()) {
                            this.a(player, hand, itemInHand);
                            FoodInfo foodProperties = itemInHand.a(DataComponents.v);
                            float f2 = foodProperties != null ? (float)foodProperties.a() : 1.0f;
                            this.heal(2.0f * f2, EntityRegainHealthEvent.RegainReason.EATING);
                            return EnumInteractionResult.a;
                        }
                        if (!(item instanceof ItemDye)) break block15;
                        dyeItem = (ItemDye)item;
                        if (this.j(player)) break block16;
                    }
                    if (this.a(itemInHand, EnumItemSlot.g) && !this.go() && this.j(player) && !this.g_()) {
                        this.h(itemInHand.c(1));
                        itemInHand.a(1, (EntityLiving)player);
                        return EnumInteractionResult.a;
                    }
                    if (this.s() && this.go() && this.j(player) && this.al().n() && this.al().c(itemInHand)) {
                        itemInHand.h(1);
                        this.a(SoundEffects.Ff);
                        ItemStack bodyArmorItem = this.al();
                        int i2 = (int)((float)bodyArmorItem.p() * 0.125f);
                        bodyArmorItem.b(Math.max(0, bodyArmorItem.o() - i2));
                        return EnumInteractionResult.a;
                    }
                    EnumInteractionResult interactionResult = super.b(player, hand);
                    if (!interactionResult.a() && this.j(player)) {
                        this.z(!this.gI());
                        this.bL = false;
                        this.cp.n();
                        this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET);
                        return EnumInteractionResult.a.b();
                    }
                    return interactionResult;
                }
                EnumColor dyeColor = dyeItem.a();
                if (dyeColor != this.gX()) {
                    EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)dyeColor.a())), (Player)player.getBukkitEntity());
                    if (!event.callEvent()) {
                        return EnumInteractionResult.d;
                    }
                    dyeColor = EnumColor.a(event.getColor().getWoolData());
                    this.a(dyeColor);
                    itemInHand.a(1, (EntityLiving)player);
                    return EnumInteractionResult.a;
                }
                break block17;
            }
            if (!this.an().D_() && itemInHand.a(Items.tD) && !this.ae_()) {
                itemInHand.a(1, (EntityLiving)player);
                this.i(player);
                return EnumInteractionResult.b;
            }
            if (this.an().purpurConfig.wolfMilkCuresRabies && itemInHand.h() == Items.sq && this.isRabid()) {
                if (!player.gQ()) {
                    player.a(hand, new ItemStack(Items.sk));
                }
                this.setRabid(false);
                for (int i3 = 0; i3 < 10; ++i3) {
                    ((WorldServer)this.an()).sendParticlesSource(((WorldServer)this.an()).C(), null, Particles.R, false, true, this.dK() + (double)this.as.i(), this.dM() + (double)this.as.i() * 1.5, this.dQ() + (double)this.as.i(), 1, this.as.k() * 0.05, this.as.k() * 0.05, this.as.k() * 0.05, 0.0);
                }
                return EnumInteractionResult.b;
            }
        }
        return super.b(player, hand);
    }

    private void i(EntityHuman player) {
        if ((this.an().purpurConfig.alwaysTameInCreative && player.gk() || this.as.a(3) == 0) && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
            this.g(player);
            this.cp.n();
            this.g((EntityLiving)null);
            this.z(true);
            this.an().a((Entity)this, (byte)7);
        } else {
            this.an().a((Entity)this, (byte)6);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 8) {
            this.cL = true;
            this.cM = 0.0f;
            this.cN = 0.0f;
        } else if (id == 56) {
            this.hb();
        } else {
            super.b(id);
        }
    }

    public float gW() {
        if (this.ae_()) {
            return 1.5393804f;
        }
        if (this.m()) {
            float maxHealth = this.fj();
            float f2 = (maxHealth - this.eU()) / maxHealth;
            return (0.55f - f2 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aH);
    }

    @Override
    public int ak() {
        return 8;
    }

    @Override
    public int a() {
        return this.az.a(cB);
    }

    @Override
    public void a(int remainingPersistentAngerTime) {
        this.az.a(cB, remainingPersistentAngerTime);
    }

    @Override
    public void c() {
        this.a(cO.a(this.as));
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cP;
    }

    @Override
    public void a(@Nullable UUID persistentAngerTarget) {
        this.cP = persistentAngerTarget;
    }

    public EnumColor gX() {
        return EnumColor.a(this.az.a(cA));
    }

    public void a(EnumColor color) {
        this.az.a(cA, color.a());
    }

    @Nullable
    public EntityWolf b(WorldServer level, EntityAgeable partner) {
        EntityWolf wolf = EntityTypes.bR.a(level, EntitySpawnReason.e);
        if (wolf != null && partner instanceof EntityWolf) {
            EntityWolf wolf1 = (EntityWolf)partner;
            if (this.as.h()) {
                wolf.b(this.gZ());
            } else {
                wolf.b(wolf1.gZ());
            }
            if (this.m()) {
                ((EntityTameableAnimal)wolf).a(this.d());
                wolf.a(true, true);
                EnumColor collarColor = this.gX();
                EnumColor collarColor1 = wolf1.gX();
                wolf.a(EnumColor.a(level, collarColor, collarColor1));
            }
            wolf.k(WolfSoundVariants.a(this.ej(), this.as));
        }
        return wolf;
    }

    public void A(boolean isInterested) {
        this.az.a(cz, isInterested);
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        EntityWolf wolf;
        return otherAnimal != this && this.m() && otherAnimal instanceof EntityWolf && (wolf = (EntityWolf)otherAnimal).m() && !wolf.s() && this.gS() && wolf.gS();
    }

    public boolean gY() {
        return this.az.a(cz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean a(EntityLiving target, EntityLiving owner) {
        if (target instanceof EntityCreeper) return false;
        if (target instanceof EntityGhast) return false;
        if (target instanceof EntityArmorStand) {
            return false;
        }
        if (target instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)target;
            if (!wolf.m()) return true;
            if (wolf.V_() == owner) return false;
            return true;
        }
        if (target instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)target;
            if (owner instanceof EntityHuman) {
                EntityHuman player1 = (EntityHuman)owner;
                if (!player1.a(player)) return false;
            }
        }
        if (target instanceof EntityHorseAbstract) {
            EntityHorseAbstract abstractHorse = (EntityHorseAbstract)target;
            if (abstractHorse.gZ()) return false;
        }
        if (!(target instanceof EntityTameableAnimal)) return true;
        EntityTameableAnimal tamableAnimal = (EntityTameableAnimal)target;
        if (tamableAnimal.m()) return false;
        return true;
    }

    @Override
    public boolean v() {
        return !this.ae_();
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.6f * this.df(), this.dA() * 0.4f);
    }

    public static boolean c(EntityTypes<EntityWolf> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.ct) && EntityWolf.a(level, pos);
    }

    class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf wolf, Class<T> avoidClass, float maxDistance, double walkSpeedModifier, double sprintSpeedModifier) {
            super(wolf, avoidClass, maxDistance, walkSpeedModifier, sprintSpeedModifier);
            this.j = wolf;
        }

        @Override
        public boolean b() {
            return super.b() && this.b instanceof EntityLlama && !this.j.m() && this.a((EntityLlama)this.b);
        }

        private boolean a(EntityLlama llama) {
            return llama.gM() >= EntityWolf.this.as.a(5);
        }

        @Override
        public void d() {
            EntityWolf.this.g((EntityLiving)null);
            super.d();
        }

        @Override
        public void a() {
            EntityWolf.this.g((EntityLiving)null);
            super.a();
        }
    }

    private static final class AvoidRabidWolfGoal
    extends PathfinderGoalAvoidTarget<EntityWolf> {
        private final EntityWolf wolf;

        public AvoidRabidWolfGoal(EntityWolf wolf, float distance, double minSpeed, double maxSpeed) {
            super(wolf, EntityWolf.class, distance, minSpeed, maxSpeed);
            this.wolf = wolf;
        }

        @Override
        public boolean b() {
            return super.b() && !this.wolf.isRabid() && this.b != null && ((EntityWolf)this.b).isRabid();
        }

        @Override
        public void d() {
            this.wolf.g((EntityLiving)null);
            super.d();
        }

        @Override
        public void a() {
            this.wolf.g((EntityLiving)null);
            super.a();
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Holder<WolfVariant> a;

        public b(Holder<WolfVariant> type) {
            super(false);
            this.a = type;
        }
    }
}

