/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityEnderCrystal
extends Entity {
    private static final DataWatcherObject<Optional<BlockPosition>> b = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.p);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.k);
    private static final boolean d = true;
    public int a;
    public boolean generatedByDragonFight = false;
    private EntityPhantom targetPhantom;
    private int phantomBeamTicks = 0;
    private int phantomDamageCooldown = 0;
    private int idleCooldown = 0;

    public EntityEnderCrystal(EntityTypes<? extends EntityEnderCrystal> type, World level) {
        super(type, level);
        this.W = true;
        this.a = this.as.a(100000);
    }

    public EntityEnderCrystal(World level, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityEnderCrystal>)EntityTypes.U, level);
        this.a_(x2, y2, z2);
    }

    public boolean shouldExplode() {
        return this.f() ? this.an().purpurConfig.basedEndCrystalExplode : this.an().purpurConfig.baselessEndCrystalExplode;
    }

    public float getExplosionPower() {
        return (float)(this.f() ? this.an().purpurConfig.basedEndCrystalExplosionPower : this.an().purpurConfig.baselessEndCrystalExplosionPower);
    }

    public boolean hasExplosionFire() {
        return this.f() ? this.an().purpurConfig.basedEndCrystalExplosionFire : this.an().purpurConfig.baselessEndCrystalExplosionFire;
    }

    public World.a getExplosionEffect() {
        return this.f() ? this.an().purpurConfig.basedEndCrystalExplosionEffect : this.an().purpurConfig.baselessEndCrystalExplosionEffect;
    }

    @Override
    protected Entity.MovementEmission br() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(b, Optional.empty());
        builder.a(c, true);
    }

    @Override
    public void g() {
        ++this.a;
        this.aT();
        this.ci();
        if (this.an() instanceof WorldServer) {
            BlockPosition blockPos = this.dF();
            if (((WorldServer)this.an()).I() != null && this.an().a_(blockPos).l() && !CraftEventFactory.callBlockIgniteEvent(this.an(), blockPos, this).isCancelled()) {
                this.an().c(blockPos, BlockFireAbstract.a(this.an(), blockPos));
            }
        }
        if (this.an().paperConfig().unsupportedSettings.fixInvulnerableEndCrystalExploit && this.generatedByDragonFight && this.cP() && (!Objects.equals(((WorldServer)this.an()).uuid, this.originWorld) || ((WorldServer)this.an()).I() == null || ((WorldServer)this.an()).I().z == null || ((WorldServer)this.an()).I().z.ordinal() > EnumDragonRespawn.d.ordinal())) {
            this.n(false);
            this.a((BlockPosition)null);
        }
        if (this.an().purpurConfig.endCrystalCramming > 0 && this.an().a(EntityEnderCrystal.class, this.de()).size() > this.an().purpurConfig.endCrystalCramming) {
            this.a(this.ei().h(), 6.0f);
        }
        if (this.an().purpurConfig.phantomAttackedByCrystalRadius <= 0.0 || --this.idleCooldown > 0) {
            return;
        }
        if (this.targetPhantom == null) {
            for (EntityPhantom phantom : this.an().a(EntityPhantom.class, this.de().g(this.an().purpurConfig.phantomAttackedByCrystalRadius))) {
                if (!phantom.F(this)) continue;
                this.attackPhantom(phantom);
                break;
            }
        } else {
            this.a(new BlockPosition(this.targetPhantom).b(0, -2, 0));
            if (--this.phantomBeamTicks > 0 && this.targetPhantom.bX()) {
                --this.phantomDamageCooldown;
                if (this.targetPhantom.F(this)) {
                    if (this.phantomDamageCooldown <= 0) {
                        this.phantomDamageCooldown = 20;
                        this.targetPhantom.a(this.targetPhantom.ei().c((Entity)this, this), this.an().purpurConfig.phantomAttackedByCrystalDamage);
                    }
                } else {
                    this.forgetPhantom();
                }
            } else {
                this.forgetPhantom();
            }
        }
    }

    private void attackPhantom(EntityPhantom phantom) {
        this.phantomDamageCooldown = 0;
        this.phantomBeamTicks = 60;
        this.targetPhantom = phantom;
    }

    private void forgetPhantom() {
        this.targetPhantom = null;
        this.a((BlockPosition)null);
        this.phantomBeamTicks = 0;
        this.phantomDamageCooldown = 0;
        this.idleCooldown = 60;
    }

    @Override
    protected void a(ValueOutput output) {
        output.b("beam_target", BlockPosition.a, this.e());
        output.a("ShowBottom", this.f());
        output.a("Paper.GeneratedByDragonFight", this.generatedByDragonFight);
    }

    @Override
    protected void a(ValueInput input) {
        this.a((BlockPosition)input.a("beam_target", BlockPosition.a).orElse(null));
        this.a(input.a("ShowBottom", true));
        this.generatedByDragonFight = input.a("Paper.GeneratedByDragonFight", false);
    }

    @Override
    public boolean bT() {
        return true;
    }

    @Override
    public final boolean b(DamageSource damageSource) {
        return !this.d(damageSource) && !(damageSource.d() instanceof EntityEnderDragon);
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.d(damageSource)) {
            return false;
        }
        if (damageSource.d() instanceof EntityEnderDragon) {
            return false;
        }
        if (!this.ec()) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, false)) {
                return false;
            }
            if (!damageSource.a(DamageTypeTags.l)) {
                if (this.shouldExplode()) {
                    DamageSource damageSource1 = damageSource.d() != null ? this.ei().d(this, damageSource.d()) : null;
                    ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, this.getExplosionPower(), this.hasExplosionFire());
                    if (event.isCancelled()) {
                        return false;
                    }
                    this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.EXPLODE);
                    level.a((Entity)this, damageSource1, null, this.dK(), this.dM(), this.dQ(), event.getRadius(), event.getFire(), this.getExplosionEffect());
                } else {
                    this.ee();
                }
            } else {
                this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            }
            this.a(level, damageSource);
        }
        return true;
    }

    @Override
    public void c(WorldServer level) {
        this.a(level, this.ei().p());
        super.c(level);
    }

    private void a(WorldServer level, DamageSource damageSource) {
        EnderDragonBattle dragonFight = level.I();
        if (dragonFight != null) {
            dragonFight.a(this, damageSource);
        }
    }

    public void a(@Nullable BlockPosition beamTarget) {
        this.aC().a(b, Optional.ofNullable(beamTarget));
    }

    @Nullable
    public BlockPosition e() {
        return this.aC().a(b).orElse(null);
    }

    public void a(boolean showBottom) {
        this.aC().a(c, showBottom);
    }

    public boolean f() {
        return this.aC().a(c);
    }

    @Override
    public boolean a(double distance) {
        return super.a(distance) || this.e() != null;
    }

    @Override
    public ItemStack dU() {
        return new ItemStack(Items.xp);
    }
}

