/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.purpurmc.purpur.controller.FlyingMoveControllerWASD;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger cv = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> a = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition cw = PathfinderTargetCondition.a().a(64.0);
    private static final int cx = 200;
    private static final int cy = 400;
    private static final float cz = 0.25f;
    private static final String cA = "DragonDeathTime";
    private static final String cB = "DragonPhase";
    private static final int cC = 0;
    public final DragonFlightHistory b = new DragonFlightHistory();
    public final EntityComplexPart[] cD;
    public final EntityComplexPart c;
    private final EntityComplexPart cE;
    private final EntityComplexPart cF;
    private final EntityComplexPart cG;
    private final EntityComplexPart cH;
    private final EntityComplexPart cI;
    private final EntityComplexPart cJ;
    private final EntityComplexPart cK;
    public float d;
    public float e;
    public boolean f;
    public int cs = 0;
    public float ct;
    @Nullable
    public EntityEnderCrystal cu;
    @Nullable
    private EnderDragonBattle cL;
    private BlockPosition cM = BlockPosition.c;
    private final DragonControllerManager cN;
    private int cO = 100;
    private float cP;
    private final PathPoint[] cS = new PathPoint[24];
    private final int[] cT = new int[24];
    private final Path cU = new Path();
    private final Explosion explosionSource;
    @Nullable
    private BlockPosition podium;
    private boolean hadRider;

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> type, World level) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.S, level);
        this.c = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.cE = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.cF = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.cG = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cH = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cI = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cJ = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cK = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cD = new EntityComplexPart[]{this.c, this.cE, this.cF, this.cG, this.cH, this.cI, this.cJ, this.cK};
        this.x(this.fj());
        this.ar = true;
        this.cN = new DragonControllerManager(this);
        this.explosionSource = new ServerExplosion(level.getMinecraftWorld(), this, null, null, new Vec3D(Double.NaN, Double.NaN, Double.NaN), Float.NaN, true, Explosion.Effect.b);
        this.cn = new FlyingMoveControllerWASD(this, this){

            @Override
            public void vanillaTick() {
            }
        };
        this.cm = new LookControllerWASD(this, this){

            @Override
            public void vanillaTick() {
            }

            @Override
            public void purpurTick(EntityHuman rider) {
                this.setYawPitch(rider.dX() - 180.0f, rider.ac * 0.5f);
            }
        };
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.enderDragonRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.enderDragonRidableInWater;
    }

    public void a(EnderDragonBattle dragonFight) {
        this.cL = dragonFight;
    }

    public void c(BlockPosition fightOrigin) {
        this.cM = fightOrigin;
    }

    public BlockPosition k() {
        return this.cM;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.enderDragonControllable;
    }

    @Override
    public double getMaxY() {
        return this.an().purpurConfig.enderDragonMaxY;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.enderDragonMaxHealth);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.enderDragonTakeDamageFromWater;
    }

    public static AttributeProvider.Builder m() {
        return EntityInsentient.I().a(GenericAttributes.t, 200.0).a(GenericAttributes.i, 16.0);
    }

    public BlockPosition getPodium() {
        if (this.podium == null) {
            return WorldGenEndTrophy.a(this.k());
        }
        return this.podium;
    }

    public void setPodium(@Nullable BlockPosition blockPos) {
        this.podium = blockPos;
    }

    @Override
    public boolean bl() {
        float cos = MathHelper.b(this.e * ((float)Math.PI * 2));
        float cos1 = MathHelper.b(this.d * ((float)Math.PI * 2));
        return cos1 <= -0.3f && cos >= -0.3f;
    }

    @Override
    public void bk() {
        if (this.an().D_() && !this.bm()) {
            this.an().a(this.dK(), this.dM(), this.dQ(), SoundEffects.jp, this.dw(), 5.0f, 0.8f + this.as.i() * 0.3f, false);
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, DragonControllerPhase.k.b());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void e_() {
        block28: {
            block29: {
                block27: {
                    v0 = hasRider = this.getRider() != null && this.isControllable() != false;
                    if (hasRider) {
                        if (!this.hadRider) {
                            this.hadRider = true;
                            this.ar = false;
                            this.bz = EntitySize.b(4.0f, 2.0f);
                        }
                        this.cn.a();
                        this.cm.a();
                        this.a((float)this.i(GenericAttributes.w) * 0.1f, new Vec3D(-this.getStrafeMot(), this.getVerticalMot(), -this.getForwardMot()));
                        mot = this.dI();
                        this.k(mot);
                        this.a(EnumMoveType.b, mot);
                        mot = mot.d(0.8999999761581421, 0.8999999761581421, 0.8999999761581421);
                        this.k(mot);
                        this.cN.a(mot.a() * mot.a() + mot.c() * mot.c() < 0.004999999888241291 ? DragonControllerPhase.k : DragonControllerPhase.a);
                    } else if (this.hadRider) {
                        this.hadRider = false;
                        this.ar = true;
                        this.bz = EntitySize.b(16.0f, 8.0f);
                        this.cN.a(DragonControllerPhase.a);
                    }
                    this.aZ();
                    if (this.an().D_()) {
                        this.x(this.eU());
                        if (!this.bm() && !this.cN.a().a() && --this.cO < 0) {
                            this.an().a(this.dK(), this.dM(), this.dQ(), SoundEffects.jq, this.dw(), 2.5f, 0.8f + this.as.i() * 0.3f, false);
                            this.cO = 200 + this.as.a(200);
                        }
                    }
                    if (this.cL == null && (var3_4 = this.an()) instanceof WorldServer && (dragonFight = (serverLevel = (WorldServer)var3_4).I()) != null && this.cT().equals(dragonFight.i())) {
                        this.cL = dragonFight;
                    }
                    this.d = this.e;
                    if (!this.eV()) break block27;
                    if (hasRider) {
                        this.ca();
                    }
                    f = (this.as.i() - 0.5f) * 8.0f;
                    f1 = (this.as.i() - 0.5f) * 4.0f;
                    f2 = (this.as.i() - 0.5f) * 8.0f;
                    this.an().a(Particles.x, this.dK() + (double)f, this.dM() + 2.0 + (double)f1, this.dQ() + (double)f2, 0.0, 0.0, 0.0);
                    break block28;
                }
                this.gH();
                deltaMovement = this.dI();
                f1 = 0.2f / ((float)deltaMovement.i() * 10.0f + 1.0f);
                this.e = !hasRider && this.cN.a().a() ? (this.e += 0.1f) : (!hasRider && this.f ? (this.e += f1 * 0.5f) : (this.e += (f1 *= (float)Math.pow(2.0, deltaMovement.h))));
                this.v(MathHelper.h(this.dX()));
                if (!this.gx()) break block29;
                this.e = 0.5f;
                break block28;
            }
            this.b.a(this.dM(), this.dX());
            var5_9 = this.an();
            if (!(var5_9 instanceof WorldServer)) ** GOTO lbl-1000
            serverLevel1 = (WorldServer)var5_9;
            if (!hasRider) {
                currentPhase = this.cN.a();
                currentPhase.a(serverLevel1);
                if (this.cN.a() != currentPhase) {
                    currentPhase = this.cN.a();
                    currentPhase.a(serverLevel1);
                }
                if ((flyTargetLocation = currentPhase.f()) != null && currentPhase.h() != DragonControllerPhase.k) {
                    d = flyTargetLocation.g - this.dK();
                    d1 = flyTargetLocation.h - this.dM();
                    d2 = flyTargetLocation.i - this.dQ();
                    d3 = d * d + d1 * d1 + d2 * d2;
                    flySpeed = currentPhase.e();
                    squareRoot = Math.sqrt(d * d + d2 * d2);
                    if (squareRoot > 0.0) {
                        d1 = MathHelper.a(d1 / squareRoot, (double)(-flySpeed), (double)flySpeed);
                    }
                    this.k(this.dI().b(0.0, d1 * 0.01, 0.0));
                    this.v(MathHelper.h(this.dX()));
                    vec3 = flyTargetLocation.a(this.dK(), this.dM(), this.dQ()).d();
                    vec31 = new Vec3D(MathHelper.a(this.dX() * 0.017453292f), this.dI().h, -MathHelper.b(this.dX() * 0.017453292f)).d();
                    max = Math.max(((float)vec31.b(vec3) + 0.5f) / 1.5f, 0.0f);
                    if (Math.abs(d) > 9.999999747378752E-6 || Math.abs(d2) > 9.999999747378752E-6) {
                        f3 = MathHelper.a(MathHelper.h(180.0f - (float)MathHelper.d(d, d2) * 57.295776f - this.dX()), -50.0f, 50.0f);
                        this.ct *= 0.8f;
                        this.ct += f3 * currentPhase.g();
                        this.v(this.dX() + this.ct * 0.1f);
                    }
                    f3 = (float)(2.0 / (d3 + 1.0));
                    f4 = 0.06f;
                    this.a(0.06f * (max * f3 + (1.0f - f3)), new Vec3D(0.0, 0.0, -1.0));
                    if (this.f) {
                        this.a(EnumMoveType.a, this.dI().c(0.800000011920929));
                    } else {
                        this.a(EnumMoveType.a, this.dI());
                    }
                    vec32 = this.dI().d();
                    d4 = 0.8 + 0.15 * (vec32.b(vec31) + 1.0) / 2.0;
                    this.k(this.dI().d(d4, 0.9100000262260437, d4));
                }
            } else lbl-1000:
            // 2 sources

            {
                this.bP.e();
                this.cN.a().b();
            }
            if (!this.an().D_()) {
                this.aT();
            }
            this.bB = this.dX();
            vec3s = new Vec3D[this.cD.length];
            for (i = 0; i < this.cD.length; ++i) {
                vec3s[i] = new Vec3D(this.cD[i].dK(), this.cD[i].dM(), this.cD[i].dQ());
            }
            f5 = (float)(this.b.a(5).a() - this.b.a(10).a()) * 10.0f * 0.017453292f;
            cos = MathHelper.b(f5);
            sin = MathHelper.a(f5);
            f6 = this.dX() * 0.017453292f;
            sin1 = MathHelper.a(f6);
            cos1 = MathHelper.b(f6);
            this.a(this.cF, (double)(sin1 * 0.5f), 0.0, (double)(-cos1 * 0.5f));
            this.a(this.cJ, (double)(cos1 * 4.5f), 2.0, (double)(sin1 * 4.5f));
            this.a(this.cK, (double)(cos1 * -4.5f), 2.0, (double)(sin1 * -4.5f));
            var12_41 = this.an();
            if (var12_41 instanceof WorldServer) {
                serverLevel2 = (WorldServer)var12_41;
                if (this.bt == 0 && !hasRider) {
                    this.a(serverLevel2, serverLevel2.a((Entity)this, this.cJ.de().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    this.a(serverLevel2, serverLevel2.a((Entity)this, this.cK.de().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    this.b(serverLevel2, serverLevel2.a((Entity)this, this.c.de().g(1.0), IEntitySelector.e));
                    this.b(serverLevel2, serverLevel2.a((Entity)this, this.cE.de().g(1.0), IEntitySelector.e));
                }
            }
            sin2 = MathHelper.a(this.dX() * 0.017453292f - this.ct * 0.01f);
            cos2 = MathHelper.b(this.dX() * 0.017453292f - this.ct * 0.01f);
            headYOffset = this.gG();
            this.a(this.c, (double)(sin2 * 6.5f * cos), (double)(headYOffset + sin * 6.5f), (double)(-cos2 * 6.5f * cos));
            this.a(this.cE, (double)(sin2 * 5.5f * cos), (double)(headYOffset + sin * 5.5f), (double)(-cos2 * 5.5f * cos));
            sample = this.b.a(5);
            for (i1 = 0; i1 < 3; ++i1) {
                enderDragonPart = null;
                if (i1 == 0) {
                    enderDragonPart = this.cG;
                }
                if (i1 == 1) {
                    enderDragonPart = this.cH;
                }
                if (i1 == 2) {
                    enderDragonPart = this.cI;
                }
                sample1 = this.b.a(12 + i1 * 2);
                f7 = this.dX() * 0.017453292f + this.j((double)(sample1.b() - sample.b())) * 0.017453292f;
                sin3 = MathHelper.a(f7);
                maxx = MathHelper.b(f7);
                f3 = 1.5f;
                f4 = (float)(i1 + 1) * 2.0f;
                this.a(enderDragonPart, (double)(-(sin1 * 1.5f + sin3 * f4) * cos), sample1.a() - sample.a() - (double)((f4 + 1.5f) * sin) + 1.5, (double)((cos1 * 1.5f + maxx * f4) * cos));
            }
            var16_29 = this.an();
            if (var16_29 instanceof WorldServer) {
                serverLevel3 = (WorldServer)var16_29;
                v1 = this.f = hasRider == false && (this.a(serverLevel3, this.c.de()) | this.a(serverLevel3, this.cE.de()) | this.a(serverLevel3, this.cF.de())) != false;
                if (this.cL != null) {
                    this.cL.b(this);
                }
            }
            for (i1 = 0; i1 < this.cD.length; ++i1) {
                this.cD[i1].Y = vec3s[i1].g;
                this.cD[i1].Z = vec3s[i1].h;
                this.cD[i1].aa = vec3s[i1].i;
                this.cD[i1].ao = vec3s[i1].g;
                this.cD[i1].ap = vec3s[i1].h;
                this.cD[i1].aq = vec3s[i1].i;
            }
        }
    }

    private void a(EntityComplexPart part, double offsetX, double offsetY, double offsetZ) {
        part.a_(this.dK() + offsetX, this.dM() + offsetY, this.dQ() + offsetZ);
    }

    private float gG() {
        if (this.cN.a().a()) {
            return -1.0f;
        }
        DragonFlightHistory.a sample = this.b.a(5);
        DragonFlightHistory.a sample1 = this.b.a(0);
        return (float)(sample.a() - sample1.a());
    }

    private void gH() {
        if (this.cu != null) {
            EntityRegainHealthEvent event;
            if (this.cu.ec()) {
                this.cu = null;
            } else if (this.at % 10 == 0 && this.eU() < this.fj() && (event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL)).callEvent()) {
                this.x((float)((double)this.eU() + event.getAmount()));
            }
        }
        if (this.as.a(10) == 0) {
            List<EntityEnderCrystal> entitiesOfClass = this.an().a(EntityEnderCrystal.class, this.de().g(32.0));
            EntityEnderCrystal endCrystal = null;
            double d2 = Double.MAX_VALUE;
            for (EntityEnderCrystal endCrystal1 : entitiesOfClass) {
                double d1 = endCrystal1.g(this);
                if (!(d1 < d2)) continue;
                d2 = d1;
                endCrystal = endCrystal1;
            }
            this.cu = endCrystal;
        }
    }

    private void a(WorldServer level, List<Entity> targets) {
        double d2 = (this.cF.de().a + this.cF.de().d) / 2.0;
        double d1 = (this.cF.de().c + this.cF.de().f) / 2.0;
        for (Entity entity : targets) {
            if (!(entity instanceof EntityLiving)) continue;
            EntityLiving livingEntity = (EntityLiving)entity;
            double d22 = entity.dK() - d2;
            double d3 = entity.dQ() - d1;
            double max = Math.max(d22 * d22 + d3 * d3, 0.1);
            entity.push(d22 / max * 4.0, 0.2f, d3 / max * 4.0, this);
            if (this.cN.a().a() || livingEntity.eH() >= entity.at - 2) continue;
            DamageSource damageSource = this.ei().b(this);
            entity.a(level, damageSource, 5.0f);
            EnchantmentManager.a(level, entity, damageSource);
        }
    }

    private void b(WorldServer level, List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            DamageSource damageSource = this.ei().b(this);
            entity.a(level, damageSource, 10.0f);
            EnchantmentManager.a(level, entity, damageSource);
        }
    }

    private float j(double angle) {
        return (float)MathHelper.e(angle);
    }

    private boolean a(WorldServer level, AxisAlignedBB box) {
        int floor = MathHelper.a(box.a);
        int floor1 = MathHelper.a(box.b);
        int floor2 = MathHelper.a(box.c);
        int floor3 = MathHelper.a(box.d);
        int floor4 = MathHelper.a(box.e);
        int floor5 = MathHelper.a(box.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<org.bukkit.block.Block> destroyedBlocks = new ArrayList<org.bukkit.block.Block>();
        for (int i2 = floor; i2 <= floor3; ++i2) {
            for (int i1 = floor1; i1 <= floor4; ++i1) {
                for (int i22 = floor2; i22 <= floor5; ++i22) {
                    BlockPosition blockPos = new BlockPosition(i2, i1, i22);
                    IBlockData blockState = level.a_(blockPos);
                    if (blockState.l() || blockState.a(TagsBlock.aR)) continue;
                    if (level.S().getBoolean(GameRules.d, level.purpurConfig.enderDragonMobGriefingOverride) && !blockState.a(TagsBlock.aQ)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(level, blockPos));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this, destroyedBlocks, 0.0f, this.explosionSource.b());
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.an().a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                CraftBlock tntBlock;
                Material blockType = block.getType();
                if (blockType.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition pos = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity blockEntity = craftBlock.getNMS().x() ? this.an().c_(pos) : null;
                    LootParams.a builder = new LootParams.a((WorldServer)this.an()).a(LootContextParameters.h, Vec3D.b(pos)).a(LootContextParameters.k, ItemStack.l).a(LootContextParameters.l, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.j, blockEntity);
                    craftBlock.getNMS().a(builder).forEach(stack -> Block.a(this.an(), pos, stack));
                    craftBlock.getNMS().a((WorldServer)this.an(), pos, ItemStack.l, false);
                }
                if (!new TNTPrimeEvent((org.bukkit.block.Block)(tntBlock = CraftBlock.at(this.an(), pos)), TNTPrimeEvent.PrimeReason.EXPLOSION, (org.bukkit.entity.Entity)this.explosionSource.c().getBukkitEntity()).callEvent()) continue;
                nmsBlock.a((WorldServer)this.an(), pos, this.explosionSource);
                this.an().a(pos, false);
            }
        }
        if (flag1) {
            BlockPosition blockPos1 = new BlockPosition(floor + this.as.a(floor3 - floor + 1), floor1 + this.as.a(floor4 - floor1 + 1), floor2 + this.as.a(floor5 - floor2 + 1));
            level.c(2008, blockPos1, 0);
        }
        return flag;
    }

    public boolean a(WorldServer level, EntityComplexPart part, DamageSource damageSource, float amount) {
        if (this.cN.a().h() == DragonControllerPhase.j) {
            return false;
        }
        amount = this.cN.a().a(damageSource, amount);
        if (part != this.c) {
            amount = amount / 4.0f + Math.min(amount, 1.0f);
        }
        if (amount < 0.01f) {
            return false;
        }
        if (damageSource.d() instanceof EntityHuman || damageSource.a(DamageTypeTags.y)) {
            float health = this.eU();
            this.d(level, damageSource, amount);
            if (this.eV() && !this.cN.a().a()) {
                this.x(1.0f);
                this.cN.a(DragonControllerPhase.j);
            }
            if (this.cN.a().a()) {
                this.cP = this.cP + health - this.eU();
                if (this.cP > 0.25f * this.fj()) {
                    this.cP = 0.0f;
                    this.cN.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return this.a(level, this.cF, damageSource, amount);
    }

    protected void d(WorldServer level, DamageSource damageSource, float amount) {
        super.a(level, damageSource, amount);
    }

    @Override
    public void c(WorldServer level) {
        this.silentDeath = true;
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, this.ei().y());
        if (deathEvent.isCancelled()) {
            this.silentDeath = false;
            return;
        }
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.c(GameEvent.p);
        if (this.cL != null) {
            this.cL.b(this);
            this.cL.a(this);
        }
    }

    @Override
    protected void eC() {
        World world;
        if (this.cL != null) {
            this.cL.b(this);
        }
        ++this.cs;
        if (this.cs >= 180 && this.cs <= 200) {
            float f2 = (this.as.i() - 0.5f) * 8.0f;
            float f1 = (this.as.i() - 0.5f) * 4.0f;
            float f22 = (this.as.i() - 0.5f) * 8.0f;
            this.an().a(Particles.w, this.dK() + (double)f2, this.dM() + 2.0 + (double)f1, this.dQ() + (double)f22, 0.0, 0.0, 0.0);
        }
        int i2 = this.expToDrop;
        World f22 = this.an();
        if (f22 instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)f22;
            if (this.cs > 150 && this.cs % 5 == 0) {
                EntityExperienceOrb.awardWithDirection(serverLevel, this.dD(), Vec3D.c, MathHelper.d((float)i2 * 0.08f), ExperienceOrb.SpawnReason.ENTITY_DEATH, EntityReference.a(this.bG, this.an(), EntityHuman.class), this);
            }
            if (this.cs == 1 && !this.bm()) {
                int viewDistance = serverLevel.getCraftServer().getViewDistance() * 16;
                for (EntityPlayer player : serverLevel.getPlayersForGlobalSoundGamerule()) {
                    double deltaX = this.dK() - player.dK();
                    double deltaZ = this.dQ() - player.dQ();
                    double distanceSquared = MathHelper.l(deltaX) + MathHelper.l(deltaZ);
                    double soundRadiusSquared = serverLevel.getGlobalSoundRangeSquared(config -> config.dragonDeathSoundRadius);
                    if (!serverLevel.S().c(GameRules.Y) && distanceSquared > soundRadiusSquared) continue;
                    if (distanceSquared > (double)MathHelper.i(viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dK() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dQ() + deltaZ / deltaLength * (double)viewDistance;
                        player.g.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.dM(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.g.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dK(), (int)this.dM(), (int)this.dQ()), 0, true));
                }
            }
        }
        Vec3D vec3 = new Vec3D(0.0, 0.1f, 0.0);
        this.a(EnumMoveType.a, vec3);
        for (EntityComplexPart enderDragonPart : this.cD) {
            enderDragonPart.bL();
            enderDragonPart.b(enderDragonPart.dD().e(vec3));
        }
        if (this.cs == 200 && (world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel1 = (WorldServer)world;
            EntityExperienceOrb.awardWithDirection(serverLevel1, this.dD(), Vec3D.c, MathHelper.d((float)i2 * 0.2f), ExperienceOrb.SpawnReason.ENTITY_DEATH, EntityReference.a(this.bG, this.an(), EntityHuman.class), this);
            if (this.cL != null) {
                this.cL.a(this);
            }
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            this.c(GameEvent.p);
        }
    }

    public int n() {
        if (this.cS[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int floor1;
                int floor;
                int i1 = 5;
                if (i2 < 12) {
                    floor = MathHelper.d(60.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                    floor1 = MathHelper.d(60.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                } else if (i2 < 20) {
                    int i22 = i2 - 12;
                    floor = MathHelper.d(40.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i22)));
                    floor1 = MathHelper.d(40.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i22)));
                    i1 += 10;
                } else {
                    int var7 = i2 - 20;
                    floor = MathHelper.d(20.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)var7)));
                    floor1 = MathHelper.d(20.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)var7)));
                }
                int max = Math.max(73, this.an().a(HeightMap.Type.f, new BlockPosition(floor, 0, floor1)).v() + i1);
                this.cS[i2] = new PathPoint(floor, max, floor1);
            }
            this.cT[0] = 6146;
            this.cT[1] = 8197;
            this.cT[2] = 8202;
            this.cT[3] = 16404;
            this.cT[4] = 32808;
            this.cT[5] = 32848;
            this.cT[6] = 65696;
            this.cT[7] = 131392;
            this.cT[8] = 131712;
            this.cT[9] = 263424;
            this.cT[10] = 526848;
            this.cT[11] = 525313;
            this.cT[12] = 1581057;
            this.cT[13] = 3166214;
            this.cT[14] = 2138120;
            this.cT[15] = 6373424;
            this.cT[16] = 4358208;
            this.cT[17] = 12910976;
            this.cT[18] = 9044480;
            this.cT[19] = 9706496;
            this.cT[20] = 15216640;
            this.cT[21] = 0xD0E000;
            this.cT[22] = 11763712;
            this.cT[23] = 0x7E0000;
        }
        return this.p(this.dK(), this.dM(), this.dQ());
    }

    public int p(double x2, double y2, double z2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint node = new PathPoint(MathHelper.a(x2), MathHelper.a(y2), MathHelper.a(z2));
        int i1 = 0;
        if (this.cL == null || this.cL.e() == 0) {
            i1 = 12;
        }
        for (int i22 = i1; i22 < 24; ++i22) {
            float f1;
            if (this.cS[i22] == null || !((f1 = this.cS[i22].c(node)) < f2)) continue;
            f2 = f1;
            i2 = i22;
        }
        return i2;
    }

    @Nullable
    public PathEntity a(int startIndex, int finishIndex, @Nullable PathPoint andThen) {
        PathPoint node;
        for (int i2 = 0; i2 < 24; ++i2) {
            node = this.cS[i2];
            node.i = false;
            node.g = 0.0f;
            node.e = 0.0f;
            node.f = 0.0f;
            node.h = null;
            node.d = -1;
        }
        PathPoint node1 = this.cS[startIndex];
        node = this.cS[finishIndex];
        node1.e = 0.0f;
        node1.g = node1.f = node1.a(node);
        this.cU.a();
        this.cU.a(node1);
        PathPoint node2 = node1;
        int i1 = 0;
        if (this.cL == null || this.cL.e() == 0) {
            i1 = 12;
        }
        while (!this.cU.e()) {
            PathPoint node3 = this.cU.c();
            if (node3.equals(node)) {
                if (andThen != null) {
                    andThen.h = node;
                    node = andThen;
                }
                return this.a(node1, node);
            }
            if (node3.a(node) < node2.a(node)) {
                node2 = node3;
            }
            node3.i = true;
            int i2 = 0;
            for (int i3 = 0; i3 < 24; ++i3) {
                if (this.cS[i3] != node3) continue;
                i2 = i3;
                break;
            }
            for (int i3x = i1; i3x < 24; ++i3x) {
                if ((this.cT[i2] & 1 << i3x) <= 0) continue;
                PathPoint node4 = this.cS[i3x];
                if (node4.i) continue;
                float f2 = node3.e + node3.a(node4);
                if (node4.c() && !(f2 < node4.e)) continue;
                node4.h = node3;
                node4.e = f2;
                node4.f = node4.a(node);
                if (node4.c()) {
                    this.cU.a(node4, node4.e + node4.f);
                    continue;
                }
                node4.g = node4.e + node4.f;
                this.cU.a(node4);
            }
        }
        if (node2 == node1) {
            return null;
        }
        cv.debug("Failed to find path from {} to {}", (Object)startIndex, (Object)finishIndex);
        if (andThen != null) {
            andThen.h = node2;
            node2 = andThen;
        }
        return this.a(node1, node2);
    }

    private PathEntity a(PathPoint start, PathPoint finish) {
        ArrayList list = Lists.newArrayList();
        PathPoint node = finish;
        list.add(0, finish);
        while (node.h != null) {
            node = node.h;
            list.add(0, node);
        }
        return new PathEntity(list, new BlockPosition(finish.a, finish.b, finish.c), true);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a(cB, this.cN.a().h().b());
        output.a(cA, this.cs);
        output.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        input.e(cB).ifPresent(integer -> this.cN.a(DragonControllerPhase.a(integer)));
        this.cs = input.a(cA, 0);
        this.expToDrop = input.a("Bukkit.expToDrop", 0);
    }

    @Override
    public void dR() {
    }

    public EntityComplexPart[] s() {
        return this.cD;
    }

    @Override
    public boolean bT() {
        return false;
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.f;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.jm;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.jr;
    }

    @Override
    public float ft() {
        return 5.0f;
    }

    public Vec3D J(float partialTick) {
        Vec3D viewVector;
        IDragonController currentPhase = this.cN.a();
        DragonControllerPhase<? extends IDragonController> phase = currentPhase.h();
        if (phase == DragonControllerPhase.d || phase == DragonControllerPhase.e) {
            BlockPosition heightmapPos = this.an().a(HeightMap.Type.f, this.getPodium());
            float max = Math.max((float)Math.sqrt(heightmapPos.b(this.dD())) / 4.0f, 1.0f);
            float f2 = 6.0f / max;
            float xRot = this.dZ();
            float f1 = 1.5f;
            this.w(-f2 * 1.5f * 5.0f);
            viewVector = this.h(partialTick);
            this.w(xRot);
        } else if (currentPhase.a()) {
            float xRot1 = this.dZ();
            float max = 1.5f;
            this.w(-45.0f);
            viewVector = this.h(partialTick);
            this.w(xRot1);
        } else {
            viewVector = this.h(partialTick);
        }
        return viewVector;
    }

    public void a(WorldServer level, EntityEnderCrystal crystal, BlockPosition pos, DamageSource damageSource) {
        EntityHuman player;
        Entity entity = damageSource.d();
        EntityHuman player1 = entity instanceof EntityHuman ? (player = (EntityHuman)entity) : level.a(cw, (double)pos.u(), (double)pos.v(), (double)pos.w());
        if (crystal == this.cu) {
            this.a(level, this.c, this.ei().d(crystal, player1), 10.0f);
        }
        this.cN.a().a(crystal, pos, damageSource, player1);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (a.equals(key) && this.an().D_()) {
            this.cN.a(DragonControllerPhase.a(this.aC().a(a)));
        }
        super.a(key);
    }

    public DragonControllerManager gE() {
        return this.cN;
    }

    @Nullable
    public EnderDragonBattle gF() {
        return this.cL;
    }

    @Override
    public boolean b(MobEffect effectInstance, @Nullable Entity entity) {
        return false;
    }

    @Override
    protected boolean p(Entity entity) {
        if (this.an().purpurConfig.enderDragonCanRideVehicles) {
            return this.X <= 0;
        }
        return false;
    }

    @Override
    public boolean o(boolean allowPassengers) {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        EntityComplexPart[] subEntities = this.s();
        for (int i2 = 0; i2 < subEntities.length; ++i2) {
            subEntities[i2].e(i2 + packet.b() + 1);
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return target.eN();
    }

    @Override
    protected float c(float scale) {
        return 1.0f;
    }

    @Override
    public int getExpReward(WorldServer level, Entity entity) {
        boolean flag = level.S().c(GameRules.g);
        int i2 = 500;
        if (this.cL != null && (this.an().purpurConfig.enderDragonAlwaysDropsFullExp || !this.cL.f())) {
            i2 = 12000;
        }
        return flag ? i2 : 0;
    }
}

