/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.purpurmc.purpur.controller.FlyingWithSpacebarMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityWither
extends EntityMonster
implements IRangedEntity {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final List<DataWatcherObject<Integer>> d = ImmutableList.of(a, b, c);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final int f = 220;
    private static final int ct = 0;
    private final float[] cu = new float[2];
    private final float[] cv = new float[2];
    private final float[] cw = new float[2];
    private final float[] cx = new float[2];
    private final int[] cy = new int[2];
    private final int[] cz = new int[2];
    private int cA;
    private int shootCooldown = 0;
    private boolean canPortal = false;
    public final BossBattleServer cB = (BossBattleServer)new BossBattleServer(this.S_(), BossBattle.BarColor.f, BossBattle.BarStyle.a).a(true);
    private static final PathfinderTargetCondition.a cC = (entity, level) -> !entity.ax().a(TagsEntity.y) && entity.gb();
    private static final PathfinderTargetCondition cD = PathfinderTargetCondition.a().a(20.0).a(cC);
    @Nullable
    private UUID summoner;
    private FlyingWithSpacebarMoveControllerWASD purpurController = new FlyingWithSpacebarMoveControllerWASD((EntityInsentient)this, 0.1f);

    public EntityWither(EntityTypes<? extends EntityWither> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.cn = new ControllerMoveFlying(this, 10, false){

            @Override
            public void a() {
                if (this.d.getRider() != null && this.d.isControllable()) {
                    EntityWither.this.purpurController.purpurTick(this.d.getRider());
                } else {
                    super.a();
                }
            }
        };
        this.cn = new ControllerMoveFlying(this, 10, false);
        this.x(this.fj());
        this.cl = 50;
    }

    @Nullable
    public UUID getSummoner() {
        return this.summoner;
    }

    public void setSummoner(@Nullable UUID summoner) {
        this.summoner = summoner;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.witherRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.witherRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.witherControllable;
    }

    @Override
    public double getMaxY() {
        return this.an().purpurConfig.witherMaxY;
    }

    @Override
    public void m(Vec3D vec3) {
        super.m(vec3);
        if (this.getRider() != null && this.isControllable() && !((Entity)this).bc) {
            float speed = (float)this.i(GenericAttributes.m) * 5.0f;
            this.B(speed);
            Vec3D mot = this.dI();
            this.a(EnumMoveType.a, mot.d(speed, 0.5, speed));
            this.k(mot.c(0.9));
        }
    }

    @Override
    public void onMount(EntityHuman rider) {
        super.onMount(rider);
        this.az.a(d.get(0), 0);
        this.az.a(d.get(1), 0);
        this.az.a(d.get(2), 0);
        this.S().n();
        this.shootCooldown = 20;
    }

    @Override
    public boolean onClick(EnumHand hand) {
        int[] nArray;
        EntityHuman entityHuman = this.getRider();
        if (hand == EnumHand.a) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 2;
        }
        return this.shoot(entityHuman, nArray);
    }

    public boolean shoot(@Nullable EntityHuman rider, int[] heads) {
        Vec3D loc;
        if (this.shootCooldown > 0) {
            return false;
        }
        this.shootCooldown = 20;
        if (rider == null) {
            return false;
        }
        CraftHumanEntity player = rider.getBukkitEntity();
        if (!player.hasPermission("allow.special.wither")) {
            return false;
        }
        MovingObjectPosition rayTrace = this.getRayTrace(120, RayTrace.FluidCollisionOption.a);
        if (rayTrace == null) {
            return false;
        }
        if (rayTrace.d() == MovingObjectPosition.EnumMovingObjectType.b) {
            BlockPosition pos = ((MovingObjectPositionBlock)rayTrace).b();
            loc = new Vec3D((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5);
        } else if (rayTrace.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            Entity target = ((MovingObjectPositionEntity)rayTrace).a();
            loc = new Vec3D(target.dK(), target.dM() + (double)(target.df() / 2.0f), target.dQ());
        } else {
            Block block = player.getTargetBlock(null, 120);
            loc = new Vec3D((double)block.getX() + 0.5, (double)block.getY() + 0.5, (double)block.getZ() + 0.5);
        }
        for (int head : heads) {
            this.shoot(head, loc.a(), loc.b(), loc.c(), rider);
        }
        return true;
    }

    public void shoot(int head, double x2, double y2, double z2, EntityHuman rider) {
        this.an().a(null, 1024, this.dF(), 0);
        double headX = this.r(head);
        double headY = this.s(head);
        double headZ = this.t(head);
        Vec3D vec3d = new Vec3D(x2 - headX, y2 - headY, z2 - headZ);
        EntityWitherSkull skull = new EntityWitherSkull(this.an(), this, vec3d.d());
        skull.n(headX, headY, headZ);
        this.an().b(skull);
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.witherMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.witherScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.witherTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.witherAlwaysDropExp;
    }

    @Override
    protected NavigationAbstract b(World level) {
        NavigationFlying flyingPathNavigation = new NavigationFlying(this, level);
        flyingPathNavigation.e(false);
        flyingPathNavigation.a(true);
        return flyingPathNavigation;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        this.cq.a(0, new a());
        this.cq.a(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.cq.a(5, new PathfinderGoalRandomFly(this, 1.0));
        this.cq.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(7, new PathfinderGoalRandomLookaround(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, cC));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, 0);
        builder.a(b, 0);
        builder.a(c, 0);
        builder.a(e, 0);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Invul", this.gI());
        output.b("Purpur.Summoner", UUIDUtil.a, this.getSummoner());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.b(input.a("Invul", 0));
        if (this.k_()) {
            this.cB.a(this.S_());
        }
        this.setSummoner(input.a("Purpur.Summoner", UUIDUtil.a).orElse(null));
    }

    @Override
    public void b(@Nullable IChatBaseComponent name) {
        super.b(name);
        this.cB.a(this.S_());
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.ES;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.EV;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.EU;
    }

    @Override
    public void e_() {
        int i2;
        Entity entity;
        Vec3D vec3 = this.dI().d(1.0, 0.6, 1.0);
        if (!this.an().D_() && this.c(0) > 0 && (entity = this.an().a(this.c(0))) != null) {
            double d2 = vec3.h;
            if (this.dM() < entity.dM() || !this.gJ() && this.dM() < entity.dM() + 5.0) {
                d2 = Math.max(0.0, d2);
                d2 += 0.3 - d2 * (double)0.6f;
            }
            vec3 = new Vec3D(vec3.g, d2, vec3.i);
            Vec3D vec31 = new Vec3D(entity.dK() - this.dK(), 0.0, entity.dQ() - this.dQ());
            if (vec31.j() > 9.0) {
                Vec3D vec32 = vec31.d();
                vec3 = vec3.b(vec32.g * 0.3 - vec3.g * 0.6, 0.0, vec32.i * 0.3 - vec3.i * 0.6);
            }
        }
        this.k(vec3);
        if (vec3.j() > 0.05) {
            this.v((float)MathHelper.d(vec3.i, vec3.g) * 57.295776f - 90.0f);
        }
        super.e_();
        for (i2 = 0; i2 < 2; ++i2) {
            this.cx[i2] = this.cv[i2];
            this.cw[i2] = this.cu[i2];
        }
        for (i2 = 0; i2 < 2; ++i2) {
            int alternativeTarget = this.c(i2 + 1);
            Entity entity1 = null;
            if (alternativeTarget > 0) {
                entity1 = this.an().a(alternativeTarget);
            }
            if (entity1 != null) {
                double headX = this.r(i2 + 1);
                double headY = this.s(i2 + 1);
                double headZ = this.t(i2 + 1);
                double d1 = entity1.dK() - headX;
                double d2 = entity1.dO() - headY;
                double d3 = entity1.dQ() - headZ;
                double squareRoot = Math.sqrt(d1 * d1 + d3 * d3);
                float f2 = (float)(MathHelper.d(d3, d1) * 180.0 / 3.1415927410125732) - 90.0f;
                float f1 = (float)(-(MathHelper.d(d2, squareRoot) * 180.0 / 3.1415927410125732));
                this.cu[i2] = this.a(this.cu[i2], f1, 40.0f);
                this.cv[i2] = this.a(this.cv[i2], f2, 10.0f);
                continue;
            }
            this.cv[i2] = this.a(this.cv[i2], this.bB, 10.0f);
        }
        boolean isPowered = this.gJ();
        for (int alternativeTargetx = 0; alternativeTargetx < 3; ++alternativeTargetx) {
            double headX1 = this.r(alternativeTargetx);
            double headY1 = this.s(alternativeTargetx);
            double headZ1 = this.t(alternativeTargetx);
            float f2 = 0.3f * this.eA();
            this.an().a(Particles.ai, headX1 + this.as.k() * (double)f2, headY1 + this.as.k() * (double)f2, headZ1 + this.as.k() * (double)f2, 0.0, 0.0, 0.0);
            if (!isPowered || this.an().z.a(4) != 0) continue;
            this.an().a(ColorParticleOption.a(Particles.v, 0.7f, 0.7f, 0.5f), headX1 + this.as.k() * (double)f2, headY1 + this.as.k() * (double)f2, headZ1 + this.as.k() * (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.gI() > 0) {
            float f3 = 3.3f * this.eA();
            for (int i1 = 0; i1 < 3; ++i1) {
                this.an().a(ColorParticleOption.a(Particles.v, 0.7f, 0.7f, 0.9f), this.dK() + this.as.k(), this.dM() + (double)(this.as.i() * f3), this.dQ() + this.as.k(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void a(WorldServer level) {
        if (this.getRider() != null && this.isControllable()) {
            Vec3D mot = this.dI();
            this.m(mot.a(), mot.b() + (this.getVerticalMot() > 0.0f ? 0.07 : 0.0), mot.c());
        }
        if (this.shootCooldown > 0) {
            --this.shootCooldown;
        }
        if (this.gI() > 0) {
            int i2 = this.gI() - 1;
            this.cB.a(1.0f - (float)i2 / 220.0f);
            if (i2 <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    level.a((Entity)this, this.dK(), this.dO(), this.dQ(), event.getRadius(), event.getFire(), World.a.c);
                }
                if (!this.bm() && level.purpurConfig.witherPlaySpawnSound) {
                    int viewDistance = level.getCraftServer().getViewDistance() * 16;
                    for (EntityPlayer player : level.getPlayersForGlobalSoundGamerule()) {
                        double deltaX = this.dK() - player.dK();
                        double deltaZ = this.dQ() - player.dQ();
                        double distanceSquared = MathHelper.l(deltaX) + MathHelper.l(deltaZ);
                        double soundRadiusSquared = level.getGlobalSoundRangeSquared(config -> config.witherSpawnSoundRadius);
                        if (!level.S().c(GameRules.Y) && distanceSquared > soundRadiusSquared) continue;
                        if (distanceSquared > (double)MathHelper.i(viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.dK() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.dQ() + deltaZ / deltaLength * (double)viewDistance;
                            player.g.b(new PacketPlayOutWorldEvent(1023, new BlockPosition((int)relativeX, (int)this.dM(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.g.b(new PacketPlayOutWorldEvent(1023, this.dF(), 0, true));
                    }
                }
            }
            this.b(i2);
            if (this.at % 10 == 0) {
                this.heal(this.fj() / 30.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            int alternativeTarget;
            super.a(level);
            for (int ix = 1; ix < 3; ++ix) {
                EntityLiving livingEntity1;
                if (this.at < this.cy[ix - 1]) continue;
                this.cy[ix - 1] = this.at + 10 + this.as.a(10);
                if (level.aq() == EnumDifficulty.c || level.aq() == EnumDifficulty.d) {
                    int n2 = ix - 1;
                    int n3 = this.cz[n2];
                    this.cz[n2] = n3 + 1;
                    if (n3 > 15) {
                        float f2 = 10.0f;
                        float f1 = 5.0f;
                        double randomDouble = MathHelper.a(this.as, this.dK() - 10.0, this.dK() + 10.0);
                        double randomDouble1 = MathHelper.a(this.as, this.dM() - 5.0, this.dM() + 5.0);
                        double randomDouble2 = MathHelper.a(this.as, this.dQ() - 10.0, this.dQ() + 10.0);
                        this.a(ix + 1, randomDouble, randomDouble1, randomDouble2, true);
                        this.cz[ix - 1] = 0;
                    }
                }
                if ((alternativeTarget = this.c(ix)) > 0) {
                    EntityLiving livingEntity = (EntityLiving)level.a(alternativeTarget);
                    if (livingEntity != null && this.c(livingEntity) && !(this.g((Entity)livingEntity) > 900.0) && this.F(livingEntity)) {
                        this.a(ix + 1, livingEntity);
                        this.cy[ix - 1] = this.at + 40 + this.as.a(20);
                        this.cz[ix - 1] = 0;
                        continue;
                    }
                    this.a(ix, 0);
                    continue;
                }
                List<EntityLiving> nearbyEntities = level.a(EntityLiving.class, cD, this, this.de().c(20.0, 8.0, 20.0));
                if (nearbyEntities.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, livingEntity1 = nearbyEntities.get(this.as.a(nearbyEntities.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.a(ix, livingEntity1.az());
            }
            if (this.e() != null) {
                this.a(0, this.e().az());
            } else {
                this.a(0, 0);
            }
            if (this.cA > 0) {
                --this.cA;
                if (this.cA == 0 && level.S().getBoolean(GameRules.d, level.purpurConfig.witherMobGriefingOverride)) {
                    boolean flag = false;
                    alternativeTarget = MathHelper.d(this.dA() / 2.0f + 1.0f);
                    int floor = MathHelper.d(this.dB());
                    for (BlockPosition blockPos : BlockPosition.b(this.dJ() - alternativeTarget, this.dL(), this.dP() - alternativeTarget, this.dJ() + alternativeTarget, this.dL() + floor, this.dP() + alternativeTarget)) {
                        IBlockData blockState = level.a_(blockPos);
                        if (!EntityWither.c(blockState) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockPos, blockState.y().g())) continue;
                        flag = level.a(blockPos, true, this) || flag;
                    }
                    if (flag) {
                        level.a(null, 1022, this.dF(), 0);
                    }
                }
            }
            if (this.at % this.an().purpurConfig.witherHealthRegenDelay == 0) {
                this.heal(this.an().purpurConfig.witherHealthRegenAmount, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.cB.a(this.eU() / this.fj());
        }
    }

    public static boolean c(IBlockData state) {
        return !state.l() && !state.a(TagsBlock.aS);
    }

    public void k() {
        this.b(220);
        this.cB.a(0.0f);
        this.x(this.fj() / 3.0f);
    }

    @Override
    public void a(IBlockData state, Vec3D motionMultiplier) {
    }

    @Override
    public void d(EntityPlayer player) {
        super.d(player);
        this.cB.a(player);
    }

    @Override
    public void e(EntityPlayer player) {
        super.e(player);
        this.cB.b(player);
    }

    private double r(int head) {
        if (head <= 0) {
            return this.dK();
        }
        float f2 = (this.bB + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float cos = MathHelper.b(f2);
        return this.dK() + (double)cos * 1.3 * (double)this.eA();
    }

    private double s(int head) {
        float f2 = head <= 0 ? 3.0f : 2.2f;
        return this.dM() + (double)(f2 * this.eA());
    }

    private double t(int head) {
        if (head <= 0) {
            return this.dQ();
        }
        float f2 = (this.bB + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float sin = MathHelper.a(f2);
        return this.dQ() + (double)sin * 1.3 * (double)this.eA();
    }

    private float a(float angle, float targetAngle, float max) {
        float f2 = MathHelper.h(targetAngle - angle);
        if (f2 > max) {
            f2 = max;
        }
        if (f2 < -max) {
            f2 = -max;
        }
        return angle + f2;
    }

    private void a(int head, EntityLiving target) {
        this.a(head, target.dK(), target.dM() + (double)target.df() * 0.5, target.dQ(), head == 0 && this.as.i() < 0.001f);
    }

    private void a(int head, double x2, double y2, double z2, boolean isDangerous) {
        if (!this.bm()) {
            this.an().a(null, 1024, this.dF(), 0);
        }
        double headX = this.r(head);
        double headY = this.s(head);
        double headZ = this.t(head);
        double d2 = x2 - headX;
        double d1 = y2 - headY;
        double d22 = z2 - headZ;
        Vec3D vec3 = new Vec3D(d2, d1, d22);
        EntityWitherSkull witherSkull = new EntityWitherSkull(this.an(), this, vec3.d());
        witherSkull.c(this);
        if (isDangerous) {
            witherSkull.b(true);
        }
        witherSkull.a_(headX, headY, headZ);
        this.an().b(witherSkull);
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.a(0, target);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity directEntity;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.t) || damageSource.d() instanceof EntityWither) {
            return false;
        }
        if (this.gI() > 0 && !damageSource.a(DamageTypeTags.d)) {
            return false;
        }
        if (this.gJ() && ((directEntity = damageSource.c()) instanceof EntityArrow || directEntity instanceof WindCharge)) {
            return false;
        }
        directEntity = damageSource.d();
        if (directEntity != null && directEntity.ax().a(TagsEntity.y)) {
            return false;
        }
        if (this.cA <= 0) {
            this.cA = 20;
        }
        for (int i2 = 0; i2 < this.cz.length; ++i2) {
            this.cz[i2] = this.cz[i2] + 3;
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        super.a(level, damageSource, recentlyHit);
        EntityItem itemEntity = this.spawnAtLocation(level, new ItemStack(Items.wA), Vec3D.c, EntityItem::r);
        if (itemEntity != null) {
            itemEntity.r();
        }
    }

    @Override
    public void dR() {
        if (this.an().aq() == EnumDifficulty.a && this.shouldDespawnInPeaceful()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.bJ = 0;
        }
    }

    @Override
    public boolean b(MobEffect effectInstance, @Nullable Entity entity) {
        return false;
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gN().a(GenericAttributes.t, 300.0).a(GenericAttributes.w, 0.6f).a(GenericAttributes.m, 0.6f).a(GenericAttributes.n, 40.0).a(GenericAttributes.a, 4.0);
    }

    public float[] n() {
        return this.cv;
    }

    public float[] s() {
        return this.cu;
    }

    public int gI() {
        return this.az.a(e);
    }

    public void b(int invulnerableTicks) {
        this.az.a(e, invulnerableTicks);
    }

    public int c(int head) {
        return this.getRider() != null && this.isControllable() ? 0 : this.az.a(d.get(head));
    }

    public void a(int targetOffset, int newId) {
        if (this.getRider() == null || !this.isControllable()) {
            this.az.a(d.get(targetOffset), newId);
        }
    }

    public boolean gJ() {
        return this.eU() <= this.fj() / 2.0f;
    }

    @Override
    protected boolean p(Entity entity) {
        if (this.an().purpurConfig.witherCanRideVehicles) {
            return this.X <= 0;
        }
        return false;
    }

    @Override
    public boolean o(boolean allowPassengers) {
        return this.canPortal;
    }

    public void setCanTravelThroughPortals(boolean canPortal) {
        this.canPortal = canPortal;
    }

    @Override
    public boolean b(MobEffect effectInstance) {
        return (!effectInstance.a(MobEffects.t) || !this.an().paperConfig().entities.mobEffects.immuneToWitherEffect.wither) && super.b(effectInstance);
    }

    class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.c, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityWither.this.gI() > 0;
        }
    }
}

