/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.slf4j.Logger;

public abstract class BlockAttachedEntity
extends Entity {
    private static final Logger b = LogUtils.getLogger();
    private int c;
    protected BlockPosition a;

    protected BlockAttachedEntity(EntityTypes<? extends BlockAttachedEntity> type, World level) {
        super(type, level);
        this.c = this.az() % this.an().spigotConfig.hangingTickFrequency;
    }

    protected BlockAttachedEntity(EntityTypes<? extends BlockAttachedEntity> type, World level, BlockPosition pos) {
        this(type, level);
        this.a = pos;
    }

    protected abstract void e();

    @Override
    public void g() {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.aI();
            if (this.c++ == this.an().spigotConfig.hangingTickFrequency) {
                this.c = 0;
                if (!this.ec() && !this.f()) {
                    HangingBreakEvent.RemoveCause cause = !this.an().a_(this.dF()).l() ? HangingBreakEvent.RemoveCause.OBSTRUCTION : HangingBreakEvent.RemoveCause.PHYSICS;
                    HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), cause);
                    this.an().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (this.ec() || event.isCancelled()) {
                        return;
                    }
                    this.discard(EntityRemoveEvent.Cause.DROP);
                    this.a(serverLevel, (Entity)null);
                }
            }
        }
    }

    public abstract boolean f();

    @Override
    public boolean bT() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean w(Entity entity) {
        if (!(entity instanceof EntityHuman)) return false;
        EntityHuman player = (EntityHuman)entity;
        if (!this.an().a((Entity)player, this.a)) return true;
        if (!this.b(this.ei().a(player), 0.0f)) return false;
        return true;
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return !this.d(damageSource);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.d(damageSource)) {
            return false;
        }
        if (!level.S().c(GameRules.d) && damageSource.d() instanceof EntityInsentient) {
            return false;
        }
        if (!this.ec()) {
            Entity damager;
            Entity entity = damager = !damageSource.b() && damageSource.d() != null ? damageSource.d() : damageSource.c();
            Object event = damager != null ? new HangingBreakByEntityEvent((Hanging)this.getBukkitEntity(), (org.bukkit.entity.Entity)damager.getBukkitEntity(), damageSource.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.ENTITY) : new HangingBreakEvent((Hanging)this.getBukkitEntity(), damageSource.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.DEFAULT);
            this.an().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.ec() || event.isCancelled()) {
                return true;
            }
            this.c(level);
            this.bP();
            this.a(level, damageSource.d());
        }
        return true;
    }

    @Override
    public boolean a(Explosion explosion) {
        Entity directSourceEntity = explosion.d();
        return directSourceEntity != null && directSourceEntity.bu() || !explosion.h() || super.a(explosion);
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (!this.ec() && movement.h() > 0.0) {
                HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), HangingBreakEvent.RemoveCause.PHYSICS);
                this.an().getCraftServer().getPluginManager().callEvent((Event)event);
                if (this.ec() || event.isCancelled()) {
                    return;
                }
                this.c(serverLevel);
                this.a(serverLevel, (Entity)null);
            }
        }
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput output, boolean includeAll) {
        if (includeAll) {
            this.a(output);
        }
    }

    @Override
    protected void a(ValueOutput output) {
        output.a("block_pos", BlockPosition.a, this.i());
    }

    @Override
    protected void a(ValueInput input) {
        BlockPosition blockPos = input.a("block_pos", BlockPosition.a).orElse(null);
        if (blockPos != null && blockPos.a(this.dF(), 16.0)) {
            this.a = blockPos;
        } else {
            b.error("Block-attached entity at invalid position: {}", (Object)blockPos);
        }
    }

    public abstract void a(WorldServer var1, @Nullable Entity var2);

    @Override
    protected boolean bV() {
        return false;
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        this.a = BlockPosition.a(x2, y2, z2);
        this.e();
        this.aF = true;
    }

    public BlockPosition i() {
        return this.a;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
    }

    @Override
    public void l_() {
    }
}

