/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Vector3f;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFence;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class EntityArmorStand
extends EntityLiving {
    public static final int a = 5;
    private static final boolean cb = true;
    public static final Vector3f b = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f c = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f d = new Vector3f(-10.0f, 0.0f, -10.0f);
    public static final Vector3f e = new Vector3f(-15.0f, 0.0f, 10.0f);
    public static final Vector3f f = new Vector3f(-1.0f, 0.0f, -1.0f);
    public static final Vector3f g = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize cc = EntitySize.c(0.0f, 0.0f);
    private static final EntitySize cd = EntityTypes.h.n().a(0.5f).b(0.9875f);
    private static final double ce = 0.1;
    private static final double cf = 0.9;
    private static final double cg = 0.4;
    private static final double ch = 1.6;
    public static final int h = 8;
    public static final int i = 16;
    public static final int j = 1;
    public static final int k = 4;
    public static final int l = 8;
    public static final int m = 16;
    public static final DataWatcherObject<Byte> n = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Vector3f> o = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> p = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> q = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> r = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> s = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> t = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    private static final Predicate<Entity> ci = entity -> {
        EntityMinecartAbstract abstractMinecart;
        return entity instanceof EntityMinecartAbstract && (abstractMinecart = (EntityMinecartAbstract)entity).y();
    };
    private static final boolean cj = false;
    private static final int ck = 0;
    private static final boolean cl = false;
    private static final boolean cm = false;
    private static final boolean cn = false;
    private static final boolean co = false;
    private boolean cp = false;
    public long ca;
    public int cq = 0;
    public boolean canMove = true;
    public boolean canTick = true;
    public boolean canTickSetByAPI = false;
    private boolean noTickEquipmentDirty = false;
    public boolean canMovementTick = true;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> type, World level) {
        super((EntityTypes<? extends EntityLiving>)type, level);
        if (level != null) {
            this.canTick = level.paperConfig().entities.armorStands.tick;
        }
        if (level != null) {
            this.canMovementTick = level.purpurConfig.armorstandMovement;
        }
        this.a(level != null && level.purpurConfig.armorstandPlaceWithArms);
    }

    public EntityArmorStand(World level, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.h, level);
        this.a_(x2, y2, z2);
    }

    public static AttributeProvider.Builder k() {
        return EntityArmorStand.es().a(GenericAttributes.C, 0.0);
    }

    @Override
    public float getBukkitYaw() {
        return this.dX();
    }

    @Override
    public void l_() {
        double x2 = this.dK();
        double y2 = this.dM();
        double z2 = this.dQ();
        super.l_();
        this.a_(x2, y2, z2);
    }

    private boolean D() {
        return !this.s() && !this.bn();
    }

    @Override
    public boolean dt() {
        return super.dt() && this.D();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(n, (byte)0);
        builder.a(o, b);
        builder.a(p, c);
        builder.a(q, d);
        builder.a(r, e);
        builder.a(s, f);
        builder.a(t, g);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.g && slot != EnumItemSlot.h && !this.g(slot);
    }

    @Override
    public void setItemSlot(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, boolean silent) {
        super.setItemSlot(slot, stack, silent);
        this.noTickEquipmentDirty = true;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Invisible", this.cB());
        output.a("Small", this.m());
        output.a("ShowArms", this.n());
        output.a("DisabledSlots", this.cq);
        output.a("NoBasePlate", !this.p());
        if (this.s()) {
            output.a("Marker", this.s());
        }
        output.a("Pose", net.minecraft.world.entity.decoration.EntityArmorStand$a.b, this.C());
        if (this.canTickSetByAPI) {
            output.a("Paper.CanTickOverride", this.canTick);
        }
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.l(input.a("Invisible", false));
        this.u(input.a("Small", false));
        this.a(input.a("ShowArms", false));
        this.cq = input.a("DisabledSlots", 0);
        this.b(input.a("NoBasePlate", false));
        this.v(input.a("Marker", false));
        this.ar = !this.D();
        input.a("Pose", net.minecraft.world.entity.decoration.EntityArmorStand$a.b).ifPresent(this::a);
        if (input.e("Paper.CanTickOverride").isPresent()) {
            this.canTick = input.a("Paper.CanTickOverride", true);
            this.canTickSetByAPI = true;
        }
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void E(Entity entity) {
    }

    @Override
    protected void q() {
        if (!this.an().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return;
        }
        for (Entity entity : this.an().a(EntityMinecartAbstract.class, this.de(), ci)) {
            if (!(this.g(entity) <= 0.2)) continue;
            entity.h(this);
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, Vec3D vec, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemInHand = player.b(hand);
        if (this.s() || itemInHand.a(Items.wV)) {
            return EnumInteractionResult.e;
        }
        if (player.at()) {
            return EnumInteractionResult.a;
        }
        if (player.an().D_()) {
            return EnumInteractionResult.b;
        }
        EnumItemSlot equipmentSlotForItem = this.f(itemInHand);
        if (itemInHand.f()) {
            EnumItemSlot equipmentSlot;
            EnumItemSlot clickedSlot = this.a(vec);
            EnumItemSlot enumItemSlot = equipmentSlot = this.g(clickedSlot) ? equipmentSlotForItem : clickedSlot;
            if (this.d(equipmentSlot) && this.a(player, equipmentSlot, itemInHand, hand)) {
                return EnumInteractionResult.b;
            }
        } else {
            if (this.g(equipmentSlotForItem)) {
                return EnumInteractionResult.d;
            }
            if (equipmentSlotForItem.a() == EnumItemSlot.Function.a && !this.n()) {
                return EnumInteractionResult.d;
            }
            if (this.a(player, equipmentSlotForItem, itemInHand, hand)) {
                return EnumInteractionResult.b;
            }
        }
        return EnumInteractionResult.e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot a(Vec3D vector) {
        EnumItemSlot equipmentSlot = EnumItemSlot.a;
        boolean isSmall = this.m();
        double d2 = vector.h / (double)(this.eA() * this.ez());
        EnumItemSlot equipmentSlot1 = EnumItemSlot.c;
        if (d2 >= 0.1) {
            double d3 = isSmall ? 0.8 : 0.45;
            if (d2 < 0.1 + d3 && this.d(equipmentSlot1)) {
                return EnumItemSlot.c;
            }
        }
        double d4 = isSmall ? 0.3 : 0.0;
        if (d2 >= 0.9 + d4) {
            double d5 = isSmall ? 1.0 : 0.7;
            if (d2 < 0.9 + d5 && this.d(EnumItemSlot.e)) {
                return EnumItemSlot.e;
            }
        }
        if (d2 >= 0.4) {
            double d6 = isSmall ? 1.0 : 0.8;
            if (d2 < 0.4 + d6 && this.d(EnumItemSlot.d)) {
                return EnumItemSlot.d;
            }
        }
        if (d2 >= 1.6 && this.d(EnumItemSlot.f)) {
            return EnumItemSlot.f;
        }
        if (this.d(EnumItemSlot.a)) return equipmentSlot;
        if (!this.d(EnumItemSlot.b)) return equipmentSlot;
        return EnumItemSlot.b;
    }

    public boolean g(EnumItemSlot slot) {
        return (this.cq & 1 << slot.b(0)) != 0 || slot.a() == EnumItemSlot.Function.a && !this.n();
    }

    private boolean a(EntityHuman player, EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemBySlot = this.a(slot);
        if (!itemBySlot.f() && (this.cq & 1 << slot.b(8)) != 0) {
            return false;
        }
        if (itemBySlot.f() && (this.cq & 1 << slot.b(16)) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemBySlot);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(stack);
        Player player1 = (Player)player.getBukkitEntity();
        ArmorStand self = (ArmorStand)this.getBukkitEntity();
        EquipmentSlot slot1 = CraftEquipmentSlot.getSlot(slot);
        EquipmentSlot hand1 = CraftEquipmentSlot.getHand(hand);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player1, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot1, hand1);
        this.an().getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (player.gk() && itemBySlot.f() && !stack.f()) {
            this.a(slot, stack.c(1));
            return true;
        }
        if (stack.f() || stack.M() <= 1) {
            this.a(slot, stack);
            player.a(hand, itemBySlot);
            return true;
        }
        if (!itemBySlot.f()) {
            return false;
        }
        this.a(slot, stack.a(1));
        return true;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.ec()) {
            return false;
        }
        if (!level.S().c(GameRules.d) && damageSource.d() instanceof EntityInsentient) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.d)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount)) {
                return false;
            }
            this.kill(level, damageSource);
            return false;
        }
        if (this.a(level, damageSource) || this.s()) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.l)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.cp)) {
                return false;
            }
            EntityDeathEvent event = this.brokenByAnything(level, damageSource);
            if (!event.isCancelled()) {
                this.kill(level, damageSource, false);
            }
            return false;
        }
        if (damageSource.a(DamageTypeTags.u)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.cp)) {
                return false;
            }
            if (this.ck()) {
                this.d(level, damageSource, 0.15f);
            } else {
                this.e(5.0f);
            }
            return false;
        }
        if (damageSource.a(DamageTypeTags.v) && this.eU() > 0.5f) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.cp)) {
                return false;
            }
            this.d(level, damageSource, 4.0f);
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.cp)) {
            return false;
        }
        boolean isCanBreakArmorStand = damageSource.a(DamageTypeTags.B);
        boolean isAlwaysKillsArmorStands = damageSource.a(DamageTypeTags.A);
        if (!isCanBreakArmorStand && !isAlwaysKillsArmorStands) {
            return false;
        }
        Entity entity = damageSource.d();
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            if (!player.gC().e) {
                return false;
            }
        }
        if (damageSource.h()) {
            this.F();
            this.E();
            this.kill(level, damageSource);
            return true;
        }
        long gameTime = level.ag();
        if (gameTime - this.ca > 5L && !isAlwaysKillsArmorStands) {
            level.a((Entity)this, (byte)32);
            this.a(GameEvent.o, damageSource.d());
            this.ca = gameTime;
        } else {
            EntityDeathEvent event = this.brokenByPlayer(level, damageSource);
            this.E();
            if (!event.isCancelled()) {
                this.kill(level, damageSource, false);
            }
        }
        return true;
    }

    @Override
    public void b(byte id) {
        if (id == 32) {
            if (this.an().D_()) {
                this.an().a(this.dK(), this.dM(), this.dQ(), SoundEffects.aD, this.dw(), 0.3f, 1.0f, false);
                this.ca = this.an().ag();
            }
        } else {
            super.b(id);
        }
    }

    @Override
    public boolean a(double distance) {
        double d2 = this.de().a() * 4.0;
        if (Double.isNaN(d2) || d2 == 0.0) {
            d2 = 4.0;
        }
        return distance < (d2 *= 64.0) * d2;
    }

    private void E() {
        if (this.an() instanceof WorldServer) {
            ((WorldServer)this.an()).a(new ParticleParamBlock(Particles.b, Blocks.n.m()), this.dK(), this.f(0.6666666666666666), this.dQ(), 10, (double)(this.dA() / 4.0f), (double)(this.dB() / 4.0f), (double)(this.dA() / 4.0f), 0.05);
        }
    }

    private void d(WorldServer level, DamageSource damageSource, float damageAmount) {
        float health = this.eU();
        if ((health -= damageAmount) <= 0.5f) {
            EntityDeathEvent event = this.brokenByAnything(level, damageSource);
            if (!event.isCancelled()) {
                this.kill(level, damageSource, false);
            }
        } else {
            this.x(health);
            this.a(GameEvent.o, damageSource.d());
        }
    }

    private EntityDeathEvent brokenByPlayer(WorldServer level, DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemStack = new net.minecraft.world.item.ItemStack(Items.wO);
        if (level.purpurConfig.persistentDroppableEntityDisplayNames) {
            itemStack.b(DataComponents.g, this.ar());
        }
        this.drops.add(new Entity.DefaultDrop(itemStack, stack -> Block.a(this.an(), this.dF(), stack)));
        return this.brokenByAnything(level, damageSource);
    }

    private EntityDeathEvent brokenByAnything(WorldServer level, DamageSource damageSource) {
        this.F();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            net.minecraft.world.item.ItemStack itemStack = this.bZ.a(equipmentSlot);
            if (itemStack.f()) continue;
            this.drops.add(new Entity.DefaultDrop(itemStack, stack -> Block.a(this.an(), this.dF().d(), stack)));
        }
        EntityDeathEvent event = this.dropAllDeathLoot(level, damageSource);
        if (!event.isCancelled()) {
            for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
                this.bZ.a(equipmentSlot, net.minecraft.world.item.ItemStack.l);
            }
        }
        return event;
    }

    private void F() {
        this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.aB, this.dw(), 1.0f, 1.0f);
    }

    @Override
    protected void C(float yBodyRot) {
        this.bC = this.ab;
        this.bB = this.dX();
    }

    @Override
    public void m(Vec3D travelVector) {
        if (this.D()) {
            super.m(travelVector);
        }
    }

    @Override
    public void s(float offset) {
        this.bC = this.ab = offset;
        this.bE = this.bD = offset;
    }

    @Override
    public void r(float rotation) {
        this.bC = this.ab = rotation;
        this.bE = this.bD = rotation;
    }

    @Override
    protected void M() {
        this.l(this.cp);
    }

    @Override
    public void l(boolean invisible) {
        this.cp = invisible;
        super.l(invisible);
    }

    @Override
    public boolean g_() {
        return this.m();
    }

    @Override
    public void g() {
        this.maxUpStep = this.an().purpurConfig.armorstandStepHeight;
        if (!this.canTick) {
            if (this.noTickEquipmentDirty) {
                this.noTickEquipmentDirty = false;
                this.L();
            }
            return;
        }
        super.g();
    }

    @Override
    public void c(WorldServer level) {
        this.kill(level, null);
    }

    public void kill(WorldServer level, @Nullable DamageSource damageSource) {
        this.kill(level, damageSource, true);
    }

    public void kill(WorldServer level, @Nullable DamageSource damageSource, boolean callEvent) {
        EntityDeathEvent event;
        if (callEvent && (event = CraftEventFactory.callEntityDeathEvent(this, damageSource == null ? this.ei().y() : damageSource, this.drops)).isCancelled()) {
            return;
        }
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.c(GameEvent.p);
    }

    @Override
    public boolean a(Explosion explosion) {
        return !explosion.h() || this.cB();
    }

    @Override
    public EnumPistonReaction p_() {
        return this.s() ? EnumPistonReaction.d : super.p_();
    }

    @Override
    public boolean o_() {
        return this.s();
    }

    public void u(boolean small) {
        this.az.a(n, this.a(this.az.a(n), 1, small));
    }

    public boolean m() {
        return (this.az.a(n) & 1) != 0;
    }

    public void a(boolean showArms) {
        this.az.a(n, this.a(this.az.a(n), 4, showArms));
    }

    public boolean n() {
        return (this.az.a(n) & 4) != 0;
    }

    public void b(boolean noBasePlate) {
        this.az.a(n, this.a(this.az.a(n), 8, noBasePlate));
    }

    public boolean p() {
        return (this.az.a(n) & 8) == 0;
    }

    public void v(boolean marker) {
        this.az.a(n, this.a(this.az.a(n), 16, marker));
    }

    public boolean s() {
        return (this.az.a(n) & 0x10) != 0;
    }

    private byte a(byte oldBit, int offset, boolean value) {
        oldBit = value ? (byte)(oldBit | offset) : (byte)(oldBit & ~offset);
        return oldBit;
    }

    public void a(Vector3f headPose) {
        this.az.a(o, headPose);
    }

    public void b(Vector3f bodyPose) {
        this.az.a(p, bodyPose);
    }

    public void c(Vector3f leftArmPose) {
        this.az.a(q, leftArmPose);
    }

    public void d(Vector3f rightArmPose) {
        this.az.a(r, rightArmPose);
    }

    public void e(Vector3f leftLegPose) {
        this.az.a(s, leftLegPose);
    }

    public void f(Vector3f rightLegPose) {
        this.az.a(t, rightLegPose);
    }

    public Vector3f v() {
        return this.az.a(o);
    }

    public Vector3f w() {
        return this.az.a(p);
    }

    public Vector3f x() {
        return this.az.a(q);
    }

    public Vector3f z() {
        return this.az.a(r);
    }

    public Vector3f A() {
        return this.az.a(s);
    }

    public Vector3f B() {
        return this.az.a(t);
    }

    @Override
    public boolean bT() {
        return super.bT() && !this.s();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean w(Entity entity) {
        if (!(entity instanceof EntityHuman)) return false;
        EntityHuman player = (EntityHuman)entity;
        if (this.an().a((Entity)player, this.dF())) return false;
        return true;
    }

    @Override
    public EnumMainHand as() {
        return EnumMainHand.b;
    }

    @Override
    public EntityLiving.a fc() {
        return new EntityLiving.a(SoundEffects.aC, SoundEffects.aC);
    }

    @Override
    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.aD;
    }

    @Override
    @Nullable
    public SoundEffect f_() {
        return SoundEffects.aB;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
    }

    @Override
    public boolean ga() {
        return false;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (n.equals(key)) {
            this.l_();
            this.W = !this.s();
        }
        super.a(key);
    }

    @Override
    public boolean gb() {
        return false;
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.w(this.s());
    }

    private EntitySize w(boolean isMarker) {
        if (isMarker) {
            return cc;
        }
        return this.g_() ? cd : this.ax().n();
    }

    @Override
    public Vec3D o(float partialTick) {
        if (this.s()) {
            AxisAlignedBB aabb = this.w(false).a(this.dD());
            BlockPosition blockPos = this.dF();
            int i2 = Integer.MIN_VALUE;
            for (BlockPosition blockPos1 : BlockPosition.c(BlockPosition.a(aabb.a, aabb.b, aabb.c), BlockPosition.a(aabb.d, aabb.e, aabb.f))) {
                int max = Math.max(this.an().a(EnumSkyBlock.b, blockPos1), this.an().a(EnumSkyBlock.a, blockPos1));
                if (max == 15) {
                    return Vec3D.b(blockPos1);
                }
                if (max <= i2) continue;
                i2 = max;
                blockPos = blockPos1.j();
            }
            return Vec3D.b(blockPos);
        }
        return super.o(partialTick);
    }

    @Override
    public net.minecraft.world.item.ItemStack dU() {
        return new net.minecraft.world.item.ItemStack(Items.wO);
    }

    @Override
    public boolean eO() {
        return !this.cB() && !this.s();
    }

    public void a(a armorStandPose) {
        this.a(armorStandPose.a());
        this.b(armorStandPose.b());
        this.c(armorStandPose.c());
        this.d(armorStandPose.d());
        this.e(armorStandPose.e());
        this.f(armorStandPose.f());
    }

    public a C() {
        return new a(this.v(), this.w(), this.x(), this.z(), this.A(), this.B());
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (this.canMove) {
            super.a(type, movement);
        }
    }

    @Override
    public void bD() {
        if (this.an().purpurConfig.armorstandWaterMovement && (this.an().purpurConfig.armorstandWaterFence || !(this.an().a_(this.dF().e()).b() instanceof BlockFence))) {
            super.bD();
        }
    }

    @Override
    public void e_() {
        if (this.canMovementTick && this.canMove) {
            super.e_();
        }
    }

    public static final class a
    extends Record {
        private final Vector3f c;
        private final Vector3f d;
        private final Vector3f e;
        private final Vector3f f;
        private final Vector3f g;
        private final Vector3f h;
        public static final a a = new a(b, c, d, e, f, g);
        public static final Codec<a> b = RecordCodecBuilder.create(instance -> instance.group((App)Vector3f.a.optionalFieldOf("Head", (Object)b).forGetter(a::a), (App)Vector3f.a.optionalFieldOf("Body", (Object)c).forGetter(a::b), (App)Vector3f.a.optionalFieldOf("LeftArm", (Object)d).forGetter(a::c), (App)Vector3f.a.optionalFieldOf("RightArm", (Object)e).forGetter(a::d), (App)Vector3f.a.optionalFieldOf("LeftLeg", (Object)f).forGetter(a::e), (App)Vector3f.a.optionalFieldOf("RightLeg", (Object)g).forGetter(a::f)).apply((Applicative)instance, a::new));

        public a(Vector3f head, Vector3f body, Vector3f leftArm, Vector3f rightArm, Vector3f leftLeg, Vector3f rightLeg) {
            this.c = head;
            this.d = body;
            this.e = leftArm;
            this.f = rightArm;
            this.g = leftLeg;
            this.h = rightLeg;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "head;body;leftArm;rightArm;leftLeg;rightLeg", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "head;body;leftArm;rightArm;leftLeg;rightLeg", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "head;body;leftArm;rightArm;leftLeg;rightLeg", "c", "d", "e", "f", "g", "h"}, this, o2);
        }

        public Vector3f a() {
            return this.c;
        }

        public Vector3f b() {
            return this.d;
        }

        public Vector3f c() {
            return this.e;
        }

        public Vector3f d() {
            return this.f;
        }

        public Vector3f e() {
            return this.g;
        }

        public Vector3f f() {
            return this.h;
        }
    }
}

