/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityPainting
extends EntityHanging {
    private static final DataWatcherObject<Holder<PaintingVariant>> c = DataWatcher.a(EntityPainting.class, DataWatcherRegistry.D);
    public static final float b = 0.0625f;

    public EntityPainting(EntityTypes<? extends EntityPainting> type, World level) {
        super((EntityTypes<? extends EntityHanging>)type, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, VariantUtils.b(this.ej(), Registries.bh));
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (c.equals(key)) {
            this.e();
        }
    }

    public void a(Holder<PaintingVariant> variant) {
        this.az.a(c, variant);
    }

    public Holder<PaintingVariant> k() {
        return this.az.a(c);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aM ? EntityPainting.c(component, this.k()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aM);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aM) {
            this.a(EntityPainting.c(DataComponents.aM, value));
            return true;
        }
        return super.b(component, value);
    }

    public static Optional<EntityPainting> a(World level, BlockPosition pos, EnumDirection direction) {
        EntityPainting painting = new EntityPainting(level, pos);
        ArrayList<Holder> list = new ArrayList<Holder>();
        level.L_().f(Registries.bh).c(PaintingVariantTags.a).forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        painting.b(direction);
        list.removeIf(holder -> {
            painting.a((Holder<PaintingVariant>)holder);
            return !painting.f();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int i2 = list.stream().mapToInt(EntityPainting::b).max().orElse(0);
        list.removeIf(holder -> EntityPainting.b(holder) < i2);
        Optional randomSafe = SystemUtils.b(list, painting.as);
        if (randomSafe.isEmpty()) {
            return Optional.empty();
        }
        painting.a((Holder)randomSafe.get());
        painting.b(direction);
        return Optional.of(painting);
    }

    private static int b(Holder<PaintingVariant> variant) {
        return variant.a().a();
    }

    private EntityPainting(World level, BlockPosition pos) {
        super((EntityTypes<? extends EntityHanging>)EntityTypes.aP, level, pos);
    }

    public EntityPainting(World level, BlockPosition pos, EnumDirection direction, Holder<PaintingVariant> variant) {
        this(level, pos);
        this.a(variant);
        this.b(direction);
    }

    @Override
    protected void a(ValueOutput output) {
        output.a("facing", EnumDirection.l, this.db());
        super.a(output);
        VariantUtils.a(output, this.k());
    }

    @Override
    protected void a(ValueInput input) {
        EnumDirection direction = input.a("facing", EnumDirection.l).orElse(EnumDirection.d);
        super.a(input);
        this.b(direction);
        VariantUtils.a(input, Registries.bh).ifPresent(this::a);
    }

    @Override
    protected AxisAlignedBB a(BlockPosition pos, EnumDirection direction) {
        PaintingVariant variant = this.k().a();
        return EntityPainting.calculateBoundingBoxStatic(pos, direction, variant.b(), variant.c());
    }

    public static AxisAlignedBB calculateBoundingBoxStatic(BlockPosition pos, EnumDirection direction, int width, int height) {
        float f2 = 0.46875f;
        Vec3D vec3 = Vec3D.b(pos).a(direction, -0.46875);
        double d2 = EntityPainting.b(width);
        double d1 = EntityPainting.b(height);
        EnumDirection counterClockWise = direction.i();
        Vec3D vec31 = vec3.a(counterClockWise, d2).a(EnumDirection.b, d1);
        EnumDirection.EnumAxis axis = direction.o();
        double d22 = axis == EnumDirection.EnumAxis.a ? 0.0625 : (double)width;
        double d3 = height;
        double d4 = axis == EnumDirection.EnumAxis.c ? 0.0625 : (double)width;
        return AxisAlignedBB.a(vec31, d22, d3, d4);
    }

    private static double b(int size) {
        return size % 2 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void a(WorldServer level, @Nullable Entity entity) {
        if (level.S().c(GameRules.j)) {
            EntityHuman player;
            this.a(SoundEffects.uj, 1.0f, 1.0f);
            if (!(entity instanceof EntityHuman) || !(player = (EntityHuman)entity).gk()) {
                ItemStack painting = new ItemStack(Items.rJ);
                if (!this.an().purpurConfig.persistentDroppableEntityDisplayNames) {
                    painting.b(DataComponents.g, null);
                }
                this.a(level, painting);
            }
        }
    }

    @Override
    public void v() {
        this.a(SoundEffects.uk, 1.0f, 1.0f);
    }

    @Override
    public void b(double x2, double y2, double z2, float yRot, float xRot) {
        this.a_(x2, y2, z2);
    }

    @Override
    public Vec3D dE() {
        return Vec3D.a(this.a);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.db().d(), this.i());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.b(EnumDirection.a(packet.n()));
    }

    @Override
    public ItemStack dU() {
        return new ItemStack(Items.rJ);
    }
}

