/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger f = LogUtils.getLogger();
    private static final IBlockData g = Blocks.L.m();
    private static final int h = 0;
    private static final float i = 0.0f;
    private static final int j = 40;
    private static final boolean k = true;
    private static final boolean l = false;
    public IBlockData m = g;
    public int a = 0;
    public boolean b = true;
    public boolean n = false;
    public boolean o;
    public int p = 40;
    public float q = 0.0f;
    @Nullable
    public NBTTagCompound c;
    public boolean d;
    protected static final DataWatcherObject<BlockPosition> e = DataWatcher.a(EntityFallingBlock.class, DataWatcherRegistry.o);
    public boolean autoExpire = true;

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> type, World level) {
        super(type, level);
    }

    public EntityFallingBlock(World level, double x2, double y2, double z2, IBlockData state) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.aa, level);
        this.m = state;
        this.W = true;
        this.a_(x2, y2, z2);
        this.k(Vec3D.c);
        this.Y = x2;
        this.Z = y2;
        this.aa = z2;
        this.a(this.dF());
    }

    public static EntityFallingBlock a(World level, BlockPosition pos, IBlockData state) {
        EntityFallingBlock fallingBlockEntity = new EntityFallingBlock(level, (double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, state.b(BlockProperties.I) ? (IBlockData)state.b(BlockProperties.I, false) : state);
        if (!CraftEventFactory.callEntityChangeBlockEvent(fallingBlockEntity, pos, state.y().g())) {
            return fallingBlockEntity;
        }
        level.a(pos, state.y().g(), 3);
        level.b(fallingBlockEntity);
        return fallingBlockEntity;
    }

    @Override
    public boolean cO() {
        return false;
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (!this.d(damageSource)) {
            this.bP();
        }
        return false;
    }

    public void a(BlockPosition startPos) {
        this.az.a(e, startPos);
    }

    public BlockPosition e() {
        return this.az.a(e);
    }

    @Override
    protected Entity.MovementEmission br() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(e, BlockPosition.c);
    }

    @Override
    public boolean bT() {
        return !this.ec();
    }

    @Override
    protected double bo() {
        return 0.04;
    }

    @Override
    public void g() {
        if (this.m.l()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            Block block = this.m.b();
            ++this.a;
            this.bq();
            this.a(EnumMoveType.a, this.dI());
            this.aT();
            if (this.an().paperConfig().fixes.fallingBlockHeightNerf.test(v2 -> this.dM() > (double)v2)) {
                WorldServer serverLevel;
                World world;
                if (this.b && (world = this.an()) instanceof WorldServer && (serverLevel = (WorldServer)world).S().c(GameRules.j)) {
                    this.a(serverLevel, block);
                }
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            this.ci();
            World world = this.an();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (this.bX() || this.d) {
                    MovingObjectPositionBlock blockHitResult;
                    BlockPosition blockPos = this.dF();
                    boolean flag = this.m.b() instanceof BlockConcretePowder;
                    boolean flag1 = flag && this.an().b_(blockPos).a(TagsFluid.a);
                    double d2 = this.dI().h();
                    if (flag && d2 > 1.0 && (blockHitResult = this.an().a(new RayTrace(new Vec3D(this.Y, this.Z, this.aa), this.dD(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.b, this))).d() != MovingObjectPosition.EnumMovingObjectType.a && this.an().b_(blockHitResult.b()).a(TagsFluid.a)) {
                        blockPos = blockHitResult.b();
                        flag1 = true;
                    }
                    if (!this.aS() && !flag1) {
                        if (this.a > 100 && this.autoExpire && (blockPos.v() <= this.an().M_() || blockPos.v() > this.an().ar()) || this.a > 600 && this.autoExpire) {
                            if (this.b && serverLevel.S().c(GameRules.j)) {
                                this.a(serverLevel, block);
                            }
                            this.discard(EntityRemoveEvent.Cause.DROP);
                        }
                    } else {
                        IBlockData blockState = this.an().a_(blockPos);
                        this.k(this.dI().d(0.7, -0.5, 0.7));
                        if (!blockState.a(Blocks.ca)) {
                            if (!this.n) {
                                boolean flag3;
                                boolean canBeReplaced = blockState.a(new BlockActionContextDirectional(this.an(), blockPos, EnumDirection.a, ItemStack.l, EnumDirection.b));
                                boolean flag2 = BlockFalling.p(this.an().a_(blockPos.e())) && (!flag || !flag1);
                                boolean bl = flag3 = this.m.a((IWorldReader)this.an(), blockPos) && !flag2;
                                if (canBeReplaced && flag3) {
                                    if (this.m.b(BlockProperties.I) && this.an().b_(blockPos).a() == FluidTypes.c) {
                                        this.m = (IBlockData)this.m.b(BlockProperties.I, true);
                                    }
                                    if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockPos, this.m)) {
                                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                        return;
                                    }
                                    if (this.an().a(blockPos, this.m, 3)) {
                                        TileEntity blockEntity;
                                        serverLevel.n().a.a(this, new PacketPlayOutBlockChange(blockPos, this.an().a_(blockPos)));
                                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                        if (block instanceof Fallable) {
                                            Fallable fallable = (Fallable)((Object)block);
                                            fallable.a(this.an(), blockPos, this.m, blockState, this);
                                        }
                                        if (this.c != null && this.m.x() && (blockEntity = this.an().c_(blockPos)) != null) {
                                            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(blockEntity.v(), f);){
                                                IRegistryCustom registryAccess = this.an().L_();
                                                TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, registryAccess);
                                                blockEntity.e(tagValueOutput);
                                                NBTTagCompound compoundTag = tagValueOutput.b();
                                                this.c.a((String string, NBTBase tag) -> compoundTag.a((String)string, tag.d()));
                                                blockEntity.b(TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)registryAccess, compoundTag));
                                            }
                                            catch (Exception var19) {
                                                f.error("Failed to load block entity from falling block", (Throwable)var19);
                                            }
                                            blockEntity.e();
                                        }
                                    } else if (this.b && serverLevel.S().c(GameRules.j)) {
                                        this.discard(EntityRemoveEvent.Cause.DROP);
                                        this.a(block, blockPos);
                                        this.a(serverLevel, block);
                                    }
                                } else {
                                    this.discard(EntityRemoveEvent.Cause.DROP);
                                    if (this.b && serverLevel.S().c(GameRules.j)) {
                                        this.a(block, blockPos);
                                        this.a(serverLevel, block);
                                    }
                                }
                            } else {
                                this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                this.a(block, blockPos);
                            }
                        }
                    }
                }
            }
            this.k(this.dI().c(0.98));
        }
    }

    public void a(Block block, BlockPosition pos) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).a(this.an(), pos, this);
        }
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        DamageSource damageSource2;
        if (!this.o) {
            return false;
        }
        int ceil = MathHelper.c(fallDistance - 1.0);
        if (ceil < 0) {
            return false;
        }
        Predicate<Entity> predicate = IEntitySelector.e.and(IEntitySelector.b);
        Block block = this.m.b();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)block);
            damageSource2 = fallable.a(this);
        } else {
            damageSource2 = this.ei().a(this);
        }
        DamageSource damageSource1 = damageSource2;
        float f2 = Math.min(MathHelper.d((float)ceil * this.q), this.p);
        this.an().a((Entity)this, this.de(), predicate).forEach(entity -> entity.a(damageSource1, f2));
        boolean isAnvil = this.m.a(TagsBlock.K);
        if (isAnvil && f2 > 0.0f && this.as.i() < 0.05f + (float)ceil * 0.05f) {
            IBlockData blockState = BlockAnvil.e(this.m);
            if (blockState == null) {
                this.n = true;
            } else {
                this.m = blockState;
            }
        }
        return false;
    }

    @Override
    protected void a(ValueOutput output) {
        output.a("BlockState", IBlockData.a, this.m);
        output.a("Time", this.a);
        output.a("DropItem", this.b);
        output.a("HurtEntities", this.o);
        output.a("FallHurtAmount", this.q);
        output.a("FallHurtMax", this.p);
        if (this.c != null) {
            output.a("TileEntityData", NBTTagCompound.a, this.c);
        }
        output.a("CancelDrop", this.n);
        if (!this.autoExpire) {
            output.a("Paper.AutoExpire", false);
        }
    }

    @Override
    protected void a(ValueInput input) {
        this.m = input.a("BlockState", IBlockData.a).orElse(g);
        this.a = input.a("Time", 0);
        boolean isAnvil = this.m.a(TagsBlock.K);
        this.o = input.a("HurtEntities", isAnvil);
        this.q = input.a("FallHurtAmount", 0.0f);
        this.p = input.a("FallHurtMax", 40);
        this.b = input.a("DropItem", true);
        this.c = input.a("TileEntityData", NBTTagCompound.a).map(blockData -> this.an().paperConfig().entities.spawning.filterBadTileEntityNbtFromFallingBlocks && this.m.b() instanceof GameMasterBlock ? null : blockData).map(NBTTagCompound::l).orElse(null);
        this.n = input.a("CancelDrop", false);
        this.autoExpire = input.a("Paper.AutoExpire", true);
    }

    public void b(float fallDamagePerDistance, int fallDamageMax) {
        this.o = true;
        this.q = fallDamagePerDistance;
        this.p = fallDamageMax;
    }

    public void f() {
        this.n = true;
    }

    @Override
    public boolean cS() {
        return false;
    }

    @Override
    public void a(CrashReportSystemDetails category) {
        super.a(category);
        category.a("Immitating BlockState", this.m.toString());
    }

    public IBlockData i() {
        return this.m;
    }

    @Override
    protected IChatBaseComponent cM() {
        return IChatBaseComponent.a("entity.minecraft.falling_block_type", this.m.b().f());
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, entity, Block.j(this.i()));
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.m = Block.a(packet.n());
        this.W = true;
        double x2 = packet.g();
        double y2 = packet.h();
        double z2 = packet.i();
        this.a_(x2, y2, z2);
        this.a(this.dF());
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleportTransition) {
        ResourceKey<World> resourceKey = teleportTransition.b().al();
        ResourceKey<World> resourceKey1 = this.an().al();
        boolean flag = (resourceKey1 == World.j || resourceKey == World.j) && resourceKey1 != resourceKey;
        Entity entity = super.b(teleportTransition);
        this.d = entity != null && flag && GlobalConfiguration.get().unsupportedSettings.allowUnsafeEndPortalTeleportation;
        return entity;
    }
}

