/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class Bogged
extends EntitySkeletonAbstract
implements IShearable {
    private static final int a = 50;
    private static final int b = 70;
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(Bogged.class, DataWatcherRegistry.k);
    private static final String d = "sheared";
    private static final boolean e = false;

    public static AttributeProvider.Builder gK() {
        return EntitySkeletonAbstract.k().a(GenericAttributes.t, 16.0);
    }

    public Bogged(EntityTypes<? extends Bogged> type, World level) {
        super((EntityTypes<? extends EntitySkeletonAbstract>)type, level);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.boggedRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.boggedRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.boggedControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.boggedMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.boggedScale);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, false);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a(d, this.gL());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a(d, false));
    }

    public boolean gL() {
        return this.az.a(c);
    }

    public void x(boolean sheared) {
        this.az.a(c, sheared);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.tZ) && this.a()) {
            World world = this.an();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return EnumInteractionResult.e;
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(serverLevel, SoundCategory.h, itemInHand, drops);
                this.a(GameEvent.M, (Entity)player);
                itemInHand.a(1, (EntityLiving)player, hand.a());
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.co;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.cq;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.cp;
    }

    @Override
    protected SoundEffect m() {
        return SoundEffects.cs;
    }

    @Override
    protected EntityArrow a(ItemStack arrow, float velocity, @Nullable ItemStack weapon) {
        EntityArrow abstractArrow = super.a(arrow, velocity, weapon);
        if (abstractArrow instanceof EntityTippedArrow) {
            EntityTippedArrow arrow1 = (EntityTippedArrow)abstractArrow;
            arrow1.a(new MobEffect(MobEffects.s, 100));
        }
        return abstractArrow;
    }

    @Override
    protected int s() {
        return 50;
    }

    @Override
    protected int gI() {
        return 70;
    }

    @Override
    public void a(WorldServer level, SoundCategory source, ItemStack shears) {
        this.shear(level, source, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer level, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.a(level, LootTables.aW, shears, (arg_0, arg_1) -> Bogged.lambda$generateDefaultDrops$0((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(WorldServer level, SoundCategory source, ItemStack shears, List<ItemStack> drops) {
        level.a(null, this, SoundEffects.cr, source, 1.0f, 1.0f);
        this.spawnShearedMushrooms(level, shears, drops);
        this.x(true);
    }

    private void spawnShearedMushrooms(WorldServer level, ItemStack stack, List<ItemStack> drops) {
        this.forceDrops = true;
        drops.forEach(drop -> this.a(level, (ItemStack)drop, this.dB()));
        this.forceDrops = false;
    }

    @Override
    public boolean a() {
        return !this.gL() && this.bX();
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$0(List drops, WorldServer ignored, ItemStack stack) {
        drops.add(stack);
    }
}

