/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.purpurmc.purpur.controller.FlyingWithSpacebarMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityBlaze
extends EntityMonster {
    private float a = 0.5f;
    private int b;
    private static final DataWatcherObject<Byte> c = DataWatcher.a(EntityBlaze.class, DataWatcherRegistry.a);

    public EntityBlaze(EntityTypes<? extends EntityBlaze> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.cn = new FlyingWithSpacebarMoveControllerWASD((EntityInsentient)this, 0.3f);
        if (this.fG()) {
            this.a(PathType.j, -1.0f);
        }
        this.a(PathType.i, 8.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
        this.cl = 10;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.blazeRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.blazeRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.blazeControllable;
    }

    @Override
    public double getMaxY() {
        return this.an().purpurConfig.blazeMaxY;
    }

    @Override
    public void m(Vec3D vec3) {
        super.m(vec3);
        if (this.getRider() != null && this.isControllable() && !((Entity)this).bc) {
            float speed = (float)this.i(GenericAttributes.m);
            this.B(speed);
            Vec3D mot = this.dI();
            this.a(EnumMoveType.a, mot.d(speed, 1.0, speed));
            this.k(mot.c(0.9));
        }
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.blazeMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.blazeScale);
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.blazeAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        this.cq.a(4, new PathfinderGoalBlazeFireball(this));
        this.cq.a(5, new PathfinderGoalMoveTowardsRestriction(this, 1.0));
        this.cq.a(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.cq.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(8, new PathfinderGoalRandomLookaround(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.c, 6.0).a(GenericAttributes.w, 0.23f).a(GenericAttributes.n, 48.0).a(GenericAttributes.m, 0.6);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, (byte)0);
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.ch;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.ck;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.cj;
    }

    @Override
    public float bK() {
        return 1.0f;
    }

    @Override
    public void e_() {
        if (!this.aS() && this.dI().h < 0.0) {
            this.k(this.dI().d(1.0, 0.6, 1.0));
        }
        if (this.an().D_()) {
            if (this.as.a(24) == 0 && !this.bm()) {
                this.an().a(this.dK() + 0.5, this.dM() + 0.5, this.dQ() + 0.5, SoundEffects.ci, this.dw(), 1.0f + this.as.i(), this.as.i() * 0.7f + 0.3f, false);
            }
            for (int i2 = 0; i2 < 2; ++i2) {
                this.an().a(Particles.ab, this.e(0.5), this.dN(), this.h(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.e_();
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.blazeTakeDamageFromWater;
    }

    @Override
    protected void a(WorldServer level) {
        EntityLiving target;
        if (this.getRider() != null && this.isControllable()) {
            Vec3D mot = this.dI();
            this.m(mot.a(), this.getVerticalMot() > 0.0f ? 0.07 : -0.07, mot.c());
            return;
        }
        --this.b;
        if (this.b <= 0) {
            this.b = 100;
            this.a = (float)this.as.a(0.5, 6.891);
        }
        if ((target = this.e()) != null && target.dO() > this.dO() + (double)this.a && this.c(target)) {
            Vec3D deltaMovement = this.dI();
            this.k(this.dI().b(0.0, ((double)0.3f - deltaMovement.h) * (double)0.3f, 0.0));
            this.aF = true;
        }
        super.a(level);
    }

    @Override
    public boolean ck() {
        return this.m();
    }

    private boolean m() {
        return (this.az.a(c) & 1) != 0;
    }

    void x(boolean charged) {
        byte b2 = this.az.a(c);
        b2 = charged ? (byte)(b2 | 1) : (byte)(b2 & 0xFFFFFFFE);
        this.az.a(c, b2);
    }

    static class PathfinderGoalBlazeFireball
    extends PathfinderGoal {
        private final EntityBlaze a;
        private int b;
        private int c;
        private int d;

        public PathfinderGoalBlazeFireball(EntityBlaze blaze) {
            this.a = blaze;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving target = this.a.e();
            return target != null && target.bX() && this.a.c(target);
        }

        @Override
        public void d() {
            this.b = 0;
        }

        @Override
        public void e() {
            this.a.x(false);
            this.d = 0;
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            --this.c;
            EntityLiving target = this.a.e();
            if (target != null) {
                boolean hasLineOfSight = this.a.T().a(target);
                this.d = hasLineOfSight ? 0 : ++this.d;
                double d2 = this.a.g((Entity)target);
                if (d2 < 4.0) {
                    if (!hasLineOfSight) {
                        return;
                    }
                    if (this.c <= 0) {
                        this.c = 20;
                        this.a.c(PathfinderGoalBlazeFireball.a(this.a), (Entity)target);
                    }
                    this.a.Q().a(target.dK(), target.dM(), target.dQ(), 1.0);
                } else if (d2 < this.h() * this.h() && hasLineOfSight) {
                    double d1 = target.dK() - this.a.dK();
                    double d22 = target.f(0.5) - this.a.f(0.5);
                    double d3 = target.dQ() - this.a.dQ();
                    if (this.c <= 0) {
                        ++this.b;
                        if (this.b == 1) {
                            this.c = 60;
                            this.a.x(true);
                        } else if (this.b <= 4) {
                            this.c = 6;
                        } else {
                            this.c = 100;
                            this.b = 0;
                            this.a.x(false);
                        }
                        if (this.b > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d2)) * 0.5;
                            if (!this.a.bm()) {
                                this.a.an().a(null, 1018, this.a.dF(), 0);
                            }
                            for (int i2 = 0; i2 < 1; ++i2) {
                                Vec3D vec3 = new Vec3D(this.a.ek().a(d1, 2.297 * d4), d22, this.a.ek().a(d3, 2.297 * d4));
                                EntitySmallFireball smallFireball = new EntitySmallFireball(this.a.an(), this.a, vec3.d());
                                smallFireball.a_(smallFireball.dK(), this.a.f(0.5) + 0.5, smallFireball.dQ());
                                this.a.an().b(smallFireball);
                            }
                        }
                    }
                    this.a.P().a(target, 10.0f, 10.0f);
                } else if (this.d < 5) {
                    this.a.Q().a(target.dK(), target.dM(), target.dQ(), 1.0);
                }
                super.a();
            }
        }

        private double h() {
            return this.a.i(GenericAttributes.n);
        }
    }
}

